/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.models.CosmosFullTextPath;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public final class CosmosFullTextPolicy {
    @JsonProperty(value="defaultLanguage")
    private String defaultLanguage;
    @JsonProperty(value="fullTextPaths")
    private List<CosmosFullTextPath> paths;

    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public CosmosFullTextPolicy setDefaultLanguage(String defaultLanguage) {
        this.defaultLanguage = defaultLanguage;
        return this;
    }

    public List<CosmosFullTextPath> getPaths() {
        return this.paths;
    }

    public CosmosFullTextPolicy setPaths(List<CosmosFullTextPath> paths) {
        for (CosmosFullTextPath cosmosFullTextPath : paths) {
            if (!cosmosFullTextPath.getLanguage().isEmpty()) continue;
            throw new IllegalArgumentException("Language needs to specified for the path in the Full text policy.");
        }
        this.paths = paths;
        return this;
    }
}

