/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.throughputControl.server;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.caches.AsyncCache;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.throughputControl.EmptyThroughputContainerController;
import com.azure.cosmos.implementation.throughputControl.server.ContainerServerThroughputControlGroupProperties;
import com.azure.cosmos.implementation.throughputControl.server.config.ServerThroughputControlGroup;
import com.azure.cosmos.implementation.throughputControl.server.controller.ServerThroughputContainerController;
import java.util.concurrent.ConcurrentHashMap;
import reactor.core.publisher.Mono;

public class ServerThroughputControlStore {
    private final AsyncCache<String, ServerThroughputContainerController> containerControllerCache = new AsyncCache();
    private final ConcurrentHashMap<String, ContainerServerThroughputControlGroupProperties> containerMap = new ConcurrentHashMap();

    public void enableThroughputControlGroup(ServerThroughputControlGroup group) {
        Preconditions.checkNotNull(group, "Throughput control group cannot be null");
        String containerNameLink = Utils.trimBeginningAndEndingSlashes(BridgeInternal.extractContainerSelfLink(group.getTargetContainer()));
        this.containerMap.compute(containerNameLink, (key, throughputControlContainerProperties) -> {
            int groupSizeAfterEnabling;
            if (throughputControlContainerProperties == null) {
                throughputControlContainerProperties = new ContainerServerThroughputControlGroupProperties(containerNameLink);
            }
            if ((groupSizeAfterEnabling = throughputControlContainerProperties.enableThroughputControlGroup(group)) == 1) {
                this.containerControllerCache.remove(containerNameLink);
            }
            return throughputControlContainerProperties;
        });
    }

    public <T> Mono<T> processRequest(RxDocumentServiceRequest request, Mono<T> originalRequestMono) {
        Preconditions.checkNotNull(request, "Request can not be null");
        Preconditions.checkNotNull(originalRequestMono, "originalRequestMono can not be null");
        if (request.getResourceType() != ResourceType.Document && request.getResourceType() != ResourceType.StoredProcedure) {
            return originalRequestMono;
        }
        String collectionNameLink = Utils.getCollectionName(request.getResourceAddress());
        return this.resolveContainerController(collectionNameLink).flatMap(containerController -> containerController.processRequest(request, originalRequestMono));
    }

    public boolean hasDefaultGroup(String containerNameLink) {
        if (this.containerMap.containsKey(containerNameLink)) {
            return this.containerMap.get(containerNameLink).hasDefaultGroup();
        }
        return false;
    }

    public boolean hasGroup(String containerNameLink, String throughputControlGroupName) {
        if (StringUtils.isEmpty(throughputControlGroupName)) {
            return false;
        }
        if (this.containerMap.containsKey(containerNameLink)) {
            return this.containerMap.get(containerNameLink).hasGroup(throughputControlGroupName);
        }
        return false;
    }

    private Mono<ServerThroughputContainerController> resolveContainerController(String containerNameLink) {
        return this.containerControllerCache.getAsync(containerNameLink, null, () -> this.createAndInitContainerController(containerNameLink));
    }

    private Mono<ServerThroughputContainerController> createAndInitContainerController(String containerNameLink) {
        Preconditions.checkArgument(StringUtils.isNotEmpty(containerNameLink), "Container link should not be null or empty");
        if (this.containerMap.containsKey(containerNameLink)) {
            ContainerServerThroughputControlGroupProperties containerProperties = this.containerMap.get(containerNameLink);
            return Mono.just((Object)new ServerThroughputContainerController(containerProperties.getThroughputControlGroups())).flatMap(ServerThroughputContainerController::init);
        }
        return Mono.just((Object)new EmptyThroughputContainerController()).flatMap(EmptyThroughputContainerController::init);
    }
}

