/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.throughputControl.sdk;

import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.apachecommons.lang.tuple.Pair;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.throughputControl.sdk.config.SDKThroughputControlGroupInternal;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class ContainerSDKThroughputControlGroupProperties {
    private static Logger logger = LoggerFactory.getLogger(ContainerSDKThroughputControlGroupProperties.class);
    private final AtomicReference<SDKThroughputControlGroupInternal> defaultGroup;
    private final Map<String, SDKThroughputControlGroupInternal> throughputControlGroups;
    private final Set<String> supressInitErrorGroupSet;
    private final AtomicReference<Mono<Integer>> throughputQueryMonoReference;
    private final String containerNameLink;

    public ContainerSDKThroughputControlGroupProperties(String containerNameLink) {
        Preconditions.checkArgument(StringUtils.isNotEmpty(containerNameLink), "Argument 'containerNameLink' should not be empty");
        this.defaultGroup = new AtomicReference();
        this.containerNameLink = containerNameLink;
        this.throughputControlGroups = new ConcurrentHashMap<String, SDKThroughputControlGroupInternal>();
        this.supressInitErrorGroupSet = ConcurrentHashMap.newKeySet();
        this.throughputQueryMonoReference = new AtomicReference();
    }

    public Pair<Integer, Boolean> enableThroughputControlGroup(SDKThroughputControlGroupInternal group, Mono<Integer> throughputQueryMono) {
        Preconditions.checkNotNull(group, "Throughput control group should not be null");
        if (group.isDefault() && !this.defaultGroup.compareAndSet(null, group) && !this.defaultGroup.get().hasSameIdentity(group)) {
            throw new IllegalArgumentException("A default group already exists");
        }
        if (group.isContinueOnInitError()) {
            this.supressInitErrorGroupSet.add(group.getGroupName());
        }
        AtomicBoolean updatedGroupConfig = new AtomicBoolean(false);
        this.throughputControlGroups.values().forEach(existingGroup -> {
            if (Objects.equals(existingGroup.getIdPrefix(), group.getIdPrefix()) && !existingGroup.equals(group)) {
                if (existingGroup.isDefault() != group.isDefault() || existingGroup.isContinueOnInitError() != group.isContinueOnInitError()) {
                    throw new IllegalArgumentException("Throughput control group with id " + group.getId() + " already exists with different setting for isDefault or isContinueOnInitError - these properties are immutable and cannot be changed.");
                }
                this.throughputControlGroups.remove(existingGroup);
                logger.info("Throughput control group with id-prefix {} already exists with different config. Will update config.", (Object)group.getIdPrefix());
                updatedGroupConfig.set(true);
            }
        });
        this.throughputControlGroups.put(group.getGroupName(), group);
        if (!this.throughputQueryMonoReference.compareAndSet(null, throughputQueryMono)) {
            logger.debug("ThroughputQueryMono has exists for container {}", (Object)this.containerNameLink);
        }
        return Pair.of(this.throughputControlGroups.size(), updatedGroupConfig.get());
    }

    public Map<String, SDKThroughputControlGroupInternal> getThroughputControlGroups() {
        return this.throughputControlGroups;
    }

    public Mono<Integer> getThroughputQueryMono() {
        return this.throughputQueryMonoReference.get();
    }

    public boolean allowRequestToContinueOnInitError(RxDocumentServiceRequest request) {
        Preconditions.checkNotNull(request, "Request should not be null");
        String requestGroupName = request.getThroughputControlGroupName();
        if (StringUtils.isEmpty(requestGroupName)) {
            if (this.defaultGroup.get() == null) {
                return true;
            }
            requestGroupName = this.defaultGroup.get().getGroupName();
        }
        return this.supressInitErrorGroupSet.contains(requestGroupName);
    }

    public boolean hasDefaultGroup() {
        return this.defaultGroup.get() != null;
    }

    public boolean hasGroup(String groupName) {
        return this.throughputControlGroups.containsKey(groupName);
    }
}

