/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.routing;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosExcludedRegions;
import com.azure.cosmos.implementation.AvailabilityStrategyContext;
import com.azure.cosmos.implementation.Configs;
import com.azure.cosmos.implementation.ConnectionPolicy;
import com.azure.cosmos.implementation.CrossRegionAvailabilityContextForRxDocumentServiceRequest;
import com.azure.cosmos.implementation.DatabaseAccount;
import com.azure.cosmos.implementation.DatabaseAccountLocation;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.Strings;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.apachecommons.collections.list.UnmodifiableList;
import com.azure.cosmos.implementation.apachecommons.collections.map.CaseInsensitiveMap;
import com.azure.cosmos.implementation.apachecommons.collections.map.UnmodifiableMap;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.routing.RegionalRoutingContext;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocationCache {
    private static final Logger logger = LoggerFactory.getLogger(LocationCache.class);
    private final boolean enableEndpointDiscovery;
    private final RegionalRoutingContext defaultRoutingContext;
    private final boolean useMultipleWriteLocations;
    private final Object lockObject;
    private final Duration unavailableLocationsExpirationTime;
    private final ConcurrentHashMap<RegionalRoutingContext, LocationUnavailabilityInfo> locationUnavailabilityInfoByEndpoint;
    private final ConnectionPolicy connectionPolicy;
    private DatabaseAccountLocationsInfo locationInfo;
    private Instant lastCacheUpdateTimestamp;
    private boolean enableMultipleWriteLocations;

    public LocationCache(ConnectionPolicy connectionPolicy, URI defaultEndpoint, Configs configs) {
        ArrayList<String> preferredLocations = new ArrayList<String>(connectionPolicy.getPreferredRegions() != null ? connectionPolicy.getPreferredRegions() : Collections.emptyList());
        this.defaultRoutingContext = new RegionalRoutingContext(defaultEndpoint);
        this.locationInfo = new DatabaseAccountLocationsInfo(preferredLocations, this.defaultRoutingContext);
        this.enableEndpointDiscovery = connectionPolicy.isEndpointDiscoveryEnabled();
        this.useMultipleWriteLocations = connectionPolicy.isMultipleWriteRegionsEnabled();
        this.lockObject = new Object();
        this.locationUnavailabilityInfoByEndpoint = new ConcurrentHashMap();
        this.lastCacheUpdateTimestamp = Instant.MIN;
        this.enableMultipleWriteLocations = false;
        this.unavailableLocationsExpirationTime = Duration.ofSeconds(configs.getUnavailableLocationsExpirationTimeInSeconds());
        this.connectionPolicy = connectionPolicy;
    }

    public UnmodifiableList<RegionalRoutingContext> getReadEndpoints() {
        if (!this.locationUnavailabilityInfoByEndpoint.isEmpty() && this.unavailableLocationsExpirationTimePassed()) {
            this.updateLocationCache();
        }
        return this.locationInfo.readRegionalRoutingContexts;
    }

    public UnmodifiableList<RegionalRoutingContext> getWriteEndpoints() {
        if (!this.locationUnavailabilityInfoByEndpoint.isEmpty() && this.unavailableLocationsExpirationTimePassed()) {
            this.updateLocationCache();
        }
        return this.locationInfo.writeRegionalRoutingContexts;
    }

    public List<RegionalRoutingContext> getAvailableReadRegionalRoutingContexts() {
        return this.locationInfo.availableReadRegionalRoutingContexts;
    }

    public List<RegionalRoutingContext> getAvailableWriteRegionalRoutingContexts() {
        return this.locationInfo.availableWriteRegionalRoutingContexts;
    }

    public List<String> getEffectivePreferredLocations() {
        return this.locationInfo.effectivePreferredLocations;
    }

    public void markEndpointUnavailableForRead(URI endpoint) {
        this.markEndpointUnavailable(endpoint, OperationType.Read);
    }

    public void markEndpointUnavailableForWrite(URI endpoint) {
        this.markEndpointUnavailable(endpoint, OperationType.Write);
    }

    public void onDatabaseAccountRead(DatabaseAccount databaseAccount) {
        this.updateLocationCache(databaseAccount.getWritableLocations(), databaseAccount.getReadableLocations(), databaseAccount.getThinClientWritableLocations(), databaseAccount.getThinClientReadableLocations(), null, BridgeInternal.isEnableMultipleWriteLocations(databaseAccount));
    }

    public RegionalRoutingContext resolveServiceEndpoint(RxDocumentServiceRequest request) {
        boolean usePreferredLocations;
        Objects.requireNonNull(request.requestContext, "RxDocumentServiceRequest.requestContext is required and cannot be null.");
        if (request.requestContext.regionalRoutingContextToRoute != null) {
            return request.requestContext.regionalRoutingContextToRoute;
        }
        int locationIndex = Utils.getValueOrDefault(request.requestContext.locationIndexToRoute, 0);
        boolean bl = usePreferredLocations = request.requestContext.usePreferredLocations != null ? request.requestContext.usePreferredLocations : true;
        if (!usePreferredLocations || request.getOperationType().isWriteOperation() && !this.canUseMultipleWriteLocations(request)) {
            DatabaseAccountLocationsInfo currentLocationInfo = this.locationInfo;
            if (this.enableEndpointDiscovery && !currentLocationInfo.availableWriteLocations.isEmpty()) {
                locationIndex = Math.min(locationIndex % 2, currentLocationInfo.availableWriteLocations.size() - 1);
                String writeLocation = (String)currentLocationInfo.availableWriteLocations.get(locationIndex);
                return (RegionalRoutingContext)currentLocationInfo.availableWriteRegionalRoutingContextsByRegionName.get(writeLocation);
            }
            return this.defaultRoutingContext;
        }
        UnmodifiableList<RegionalRoutingContext> endpoints = request.getOperationType().isWriteOperation() ? this.getApplicableWriteRegionRoutingContexts(request) : this.getApplicableReadRegionRoutingContexts(request);
        return (RegionalRoutingContext)endpoints.get(locationIndex % endpoints.size());
    }

    public UnmodifiableList<RegionalRoutingContext> getApplicableWriteRegionRoutingContexts(RxDocumentServiceRequest request) {
        return this.getApplicableWriteRegionRoutingContexts(request, request.requestContext.getExcludeRegions(), request.requestContext.getUnavailableRegionsForPartition());
    }

    public UnmodifiableList<RegionalRoutingContext> getApplicableWriteRegionRoutingContexts(List<String> excludedRegionsOnRequest, List<String> unavailableRegionsForPartition) {
        List<String> effectiveExcludedRegions;
        UnmodifiableList<RegionalRoutingContext> writeEndpoints = this.getWriteEndpoints();
        Supplier<CosmosExcludedRegions> excludedRegionsSupplier = this.connectionPolicy.getExcludedRegionsSupplier();
        ArrayList<String> arrayList = effectiveExcludedRegions = LocationCache.isExcludedRegionsSupplierConfigured(excludedRegionsSupplier) ? new ArrayList<String>(excludedRegionsSupplier.get().getExcludedRegions()) : Collections.emptyList();
        if (!this.isExcludeRegionsConfigured(excludedRegionsOnRequest, effectiveExcludedRegions) && (unavailableRegionsForPartition == null || unavailableRegionsForPartition.isEmpty())) {
            return writeEndpoints;
        }
        if (excludedRegionsOnRequest != null && !excludedRegionsOnRequest.isEmpty()) {
            effectiveExcludedRegions = excludedRegionsOnRequest;
        }
        return this.getApplicableRegionRoutingContexts(null, this.locationInfo.effectivePreferredLocations, writeEndpoints, this.locationInfo.hubRoutingContext, this.locationInfo.regionNameByWriteRegionalRoutingContexts, this.locationInfo.availableWriteRegionalRoutingContextsByRegionName, this.defaultRoutingContext, effectiveExcludedRegions, unavailableRegionsForPartition);
    }

    public UnmodifiableList<RegionalRoutingContext> getApplicableReadRegionRoutingContexts(RxDocumentServiceRequest request) {
        return this.getApplicableReadRegionRoutingContexts(request, request.requestContext.getExcludeRegions(), request.requestContext.getUnavailableRegionsForPartition());
    }

    public UnmodifiableList<RegionalRoutingContext> getApplicableReadRegionRoutingContexts(List<String> excludedRegionsOnRequest, List<String> unavailableRegionsForPartition) {
        List<String> effectiveExcludedRegions;
        UnmodifiableList<RegionalRoutingContext> readEndpoints = this.getReadEndpoints();
        Supplier<CosmosExcludedRegions> excludedRegionsSupplier = this.connectionPolicy.getExcludedRegionsSupplier();
        ArrayList<String> arrayList = effectiveExcludedRegions = LocationCache.isExcludedRegionsSupplierConfigured(excludedRegionsSupplier) ? new ArrayList<String>(excludedRegionsSupplier.get().getExcludedRegions()) : Collections.emptyList();
        if (!this.isExcludeRegionsConfigured(excludedRegionsOnRequest, effectiveExcludedRegions) && (unavailableRegionsForPartition == null || unavailableRegionsForPartition.isEmpty())) {
            return readEndpoints;
        }
        if (excludedRegionsOnRequest != null && !excludedRegionsOnRequest.isEmpty()) {
            effectiveExcludedRegions = excludedRegionsOnRequest;
        }
        return this.getApplicableRegionRoutingContexts(null, this.locationInfo.effectivePreferredLocations, readEndpoints, this.locationInfo.hubRoutingContext, this.locationInfo.regionNameByReadRegionalRoutingContexts, this.locationInfo.availableReadRegionalRoutingContextsByRegionName, (RegionalRoutingContext)this.locationInfo.writeRegionalRoutingContexts.get(0), effectiveExcludedRegions, unavailableRegionsForPartition);
    }

    private UnmodifiableList<RegionalRoutingContext> getApplicableReadRegionRoutingContexts(RxDocumentServiceRequest request, List<String> excludedRegionsOnRequest, List<String> unavailableRegionsForPartition) {
        List<String> effectiveExcludedRegions;
        UnmodifiableList<RegionalRoutingContext> readEndpoints = this.getReadEndpoints();
        Supplier<CosmosExcludedRegions> excludedRegionsSupplier = this.connectionPolicy.getExcludedRegionsSupplier();
        ArrayList<String> arrayList = effectiveExcludedRegions = LocationCache.isExcludedRegionsSupplierConfigured(excludedRegionsSupplier) ? new ArrayList<String>(excludedRegionsSupplier.get().getExcludedRegions()) : Collections.emptyList();
        if (!this.isExcludeRegionsConfigured(excludedRegionsOnRequest, effectiveExcludedRegions) && (unavailableRegionsForPartition == null || unavailableRegionsForPartition.isEmpty())) {
            return readEndpoints;
        }
        if (excludedRegionsOnRequest != null && !excludedRegionsOnRequest.isEmpty()) {
            effectiveExcludedRegions = excludedRegionsOnRequest;
        }
        return this.getApplicableRegionRoutingContexts(request, this.locationInfo.effectivePreferredLocations, readEndpoints, this.locationInfo.hubRoutingContext, this.locationInfo.regionNameByReadRegionalRoutingContexts, this.locationInfo.availableReadRegionalRoutingContextsByRegionName, (RegionalRoutingContext)this.locationInfo.writeRegionalRoutingContexts.get(0), effectiveExcludedRegions, unavailableRegionsForPartition);
    }

    private UnmodifiableList<RegionalRoutingContext> getApplicableWriteRegionRoutingContexts(RxDocumentServiceRequest request, List<String> excludedRegionsOnRequest, List<String> unavailableRegionsForPartition) {
        List<String> effectiveExcludedRegions;
        UnmodifiableList<RegionalRoutingContext> writeEndpoints = this.getWriteEndpoints();
        Supplier<CosmosExcludedRegions> excludedRegionsSupplier = this.connectionPolicy.getExcludedRegionsSupplier();
        ArrayList<String> arrayList = effectiveExcludedRegions = LocationCache.isExcludedRegionsSupplierConfigured(excludedRegionsSupplier) ? new ArrayList<String>(excludedRegionsSupplier.get().getExcludedRegions()) : Collections.emptyList();
        if (!this.isExcludeRegionsConfigured(excludedRegionsOnRequest, effectiveExcludedRegions) && (unavailableRegionsForPartition == null || unavailableRegionsForPartition.isEmpty())) {
            return writeEndpoints;
        }
        if (excludedRegionsOnRequest != null && !excludedRegionsOnRequest.isEmpty()) {
            effectiveExcludedRegions = excludedRegionsOnRequest;
        }
        return this.getApplicableRegionRoutingContexts(request, this.locationInfo.effectivePreferredLocations, writeEndpoints, this.locationInfo.hubRoutingContext, this.locationInfo.regionNameByWriteRegionalRoutingContexts, this.locationInfo.availableWriteRegionalRoutingContextsByRegionName, this.defaultRoutingContext, effectiveExcludedRegions, unavailableRegionsForPartition);
    }

    private UnmodifiableList<RegionalRoutingContext> getApplicableRegionRoutingContexts(RxDocumentServiceRequest request, List<String> effectivePreferredLocations, UnmodifiableList<RegionalRoutingContext> regionalRoutingContexts, RegionalRoutingContext hubRoutingContext, UnmodifiableMap<RegionalRoutingContext, String> regionNameByRegionalRoutingContext, UnmodifiableMap<String, RegionalRoutingContext> regionalRoutingContextByRegionName, RegionalRoutingContext fallbackRoutingContext, List<String> userConfiguredExcludeRegions, List<String> internalExcludeRegions) {
        Utils.ValueHolder regionName;
        ArrayList<RegionalRoutingContext> endpointsRemovedByInternalExcludeRegions = new ArrayList<RegionalRoutingContext>();
        ArrayList<RegionalRoutingContext> applicableEndpoints = new ArrayList<RegionalRoutingContext>();
        for (RegionalRoutingContext endpoint : regionalRoutingContexts) {
            if (!Utils.tryGetValue(regionNameByRegionalRoutingContext, endpoint, regionName = new Utils.ValueHolder())) continue;
            if (userConfiguredExcludeRegions.stream().anyMatch(((String)regionName.v)::equalsIgnoreCase)) continue;
            applicableEndpoints.add(endpoint);
        }
        if (internalExcludeRegions != null && !internalExcludeRegions.isEmpty()) {
            for (RegionalRoutingContext endpoint : regionalRoutingContexts) {
                if (!Utils.tryGetValue(regionNameByRegionalRoutingContext, endpoint, regionName = new Utils.ValueHolder())) continue;
                if (!internalExcludeRegions.stream().anyMatch(((String)regionName.v)::equalsIgnoreCase)) continue;
                int size = applicableEndpoints.size();
                applicableEndpoints.remove(endpoint);
                int newSize = applicableEndpoints.size();
                if (newSize >= size) continue;
                endpointsRemovedByInternalExcludeRegions.add(endpoint);
            }
        }
        boolean isFallbackEndpointUsed = false;
        if (applicableEndpoints.isEmpty()) {
            applicableEndpoints.add(fallbackRoutingContext);
            isFallbackEndpointUsed = true;
        }
        return this.reevaluate(request, effectivePreferredLocations, new UnmodifiableList<RegionalRoutingContext>((List<RegionalRoutingContext>)applicableEndpoints), regionNameByRegionalRoutingContext, regionalRoutingContextByRegionName, userConfiguredExcludeRegions, endpointsRemovedByInternalExcludeRegions, internalExcludeRegions, regionalRoutingContexts, hubRoutingContext, isFallbackEndpointUsed);
    }

    private UnmodifiableList<RegionalRoutingContext> reevaluate(RxDocumentServiceRequest request, List<String> effectivePreferredLocations, UnmodifiableList<RegionalRoutingContext> applicableRegionalRoutingContexts, UnmodifiableMap<RegionalRoutingContext, String> regionNameByRegionalRoutingContexts, UnmodifiableMap<String, RegionalRoutingContext> regionalRoutingContextsByRegionName, List<String> userConfiguredExcludeRegions, List<RegionalRoutingContext> regionalRoutingContextsRemovedByInternalExcludeRegions, List<String> internalExcludeRegions, List<RegionalRoutingContext> preferredRoutingContexts, RegionalRoutingContext hubRoutingContext, boolean isFallbackRoutingContextUsed) {
        ArrayList<RegionalRoutingContext> modifiedRegionalRoutingContexts;
        block14: {
            if (preferredRoutingContexts.size() <= 1) {
                return applicableRegionalRoutingContexts;
            }
            if (applicableRegionalRoutingContexts.size() >= 2) {
                return applicableRegionalRoutingContexts;
            }
            if (request == null || request.requestContext == null) {
                return applicableRegionalRoutingContexts;
            }
            CrossRegionAvailabilityContextForRxDocumentServiceRequest crossRegionAvailabilityContextForRequest = request.requestContext.getCrossRegionAvailabilityContext();
            if (crossRegionAvailabilityContextForRequest == null) {
                return applicableRegionalRoutingContexts;
            }
            AvailabilityStrategyContext availabilityStrategyContext = crossRegionAvailabilityContextForRequest.getAvailabilityStrategyContext();
            if (availabilityStrategyContext != null && availabilityStrategyContext.isAvailabilityStrategyEnabled() && availabilityStrategyContext.isHedgedRequest()) {
                return applicableRegionalRoutingContexts;
            }
            modifiedRegionalRoutingContexts = new ArrayList<RegionalRoutingContext>();
            RegionalRoutingContext firstApplicableRegionalRoutingContext = (RegionalRoutingContext)applicableRegionalRoutingContexts.get(0);
            if (isFallbackRoutingContextUsed) {
                if (!userConfiguredExcludeRegions.isEmpty() && regionalRoutingContextsRemovedByInternalExcludeRegions.isEmpty()) {
                    crossRegionAvailabilityContextForRequest.shouldUsePerPartitionAutomaticFailoverOverrideForReadsIfApplicable(true);
                    return applicableRegionalRoutingContexts;
                }
                if (effectivePreferredLocations != null && !effectivePreferredLocations.isEmpty()) {
                    if (crossRegionAvailabilityContextForRequest.hasPerPartitionAutomaticFailoverBeenAppliedForReads()) {
                        crossRegionAvailabilityContextForRequest.shouldUsePerPartitionAutomaticFailoverOverrideForReadsIfApplicable(false);
                        modifiedRegionalRoutingContexts.add(firstApplicableRegionalRoutingContext);
                    } else {
                        crossRegionAvailabilityContextForRequest.shouldUsePerPartitionAutomaticFailoverOverrideForReadsIfApplicable(true);
                    }
                }
            }
            modifiedRegionalRoutingContexts.add(firstApplicableRegionalRoutingContext);
            boolean isFirstApplicableRoutingContextAGlobalRoutingContext = !regionNameByRegionalRoutingContexts.containsKey(firstApplicableRegionalRoutingContext);
            Preconditions.checkNotNull(hubRoutingContext, "Argument 'hubRegionalEndpoint' cannot be null!");
            if (internalExcludeRegions == null || internalExcludeRegions.isEmpty()) break block14;
            if (isFirstApplicableRoutingContextAGlobalRoutingContext) {
                for (String internalExcludeRegion : internalExcludeRegions) {
                    Utils.ValueHolder<Object> regionalRoutingContextValueHolder;
                    if (!Utils.tryGetValue(regionalRoutingContextsByRegionName, internalExcludeRegion, regionalRoutingContextValueHolder = new Utils.ValueHolder<Object>(null)) || ((RegionalRoutingContext)regionalRoutingContextValueHolder.v).equals(hubRoutingContext)) continue;
                    modifiedRegionalRoutingContexts.add((RegionalRoutingContext)regionalRoutingContextValueHolder.v);
                    break;
                }
            } else {
                for (String internalExcludeRegion : internalExcludeRegions) {
                    Utils.ValueHolder<Object> regionalRoutingContextValueHolder;
                    if (!Utils.tryGetValue(regionalRoutingContextsByRegionName, internalExcludeRegion, regionalRoutingContextValueHolder = new Utils.ValueHolder<Object>(null)) || ((RegionalRoutingContext)regionalRoutingContextValueHolder.v).equals(firstApplicableRegionalRoutingContext) || userConfiguredExcludeRegions.contains(internalExcludeRegion)) continue;
                    modifiedRegionalRoutingContexts.add((RegionalRoutingContext)regionalRoutingContextValueHolder.v);
                    break;
                }
            }
        }
        return new UnmodifiableList<RegionalRoutingContext>((List<RegionalRoutingContext>)modifiedRegionalRoutingContexts);
    }

    private boolean isExcludeRegionsConfigured(List<String> excludedRegionsOnRequest, List<String> excludedRegionsOnClient) {
        boolean isExcludedRegionsConfiguredOnRequest = excludedRegionsOnRequest != null && !excludedRegionsOnRequest.isEmpty();
        boolean isExcludedRegionsConfiguredOnClient = excludedRegionsOnClient != null && !excludedRegionsOnClient.isEmpty();
        return isExcludedRegionsConfiguredOnRequest || isExcludedRegionsConfiguredOnClient;
    }

    public RegionalRoutingContext resolveFaultInjectionEndpoint(String region, boolean writeOnly) {
        Utils.ValueHolder endpointValueHolder = new Utils.ValueHolder();
        if (writeOnly) {
            Utils.tryGetValue(this.locationInfo.availableWriteRegionalRoutingContextsByRegionName, region, endpointValueHolder);
        } else {
            Utils.tryGetValue(this.locationInfo.availableReadRegionalRoutingContextsByRegionName, region, endpointValueHolder);
        }
        if (endpointValueHolder.v != null) {
            return (RegionalRoutingContext)endpointValueHolder.v;
        }
        throw new IllegalArgumentException("Can not find service endpoint for region " + region);
    }

    public URI getDefaultEndpoint() {
        return this.defaultRoutingContext.getGatewayRegionalEndpoint();
    }

    public boolean shouldRefreshEndpoints(Utils.ValueHolder<Boolean> canRefreshInBackground) {
        canRefreshInBackground.v = true;
        DatabaseAccountLocationsInfo currentLocationInfo = this.locationInfo;
        String mostPreferredLocation = (String)Utils.firstOrDefault(currentLocationInfo.preferredLocations);
        if (StringUtils.isEmpty(mostPreferredLocation)) {
            mostPreferredLocation = (String)Utils.firstOrDefault(currentLocationInfo.effectivePreferredLocations);
        }
        if (this.enableEndpointDiscovery) {
            boolean shouldRefresh = this.useMultipleWriteLocations && !this.enableMultipleWriteLocations;
            UnmodifiableList readLocationEndpoints = currentLocationInfo.readRegionalRoutingContexts;
            if (this.isEndpointUnavailable((RegionalRoutingContext)readLocationEndpoints.get(0), OperationType.Read)) {
                canRefreshInBackground.v = this.anyEndpointsAvailable(readLocationEndpoints, OperationType.Read);
                logger.debug("shouldRefreshEndpoints = true,  since the first read endpoint [{}] is not available for read. canRefreshInBackground = [{}]", readLocationEndpoints.get(0), canRefreshInBackground.v);
                return true;
            }
            if (!Strings.isNullOrEmpty(mostPreferredLocation)) {
                Utils.ValueHolder mostPreferredReadEndpointHolder = new Utils.ValueHolder();
                logger.debug("getReadEndpoints [{}]", (Object)readLocationEndpoints);
                if (Utils.tryGetValue(currentLocationInfo.availableReadRegionalRoutingContextsByRegionName, mostPreferredLocation, mostPreferredReadEndpointHolder)) {
                    logger.debug("most preferred is [{}], most preferred available is [{}]", (Object)mostPreferredLocation, mostPreferredReadEndpointHolder.v);
                    if (!this.areEqual((RegionalRoutingContext)mostPreferredReadEndpointHolder.v, (RegionalRoutingContext)readLocationEndpoints.get(0))) {
                        logger.debug("shouldRefreshEndpoints = true, most preferred location [{}] is not available for read.", (Object)mostPreferredLocation);
                        return true;
                    }
                    logger.debug("most preferred is [{}], and most preferred available [{}] are the same", (Object)mostPreferredLocation, mostPreferredReadEndpointHolder.v);
                } else {
                    logger.debug("shouldRefreshEndpoints = true, most preferred location [{}] is not in available read locations.", (Object)mostPreferredLocation);
                    return true;
                }
            }
            Utils.ValueHolder mostPreferredWriteEndpointHolder = new Utils.ValueHolder();
            UnmodifiableList writeLocationEndpoints = currentLocationInfo.writeRegionalRoutingContexts;
            logger.debug("getWriteEndpoints [{}]", (Object)writeLocationEndpoints);
            if (!this.canUseMultipleWriteLocations()) {
                if (this.isEndpointUnavailable((RegionalRoutingContext)writeLocationEndpoints.get(0), OperationType.Write)) {
                    canRefreshInBackground.v = this.anyEndpointsAvailable(writeLocationEndpoints, OperationType.Write);
                    logger.debug("shouldRefreshEndpoints = true, most preferred location [{}] endpoint [{}] is not available for write. canRefreshInBackground = [{}]", new Object[]{mostPreferredLocation, writeLocationEndpoints.get(0), canRefreshInBackground.v});
                    return true;
                }
                logger.debug("shouldRefreshEndpoints: false, [{}] is available for Write", writeLocationEndpoints.get(0));
                return shouldRefresh;
            }
            if (!Strings.isNullOrEmpty(mostPreferredLocation)) {
                if (Utils.tryGetValue(currentLocationInfo.availableWriteRegionalRoutingContextsByRegionName, mostPreferredLocation, mostPreferredWriteEndpointHolder)) {
                    boolean bl = shouldRefresh = !this.areEqual((RegionalRoutingContext)mostPreferredWriteEndpointHolder.v, (RegionalRoutingContext)writeLocationEndpoints.get(0));
                    if (shouldRefresh) {
                        logger.debug("shouldRefreshEndpoints: true, write endpoint [{}] is not the same as most preferred [{}]", writeLocationEndpoints.get(0), mostPreferredWriteEndpointHolder.v);
                    } else {
                        logger.debug("shouldRefreshEndpoints: false, write endpoint [{}] is the same as most preferred [{}]", writeLocationEndpoints.get(0), mostPreferredWriteEndpointHolder.v);
                    }
                    return shouldRefresh;
                }
                logger.debug("shouldRefreshEndpoints = true, most preferred location [{}] is not in available write locations", (Object)mostPreferredLocation);
                return true;
            }
            logger.debug("shouldRefreshEndpoints: false, mostPreferredLocation [{}] is empty", (Object)mostPreferredLocation);
            return shouldRefresh;
        }
        logger.debug("shouldRefreshEndpoints: false, endpoint discovery not enabled");
        return false;
    }

    public String getRegionName(URI locationEndpoint, com.azure.cosmos.implementation.OperationType operationType) {
        return this.getRegionName(locationEndpoint, operationType, false);
    }

    public String getRegionName(URI locationEndpoint, com.azure.cosmos.implementation.OperationType operationType, boolean isPerPartitionAutomaticFailoverEnabled) {
        Utils.ValueHolder regionName = new Utils.ValueHolder();
        RegionalRoutingContext regionalRoutingContext = new RegionalRoutingContext(locationEndpoint);
        if (isPerPartitionAutomaticFailoverEnabled ? Utils.tryGetValue(this.locationInfo.regionNameByReadRegionalRoutingContexts, regionalRoutingContext, regionName) : (operationType.isWriteOperation() ? Utils.tryGetValue(this.locationInfo.regionNameByWriteRegionalRoutingContexts, regionalRoutingContext, regionName) : Utils.tryGetValue(this.locationInfo.regionNameByReadRegionalRoutingContexts, regionalRoutingContext, regionName))) {
            return (String)regionName.v;
        }
        return ((String)this.locationInfo.availableWriteLocations.get(0)).toLowerCase(Locale.ROOT);
    }

    private boolean areEqual(RegionalRoutingContext url1, RegionalRoutingContext url2) {
        return url1.equals(url2);
    }

    private void clearStaleEndpointUnavailabilityInfo() {
        if (!this.locationUnavailabilityInfoByEndpoint.isEmpty()) {
            ArrayList unavailableEndpoints = new ArrayList(this.locationUnavailabilityInfoByEndpoint.keySet());
            for (RegionalRoutingContext unavailableEndpoint : unavailableEndpoints) {
                Utils.ValueHolder unavailabilityInfoHolder = new Utils.ValueHolder();
                Utils.ValueHolder removedHolder = new Utils.ValueHolder();
                if (!Utils.tryGetValue(this.locationUnavailabilityInfoByEndpoint, unavailableEndpoint, unavailabilityInfoHolder) || !this.durationPassed(Instant.now(), ((LocationUnavailabilityInfo)unavailabilityInfoHolder.v).lastUnavailabilityCheckTimeStamp, this.unavailableLocationsExpirationTime) || !Utils.tryRemove(this.locationUnavailabilityInfoByEndpoint, unavailableEndpoint, removedHolder)) continue;
                logger.debug("Removed endpoint [{}] unavailable for operations [{}] from unavailableEndpoints", (Object)unavailableEndpoint, (Object)((LocationUnavailabilityInfo)unavailabilityInfoHolder.v).unavailableOperations);
            }
        }
    }

    private boolean isEndpointUnavailable(RegionalRoutingContext endpoint, OperationType expectedAvailableOperations) {
        Utils.ValueHolder unavailabilityInfoHolder = new Utils.ValueHolder();
        if (expectedAvailableOperations == OperationType.None || !Utils.tryGetValue(this.locationUnavailabilityInfoByEndpoint, endpoint, unavailabilityInfoHolder) || !((LocationUnavailabilityInfo)unavailabilityInfoHolder.v).unavailableOperations.supports(expectedAvailableOperations)) {
            return false;
        }
        if (this.durationPassed(Instant.now(), ((LocationUnavailabilityInfo)unavailabilityInfoHolder.v).lastUnavailabilityCheckTimeStamp, this.unavailableLocationsExpirationTime)) {
            return false;
        }
        logger.debug("Endpoint [{}] unavailable for operations [{}] present in unavailableEndpoints", (Object)endpoint, (Object)((LocationUnavailabilityInfo)unavailabilityInfoHolder.v).unavailableOperations);
        return true;
    }

    private boolean anyEndpointsAvailable(List<RegionalRoutingContext> endpoints, OperationType expectedAvailableOperations) {
        boolean anyEndpointsAvailable = false;
        for (RegionalRoutingContext endpoint : endpoints) {
            if (this.isEndpointUnavailable(endpoint, expectedAvailableOperations)) continue;
            anyEndpointsAvailable = true;
            break;
        }
        return anyEndpointsAvailable;
    }

    private void markEndpointUnavailable(URI unavailableEndpoint, final OperationType unavailableOperationType) {
        final Instant currentTime = Instant.now();
        LocationUnavailabilityInfo updatedInfo = this.locationUnavailabilityInfoByEndpoint.compute(new RegionalRoutingContext(unavailableEndpoint), new BiFunction<RegionalRoutingContext, LocationUnavailabilityInfo, LocationUnavailabilityInfo>(){

            @Override
            public LocationUnavailabilityInfo apply(RegionalRoutingContext url, LocationUnavailabilityInfo info) {
                if (info == null) {
                    return new LocationUnavailabilityInfo(currentTime, unavailableOperationType);
                }
                info.lastUnavailabilityCheckTimeStamp = currentTime;
                info.unavailableOperations = OperationType.combine(info.unavailableOperations, unavailableOperationType);
                return info;
            }
        });
        this.updateLocationCache();
        logger.debug("Endpoint [{}] unavailable for [{}] added/updated to unavailableEndpoints with timestamp [{}]", new Object[]{unavailableEndpoint, unavailableOperationType, updatedInfo.lastUnavailabilityCheckTimeStamp});
    }

    private void updateLocationCache() {
        this.updateLocationCache(null, null, null, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLocationCache(Iterable<DatabaseAccountLocation> gatewayWriteLocations, Iterable<DatabaseAccountLocation> gatewayReadLocations, Iterable<DatabaseAccountLocation> thinClientWriteLocations, Iterable<DatabaseAccountLocation> thinClientReadLocations, UnmodifiableList<String> preferenceList, Boolean enableMultipleWriteLocations) {
        Object object = this.lockObject;
        synchronized (object) {
            DatabaseAccountLocationsInfo nextLocationInfo = new DatabaseAccountLocationsInfo(this.locationInfo);
            logger.debug("updating location cache ..., current readLocations [{}], current writeLocations [{}]", (Object)nextLocationInfo.readRegionalRoutingContexts, (Object)nextLocationInfo.writeRegionalRoutingContexts);
            if (preferenceList != null) {
                nextLocationInfo.preferredLocations = preferenceList;
            }
            if (enableMultipleWriteLocations != null) {
                this.enableMultipleWriteLocations = enableMultipleWriteLocations;
            }
            this.clearStaleEndpointUnavailabilityInfo();
            if (gatewayReadLocations != null) {
                Utils.ValueHolder<UnmodifiableList<String>> readLocationsValueHolderOut = Utils.ValueHolder.initialize(nextLocationInfo.availableReadLocations);
                Utils.ValueHolder<UnmodifiableList<RegionalRoutingContext>> availableReadEndpointsOut = Utils.ValueHolder.initialize(nextLocationInfo.availableReadRegionalRoutingContexts);
                Utils.ValueHolder<UnmodifiableMap<RegionalRoutingContext, String>> readRegionMapValueHolderOut = Utils.ValueHolder.initialize(nextLocationInfo.regionNameByReadRegionalRoutingContexts);
                nextLocationInfo.availableReadRegionalRoutingContextsByRegionName = this.getEndpointsByLocation(gatewayReadLocations, thinClientReadLocations, readLocationsValueHolderOut, availableReadEndpointsOut, readRegionMapValueHolderOut);
                nextLocationInfo.availableReadLocations = (UnmodifiableList)readLocationsValueHolderOut.v;
                nextLocationInfo.regionNameByReadRegionalRoutingContexts = (UnmodifiableMap)readRegionMapValueHolderOut.v;
                nextLocationInfo.availableReadRegionalRoutingContexts = (UnmodifiableList)availableReadEndpointsOut.v;
                nextLocationInfo.hubRoutingContext = (RegionalRoutingContext)nextLocationInfo.availableReadRegionalRoutingContexts.get(0);
            }
            if (gatewayWriteLocations != null) {
                Utils.ValueHolder<UnmodifiableList<String>> writeLocationsValueHolderOut = Utils.ValueHolder.initialize(nextLocationInfo.availableWriteLocations);
                Utils.ValueHolder<UnmodifiableMap<RegionalRoutingContext, String>> writeRegionMapOut = Utils.ValueHolder.initialize(nextLocationInfo.regionNameByWriteRegionalRoutingContexts);
                Utils.ValueHolder<UnmodifiableList<RegionalRoutingContext>> availableWriteEndpointsOut = Utils.ValueHolder.initialize(nextLocationInfo.availableWriteRegionalRoutingContexts);
                nextLocationInfo.availableWriteRegionalRoutingContextsByRegionName = this.getEndpointsByLocation(gatewayWriteLocations, thinClientWriteLocations, writeLocationsValueHolderOut, availableWriteEndpointsOut, writeRegionMapOut);
                nextLocationInfo.availableWriteLocations = (UnmodifiableList)writeLocationsValueHolderOut.v;
                nextLocationInfo.regionNameByWriteRegionalRoutingContexts = (UnmodifiableMap)writeRegionMapOut.v;
                nextLocationInfo.availableWriteRegionalRoutingContexts = (UnmodifiableList)availableWriteEndpointsOut.v;
                nextLocationInfo.hubRoutingContext = (RegionalRoutingContext)nextLocationInfo.availableWriteRegionalRoutingContexts.get(0);
            }
            nextLocationInfo.writeRegionalRoutingContexts = this.getPreferredAvailableRoutingContexts(nextLocationInfo.availableWriteRegionalRoutingContextsByRegionName, nextLocationInfo.availableWriteLocations, OperationType.Write, this.defaultRoutingContext);
            nextLocationInfo.readRegionalRoutingContexts = this.getPreferredAvailableRoutingContexts(nextLocationInfo.availableReadRegionalRoutingContextsByRegionName, nextLocationInfo.availableReadLocations, OperationType.Read, (RegionalRoutingContext)nextLocationInfo.writeRegionalRoutingContexts.get(0));
            if (nextLocationInfo.preferredLocations == null || nextLocationInfo.preferredLocations.isEmpty()) {
                Utils.ValueHolder regionForDefaultEndpoint = new Utils.ValueHolder();
                if (!Utils.tryGetValue(nextLocationInfo.regionNameByReadRegionalRoutingContexts, this.defaultRoutingContext, regionForDefaultEndpoint)) {
                    nextLocationInfo.effectivePreferredLocations = nextLocationInfo.availableReadLocations;
                }
            }
            this.lastCacheUpdateTimestamp = Instant.now();
            logger.debug("updating location cache finished, new readLocations [{}], new writeLocations [{}]", (Object)nextLocationInfo.readRegionalRoutingContexts, (Object)nextLocationInfo.writeRegionalRoutingContexts);
            this.locationInfo = nextLocationInfo;
        }
    }

    private UnmodifiableList<RegionalRoutingContext> getPreferredAvailableRoutingContexts(UnmodifiableMap<String, RegionalRoutingContext> endpointsByLocation, UnmodifiableList<String> orderedLocations, OperationType expectedAvailableOperation, RegionalRoutingContext fallbackRegionalRoutingContext) {
        ArrayList<RegionalRoutingContext> endpoints = new ArrayList<RegionalRoutingContext>();
        DatabaseAccountLocationsInfo currentLocationInfo = this.locationInfo;
        if (this.enableEndpointDiscovery) {
            if (this.canUseMultipleWriteLocations() || expectedAvailableOperation.supports(OperationType.Read)) {
                ArrayList<RegionalRoutingContext> unavailableEndpoints = new ArrayList<RegionalRoutingContext>();
                if (currentLocationInfo.preferredLocations != null && !currentLocationInfo.preferredLocations.isEmpty()) {
                    for (String location : currentLocationInfo.preferredLocations) {
                        Utils.ValueHolder endpoint;
                        if (!Utils.tryGetValue(endpointsByLocation, location, endpoint = new Utils.ValueHolder())) continue;
                        if (this.isEndpointUnavailable((RegionalRoutingContext)endpoint.v, expectedAvailableOperation)) {
                            unavailableEndpoints.add((RegionalRoutingContext)endpoint.v);
                            continue;
                        }
                        endpoints.add((RegionalRoutingContext)endpoint.v);
                    }
                } else {
                    for (String location : orderedLocations) {
                        Utils.ValueHolder<Object> endpoint;
                        if (!Utils.tryGetValue(endpointsByLocation, location, endpoint = Utils.ValueHolder.initialize(null))) continue;
                        if (this.defaultRoutingContext.getGatewayRegionalEndpoint().equals(((RegionalRoutingContext)endpoint.v).getGatewayRegionalEndpoint())) {
                            endpoints = new ArrayList();
                            break;
                        }
                        if (this.isEndpointUnavailable((RegionalRoutingContext)endpoint.v, expectedAvailableOperation)) {
                            unavailableEndpoints.add((RegionalRoutingContext)endpoint.v);
                            continue;
                        }
                        endpoints.add((RegionalRoutingContext)endpoint.v);
                    }
                }
                if (endpoints.isEmpty()) {
                    endpoints.add(fallbackRegionalRoutingContext);
                }
                endpoints.addAll(unavailableEndpoints);
            } else {
                for (String location : orderedLocations) {
                    Utils.ValueHolder<Object> endpoint = Utils.ValueHolder.initialize(null);
                    if (Strings.isNullOrEmpty(location) || !Utils.tryGetValue(endpointsByLocation, location, endpoint)) continue;
                    endpoints.add((RegionalRoutingContext)endpoint.v);
                }
            }
        }
        if (endpoints.isEmpty()) {
            endpoints.add(fallbackRegionalRoutingContext);
        }
        return new UnmodifiableList<RegionalRoutingContext>((List<RegionalRoutingContext>)endpoints);
    }

    private void addRoutingContexts(Iterable<DatabaseAccountLocation> gatewayDbAccountLocations, Iterable<DatabaseAccountLocation> thinclientDbAccountLocations, Map<String, RegionalRoutingContext> endpointsByLocation, Map<RegionalRoutingContext, String> regionByEndpoint, List<String> parsedLocations, List<RegionalRoutingContext> orderedEndpoints) {
        RegionalRoutingContext regionalRoutingContext;
        URI endpoint;
        String location;
        if (gatewayDbAccountLocations != null) {
            for (DatabaseAccountLocation gatewayDbAccountLocation : gatewayDbAccountLocations) {
                if (Strings.isNullOrEmpty(gatewayDbAccountLocation.getName())) continue;
                try {
                    location = gatewayDbAccountLocation.getName().toLowerCase(Locale.ROOT);
                    endpoint = new URI(gatewayDbAccountLocation.getEndpoint().toLowerCase(Locale.ROOT));
                    regionalRoutingContext = new RegionalRoutingContext(endpoint);
                    if (!endpointsByLocation.containsKey(location)) {
                        endpointsByLocation.put(location, regionalRoutingContext);
                    }
                    if (!regionByEndpoint.containsKey(regionalRoutingContext)) {
                        regionByEndpoint.put(regionalRoutingContext, location);
                    }
                    parsedLocations.add(gatewayDbAccountLocation.getName());
                    orderedEndpoints.add(regionalRoutingContext);
                }
                catch (Exception e) {
                    logger.warn("Skipping add for location = [{}] and endpoint = [{}] due to exception [{}]", new Object[]{gatewayDbAccountLocation.getName(), gatewayDbAccountLocation.getEndpoint(), e.getMessage()});
                }
            }
        }
        if (thinclientDbAccountLocations != null) {
            for (DatabaseAccountLocation thinclientDbAccountLocation : thinclientDbAccountLocations) {
                if (Strings.isNullOrEmpty(thinclientDbAccountLocation.getName())) continue;
                try {
                    location = thinclientDbAccountLocation.getName().toLowerCase(Locale.ROOT);
                    endpoint = new URI(thinclientDbAccountLocation.getEndpoint().toLowerCase(Locale.ROOT));
                    regionalRoutingContext = endpointsByLocation.get(location);
                    regionalRoutingContext.setThinclientRegionalEndpoint(endpoint);
                }
                catch (Exception e) {
                    logger.warn("Skipping add for location = [{}] and endpoint = [{}] due to exception [{}]", new Object[]{thinclientDbAccountLocation.getName(), thinclientDbAccountLocation.getEndpoint(), e.getMessage()});
                }
            }
        }
    }

    private UnmodifiableMap<String, RegionalRoutingContext> getEndpointsByLocation(Iterable<DatabaseAccountLocation> gatewayLocations, Iterable<DatabaseAccountLocation> thinclientLocations, Utils.ValueHolder<UnmodifiableList<String>> orderedLocations, Utils.ValueHolder<UnmodifiableList<RegionalRoutingContext>> orderedEndpointsHolder, Utils.ValueHolder<UnmodifiableMap<RegionalRoutingContext, String>> regionMap) {
        CaseInsensitiveMap<String, RegionalRoutingContext> endpointsByLocation = new CaseInsensitiveMap<String, RegionalRoutingContext>();
        CaseInsensitiveMap<RegionalRoutingContext, String> regionByEndpoint = new CaseInsensitiveMap<RegionalRoutingContext, String>();
        ArrayList<String> parsedLocations = new ArrayList<String>();
        ArrayList<RegionalRoutingContext> orderedEndpoints = new ArrayList<RegionalRoutingContext>();
        this.addRoutingContexts(gatewayLocations, thinclientLocations, endpointsByLocation, regionByEndpoint, parsedLocations, orderedEndpoints);
        orderedLocations.v = new UnmodifiableList<String>((List<String>)parsedLocations);
        orderedEndpointsHolder.v = new UnmodifiableList<RegionalRoutingContext>((List<RegionalRoutingContext>)orderedEndpoints);
        regionMap.v = (UnmodifiableMap)UnmodifiableMap.unmodifiableMap(regionByEndpoint);
        return (UnmodifiableMap)UnmodifiableMap.unmodifiableMap(endpointsByLocation);
    }

    public boolean canUseMultipleWriteLocations() {
        return this.useMultipleWriteLocations && this.enableMultipleWriteLocations;
    }

    public boolean canUseMultipleWriteLocations(RxDocumentServiceRequest request) {
        return this.canUseMultipleWriteLocations() && (request.getResourceType() == ResourceType.Document || request.getResourceType() == ResourceType.StoredProcedure && request.getOperationType() == com.azure.cosmos.implementation.OperationType.ExecuteJavaScript);
    }

    private boolean durationPassed(Instant end, Instant start, Duration duration) {
        return end.minus(duration).isAfter(start);
    }

    private boolean unavailableLocationsExpirationTimePassed() {
        return this.durationPassed(Instant.now(), this.lastCacheUpdateTimestamp, this.unavailableLocationsExpirationTime);
    }

    private static boolean isExcludedRegionsSupplierConfigured(Supplier<CosmosExcludedRegions> excludedRegionsSupplier) {
        return excludedRegionsSupplier != null && excludedRegionsSupplier.get() != null;
    }

    static class DatabaseAccountLocationsInfo {
        private UnmodifiableList<RegionalRoutingContext> writeRegionalRoutingContexts;
        private UnmodifiableList<RegionalRoutingContext> readRegionalRoutingContexts;
        private UnmodifiableList<String> preferredLocations;
        private UnmodifiableList<String> effectivePreferredLocations;
        private UnmodifiableList<String> availableWriteLocations;
        private UnmodifiableList<String> availableReadLocations;
        private UnmodifiableMap<String, RegionalRoutingContext> availableWriteRegionalRoutingContextsByRegionName;
        private UnmodifiableMap<String, RegionalRoutingContext> availableReadRegionalRoutingContextsByRegionName;
        private UnmodifiableMap<RegionalRoutingContext, String> regionNameByWriteRegionalRoutingContexts;
        private UnmodifiableMap<RegionalRoutingContext, String> regionNameByReadRegionalRoutingContexts;
        private UnmodifiableList<RegionalRoutingContext> availableWriteRegionalRoutingContexts;
        private UnmodifiableList<RegionalRoutingContext> availableReadRegionalRoutingContexts;
        private RegionalRoutingContext hubRoutingContext;

        public DatabaseAccountLocationsInfo(List<String> preferredLocations, RegionalRoutingContext defaultRoutingContext) {
            this.preferredLocations = new UnmodifiableList(preferredLocations.stream().map(loc -> loc.toLowerCase(Locale.ROOT)).collect(Collectors.toList()));
            this.effectivePreferredLocations = new UnmodifiableList(Collections.emptyList());
            this.availableWriteRegionalRoutingContextsByRegionName = (UnmodifiableMap)UnmodifiableMap.unmodifiableMap(new CaseInsensitiveMap());
            this.availableReadRegionalRoutingContextsByRegionName = (UnmodifiableMap)UnmodifiableMap.unmodifiableMap(new CaseInsensitiveMap());
            this.regionNameByWriteRegionalRoutingContexts = (UnmodifiableMap)UnmodifiableMap.unmodifiableMap(new CaseInsensitiveMap());
            this.regionNameByReadRegionalRoutingContexts = (UnmodifiableMap)UnmodifiableMap.unmodifiableMap(new CaseInsensitiveMap());
            this.availableReadLocations = new UnmodifiableList(Collections.emptyList());
            this.availableWriteLocations = new UnmodifiableList(Collections.emptyList());
            this.readRegionalRoutingContexts = new UnmodifiableList<RegionalRoutingContext>(Collections.singletonList(defaultRoutingContext));
            this.writeRegionalRoutingContexts = new UnmodifiableList<RegionalRoutingContext>(Collections.singletonList(defaultRoutingContext));
            this.availableReadRegionalRoutingContexts = new UnmodifiableList<RegionalRoutingContext>(Collections.singletonList(defaultRoutingContext));
            this.availableWriteRegionalRoutingContexts = new UnmodifiableList<RegionalRoutingContext>(Collections.singletonList(defaultRoutingContext));
        }

        public DatabaseAccountLocationsInfo(DatabaseAccountLocationsInfo other) {
            this.preferredLocations = other.preferredLocations;
            this.effectivePreferredLocations = other.effectivePreferredLocations;
            this.availableWriteLocations = other.availableWriteLocations;
            this.availableReadLocations = other.availableReadLocations;
            this.availableWriteRegionalRoutingContextsByRegionName = other.availableWriteRegionalRoutingContextsByRegionName;
            this.regionNameByWriteRegionalRoutingContexts = other.regionNameByWriteRegionalRoutingContexts;
            this.regionNameByReadRegionalRoutingContexts = other.regionNameByReadRegionalRoutingContexts;
            this.availableReadRegionalRoutingContextsByRegionName = other.availableReadRegionalRoutingContextsByRegionName;
            this.writeRegionalRoutingContexts = other.writeRegionalRoutingContexts;
            this.readRegionalRoutingContexts = other.readRegionalRoutingContexts;
            this.availableReadRegionalRoutingContexts = other.availableReadRegionalRoutingContexts;
            this.availableWriteRegionalRoutingContexts = other.availableWriteRegionalRoutingContexts;
            this.hubRoutingContext = other.hubRoutingContext;
        }
    }

    private static enum OperationType {
        None(0),
        Read(1),
        Write(2),
        ReadAndWrite(3);

        private final int flag;

        public boolean hasReadFlag() {
            return (this.flag & OperationType.Read.flag) != 0;
        }

        public boolean hasWriteFlag() {
            return (this.flag & OperationType.Write.flag) != 0;
        }

        public static OperationType combine(OperationType t1, OperationType t2) {
            switch (t1.flag | t2.flag) {
                case 0: {
                    return None;
                }
                case 1: {
                    return Read;
                }
                case 2: {
                    return Write;
                }
            }
            return ReadAndWrite;
        }

        public boolean supports(OperationType type) {
            return (this.flag & type.flag) != 0;
        }

        private OperationType(int flag) {
            this.flag = flag;
        }
    }

    private static class LocationUnavailabilityInfo {
        public Instant lastUnavailabilityCheckTimeStamp;
        public OperationType unavailableOperations;

        LocationUnavailabilityInfo(Instant instant, OperationType type) {
            this.lastUnavailabilityCheckTimeStamp = instant;
            this.unavailableOperations = type;
        }
    }
}

