/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.query.metrics;

import com.azure.cosmos.implementation.apachecommons.lang.time.StopWatch;
import com.azure.cosmos.implementation.query.metrics.SchedulingTimeSpan;

public class SchedulingStopwatch {
    private StopWatch turnaroundTimeStopwatch = new StopWatch();
    private StopWatch responseTimeStopwatch = new StopWatch();
    private StopWatch runTimeStopwatch = new StopWatch();
    private long numPreemptions;
    private boolean responded;

    public SchedulingTimeSpan getElapsedTime() {
        return new SchedulingTimeSpan(this.turnaroundTimeStopwatch.getTime(), this.responseTimeStopwatch.getTime(), this.runTimeStopwatch.getTime(), this.turnaroundTimeStopwatch.getTime() - this.runTimeStopwatch.getTime(), this.numPreemptions);
    }

    public void ready() {
        this.startStopWatch(this.turnaroundTimeStopwatch);
        this.startStopWatch(this.responseTimeStopwatch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        StopWatch stopWatch = this.runTimeStopwatch;
        synchronized (stopWatch) {
            if (this.runTimeStopwatch.isStarted()) {
                return;
            }
            if (!this.responded) {
                this.stopStopWatch(this.responseTimeStopwatch);
                this.responded = true;
            }
            this.runTimeStopwatch.reset();
            this.runTimeStopwatch.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        StopWatch stopWatch = this.runTimeStopwatch;
        synchronized (stopWatch) {
            if (!this.runTimeStopwatch.isStarted()) {
                return;
            }
            this.runTimeStopwatch.stop();
            ++this.numPreemptions;
        }
    }

    public void terminate() {
        this.stopStopWatch(this.turnaroundTimeStopwatch);
        this.stopStopWatch(this.responseTimeStopwatch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startStopWatch(StopWatch stopwatch) {
        StopWatch stopWatch = stopwatch;
        synchronized (stopWatch) {
            if (stopwatch.isStarted()) {
                return;
            }
            stopwatch.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopStopWatch(StopWatch stopwatch) {
        StopWatch stopWatch = stopwatch;
        synchronized (stopWatch) {
            if (!stopwatch.isStarted()) {
                return;
            }
            stopwatch.stop();
        }
    }
}

