/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity.addressEnumerator;

import com.azure.cosmos.implementation.directconnectivity.Uri;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;

public class AddressEnumeratorFisherYateShuffle {
    public static List<Uri> getTransportAddressUris(List<Uri> addresses) {
        Preconditions.checkNotNull(addresses, "Argument 'addresses' should not be null");
        ArrayList<Uri> addressesCopy = new ArrayList<Uri>(addresses);
        for (int i = addressesCopy.size(); i > 0; --i) {
            int randomIndex = AddressEnumeratorFisherYateShuffle.generateNextRandom(i);
            Collections.swap(addressesCopy, i - 1, randomIndex);
        }
        return addressesCopy;
    }

    private static int generateNextRandom(int maxValue) {
        return ThreadLocalRandom.current().nextInt(maxValue);
    }
}

