/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.changefeed.common;

import com.azure.cosmos.implementation.JsonSerializable;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.changefeed.common.ChangeFeedMode;
import com.azure.cosmos.implementation.changefeed.common.ChangeFeedStartFromBeginningImpl;
import com.azure.cosmos.implementation.changefeed.common.ChangeFeedStartFromETagAndFeedRangeImpl;
import com.azure.cosmos.implementation.changefeed.common.ChangeFeedStartFromInternalDeserializer;
import com.azure.cosmos.implementation.changefeed.common.ChangeFeedStartFromLegacyContinuationImpl;
import com.azure.cosmos.implementation.changefeed.common.ChangeFeedStartFromNowImpl;
import com.azure.cosmos.implementation.changefeed.common.ChangeFeedStartFromPointInTimeImpl;
import com.azure.cosmos.implementation.feedranges.FeedRangeInternal;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.Instant;

@JsonDeserialize(using=ChangeFeedStartFromInternalDeserializer.class)
public abstract class ChangeFeedStartFromInternal
extends JsonSerializable {
    protected static final long START_FROM_BEGINNING_EPOCH_SECONDS = -62135596800L;
    protected static final Instant START_FROM_BEGINNING_TIME = Instant.ofEpochSecond(-62135596800L);

    ChangeFeedStartFromInternal() {
    }

    public static ChangeFeedStartFromInternal createFromBeginning() {
        return InstanceHolder.FROM_BEGINNING_SINGLETON;
    }

    public static ChangeFeedStartFromInternal createFromETagAndFeedRange(String eTag, FeedRangeInternal feedRange) {
        return new ChangeFeedStartFromETagAndFeedRangeImpl(eTag, feedRange);
    }

    public static ChangeFeedStartFromInternal createFromNow() {
        return InstanceHolder.FROM_NOW_SINGLETON;
    }

    public static ChangeFeedStartFromInternal createFromPointInTime(Instant pointInTime) {
        return new ChangeFeedStartFromPointInTimeImpl(pointInTime);
    }

    public static ChangeFeedStartFromInternal createFromLegacyContinuation() {
        return new ChangeFeedStartFromLegacyContinuationImpl();
    }

    @Override
    public void populatePropertyBag() {
        super.populatePropertyBag();
    }

    @Override
    public String toString() {
        return this.toJson();
    }

    @Override
    public String toJson() {
        String json = super.toJson();
        if (json.indexOf("\"Type\":") != json.lastIndexOf("\"Type\":")) {
            throw new IllegalStateException("There shouldn't be any duplicate json properties!");
        }
        return json;
    }

    public abstract boolean supportsFullFidelityRetention();

    public abstract void populateRequest(RxDocumentServiceRequest var1, ChangeFeedMode var2);

    private static final class InstanceHolder {
        static final ChangeFeedStartFromBeginningImpl FROM_BEGINNING_SINGLETON = new ChangeFeedStartFromBeginningImpl();
        static final ChangeFeedStartFromNowImpl FROM_NOW_SINGLETON = new ChangeFeedStartFromNowImpl();

        private InstanceHolder() {
        }
    }
}

