/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.cosmos.CosmosAsyncClient;
import com.azure.cosmos.CosmosAsyncDatabase;
import com.azure.cosmos.CosmosAsyncUser;
import com.azure.cosmos.implementation.OperationType;
import com.azure.cosmos.implementation.RequestOptions;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.models.CosmosPermissionProperties;
import com.azure.cosmos.models.CosmosPermissionRequestOptions;
import com.azure.cosmos.models.CosmosPermissionResponse;
import com.azure.cosmos.models.ModelBridgeInternal;
import reactor.core.publisher.Mono;

public class CosmosAsyncPermission {
    private final CosmosAsyncUser cosmosUser;
    private String id;

    CosmosAsyncPermission(String id, CosmosAsyncUser user) {
        this.id = id;
        this.cosmosUser = user;
    }

    public String getId() {
        return this.id;
    }

    CosmosAsyncPermission setId(String id) {
        this.id = id;
        return this;
    }

    public Mono<CosmosPermissionResponse> read(CosmosPermissionRequestOptions options) {
        if (options == null) {
            options = new CosmosPermissionRequestOptions();
        }
        CosmosPermissionRequestOptions requestOptions = options;
        return FluxUtil.withContext(context -> this.readInternal(requestOptions, (Context)context));
    }

    public Mono<CosmosPermissionResponse> replace(CosmosPermissionProperties permissionProperties, CosmosPermissionRequestOptions options) {
        if (options == null) {
            options = new CosmosPermissionRequestOptions();
        }
        CosmosPermissionRequestOptions requestOptions = options;
        return FluxUtil.withContext(context -> this.replaceInternal(permissionProperties, requestOptions, (Context)context));
    }

    public Mono<CosmosPermissionResponse> delete(CosmosPermissionRequestOptions options) {
        if (options == null) {
            options = new CosmosPermissionRequestOptions();
        }
        CosmosPermissionRequestOptions requestOptions = options;
        return FluxUtil.withContext(context -> this.deleteInternal(requestOptions, (Context)context));
    }

    String getURIPathSegment() {
        return "permissions";
    }

    String getParentLink() {
        return this.cosmosUser.getLink();
    }

    String getLink() {
        return this.getParentLink() + "/" + this.getURIPathSegment() + "/" + this.getId();
    }

    private Mono<CosmosPermissionResponse> readInternal(CosmosPermissionRequestOptions options, Context context) {
        String spanName = "readPermission." + this.cosmosUser.getId();
        RequestOptions nonNullRequestOptions = options != null ? ModelBridgeInternal.toRequestOptions(options) : new RequestOptions();
        Mono responseMono = this.cosmosUser.getDatabase().getDocClientWrapper().readPermission(this.getLink(), nonNullRequestOptions).map(ModelBridgeInternal::createCosmosPermissionResponse).single();
        CosmosAsyncClient client = this.cosmosUser.getDatabase().getClient();
        return client.getDiagnosticsProvider().traceEnabledCosmosResponsePublisher(responseMono, context, spanName, this.cosmosUser.getDatabase().getId(), null, client, null, OperationType.Read, ResourceType.Permission, nonNullRequestOptions);
    }

    private Mono<CosmosPermissionResponse> replaceInternal(CosmosPermissionProperties permissionProperties, CosmosPermissionRequestOptions options, Context context) {
        String spanName = "replacePermission." + this.cosmosUser.getId();
        RequestOptions nonNullRequestOptions = CosmosAsyncPermission.ensureAndConvertRequestOptions(options);
        CosmosAsyncDatabase databaseContext = this.cosmosUser.getDatabase();
        Mono responseMono = this.cosmosUser.getDatabase().getDocClientWrapper().replacePermission(ModelBridgeInternal.getPermission(permissionProperties, databaseContext.getId()), nonNullRequestOptions).map(ModelBridgeInternal::createCosmosPermissionResponse).single();
        CosmosAsyncClient client = this.cosmosUser.getDatabase().getClient();
        return client.getDiagnosticsProvider().traceEnabledCosmosResponsePublisher(responseMono, context, spanName, this.cosmosUser.getDatabase().getId(), null, client, null, OperationType.Replace, ResourceType.Permission, nonNullRequestOptions);
    }

    private Mono<CosmosPermissionResponse> deleteInternal(CosmosPermissionRequestOptions options, Context context) {
        String spanName = "deletePermission." + this.cosmosUser.getId();
        RequestOptions nonNullRequestOptions = CosmosAsyncPermission.ensureAndConvertRequestOptions(options);
        Mono responseMono = this.cosmosUser.getDatabase().getDocClientWrapper().deletePermission(this.getLink(), nonNullRequestOptions).map(ModelBridgeInternal::createCosmosPermissionResponse).single();
        CosmosAsyncClient client = this.cosmosUser.getDatabase().getClient();
        return client.getDiagnosticsProvider().traceEnabledCosmosResponsePublisher(responseMono, context, spanName, this.cosmosUser.getDatabase().getId(), null, client, null, OperationType.Delete, ResourceType.Permission, nonNullRequestOptions);
    }

    private static RequestOptions ensureAndConvertRequestOptions(CosmosPermissionRequestOptions options) {
        if (options != null) {
            return ModelBridgeInternal.toRequestOptions(options);
        }
        return new RequestOptions();
    }
}

