/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.cosmos.CosmosAsyncClient;
import com.azure.cosmos.CosmosAsyncDatabase;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.OperationType;
import com.azure.cosmos.implementation.RequestOptions;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.models.CosmosClientEncryptionKeyProperties;
import com.azure.cosmos.models.CosmosClientEncryptionKeyResponse;
import com.azure.cosmos.models.ModelBridgeInternal;
import reactor.core.publisher.Mono;

public final class CosmosAsyncClientEncryptionKey {
    private final CosmosAsyncDatabase database;
    private final String id;

    CosmosAsyncClientEncryptionKey(String id, CosmosAsyncDatabase database) {
        this.id = id;
        this.database = database;
    }

    public String getId() {
        return this.id;
    }

    public Mono<CosmosClientEncryptionKeyResponse> read() {
        return FluxUtil.withContext(context -> this.readInternal((Context)context, null));
    }

    Mono<CosmosClientEncryptionKeyResponse> read(RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> this.readInternal((Context)context, requestOptions));
    }

    private Mono<CosmosClientEncryptionKeyResponse> readInternal(Context context, RequestOptions requestOptions) {
        String spanName = "readClientEncryptionKey." + this.getId();
        Mono responseMono = this.database.getDocClientWrapper().readClientEncryptionKey(this.getLink(), requestOptions).map(ModelBridgeInternal::createCosmosClientEncryptionKeyResponse).single();
        CosmosAsyncClient client = this.database.getClient();
        return this.database.getClient().getDiagnosticsProvider().traceEnabledCosmosResponsePublisher(responseMono, context, spanName, this.database.getId(), null, client, null, OperationType.Read, ResourceType.ClientEncryptionKey, requestOptions);
    }

    public Mono<CosmosClientEncryptionKeyResponse> replace(CosmosClientEncryptionKeyProperties keyProperties) {
        return FluxUtil.withContext(context -> this.replaceInternal(keyProperties, (Context)context));
    }

    private Mono<CosmosClientEncryptionKeyResponse> replaceInternal(CosmosClientEncryptionKeyProperties keyProperties, Context context) {
        String spanName = "replaceClientEncryptionKey." + this.getId();
        Mono responseMono = this.database.getDocClientWrapper().replaceClientEncryptionKey(ModelBridgeInternal.getClientEncryptionKey(keyProperties), this.getLink(), null).map(ModelBridgeInternal::createCosmosClientEncryptionKeyResponse).single();
        CosmosAsyncClient client = this.database.getClient();
        return this.database.getClient().getDiagnosticsProvider().traceEnabledCosmosResponsePublisher(responseMono, context, spanName, this.database.getId(), null, client, null, OperationType.Replace, ResourceType.ClientEncryptionKey, null);
    }

    String getURIPathSegment() {
        return "clientencryptionkeys";
    }

    String getParentLink() {
        return this.database.getLink();
    }

    String getLink() {
        return this.getParentLink() + "/" + this.getURIPathSegment() + "/" + this.getId();
    }

    static void initialize() {
        ImplementationBridgeHelpers.CosmosAsyncClientEncryptionKeyHelper.setCosmosAsyncClientEncryptionKeyAccessor(CosmosAsyncClientEncryptionKey::read);
    }

    static {
        CosmosAsyncClientEncryptionKey.initialize();
    }
}

