/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.throughputControl.server;

import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.throughputControl.server.config.ServerThroughputControlGroup;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;

public class ContainerServerThroughputControlGroupProperties {
    private final String containerNameLink;
    private final AtomicReference<ServerThroughputControlGroup> defaultGroup;
    private final Map<String, ServerThroughputControlGroup> throughputControlGroups;

    public ContainerServerThroughputControlGroupProperties(String containerNameLink) {
        Preconditions.checkArgument(StringUtils.isNotEmpty(containerNameLink), "Argument 'containerNameLink' should not be empty");
        this.containerNameLink = containerNameLink;
        this.defaultGroup = new AtomicReference();
        this.throughputControlGroups = new ConcurrentHashMap<String, ServerThroughputControlGroup>();
    }

    public int enableThroughputControlGroup(ServerThroughputControlGroup group) {
        Preconditions.checkNotNull(group, "Argument 'group' should not be null'");
        if (group.isDefault() && !this.defaultGroup.compareAndSet(null, group) && !this.defaultGroup.get().equals(group)) {
            throw new IllegalArgumentException("A default group already exists");
        }
        ServerThroughputControlGroup serverThroughputControlGroup = this.throughputControlGroups.computeIfAbsent(group.getGroupName(), key -> group);
        if (!serverThroughputControlGroup.equals(group)) {
            throw new IllegalArgumentException("A group with same name already exists, name: " + group.getGroupName());
        }
        return this.throughputControlGroups.size();
    }

    public Map<String, ServerThroughputControlGroup> getThroughputControlGroups() {
        return this.throughputControlGroups;
    }

    public boolean hasDefaultGroup() {
        return this.defaultGroup.get() != null;
    }

    public boolean hasGroup(String groupName) {
        return this.throughputControlGroups.containsKey(groupName);
    }
}

