/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.ConsistencyLevel;
import com.azure.cosmos.CosmosContainerProactiveInitConfig;
import com.azure.cosmos.CosmosException;
import com.azure.cosmos.ReadConsistencyStrategy;
import com.azure.cosmos.implementation.ApiType;
import com.azure.cosmos.implementation.BackoffRetryUtility;
import com.azure.cosmos.implementation.Configs;
import com.azure.cosmos.implementation.CosmosError;
import com.azure.cosmos.implementation.CosmosSchedulers;
import com.azure.cosmos.implementation.DiagnosticsClientContext;
import com.azure.cosmos.implementation.DocumentCollection;
import com.azure.cosmos.implementation.Exceptions;
import com.azure.cosmos.implementation.GatewayRequestTimelineContext;
import com.azure.cosmos.implementation.GlobalEndpointManager;
import com.azure.cosmos.implementation.HttpConstants;
import com.azure.cosmos.implementation.ISessionContainer;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.MetadataDiagnosticsContext;
import com.azure.cosmos.implementation.MetadataRequestRetryPolicy;
import com.azure.cosmos.implementation.OperationType;
import com.azure.cosmos.implementation.PartitionKeyRange;
import com.azure.cosmos.implementation.PathsHelper;
import com.azure.cosmos.implementation.QueryCompatibilityMode;
import com.azure.cosmos.implementation.ReplicatedResourceClientUtils;
import com.azure.cosmos.implementation.RequestTimeline;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.RxDocumentServiceResponse;
import com.azure.cosmos.implementation.RxStoreModel;
import com.azure.cosmos.implementation.SessionTokenHelper;
import com.azure.cosmos.implementation.Strings;
import com.azure.cosmos.implementation.UserAgentContainer;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.caches.RxClientCollectionCache;
import com.azure.cosmos.implementation.caches.RxPartitionKeyRangeCache;
import com.azure.cosmos.implementation.directconnectivity.GatewayServiceConfigurationReader;
import com.azure.cosmos.implementation.directconnectivity.HttpUtils;
import com.azure.cosmos.implementation.directconnectivity.RequestHelper;
import com.azure.cosmos.implementation.directconnectivity.StoreResponse;
import com.azure.cosmos.implementation.directconnectivity.Uri;
import com.azure.cosmos.implementation.directconnectivity.WebExceptionUtility;
import com.azure.cosmos.implementation.faultinjection.GatewayServerErrorInjector;
import com.azure.cosmos.implementation.faultinjection.IFaultInjectorProvider;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.http.HttpClient;
import com.azure.cosmos.implementation.http.HttpHeaders;
import com.azure.cosmos.implementation.http.HttpRequest;
import com.azure.cosmos.implementation.http.HttpResponse;
import com.azure.cosmos.implementation.http.HttpTransportSerializer;
import com.azure.cosmos.implementation.http.ReactorNettyRequestRecord;
import com.azure.cosmos.implementation.routing.CollectionRoutingMap;
import com.azure.cosmos.implementation.routing.PartitionKeyInternal;
import com.azure.cosmos.implementation.routing.PartitionKeyInternalHelper;
import com.azure.cosmos.implementation.routing.PartitionKeyRangeIdentity;
import com.azure.cosmos.implementation.routing.RegionalRoutingContext;
import com.azure.cosmos.implementation.throughputControl.ThroughputControlStore;
import com.azure.cosmos.models.CosmosContainerIdentity;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.ResourceLeakDetector;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SignalType;

public class RxGatewayStoreModel
implements RxStoreModel,
HttpTransportSerializer {
    private static final boolean leakDetectionDebuggingEnabled = ResourceLeakDetector.getLevel().ordinal() >= ResourceLeakDetector.Level.ADVANCED.ordinal();
    private static final boolean HTTP_CONNECTION_WITHOUT_TLS_ALLOWED = Configs.isHttpConnectionWithoutTLSAllowed();
    private final DiagnosticsClientContext clientContext;
    private final Logger logger = LoggerFactory.getLogger(RxGatewayStoreModel.class);
    private final Map<String, String> defaultHeaders;
    private final HttpClient httpClient;
    private final QueryCompatibilityMode queryCompatibilityMode;
    protected final GlobalEndpointManager globalEndpointManager;
    private ConsistencyLevel defaultConsistencyLevel;
    private ISessionContainer sessionContainer;
    private ThroughputControlStore throughputControlStore;
    private boolean useMultipleWriteLocations;
    private RxPartitionKeyRangeCache partitionKeyRangeCache;
    private GatewayServiceConfigurationReader gatewayServiceConfigurationReader;
    private RxClientCollectionCache collectionCache;
    private GatewayServerErrorInjector gatewayServerErrorInjector;

    public RxGatewayStoreModel(DiagnosticsClientContext clientContext, ISessionContainer sessionContainer, ConsistencyLevel defaultConsistencyLevel, QueryCompatibilityMode queryCompatibilityMode, UserAgentContainer userAgentContainer, GlobalEndpointManager globalEndpointManager, HttpClient httpClient, ApiType apiType) {
        this.clientContext = clientContext;
        if (userAgentContainer == null) {
            userAgentContainer = new UserAgentContainer();
        }
        this.defaultHeaders = this.getDefaultHeaders(apiType, userAgentContainer);
        this.defaultConsistencyLevel = defaultConsistencyLevel;
        this.globalEndpointManager = globalEndpointManager;
        this.queryCompatibilityMode = queryCompatibilityMode;
        this.httpClient = httpClient;
        this.sessionContainer = sessionContainer;
    }

    public RxGatewayStoreModel(RxGatewayStoreModel inner) {
        this.clientContext = inner.clientContext;
        this.defaultHeaders = inner.defaultHeaders;
        this.defaultConsistencyLevel = inner.defaultConsistencyLevel;
        this.globalEndpointManager = inner.globalEndpointManager;
        this.queryCompatibilityMode = inner.queryCompatibilityMode;
        this.httpClient = inner.httpClient;
        this.sessionContainer = inner.sessionContainer;
    }

    protected Map<String, String> getDefaultHeaders(ApiType apiType, UserAgentContainer userAgentContainer) {
        Preconditions.checkNotNull(userAgentContainer, "Argument 'userAGentContainer' must not be null.");
        HashMap<String, String> defaultHeaders = new HashMap<String, String>(8);
        defaultHeaders.put("Cache-Control", "no-cache");
        defaultHeaders.put("x-ms-version", "2020-07-15");
        defaultHeaders.put("x-ms-cosmos-sdk-supportedcapabilities", HttpConstants.SDKSupportedCapabilities.SUPPORTED_CAPABILITIES);
        if (apiType != null) {
            defaultHeaders.put("x-ms-cosmos-apitype", apiType.toString());
        }
        String userAgent = userAgentContainer == null ? UserAgentContainer.BASE_USER_AGENT_STRING : userAgentContainer.getUserAgent();
        defaultHeaders.put("User-Agent", userAgent);
        return defaultHeaders;
    }

    void setGatewayServiceConfigurationReader(GatewayServiceConfigurationReader gatewayServiceConfigurationReader) {
        this.gatewayServiceConfigurationReader = gatewayServiceConfigurationReader;
    }

    public void setPartitionKeyRangeCache(RxPartitionKeyRangeCache partitionKeyRangeCache) {
        this.partitionKeyRangeCache = partitionKeyRangeCache;
    }

    public void setUseMultipleWriteLocations(boolean useMultipleWriteLocations) {
        this.useMultipleWriteLocations = useMultipleWriteLocations;
    }

    public void setSessionContainer(ISessionContainer sessionContainer) {
        this.sessionContainer = sessionContainer;
    }

    boolean isUseMultipleWriteLocations() {
        return this.useMultipleWriteLocations;
    }

    RxPartitionKeyRangeCache getPartitionKeyRangeCache() {
        return this.partitionKeyRangeCache;
    }

    GatewayServiceConfigurationReader getGatewayServiceConfigurationReader() {
        return this.gatewayServiceConfigurationReader;
    }

    RxClientCollectionCache getCollectionCache() {
        return this.collectionCache;
    }

    public void setCollectionCache(RxClientCollectionCache collectionCache) {
        this.collectionCache = collectionCache;
    }

    @Override
    public HttpRequest wrapInHttpRequest(RxDocumentServiceRequest request, URI requestUri) throws Exception {
        HttpMethod method = RxGatewayStoreModel.getHttpMethod(request);
        HttpHeaders httpHeaders = this.getHttpRequestHeaders(request.getHeaders());
        Flux<byte[]> contentAsByteArray = request.getContentAsByteArrayFlux();
        return new HttpRequest(method, requestUri, requestUri.getPort(), httpHeaders, contentAsByteArray);
    }

    @Override
    public StoreResponse unwrapToStoreResponse(String endpoint, RxDocumentServiceRequest request, int statusCode, HttpHeaders headers, ByteBuf retainedContent) {
        Preconditions.checkNotNull(headers, "Argument 'headers' must not be null.");
        Preconditions.checkNotNull(retainedContent, "Argument 'retainedContent' must not be null - use empty ByteBuf when theres is no payload.");
        this.validateOrThrow(request, HttpResponseStatus.valueOf((int)statusCode), headers, retainedContent);
        int size = retainedContent.readableBytes();
        if (size > 0) {
            if (leakDetectionDebuggingEnabled) {
                retainedContent.touch((Object)this);
            }
            return new StoreResponse(endpoint, statusCode, HttpUtils.unescape(headers.toMap()), new ByteBufInputStream(retainedContent, true), size);
        }
        retainedContent.release();
        return new StoreResponse(endpoint, statusCode, HttpUtils.unescape(headers.toMap()), null, 0);
    }

    private Mono<RxDocumentServiceResponse> query(RxDocumentServiceRequest request) {
        if (request.getOperationType() != OperationType.QueryPlan) {
            request.getHeaders().put("x-ms-documentdb-isquery", "true");
        }
        switch (this.queryCompatibilityMode) {
            case SqlQuery: {
                request.getHeaders().put("Content-Type", "application/sql");
                break;
            }
            default: {
                request.getHeaders().put("Content-Type", "application/query+json");
            }
        }
        return this.performRequest(request);
    }

    public Mono<RxDocumentServiceResponse> performRequest(RxDocumentServiceRequest request) {
        try {
            if (request.requestContext.cosmosDiagnostics == null) {
                request.requestContext.cosmosDiagnostics = this.clientContext.createDiagnostics();
            }
            URI uri = this.getUri(request);
            request.requestContext.resourcePhysicalAddress = uri.toString();
            if (this.throughputControlStore != null) {
                return this.throughputControlStore.processRequest(request, Mono.defer(() -> this.performRequestInternal(request, uri)));
            }
            return this.performRequestInternal(request, uri);
        }
        catch (Exception e) {
            return Mono.error((Throwable)e);
        }
    }

    protected boolean partitionKeyRangeResolutionNeeded(RxDocumentServiceRequest request) {
        return false;
    }

    public Mono<RxDocumentServiceResponse> performRequestInternal(RxDocumentServiceRequest request, URI requestUri) {
        if (!this.partitionKeyRangeResolutionNeeded(request)) {
            return this.performRequestInternalCore(request, requestUri);
        }
        return this.resolvePartitionKeyRangeByPkRangeId(request).flatMap(pkRange -> {
            request.requestContext.resolvedPartitionKeyRange = pkRange;
            return this.performRequestInternalCore(request, requestUri);
        });
    }

    private Mono<RxDocumentServiceResponse> performRequestInternalCore(RxDocumentServiceRequest request, URI requestUri) {
        try {
            HttpRequest httpRequest = request.getEffectiveHttpTransportSerializer(this).wrapInHttpRequest(request, requestUri);
            Mono<HttpResponse> httpResponseMono = this.httpClient.send(httpRequest, request.getResponseTimeout());
            if (this.gatewayServerErrorInjector != null) {
                httpResponseMono = this.gatewayServerErrorInjector.injectGatewayErrors(request.getResponseTimeout(), httpRequest, request, httpResponseMono);
                return this.toDocumentServiceResponse(httpResponseMono, request, httpRequest);
            }
            return this.toDocumentServiceResponse(httpResponseMono, request, httpRequest);
        }
        catch (Exception e) {
            return Mono.error((Throwable)e);
        }
    }

    private HttpHeaders getHttpRequestHeaders(Map<String, String> headers) {
        HttpHeaders httpHeaders = new HttpHeaders(this.defaultHeaders.size());
        for (Map.Entry<String, String> entry : this.defaultHeaders.entrySet()) {
            if (headers.containsKey(entry.getKey())) continue;
            httpHeaders.set(entry.getKey(), entry.getValue());
        }
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                if (entry.getValue() == null) {
                    httpHeaders.set(entry.getKey(), "");
                    continue;
                }
                httpHeaders.set(entry.getKey(), entry.getValue());
            }
        }
        return httpHeaders;
    }

    public URI getRootUri(RxDocumentServiceRequest request) {
        return this.globalEndpointManager.resolveServiceEndpoint(request).getGatewayRegionalEndpoint();
    }

    private URI getUri(RxDocumentServiceRequest request) throws URISyntaxException {
        URI rootUri = request.getEndpointOverride();
        if (rootUri == null) {
            rootUri = request.getIsMedia() ? ((RegionalRoutingContext)this.globalEndpointManager.getWriteEndpoints().get(0)).getGatewayRegionalEndpoint() : this.getRootUri(request);
        }
        String path = PathsHelper.generatePath(request.getResourceType(), request, request.isFeed);
        if (request.getResourceType().equals((Object)ResourceType.DatabaseAccount)) {
            path = "";
        }
        String scheme = HTTP_CONNECTION_WITHOUT_TLS_ALLOWED ? rootUri.getScheme() : "https";
        return new URI(scheme, null, rootUri.getHost(), rootUri.getPort(), this.ensureSlashPrefixed(path), null, null);
    }

    private String ensureSlashPrefixed(String path) {
        if (path == null) {
            return null;
        }
        if (path.startsWith("/")) {
            return path;
        }
        return "/" + path;
    }

    private Mono<RxDocumentServiceResponse> toDocumentServiceResponse(Mono<HttpResponse> httpResponseMono, RxDocumentServiceRequest request, HttpRequest httpRequest) {
        return httpResponseMono.publishOn(CosmosSchedulers.TRANSPORT_RESPONSE_BOUNDED_ELASTIC).flatMap(httpResponse -> {
            HttpHeaders httpResponseHeaders = httpResponse.headers();
            int httpResponseStatus = httpResponse.statusCode();
            Mono contentObservable = httpResponse.body().switchIfEmpty(Mono.just((Object)Unpooled.EMPTY_BUFFER)).map(bodyByteBuf -> leakDetectionDebuggingEnabled ? bodyByteBuf.retain().touch((Object)this) : bodyByteBuf.retain()).publishOn(CosmosSchedulers.TRANSPORT_RESPONSE_BOUNDED_ELASTIC);
            return contentObservable.map(content -> {
                ReactorNettyRequestRecord reactorNettyRequestRecord;
                if (leakDetectionDebuggingEnabled) {
                    content.touch((Object)this);
                }
                if ((reactorNettyRequestRecord = httpResponse.request().reactorNettyRequestRecord()) != null) {
                    reactorNettyRequestRecord.setTimeCompleted(Instant.now());
                }
                StoreResponse rsp = request.getEffectiveHttpTransportSerializer(this).unwrapToStoreResponse(httpRequest.uri().toString(), request, httpResponseStatus, httpResponseHeaders, (ByteBuf)content);
                if (reactorNettyRequestRecord != null) {
                    rsp.setRequestTimeline(reactorNettyRequestRecord.takeTimelineSnapshot());
                    if (this.gatewayServerErrorInjector != null) {
                        rsp.setFaultInjectionRuleId(request.faultInjectionRequestContext.getFaultInjectionRuleId(reactorNettyRequestRecord.getTransportRequestId()));
                        rsp.setFaultInjectionRuleEvaluationResults(request.faultInjectionRequestContext.getFaultInjectionRuleEvaluationResults(reactorNettyRequestRecord.getTransportRequestId()));
                    }
                }
                if (request.requestContext.cosmosDiagnostics != null) {
                    BridgeInternal.recordGatewayResponse(request.requestContext.cosmosDiagnostics, request, rsp, this.globalEndpointManager);
                }
                return rsp;
            }).single();
        }).map(rsp -> {
            RxDocumentServiceResponse rxDocumentServiceResponse = httpRequest.reactorNettyRequestRecord() != null ? new RxDocumentServiceResponse(this.clientContext, (StoreResponse)rsp, httpRequest.reactorNettyRequestRecord().takeTimelineSnapshot()) : new RxDocumentServiceResponse(this.clientContext, (StoreResponse)rsp);
            rxDocumentServiceResponse.setCosmosDiagnostics(request.requestContext.cosmosDiagnostics);
            return rxDocumentServiceResponse;
        }).onErrorResume(throwable -> {
            CosmosException dce;
            Throwable unwrappedException = reactor.core.Exceptions.unwrap((Throwable)throwable);
            if (!(unwrappedException instanceof Exception)) {
                this.logger.error("Unexpected failure {}", (Object)unwrappedException.getMessage(), (Object)unwrappedException);
                return Mono.error((Throwable)unwrappedException);
            }
            Exception exception = (Exception)unwrappedException;
            if (!(exception instanceof CosmosException)) {
                this.logger.warn("Network failure", (Throwable)exception);
                int statusCode = 0;
                if (WebExceptionUtility.isNetworkFailure(exception)) {
                    statusCode = WebExceptionUtility.isReadTimeoutException(exception) ? 408 : 503;
                }
                dce = BridgeInternal.createCosmosException(request.requestContext.resourcePhysicalAddress, statusCode, exception);
                BridgeInternal.setRequestHeaders(dce, request.getHeaders());
            } else {
                dce = (CosmosException)((Object)((Object)exception));
            }
            if (WebExceptionUtility.isNetworkFailure((Exception)((Object)dce))) {
                if (WebExceptionUtility.isReadTimeoutException((Exception)((Object)dce))) {
                    BridgeInternal.setSubStatusCode(dce, 10002);
                } else {
                    BridgeInternal.setSubStatusCode(dce, 10001);
                }
            }
            ImplementationBridgeHelpers.CosmosExceptionHelper.getCosmosExceptionAccessor().setRequestUri(dce, Uri.create(httpRequest.uri().toString()));
            if (request.requestContext.cosmosDiagnostics != null) {
                if (httpRequest.reactorNettyRequestRecord() != null) {
                    ReactorNettyRequestRecord reactorNettyRequestRecord = httpRequest.reactorNettyRequestRecord();
                    BridgeInternal.setRequestTimeline(dce, reactorNettyRequestRecord.takeTimelineSnapshot());
                    ImplementationBridgeHelpers.CosmosExceptionHelper.getCosmosExceptionAccessor().setFaultInjectionRuleId(dce, request.faultInjectionRequestContext.getFaultInjectionRuleId(reactorNettyRequestRecord.getTransportRequestId()));
                    ImplementationBridgeHelpers.CosmosExceptionHelper.getCosmosExceptionAccessor().setFaultInjectionEvaluationResults(dce, request.faultInjectionRequestContext.getFaultInjectionRuleEvaluationResults(reactorNettyRequestRecord.getTransportRequestId()));
                }
                BridgeInternal.recordGatewayResponse(request.requestContext.cosmosDiagnostics, request, dce, this.globalEndpointManager);
            }
            return Mono.error((Throwable)((Object)dce));
        }).doFinally(signalType -> {
            if (signalType != SignalType.CANCEL) {
                return;
            }
            if (httpRequest.reactorNettyRequestRecord() != null) {
                ReactorNettyRequestRecord reactorNettyRequestRecord = httpRequest.reactorNettyRequestRecord();
                RequestTimeline requestTimeline = reactorNettyRequestRecord.takeTimelineSnapshot();
                long transportRequestId = reactorNettyRequestRecord.getTransportRequestId();
                GatewayRequestTimelineContext gatewayRequestTimelineContext = new GatewayRequestTimelineContext(requestTimeline, transportRequestId);
                request.requestContext.cancelledGatewayRequestTimelineContexts.add(gatewayRequestTimelineContext);
            }
        });
    }

    private void validateOrThrow(RxDocumentServiceRequest request, HttpResponseStatus status, HttpHeaders headers, ByteBuf retainedBodyAsByteBuf) {
        int statusCode = status.code();
        if (statusCode >= 400) {
            String statusCodeString = status.reasonPhrase() != null ? status.reasonPhrase().replace(" ", "") : "";
            String body = retainedBodyAsByteBuf != null ? retainedBodyAsByteBuf.toString(StandardCharsets.UTF_8) : null;
            retainedBodyAsByteBuf.release();
            CosmosError cosmosError = StringUtils.isNotEmpty(body) ? new CosmosError(body) : new CosmosError();
            cosmosError = new CosmosError(statusCodeString, String.format("%s, StatusCode: %s", cosmosError.getMessage(), statusCodeString), cosmosError.getPartitionedQueryExecutionInfo());
            CosmosException dce = BridgeInternal.createCosmosException(request.requestContext.resourcePhysicalAddress, statusCode, cosmosError, headers.toMap());
            BridgeInternal.setRequestHeaders(dce, request.getHeaders());
            throw dce;
        }
    }

    private static HttpMethod getHttpMethod(RxDocumentServiceRequest request) {
        switch (request.getOperationType()) {
            case Create: 
            case Batch: 
            case Upsert: 
            case ExecuteJavaScript: 
            case SqlQuery: 
            case Query: 
            case QueryPlan: {
                return HttpMethod.POST;
            }
            case Patch: {
                return HttpMethod.PATCH;
            }
            case Delete: {
                if (request.getResourceType() == ResourceType.PartitionKey) {
                    return HttpMethod.POST;
                }
                return HttpMethod.DELETE;
            }
            case Read: 
            case ReadFeed: {
                return HttpMethod.GET;
            }
            case Replace: {
                return HttpMethod.PUT;
            }
        }
        throw new IllegalStateException("Operation type " + (Object)((Object)request.getOperationType()) + " cannot be processed in RxGatewayStoreModel.");
    }

    private Mono<RxDocumentServiceResponse> invokeAsyncInternal(RxDocumentServiceRequest request) {
        switch (request.getOperationType()) {
            case Create: 
            case Batch: 
            case Upsert: 
            case ExecuteJavaScript: 
            case Patch: 
            case Delete: 
            case Read: 
            case ReadFeed: 
            case Replace: {
                return this.performRequest(request);
            }
            case SqlQuery: 
            case Query: 
            case QueryPlan: {
                return this.query(request);
            }
        }
        throw new IllegalStateException("Unknown operation setType " + (Object)((Object)request.getOperationType()));
    }

    private Mono<RxDocumentServiceResponse> invokeAsync(RxDocumentServiceRequest request) {
        Callable funcDelegate = () -> this.invokeAsyncInternal(request).single();
        MetadataRequestRetryPolicy metadataRequestRetryPolicy = new MetadataRequestRetryPolicy(this.globalEndpointManager);
        metadataRequestRetryPolicy.onBeforeSendRequest(request);
        return BackoffRetryUtility.executeRetry(funcDelegate, metadataRequestRetryPolicy);
    }

    @Override
    public Mono<RxDocumentServiceResponse> processMessage(RxDocumentServiceRequest request) {
        Mono responseObs = this.addIntendedCollectionRidAndSessionToken(request).then(this.invokeAsync(request));
        return responseObs.onErrorResume(e -> {
            CosmosException dce = Utils.as(e, CosmosException.class);
            if (dce == null) {
                this.logger.error("unexpected failure {}", (Object)e.getMessage(), e);
                return Mono.error((Throwable)e);
            }
            if (!ReplicatedResourceClientUtils.isMasterResource(request.getResourceType()) && (dce.getStatusCode() == 412 || dce.getStatusCode() == 409 || dce.getStatusCode() == 404 && !Exceptions.isSubStatusCode(dce, 1002))) {
                this.captureSessionToken(request, dce.getResponseHeaders());
            }
            if (Exceptions.isThroughputControlRequestRateTooLargeException(dce) && request.requestContext.cosmosDiagnostics != null) {
                BridgeInternal.recordGatewayResponse(request.requestContext.cosmosDiagnostics, request, dce, this.globalEndpointManager);
            }
            return Mono.error((Throwable)((Object)dce));
        }).flatMap(response -> this.captureSessionTokenAndHandlePartitionSplit(request, response.getResponseHeaders()).then(Mono.just((Object)response)));
    }

    @Override
    public void enableThroughputControl(ThroughputControlStore throughputControlStore) {
        this.throughputControlStore = throughputControlStore;
    }

    @Override
    public Flux<Void> submitOpenConnectionTasksAndInitCaches(CosmosContainerProactiveInitConfig proactiveContainerInitConfig) {
        return Flux.empty();
    }

    @Override
    public void configureFaultInjectorProvider(IFaultInjectorProvider injectorProvider, Configs configs) {
        if (this.gatewayServerErrorInjector == null) {
            this.gatewayServerErrorInjector = new GatewayServerErrorInjector(configs, this.collectionCache, this.partitionKeyRangeCache);
        }
        this.gatewayServerErrorInjector.registerServerErrorInjector(injectorProvider.getServerErrorInjector());
    }

    @Override
    public void recordOpenConnectionsAndInitCachesCompleted(List<CosmosContainerIdentity> cosmosContainerIdentities) {
    }

    @Override
    public void recordOpenConnectionsAndInitCachesStarted(List<CosmosContainerIdentity> cosmosContainerIdentities) {
    }

    public Map<String, String> getDefaultHeaders() {
        return this.defaultHeaders;
    }

    private void captureSessionToken(RxDocumentServiceRequest request, Map<String, String> responseHeaders) {
        if (request.getResourceType() == ResourceType.DocumentCollection && request.getOperationType() == OperationType.Delete) {
            String resourceId = request.getIsNameBased() ? responseHeaders.get("x-ms-content-path") : request.getResourceId();
            this.sessionContainer.clearTokenByResourceId(resourceId);
        } else {
            this.sessionContainer.setSessionToken(request, responseHeaders);
        }
    }

    private Mono<Void> captureSessionTokenAndHandlePartitionSplit(RxDocumentServiceRequest request, Map<String, String> responseHeaders) {
        this.captureSessionToken(request, responseHeaders);
        if (request.requestContext.resolvedPartitionKeyRange != null && StringUtils.isNotEmpty(request.requestContext.resolvedCollectionRid) && StringUtils.isNotEmpty(responseHeaders.get("x-ms-documentdb-partitionkeyrangeid")) && !responseHeaders.get("x-ms-documentdb-partitionkeyrangeid").equals(request.requestContext.resolvedPartitionKeyRange.getId())) {
            return this.partitionKeyRangeCache.refreshAsync(BridgeInternal.getMetaDataDiagnosticContext(request.requestContext.cosmosDiagnostics), request.requestContext.resolvedCollectionRid).flatMap(collectionRoutingMapValueHolder -> Mono.empty());
        }
        return Mono.empty();
    }

    private Mono<Void> addIntendedCollectionRidAndSessionToken(RxDocumentServiceRequest request) {
        return this.applySessionToken(request).then(this.addIntendedCollectionRid(request));
    }

    private Mono<Void> addIntendedCollectionRid(RxDocumentServiceRequest request) {
        if (this.collectionCache != null && request.getResourceType().equals((Object)ResourceType.Document)) {
            return this.collectionCache.resolveCollectionAsync(BridgeInternal.getMetaDataDiagnosticContext(request.requestContext.cosmosDiagnostics), request).flatMap(documentCollectionValueHolder -> {
                if (StringUtils.isEmpty(request.getHeaders().get("x-ms-cosmos-intended-collection-rid"))) {
                    request.getHeaders().put("x-ms-cosmos-intended-collection-rid", request.requestContext.resolvedCollectionRid);
                } else {
                    request.intendedCollectionRidPassedIntoSDK = true;
                }
                return Mono.empty();
            });
        }
        return Mono.empty();
    }

    protected Mono<PartitionKeyRange> resolvePartitionKeyRangeByPkRangeId(RxDocumentServiceRequest request) {
        Objects.requireNonNull(request, "Parameter 'request' is required and cannot be null");
        Objects.requireNonNull(this.partitionKeyRangeCache, "Parameter 'this::partitionKeyRangeCache' is required and cannot be null");
        Objects.requireNonNull(this.collectionCache, "Parameter 'this::collectionCache' is required and cannot be null");
        PartitionKeyRangeIdentity pkRangeId = request.getPartitionKeyRangeIdentity();
        Objects.requireNonNull(pkRangeId, "Parameter 'request::getPartitionKeyRangeIdentity()' is required and cannot be null");
        MetadataDiagnosticsContext metadataCtx = BridgeInternal.getMetaDataDiagnosticContext(request.requestContext.cosmosDiagnostics);
        if (pkRangeId.getCollectionRid() != null) {
            return this.resolvePartitionKeyRangeByPkRangeIdCore(pkRangeId, pkRangeId.getCollectionRid(), metadataCtx);
        }
        return this.collectionCache.resolveCollectionAsync(metadataCtx, request).flatMap(collectionHolder -> this.resolvePartitionKeyRangeByPkRangeIdCore(pkRangeId, ((DocumentCollection)collectionHolder.v).getResourceId(), metadataCtx));
    }

    private Mono<PartitionKeyRange> resolvePartitionKeyRangeByPkRangeIdCore(PartitionKeyRangeIdentity pkRangeId, String effectiveCollectionRid, MetadataDiagnosticsContext metadataCtx) {
        Objects.requireNonNull(pkRangeId, "Parameter 'pkRangeId' is required and cannot be null");
        Objects.requireNonNull(this.partitionKeyRangeCache, "Parameter 'this::partitionKeyRangeCache' is required and cannot be null");
        return this.partitionKeyRangeCache.tryLookupAsync(metadataCtx, effectiveCollectionRid, null, null).flatMap(collectionRoutingMapValueHolder -> {
            PartitionKeyRange range = ((CollectionRoutingMap)collectionRoutingMapValueHolder.v).getRangeByPartitionKeyRangeId(pkRangeId.getPartitionKeyRangeId());
            return Mono.just((Object)range);
        });
    }

    private Mono<Void> applySessionToken(RxDocumentServiceRequest request) {
        boolean sessionConsistency;
        Map<String, String> headers = request.getHeaders();
        Objects.requireNonNull(headers, "RxDocumentServiceRequest::headers is required and cannot be null");
        if (RxGatewayStoreModel.isMasterOperation(request.getResourceType(), request.getOperationType())) {
            if (!Strings.isNullOrEmpty(request.getHeaders().get("x-ms-session-token"))) {
                request.getHeaders().remove("x-ms-session-token");
            }
            return Mono.empty();
        }
        boolean bl = sessionConsistency = RequestHelper.getReadConsistencyStrategyToUse(this.gatewayServiceConfigurationReader, request) == ReadConsistencyStrategy.SESSION;
        if (!Strings.isNullOrEmpty(request.getHeaders().get("x-ms-session-token"))) {
            if (!sessionConsistency || !request.isReadOnlyRequest() && request.getOperationType() != OperationType.Batch && !this.useMultipleWriteLocations) {
                request.getHeaders().remove("x-ms-session-token");
            }
            return Mono.empty();
        }
        if (!sessionConsistency || !request.isReadOnlyRequest() && request.getOperationType() != OperationType.Batch && !this.useMultipleWriteLocations) {
            return Mono.empty();
        }
        if (this.collectionCache != null && this.partitionKeyRangeCache != null) {
            return this.collectionCache.resolveCollectionAsync(BridgeInternal.getMetaDataDiagnosticContext(request.requestContext.cosmosDiagnostics), request).flatMap(collectionValueHolder -> {
                if (collectionValueHolder == null || collectionValueHolder.v == null) {
                    String sessionToken = this.sessionContainer.resolveGlobalSessionToken(request);
                    if (!Strings.isNullOrEmpty(sessionToken)) {
                        headers.put("x-ms-session-token", sessionToken);
                    }
                    return Mono.empty();
                }
                return this.partitionKeyRangeCache.tryLookupAsync(BridgeInternal.getMetaDataDiagnosticContext(request.requestContext.cosmosDiagnostics), ((DocumentCollection)collectionValueHolder.v).getResourceId(), null, null).flatMap(collectionRoutingMapValueHolder -> {
                    if (collectionRoutingMapValueHolder == null || collectionRoutingMapValueHolder.v == null) {
                        String sessionToken = this.sessionContainer.resolveGlobalSessionToken(request);
                        if (!Strings.isNullOrEmpty(sessionToken)) {
                            headers.put("x-ms-session-token", sessionToken);
                        }
                        return Mono.empty();
                    }
                    String partitionKeyRangeId = request.getHeaders().get("x-ms-documentdb-partitionkeyrangeid");
                    PartitionKeyInternal partitionKeyInternal = request.getPartitionKeyInternal();
                    if (StringUtils.isNotEmpty(partitionKeyRangeId)) {
                        PartitionKeyRange range;
                        request.requestContext.resolvedPartitionKeyRange = range = ((CollectionRoutingMap)collectionRoutingMapValueHolder.v).getRangeByPartitionKeyRangeId(partitionKeyRangeId);
                        if (request.requestContext.resolvedPartitionKeyRange == null) {
                            SessionTokenHelper.setPartitionLocalSessionToken(request, partitionKeyRangeId, this.sessionContainer);
                        } else {
                            SessionTokenHelper.setPartitionLocalSessionToken(request, this.sessionContainer);
                        }
                    } else if (partitionKeyInternal != null) {
                        PartitionKeyRange range;
                        String effectivePartitionKeyString = StringUtils.isNotEmpty(request.getEffectivePartitionKey()) ? request.getEffectivePartitionKey() : PartitionKeyInternalHelper.getEffectivePartitionKeyString(partitionKeyInternal, ((DocumentCollection)collectionValueHolder.v).getPartitionKey());
                        request.setEffectivePartitionKey(effectivePartitionKeyString);
                        request.requestContext.resolvedPartitionKeyRange = range = ((CollectionRoutingMap)collectionRoutingMapValueHolder.v).getRangeByEffectivePartitionKey(effectivePartitionKeyString);
                        SessionTokenHelper.setPartitionLocalSessionToken(request, this.sessionContainer);
                    } else {
                        String sessionToken = this.sessionContainer.resolveGlobalSessionToken(request);
                        if (!Strings.isNullOrEmpty(sessionToken)) {
                            headers.put("x-ms-session-token", sessionToken);
                        }
                    }
                    return Mono.empty();
                });
            });
        }
        String sessionToken = this.sessionContainer.resolveGlobalSessionToken(request);
        if (!Strings.isNullOrEmpty(sessionToken)) {
            headers.put("x-ms-session-token", sessionToken);
        }
        return Mono.empty();
    }

    private static boolean isMasterOperation(ResourceType resourceType, OperationType operationType) {
        return ReplicatedResourceClientUtils.isMasterResource(resourceType) || RxGatewayStoreModel.isStoredProcedureMasterOperation(resourceType, operationType) || operationType == OperationType.QueryPlan;
    }

    private static boolean isStoredProcedureMasterOperation(ResourceType resourceType, OperationType operationType) {
        return resourceType == ResourceType.StoredProcedure && operationType != OperationType.ExecuteJavaScript;
    }
}

