/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity;

import com.azure.cosmos.implementation.directconnectivity.HttpUtils;
import com.azure.cosmos.implementation.directconnectivity.StoreResponse;
import com.azure.cosmos.implementation.http.HttpHeaders;
import com.azure.cosmos.implementation.http.HttpResponse;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import reactor.core.publisher.Mono;

class ResponseUtils {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    ResponseUtils() {
    }

    static Mono<StoreResponse> toStoreResponse(HttpResponse httpClientResponse, String endpoint) {
        HttpHeaders httpResponseHeaders = httpClientResponse.headers();
        Mono contentObservable = httpClientResponse.body().switchIfEmpty(Mono.just((Object)Unpooled.EMPTY_BUFFER));
        return contentObservable.map(byteBufContent -> {
            int size = 0;
            if (byteBufContent == null || (size = byteBufContent.readableBytes()) == 0) {
                return new StoreResponse(endpoint, httpClientResponse.statusCode(), HttpUtils.unescape(httpResponseHeaders.toMap()), null, 0);
            }
            return new StoreResponse(endpoint, httpClientResponse.statusCode(), HttpUtils.unescape(httpResponseHeaders.toMap()), new ByteBufInputStream(byteBufContent, true), size);
        });
    }
}

