/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.CosmosAsyncContainer;
import com.azure.cosmos.CosmosBridgeInternal;
import com.azure.cosmos.CosmosContainer;
import com.azure.cosmos.implementation.apachecommons.lang.tuple.Pair;
import com.azure.cosmos.models.CosmosItemIdentity;
import com.azure.cosmos.models.FeedResponse;
import com.azure.cosmos.models.PartitionKey;
import java.util.ArrayList;
import java.util.List;
import reactor.core.publisher.Mono;

public final class ItemOperations {
    public static <T> FeedResponse<T> readMany(CosmosContainer container, List<Pair<String, PartitionKey>> itemKeyList, Class<T> classType) {
        return (FeedResponse)ItemOperations.readManyAsync(CosmosBridgeInternal.getCosmosAsyncContainer(container), itemKeyList, classType).block();
    }

    public static <T> Mono<FeedResponse<T>> readManyAsync(CosmosAsyncContainer container, List<Pair<String, PartitionKey>> itemKeyList, Class<T> classType) {
        if (container == null) {
            throw new IllegalArgumentException("Parameter container is required and cannot be null.");
        }
        return container.readMany(ItemOperations.convertItemKeyList(itemKeyList), classType);
    }

    private static List<CosmosItemIdentity> convertItemKeyList(List<Pair<String, PartitionKey>> itemKeyList) {
        if (itemKeyList != null) {
            ArrayList<CosmosItemIdentity> itemIdentities = new ArrayList<CosmosItemIdentity>(itemKeyList.size());
            for (int i = 0; i < itemKeyList.size(); ++i) {
                itemIdentities.add(new CosmosItemIdentity(itemKeyList.get(i).getRight(), itemKeyList.get(i).getLeft()));
            }
            return itemIdentities;
        }
        return new ArrayList<CosmosItemIdentity>();
    }

    private ItemOperations() {
    }
}

