/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.ConsistencyLevel;
import com.azure.cosmos.ReadConsistencyStrategy;
import com.azure.cosmos.implementation.BadRequestException;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.Strings;
import com.azure.cosmos.implementation.directconnectivity.GatewayServiceConfigurationReader;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import java.util.Map;

public class RequestHelper {
    public static ReadConsistencyStrategy getReadConsistencyStrategyToUse(GatewayServiceConfigurationReader serviceConfigReader, RxDocumentServiceRequest request) {
        Preconditions.checkNotNull(serviceConfigReader, "Argument 'serviceConfigReader' must not be null.");
        Preconditions.checkNotNull(request, "Argument 'request' must not be null.");
        ReadConsistencyStrategy requestLevelReadConsistencyStrategy = null;
        if (request.requestContext != null && request.requestContext.readConsistencyStrategy != null) {
            requestLevelReadConsistencyStrategy = request.requestContext.readConsistencyStrategy;
        }
        return RequestHelper.getReadConsistencyStrategyToUse(request.getHeaders(), requestLevelReadConsistencyStrategy, serviceConfigReader.getDefaultConsistencyLevel());
    }

    public static ReadConsistencyStrategy getReadConsistencyStrategyToUse(Map<String, String> headers, ReadConsistencyStrategy requestLevelReadConsistencyStrategy, ConsistencyLevel defaultConsistencySnapshot) {
        if (requestLevelReadConsistencyStrategy == null || requestLevelReadConsistencyStrategy == ReadConsistencyStrategy.DEFAULT) {
            String requestReadConsistencyStrategyHeaderValue = headers.get("x-ms-cosmos-read-consistency-strategy");
            if (!Strings.isNullOrEmpty(requestReadConsistencyStrategyHeaderValue)) {
                requestLevelReadConsistencyStrategy = ImplementationBridgeHelpers.ReadConsistencyStrategyHelper.getReadConsistencyStrategyAccessor().createFromServiceSerializedFormat(requestReadConsistencyStrategyHeaderValue);
                if (requestLevelReadConsistencyStrategy == null) {
                    throw new BadRequestException(String.format("Value '%s' specified for the header '%s' is invalid.", requestReadConsistencyStrategyHeaderValue, "x-ms-cosmos-read-consistency-strategy"));
                }
                if (!RequestHelper.validateReadConsistencyStrategy(defaultConsistencySnapshot, requestLevelReadConsistencyStrategy)) {
                    throw new BadRequestException(String.format("Value '%s' specified for the header '%s' is invalid. This value requires the account-level default consistency level to be '%s' - but it is '%s'.", new Object[]{requestReadConsistencyStrategyHeaderValue, "x-ms-cosmos-read-consistency-strategy", ConsistencyLevel.STRONG, defaultConsistencySnapshot}));
                }
            }
        } else {
            headers.put("x-ms-cosmos-read-consistency-strategy", requestLevelReadConsistencyStrategy.toString());
        }
        if (requestLevelReadConsistencyStrategy != null && requestLevelReadConsistencyStrategy != ReadConsistencyStrategy.DEFAULT) {
            switch (requestLevelReadConsistencyStrategy) {
                case EVENTUAL: {
                    headers.put("x-ms-consistency-level", ConsistencyLevel.EVENTUAL.toString());
                    break;
                }
                case SESSION: {
                    headers.put("x-ms-consistency-level", ConsistencyLevel.SESSION.toString());
                    break;
                }
                case LATEST_COMMITTED: {
                    headers.put("x-ms-consistency-level", ConsistencyLevel.BOUNDED_STALENESS.toString());
                    break;
                }
                case GLOBAL_STRONG: {
                    headers.put("x-ms-consistency-level", ConsistencyLevel.STRONG.toString());
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown read consistency strategy '" + (Object)((Object)requestLevelReadConsistencyStrategy) + "'.");
                }
            }
            return requestLevelReadConsistencyStrategy;
        }
        ConsistencyLevel consistencyLevelToUse = defaultConsistencySnapshot;
        String requestConsistencyLevelHeaderValue = headers.get("x-ms-consistency-level");
        if (!Strings.isNullOrEmpty(requestConsistencyLevelHeaderValue)) {
            ConsistencyLevel requestConsistencyLevel = BridgeInternal.fromServiceSerializedFormat(requestConsistencyLevelHeaderValue);
            if (requestConsistencyLevel == null) {
                throw new BadRequestException(String.format("Value '%s' specified for the header '%s' is invalid.", requestConsistencyLevelHeaderValue, "x-ms-consistency-level"));
            }
            consistencyLevelToUse = requestConsistencyLevel;
        }
        switch (consistencyLevelToUse) {
            case EVENTUAL: 
            case CONSISTENT_PREFIX: {
                return ReadConsistencyStrategy.EVENTUAL;
            }
            case SESSION: {
                return ReadConsistencyStrategy.SESSION;
            }
            case BOUNDED_STALENESS: {
                return ReadConsistencyStrategy.LATEST_COMMITTED;
            }
            case STRONG: {
                return ReadConsistencyStrategy.GLOBAL_STRONG;
            }
        }
        throw new IllegalStateException("Unknown consistency level '" + (Object)((Object)consistencyLevelToUse) + "'.");
    }

    private static boolean validateReadConsistencyStrategy(ConsistencyLevel backendConsistency, ReadConsistencyStrategy readConsistencyStrategy) {
        if (readConsistencyStrategy == ReadConsistencyStrategy.GLOBAL_STRONG) {
            return backendConsistency == ConsistencyLevel.STRONG;
        }
        return true;
    }
}

