/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.CosmosContainerProactiveInitConfig;
import com.azure.cosmos.implementation.directconnectivity.ContainerDirectConnectionMetadata;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.models.CosmosContainerIdentity;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class CosmosContainerProactiveInitConfigBuilder {
    private static final int MAX_NO_OF_PROACTIVE_CONNECTION_REGIONS = 5;
    private static final int MAX_MIN_CONNECTION_POOL_SIZE_PER_ENDPOINT = 10;
    private final Map<CosmosContainerIdentity, ContainerDirectConnectionMetadata> containerDirectConnectionMetadataMap;
    private int numProactiveConnectionRegions;
    private Duration aggressiveWarmupDuration;

    public CosmosContainerProactiveInitConfigBuilder(List<CosmosContainerIdentity> cosmosContainerIdentities) {
        Preconditions.checkArgument(cosmosContainerIdentities != null && !cosmosContainerIdentities.isEmpty(), "The list of container identities cannot be null or empty.");
        this.containerDirectConnectionMetadataMap = new HashMap<CosmosContainerIdentity, ContainerDirectConnectionMetadata>();
        if (cosmosContainerIdentities != null && !cosmosContainerIdentities.isEmpty()) {
            for (CosmosContainerIdentity cosmosContainerIdentity : cosmosContainerIdentities) {
                this.containerDirectConnectionMetadataMap.put(cosmosContainerIdentity, new ContainerDirectConnectionMetadata());
            }
        }
        this.numProactiveConnectionRegions = 1;
    }

    public CosmosContainerProactiveInitConfigBuilder setProactiveConnectionRegionsCount(int numProactiveConnectionRegions) {
        Preconditions.checkArgument(numProactiveConnectionRegions > 0 && numProactiveConnectionRegions <= 5, "The no. of regions to proactively connect to cannot be less than 1 or more than {}.", 5);
        this.numProactiveConnectionRegions = numProactiveConnectionRegions;
        return this;
    }

    public CosmosContainerProactiveInitConfigBuilder setAggressiveWarmupDuration(Duration aggressiveWarmupDuration) {
        Preconditions.checkArgument(aggressiveWarmupDuration != null, "aggressiveWarmupDuration cannot be a null value");
        Preconditions.checkArgument(aggressiveWarmupDuration.compareTo(Duration.ZERO) > 0, "aggressiveWarmupDuration should be greater than Duration.ZERO");
        this.aggressiveWarmupDuration = aggressiveWarmupDuration;
        return this;
    }

    CosmosContainerProactiveInitConfigBuilder setMinConnectionPoolSizePerEndpointForContainer(CosmosContainerIdentity cosmosContainerIdentity, int minConnectionsPerEndpoint) {
        Preconditions.checkArgument(minConnectionsPerEndpoint >= 0 && minConnectionsPerEndpoint <= 10, "minConnectionsPerEndpoint cannot be negative or greater than {}", 10);
        ContainerDirectConnectionMetadata containerDirectConnectionMetadata = this.containerDirectConnectionMetadataMap.get(cosmosContainerIdentity);
        containerDirectConnectionMetadata.setMinConnectionPoolSizePerEndpointForContainer(minConnectionsPerEndpoint);
        return this;
    }

    public CosmosContainerProactiveInitConfig build() {
        Preconditions.checkArgument(this.numProactiveConnectionRegions >= 0 && this.numProactiveConnectionRegions <= 5, "The no. of regions to proactively connect to cannot be less than 0 or more than {}.", 5);
        return new CosmosContainerProactiveInitConfig(this.numProactiveConnectionRegions, this.containerDirectConnectionMetadataMap, this.aggressiveWarmupDuration);
    }
}

