/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.CosmosDiagnostics;
import com.azure.cosmos.implementation.ResourceResponse;
import java.time.Duration;
import java.util.Map;

public class CosmosResponse<T> {
    private T properties;
    final ResourceResponse<?> resourceResponseWrapper;

    CosmosResponse(ResourceResponse<?> resourceResponse) {
        this.resourceResponseWrapper = resourceResponse;
    }

    CosmosResponse(T properties) {
        this.properties = properties;
        this.resourceResponseWrapper = null;
    }

    CosmosResponse(ResourceResponse<?> resourceResponse, T properties) {
        this.resourceResponseWrapper = resourceResponse;
        this.properties = properties;
    }

    public T getProperties() {
        return this.properties;
    }

    CosmosResponse<T> setProperties(T resourceSettings) {
        this.properties = resourceSettings;
        return this;
    }

    public String getMaxResourceQuota() {
        if (this.resourceResponseWrapper == null) {
            return null;
        }
        return this.resourceResponseWrapper.getMaxResourceQuota();
    }

    public String getCurrentResourceQuotaUsage() {
        if (this.resourceResponseWrapper == null) {
            return null;
        }
        return this.resourceResponseWrapper.getCurrentResourceQuotaUsage();
    }

    public String getActivityId() {
        if (this.resourceResponseWrapper == null) {
            return null;
        }
        return this.resourceResponseWrapper.getActivityId();
    }

    public double getRequestCharge() {
        if (this.resourceResponseWrapper == null) {
            return 0.0;
        }
        return this.resourceResponseWrapper.getRequestCharge();
    }

    public int getStatusCode() {
        if (this.resourceResponseWrapper == null) {
            return 0;
        }
        return this.resourceResponseWrapper.getStatusCode();
    }

    public String getSessionToken() {
        if (this.resourceResponseWrapper == null) {
            return null;
        }
        return this.resourceResponseWrapper.getSessionToken();
    }

    public Map<String, String> getResponseHeaders() {
        if (this.resourceResponseWrapper == null) {
            return null;
        }
        return this.resourceResponseWrapper.getResponseHeaders();
    }

    public CosmosDiagnostics getDiagnostics() {
        if (this.resourceResponseWrapper == null) {
            return null;
        }
        return this.resourceResponseWrapper.getDiagnostics();
    }

    public Duration getDuration() {
        if (this.resourceResponseWrapper == null) {
            return null;
        }
        return this.resourceResponseWrapper.getDuration();
    }
}

