/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.cpu;

import java.text.DecimalFormat;
import java.time.Instant;

public class CpuLoad {
    public Instant timestamp;
    public float value;
    private String cachedToString;

    public CpuLoad(Instant timestamp, float value) {
        if ((double)value < 0.0 || (double)value > 100.0) {
            throw new IllegalArgumentException("Valid CPU load values must be between 0.0 and 100.0, but it is " + value);
        }
        this.timestamp = timestamp;
        this.value = value;
    }

    public String toString() {
        if (this.cachedToString == null) {
            this.cachedToString = this.toStringInternal();
        }
        return this.cachedToString;
    }

    private String toStringInternal() {
        DecimalFormat decimalFormat = new DecimalFormat("0.0");
        return "(" + this.timestamp.toString() + " " + decimalFormat.format(this.value) + "%)";
    }
}

