/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.core.http.ProxyOptions;
import com.azure.cosmos.implementation.Configs;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import java.time.Duration;

public final class GatewayConnectionConfig {
    private static final Duration MIN_NETWORK_REQUEST_TIMEOUT = Duration.ofSeconds(60L);
    private static final Duration DEFAULT_NETWORK_REQUEST_TIMEOUT = Duration.ofSeconds(60L);
    private static final Duration DEFAULT_IDLE_CONNECTION_TIMEOUT = Duration.ofSeconds(60L);
    private Duration networkRequestTimeout;
    private int maxConnectionPoolSize;
    private Duration idleConnectionTimeout = DEFAULT_IDLE_CONNECTION_TIMEOUT;
    private ProxyOptions proxy;

    public GatewayConnectionConfig() {
        this.maxConnectionPoolSize = Configs.getDefaultHttpPoolSize();
        this.networkRequestTimeout = DEFAULT_NETWORK_REQUEST_TIMEOUT;
    }

    public static GatewayConnectionConfig getDefaultConfig() {
        return new GatewayConnectionConfig();
    }

    Duration getNetworkRequestTimeout() {
        return this.networkRequestTimeout;
    }

    GatewayConnectionConfig setNetworkRequestTimeout(Duration networkRequestTimeout) {
        Preconditions.checkNotNull(networkRequestTimeout, "NetworkRequestTimeout can not be null");
        Preconditions.checkArgument(networkRequestTimeout.toMillis() >= MIN_NETWORK_REQUEST_TIMEOUT.toMillis(), "NetworkRequestTimeout can not be less than %s millis", MIN_NETWORK_REQUEST_TIMEOUT.toMillis());
        this.networkRequestTimeout = networkRequestTimeout;
        return this;
    }

    public int getMaxConnectionPoolSize() {
        return this.maxConnectionPoolSize;
    }

    public GatewayConnectionConfig setMaxConnectionPoolSize(int maxConnectionPoolSize) {
        this.maxConnectionPoolSize = maxConnectionPoolSize;
        return this;
    }

    public Duration getIdleConnectionTimeout() {
        return this.idleConnectionTimeout;
    }

    public GatewayConnectionConfig setIdleConnectionTimeout(Duration idleConnectionTimeout) {
        this.idleConnectionTimeout = idleConnectionTimeout;
        return this;
    }

    public ProxyOptions getProxy() {
        return this.proxy;
    }

    public GatewayConnectionConfig setProxy(ProxyOptions proxy) {
        if (proxy.getType() != ProxyOptions.Type.HTTP) {
            throw new IllegalArgumentException("Only http proxy type is supported.");
        }
        this.proxy = proxy;
        return this;
    }

    public String toString() {
        String proxyType = this.proxy != null ? this.proxy.getType().toString() : null;
        String proxyAddress = this.proxy != null ? this.proxy.getAddress().toString() : null;
        return "GatewayConnectionConfig{, maxConnectionPoolSize=" + this.maxConnectionPoolSize + ", idleConnectionTimeout=" + this.idleConnectionTimeout + ", networkRequestTimeout=" + this.networkRequestTimeout + ", proxyType=" + proxyType + ", inetSocketProxyAddress=" + proxyAddress + '}';
    }
}

