/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.core.credential.AzureKeyCredential;
import com.azure.core.credential.SimpleTokenCache;
import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.ConnectionMode;
import com.azure.cosmos.ConsistencyLevel;
import com.azure.cosmos.CosmosAsyncClient;
import com.azure.cosmos.CosmosContainerProactiveInitConfig;
import com.azure.cosmos.CosmosDiagnostics;
import com.azure.cosmos.CosmosDiagnosticsContext;
import com.azure.cosmos.CosmosEndToEndOperationLatencyPolicyConfig;
import com.azure.cosmos.CosmosException;
import com.azure.cosmos.CosmosItemSerializer;
import com.azure.cosmos.CosmosOperationPolicy;
import com.azure.cosmos.DirectConnectionConfig;
import com.azure.cosmos.SessionRetryOptions;
import com.azure.cosmos.ThresholdBasedAvailabilityStrategy;
import com.azure.cosmos.implementation.AadTokenAuthorizationHelper;
import com.azure.cosmos.implementation.ApiType;
import com.azure.cosmos.implementation.AsyncDocumentClient;
import com.azure.cosmos.implementation.AuthorizationTokenType;
import com.azure.cosmos.implementation.BaseAuthorizationTokenProvider;
import com.azure.cosmos.implementation.ChangeFeedOperationState;
import com.azure.cosmos.implementation.ChangeFeedQueryImpl;
import com.azure.cosmos.implementation.ClientEncryptionKey;
import com.azure.cosmos.implementation.ClientSideRequestStatistics;
import com.azure.cosmos.implementation.CollectionRoutingMapNotFoundException;
import com.azure.cosmos.implementation.Configs;
import com.azure.cosmos.implementation.Conflict;
import com.azure.cosmos.implementation.ConnectionPolicy;
import com.azure.cosmos.implementation.CosmosChangeFeedRequestOptionsImpl;
import com.azure.cosmos.implementation.CosmosClientMetadataCachesSnapshot;
import com.azure.cosmos.implementation.CosmosResourceType;
import com.azure.cosmos.implementation.Database;
import com.azure.cosmos.implementation.DatabaseAccount;
import com.azure.cosmos.implementation.DatabaseAccountLocation;
import com.azure.cosmos.implementation.DatabaseAccountManagerInternal;
import com.azure.cosmos.implementation.DiagnosticsClientContext;
import com.azure.cosmos.implementation.DistinctClientSideRequestStatisticsCollection;
import com.azure.cosmos.implementation.Document;
import com.azure.cosmos.implementation.DocumentClientRetryPolicy;
import com.azure.cosmos.implementation.DocumentCollection;
import com.azure.cosmos.implementation.DocumentServiceRequestContext;
import com.azure.cosmos.implementation.FeedOperationContextForCircuitBreaker;
import com.azure.cosmos.implementation.GlobalEndpointManager;
import com.azure.cosmos.implementation.HttpConstants;
import com.azure.cosmos.implementation.IAuthorizationTokenProvider;
import com.azure.cosmos.implementation.IRetryPolicyFactory;
import com.azure.cosmos.implementation.ISessionContainer;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.InternalObjectNode;
import com.azure.cosmos.implementation.InvalidPartitionException;
import com.azure.cosmos.implementation.InvalidPartitionExceptionRetryPolicy;
import com.azure.cosmos.implementation.JsonSerializable;
import com.azure.cosmos.implementation.LifeCycleUtils;
import com.azure.cosmos.implementation.MetadataDiagnosticsContext;
import com.azure.cosmos.implementation.ObservableHelper;
import com.azure.cosmos.implementation.Offer;
import com.azure.cosmos.implementation.OfferAutoscaleAutoUpgradeProperties;
import com.azure.cosmos.implementation.OfferAutoscaleSettings;
import com.azure.cosmos.implementation.OperationCancelledException;
import com.azure.cosmos.implementation.OperationType;
import com.azure.cosmos.implementation.PartitionKeyHelper;
import com.azure.cosmos.implementation.PartitionKeyMismatchRetryPolicy;
import com.azure.cosmos.implementation.PartitionKeyRange;
import com.azure.cosmos.implementation.PathInfo;
import com.azure.cosmos.implementation.PathsHelper;
import com.azure.cosmos.implementation.Permission;
import com.azure.cosmos.implementation.PointOperationContextForCircuitBreaker;
import com.azure.cosmos.implementation.QueryCompatibilityMode;
import com.azure.cosmos.implementation.QueryFeedOperationState;
import com.azure.cosmos.implementation.QueryMetrics;
import com.azure.cosmos.implementation.RegionScopedSessionContainer;
import com.azure.cosmos.implementation.RequestOptions;
import com.azure.cosmos.implementation.RequestVerb;
import com.azure.cosmos.implementation.ResetSessionTokenRetryPolicyFactory;
import com.azure.cosmos.implementation.Resource;
import com.azure.cosmos.implementation.ResourceResponse;
import com.azure.cosmos.implementation.ResourceTokenAuthorizationHelper;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.implementation.RetryPolicy;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.RxDocumentServiceResponse;
import com.azure.cosmos.implementation.RxGatewayStoreModel;
import com.azure.cosmos.implementation.RxStoreModel;
import com.azure.cosmos.implementation.SerializationDiagnosticsContext;
import com.azure.cosmos.implementation.SessionContainer;
import com.azure.cosmos.implementation.SqlQuerySpecLogger;
import com.azure.cosmos.implementation.StoredProcedure;
import com.azure.cosmos.implementation.StoredProcedureResponse;
import com.azure.cosmos.implementation.Strings;
import com.azure.cosmos.implementation.Trigger;
import com.azure.cosmos.implementation.User;
import com.azure.cosmos.implementation.UserAgentContainer;
import com.azure.cosmos.implementation.UserDefinedFunction;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.apachecommons.lang.tuple.ImmutablePair;
import com.azure.cosmos.implementation.batch.BatchResponseParser;
import com.azure.cosmos.implementation.batch.PartitionKeyRangeServerBatchRequest;
import com.azure.cosmos.implementation.batch.ServerBatchRequest;
import com.azure.cosmos.implementation.batch.SinglePartitionKeyServerBatchRequest;
import com.azure.cosmos.implementation.caches.RxClientCollectionCache;
import com.azure.cosmos.implementation.caches.RxCollectionCache;
import com.azure.cosmos.implementation.caches.RxPartitionKeyRangeCache;
import com.azure.cosmos.implementation.circuitBreaker.GlobalPartitionEndpointManagerForCircuitBreaker;
import com.azure.cosmos.implementation.circuitBreaker.PartitionKeyRangeWrapper;
import com.azure.cosmos.implementation.clienttelemetry.ClientTelemetry;
import com.azure.cosmos.implementation.cpu.CpuMemoryListener;
import com.azure.cosmos.implementation.cpu.CpuMemoryMonitor;
import com.azure.cosmos.implementation.directconnectivity.AddressSelector;
import com.azure.cosmos.implementation.directconnectivity.GatewayServiceConfigurationReader;
import com.azure.cosmos.implementation.directconnectivity.GlobalAddressResolver;
import com.azure.cosmos.implementation.directconnectivity.ServerStoreModel;
import com.azure.cosmos.implementation.directconnectivity.StoreClient;
import com.azure.cosmos.implementation.directconnectivity.StoreClientFactory;
import com.azure.cosmos.implementation.faultinjection.IFaultInjectorProvider;
import com.azure.cosmos.implementation.feedranges.FeedRangeEpkImpl;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.http.HttpClient;
import com.azure.cosmos.implementation.http.HttpClientConfig;
import com.azure.cosmos.implementation.http.HttpHeaders;
import com.azure.cosmos.implementation.http.SharedGatewayHttpClient;
import com.azure.cosmos.implementation.patch.PatchUtil;
import com.azure.cosmos.implementation.query.DocumentQueryExecutionContextFactory;
import com.azure.cosmos.implementation.query.IDocumentQueryClient;
import com.azure.cosmos.implementation.query.IDocumentQueryExecutionContext;
import com.azure.cosmos.implementation.query.Paginator;
import com.azure.cosmos.implementation.query.PartitionedQueryExecutionInfo;
import com.azure.cosmos.implementation.query.PipelinedQueryExecutionContextBase;
import com.azure.cosmos.implementation.query.QueryInfo;
import com.azure.cosmos.implementation.routing.CollectionRoutingMap;
import com.azure.cosmos.implementation.routing.PartitionKeyAndResourceTokenPair;
import com.azure.cosmos.implementation.routing.PartitionKeyInternal;
import com.azure.cosmos.implementation.routing.PartitionKeyInternalHelper;
import com.azure.cosmos.implementation.routing.PartitionKeyRangeIdentity;
import com.azure.cosmos.implementation.routing.Range;
import com.azure.cosmos.implementation.routing.RegionNameToRegionIdMap;
import com.azure.cosmos.implementation.spark.OperationContext;
import com.azure.cosmos.implementation.spark.OperationContextAndListenerTuple;
import com.azure.cosmos.implementation.spark.OperationListener;
import com.azure.cosmos.implementation.throughputControl.ThroughputControlStore;
import com.azure.cosmos.implementation.throughputControl.config.ThroughputControlGroupInternal;
import com.azure.cosmos.models.CosmosAuthorizationTokenResolver;
import com.azure.cosmos.models.CosmosBatchResponse;
import com.azure.cosmos.models.CosmosChangeFeedRequestOptions;
import com.azure.cosmos.models.CosmosClientTelemetryConfig;
import com.azure.cosmos.models.CosmosContainerIdentity;
import com.azure.cosmos.models.CosmosItemIdentity;
import com.azure.cosmos.models.CosmosItemRequestOptions;
import com.azure.cosmos.models.CosmosItemResponse;
import com.azure.cosmos.models.CosmosOperationDetails;
import com.azure.cosmos.models.CosmosPatchOperations;
import com.azure.cosmos.models.CosmosQueryRequestOptions;
import com.azure.cosmos.models.FeedRange;
import com.azure.cosmos.models.FeedResponse;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.azure.cosmos.models.PartitionKey;
import com.azure.cosmos.models.PartitionKeyDefinition;
import com.azure.cosmos.models.PartitionKind;
import com.azure.cosmos.models.SqlParameter;
import com.azure.cosmos.models.SqlQuerySpec;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SignalType;
import reactor.util.concurrent.Queues;
import reactor.util.function.Tuple2;

public class RxDocumentClientImpl
implements AsyncDocumentClient,
IAuthorizationTokenProvider,
CpuMemoryListener,
DiagnosticsClientContext {
    private static final List<String> EMPTY_REGION_LIST = Collections.emptyList();
    private static final List<URI> EMPTY_ENDPOINT_LIST = Collections.emptyList();
    private static final ImplementationBridgeHelpers.CosmosDiagnosticsHelper.CosmosDiagnosticsAccessor diagnosticsAccessor = ImplementationBridgeHelpers.CosmosDiagnosticsHelper.getCosmosDiagnosticsAccessor();
    private static final ImplementationBridgeHelpers.FeedResponseHelper.FeedResponseAccessor feedResponseAccessor = ImplementationBridgeHelpers.FeedResponseHelper.getFeedResponseAccessor();
    private static final ImplementationBridgeHelpers.CosmosClientTelemetryConfigHelper.CosmosClientTelemetryConfigAccessor telemetryCfgAccessor = ImplementationBridgeHelpers.CosmosClientTelemetryConfigHelper.getCosmosClientTelemetryConfigAccessor();
    private static final ImplementationBridgeHelpers.CosmosDiagnosticsContextHelper.CosmosDiagnosticsContextAccessor ctxAccessor = ImplementationBridgeHelpers.CosmosDiagnosticsContextHelper.getCosmosDiagnosticsContextAccessor();
    private static final ImplementationBridgeHelpers.CosmosQueryRequestOptionsHelper.CosmosQueryRequestOptionsAccessor qryOptAccessor = ImplementationBridgeHelpers.CosmosQueryRequestOptionsHelper.getCosmosQueryRequestOptionsAccessor();
    private static final ImplementationBridgeHelpers.CosmosItemResponseHelper.CosmosItemResponseBuilderAccessor itemResponseAccessor = ImplementationBridgeHelpers.CosmosItemResponseHelper.getCosmosItemResponseBuilderAccessor();
    private static final ImplementationBridgeHelpers.CosmosChangeFeedRequestOptionsHelper.CosmosChangeFeedRequestOptionsAccessor changeFeedOptionsAccessor = ImplementationBridgeHelpers.CosmosChangeFeedRequestOptionsHelper.getCosmosChangeFeedRequestOptionsAccessor();
    private static final ImplementationBridgeHelpers.CosmosOperationDetailsHelper.CosmosOperationDetailsAccessor operationDetailsAccessor = ImplementationBridgeHelpers.CosmosOperationDetailsHelper.getCosmosOperationDetailsAccessor();
    private static final String tempMachineId = "uuid:" + UUID.randomUUID();
    private static final AtomicInteger activeClientsCnt = new AtomicInteger(0);
    private static final Map<String, Integer> clientMap = new ConcurrentHashMap<String, Integer>();
    private static final AtomicInteger clientIdGenerator = new AtomicInteger(0);
    private static final Range<String> RANGE_INCLUDING_ALL_PARTITION_KEY_RANGES = new Range<String>(PartitionKeyInternalHelper.MinimumInclusiveEffectivePartitionKey, PartitionKeyInternalHelper.MaximumExclusiveEffectivePartitionKey, true, false);
    private static final String DUMMY_SQL_QUERY = "this is dummy and only used in creating ParallelDocumentQueryExecutioncontext, but not used";
    private static final ObjectMapper mapper = Utils.getSimpleObjectMapper();
    private final CosmosItemSerializer defaultCustomSerializer;
    private static final Logger logger = LoggerFactory.getLogger(RxDocumentClientImpl.class);
    private final String masterKeyOrResourceToken;
    private final URI serviceEndpoint;
    private final ConnectionPolicy connectionPolicy;
    private final ConsistencyLevel consistencyLevel;
    private final BaseAuthorizationTokenProvider authorizationTokenProvider;
    private final UserAgentContainer userAgentContainer;
    private final boolean hasAuthKeyResourceToken;
    private final Configs configs;
    private final boolean connectionSharingAcrossClientsEnabled;
    private AzureKeyCredential credential;
    private final TokenCredential tokenCredential;
    private String[] tokenCredentialScopes;
    private SimpleTokenCache tokenCredentialCache;
    private CosmosAuthorizationTokenResolver cosmosAuthorizationTokenResolver;
    AuthorizationTokenType authorizationTokenType;
    private ISessionContainer sessionContainer;
    private String firstResourceTokenFromPermissionFeed = "";
    private RxClientCollectionCache collectionCache;
    private RxGatewayStoreModel gatewayProxy;
    private RxStoreModel storeModel;
    private GlobalAddressResolver addressResolver;
    private RxPartitionKeyRangeCache partitionKeyRangeCache;
    private Map<String, List<PartitionKeyAndResourceTokenPair>> resourceTokensMap;
    private final boolean contentResponseOnWriteEnabled;
    private final Map<String, PartitionedQueryExecutionInfo> queryPlanCache;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final int clientId;
    private ClientTelemetry clientTelemetry;
    private final ApiType apiType;
    private final CosmosEndToEndOperationLatencyPolicyConfig cosmosEndToEndOperationLatencyPolicyConfig;
    private final AtomicReference<CosmosDiagnostics> mostRecentlyCreatedDiagnostics = new AtomicReference<Object>(null);
    private IRetryPolicyFactory resetSessionTokenRetryPolicy;
    private final QueryCompatibilityMode queryCompatibilityMode = QueryCompatibilityMode.Default;
    private final GlobalEndpointManager globalEndpointManager;
    private final GlobalPartitionEndpointManagerForCircuitBreaker globalPartitionEndpointManagerForCircuitBreaker;
    private final RetryPolicy retryPolicy;
    private HttpClient reactorHttpClient;
    private Function<HttpClient, HttpClient> httpClientInterceptor;
    private volatile boolean useMultipleWriteLocations;
    private StoreClientFactory storeClientFactory;
    private GatewayServiceConfigurationReader gatewayConfigurationReader;
    private final DiagnosticsClientContext.DiagnosticsClientConfig diagnosticsClientConfig;
    private final AtomicBoolean throughputControlEnabled;
    private ThroughputControlStore throughputControlStore;
    private final CosmosClientTelemetryConfig clientTelemetryConfig;
    private final String clientCorrelationId;
    private final SessionRetryOptions sessionRetryOptions;
    private final boolean sessionCapturingOverrideEnabled;
    private final boolean sessionCapturingDisabled;
    private final boolean isRegionScopedSessionCapturingEnabledOnClientOrSystemConfig;
    private List<CosmosOperationPolicy> operationPolicies;
    private AtomicReference<CosmosAsyncClient> cachedCosmosAsyncClientSnapshot;

    public RxDocumentClientImpl(URI serviceEndpoint, String masterKeyOrResourceToken, List<Permission> permissionFeed, ConnectionPolicy connectionPolicy, ConsistencyLevel consistencyLevel, Configs configs, CosmosAuthorizationTokenResolver cosmosAuthorizationTokenResolver, AzureKeyCredential credential, boolean sessionCapturingOverride, boolean connectionSharingAcrossClientsEnabled, boolean contentResponseOnWriteEnabled, CosmosClientMetadataCachesSnapshot metadataCachesSnapshot, ApiType apiType, CosmosClientTelemetryConfig clientTelemetryConfig, String clientCorrelationId, CosmosEndToEndOperationLatencyPolicyConfig cosmosEndToEndOperationLatencyPolicyConfig, SessionRetryOptions sessionRetryOptions, CosmosContainerProactiveInitConfig containerProactiveInitConfig, CosmosItemSerializer defaultCustomSerializer, boolean isRegionScopedSessionCapturingEnabled) {
        this(serviceEndpoint, masterKeyOrResourceToken, permissionFeed, connectionPolicy, consistencyLevel, configs, credential, null, sessionCapturingOverride, connectionSharingAcrossClientsEnabled, contentResponseOnWriteEnabled, metadataCachesSnapshot, apiType, clientTelemetryConfig, clientCorrelationId, cosmosEndToEndOperationLatencyPolicyConfig, sessionRetryOptions, containerProactiveInitConfig, defaultCustomSerializer, isRegionScopedSessionCapturingEnabled);
        this.cosmosAuthorizationTokenResolver = cosmosAuthorizationTokenResolver;
    }

    public RxDocumentClientImpl(URI serviceEndpoint, String masterKeyOrResourceToken, List<Permission> permissionFeed, ConnectionPolicy connectionPolicy, ConsistencyLevel consistencyLevel, Configs configs, CosmosAuthorizationTokenResolver cosmosAuthorizationTokenResolver, AzureKeyCredential credential, TokenCredential tokenCredential, boolean sessionCapturingOverride, boolean connectionSharingAcrossClientsEnabled, boolean contentResponseOnWriteEnabled, CosmosClientMetadataCachesSnapshot metadataCachesSnapshot, ApiType apiType, CosmosClientTelemetryConfig clientTelemetryConfig, String clientCorrelationId, CosmosEndToEndOperationLatencyPolicyConfig cosmosEndToEndOperationLatencyPolicyConfig, SessionRetryOptions sessionRetryOptions, CosmosContainerProactiveInitConfig containerProactiveInitConfig, CosmosItemSerializer defaultCustomSerializer, boolean isRegionScopedSessionCapturingEnabled, List<CosmosOperationPolicy> operationPolicies) {
        this(serviceEndpoint, masterKeyOrResourceToken, permissionFeed, connectionPolicy, consistencyLevel, configs, credential, tokenCredential, sessionCapturingOverride, connectionSharingAcrossClientsEnabled, contentResponseOnWriteEnabled, metadataCachesSnapshot, apiType, clientTelemetryConfig, clientCorrelationId, cosmosEndToEndOperationLatencyPolicyConfig, sessionRetryOptions, containerProactiveInitConfig, defaultCustomSerializer, isRegionScopedSessionCapturingEnabled);
        this.cosmosAuthorizationTokenResolver = cosmosAuthorizationTokenResolver;
        this.operationPolicies = operationPolicies;
    }

    private RxDocumentClientImpl(URI serviceEndpoint, String masterKeyOrResourceToken, List<Permission> permissionFeed, ConnectionPolicy connectionPolicy, ConsistencyLevel consistencyLevel, Configs configs, AzureKeyCredential credential, TokenCredential tokenCredential, boolean sessionCapturingOverrideEnabled, boolean connectionSharingAcrossClientsEnabled, boolean contentResponseOnWriteEnabled, CosmosClientMetadataCachesSnapshot metadataCachesSnapshot, ApiType apiType, CosmosClientTelemetryConfig clientTelemetryConfig, String clientCorrelationId, CosmosEndToEndOperationLatencyPolicyConfig cosmosEndToEndOperationLatencyPolicyConfig, SessionRetryOptions sessionRetryOptions, CosmosContainerProactiveInitConfig containerProactiveInitConfig, CosmosItemSerializer defaultCustomSerializer, boolean isRegionScopedSessionCapturingEnabled) {
        this(serviceEndpoint, masterKeyOrResourceToken, connectionPolicy, consistencyLevel, configs, credential, tokenCredential, sessionCapturingOverrideEnabled, connectionSharingAcrossClientsEnabled, contentResponseOnWriteEnabled, metadataCachesSnapshot, apiType, clientTelemetryConfig, clientCorrelationId, cosmosEndToEndOperationLatencyPolicyConfig, sessionRetryOptions, containerProactiveInitConfig, defaultCustomSerializer, isRegionScopedSessionCapturingEnabled);
        if (permissionFeed != null && permissionFeed.size() > 0) {
            this.resourceTokensMap = new HashMap<String, List<PartitionKeyAndResourceTokenPair>>();
            for (Permission permission : permissionFeed) {
                PartitionKey partitionKey;
                String[] segments = StringUtils.split(permission.getResourceLink(), "/".charAt(0));
                if (segments.length == 0) {
                    throw new IllegalArgumentException("resourceLink");
                }
                List<PartitionKeyAndResourceTokenPair> partitionKeyAndResourceTokenPairs = null;
                PathInfo pathInfo = new PathInfo(false, "", "", false);
                if (!PathsHelper.tryParsePathSegments(permission.getResourceLink(), pathInfo, null)) {
                    throw new IllegalArgumentException(permission.getResourceLink());
                }
                partitionKeyAndResourceTokenPairs = this.resourceTokensMap.get(pathInfo.resourceIdOrFullName);
                if (partitionKeyAndResourceTokenPairs == null) {
                    partitionKeyAndResourceTokenPairs = new ArrayList<PartitionKeyAndResourceTokenPair>();
                    this.resourceTokensMap.put(pathInfo.resourceIdOrFullName, partitionKeyAndResourceTokenPairs);
                }
                partitionKeyAndResourceTokenPairs.add(new PartitionKeyAndResourceTokenPair((partitionKey = permission.getResourcePartitionKey()) != null ? BridgeInternal.getPartitionKeyInternal(partitionKey) : PartitionKeyInternal.Empty, permission.getToken()));
                logger.debug("Initializing resource token map  , with map key [{}] , partition key [{}] and resource token [{}]", new Object[]{pathInfo.resourceIdOrFullName, partitionKey != null ? partitionKey.toString() : null, permission.getToken()});
            }
            if (this.resourceTokensMap.isEmpty()) {
                throw new IllegalArgumentException("permissionFeed");
            }
            String firstToken = permissionFeed.get(0).getToken();
            if (ResourceTokenAuthorizationHelper.isResourceToken(firstToken)) {
                this.firstResourceTokenFromPermissionFeed = firstToken;
            }
        }
    }

    RxDocumentClientImpl(URI serviceEndpoint, String masterKeyOrResourceToken, ConnectionPolicy connectionPolicy, ConsistencyLevel consistencyLevel, Configs configs, AzureKeyCredential credential, TokenCredential tokenCredential, boolean sessionCapturingOverrideEnabled, boolean connectionSharingAcrossClientsEnabled, boolean contentResponseOnWriteEnabled, CosmosClientMetadataCachesSnapshot metadataCachesSnapshot, ApiType apiType, CosmosClientTelemetryConfig clientTelemetryConfig, String clientCorrelationId, CosmosEndToEndOperationLatencyPolicyConfig cosmosEndToEndOperationLatencyPolicyConfig, SessionRetryOptions sessionRetryOptions, CosmosContainerProactiveInitConfig containerProactiveInitConfig, CosmosItemSerializer defaultCustomSerializer, boolean isRegionScopedSessionCapturingEnabled) {
        assert (clientTelemetryConfig != null);
        Boolean clientTelemetryEnabled = ImplementationBridgeHelpers.CosmosClientTelemetryConfigHelper.getCosmosClientTelemetryConfigAccessor().isSendClientTelemetryToServiceEnabled(clientTelemetryConfig);
        assert (clientTelemetryEnabled != null);
        activeClientsCnt.incrementAndGet();
        this.clientId = clientIdGenerator.incrementAndGet();
        this.clientCorrelationId = Strings.isNullOrWhiteSpace(clientCorrelationId) ? String.format("%05d", this.clientId) : clientCorrelationId;
        clientMap.put(serviceEndpoint.toString(), clientMap.getOrDefault(serviceEndpoint.toString(), 0) + 1);
        this.diagnosticsClientConfig = new DiagnosticsClientContext.DiagnosticsClientConfig();
        this.diagnosticsClientConfig.withClientId(this.clientId);
        this.diagnosticsClientConfig.withActiveClientCounter(activeClientsCnt);
        this.diagnosticsClientConfig.withClientMap(clientMap);
        this.diagnosticsClientConfig.withConnectionSharingAcrossClientsEnabled(connectionSharingAcrossClientsEnabled);
        this.diagnosticsClientConfig.withConsistency(consistencyLevel);
        this.throughputControlEnabled = new AtomicBoolean(false);
        this.cosmosEndToEndOperationLatencyPolicyConfig = cosmosEndToEndOperationLatencyPolicyConfig;
        this.diagnosticsClientConfig.withEndToEndOperationLatencyPolicy(cosmosEndToEndOperationLatencyPolicyConfig);
        this.sessionRetryOptions = sessionRetryOptions;
        this.defaultCustomSerializer = defaultCustomSerializer;
        logger.info("Initializing DocumentClient [{}] with serviceEndpoint [{}], connectionPolicy [{}], consistencyLevel [{}]", new Object[]{this.clientId, serviceEndpoint, connectionPolicy, consistencyLevel});
        try {
            boolean disableSessionCapturing;
            this.connectionSharingAcrossClientsEnabled = connectionSharingAcrossClientsEnabled;
            this.configs = configs;
            this.masterKeyOrResourceToken = masterKeyOrResourceToken;
            this.serviceEndpoint = serviceEndpoint;
            this.credential = credential;
            this.tokenCredential = tokenCredential;
            this.contentResponseOnWriteEnabled = contentResponseOnWriteEnabled;
            this.authorizationTokenType = AuthorizationTokenType.Invalid;
            if (this.credential != null) {
                this.hasAuthKeyResourceToken = false;
                this.authorizationTokenType = AuthorizationTokenType.PrimaryMasterKey;
                this.authorizationTokenProvider = new BaseAuthorizationTokenProvider(this.credential);
            } else if (masterKeyOrResourceToken != null && ResourceTokenAuthorizationHelper.isResourceToken(masterKeyOrResourceToken)) {
                this.authorizationTokenProvider = null;
                this.hasAuthKeyResourceToken = true;
                this.authorizationTokenType = AuthorizationTokenType.ResourceToken;
            } else if (masterKeyOrResourceToken != null && !ResourceTokenAuthorizationHelper.isResourceToken(masterKeyOrResourceToken)) {
                this.credential = new AzureKeyCredential(this.masterKeyOrResourceToken);
                this.hasAuthKeyResourceToken = false;
                this.authorizationTokenType = AuthorizationTokenType.PrimaryMasterKey;
                this.authorizationTokenProvider = new BaseAuthorizationTokenProvider(this.credential);
            } else {
                this.hasAuthKeyResourceToken = false;
                this.authorizationTokenProvider = null;
                if (tokenCredential != null) {
                    this.tokenCredentialScopes = new String[]{serviceEndpoint.getScheme() + "://" + serviceEndpoint.getHost() + "/.default"};
                    this.tokenCredentialCache = new SimpleTokenCache(() -> this.tokenCredential.getToken(new TokenRequestContext().addScopes(this.tokenCredentialScopes)));
                    this.authorizationTokenType = AuthorizationTokenType.AadToken;
                }
            }
            this.connectionPolicy = connectionPolicy != null ? connectionPolicy : new ConnectionPolicy(DirectConnectionConfig.getDefaultConfig());
            this.diagnosticsClientConfig.withConnectionMode(this.getConnectionPolicy().getConnectionMode());
            this.diagnosticsClientConfig.withConnectionPolicy(this.connectionPolicy);
            this.diagnosticsClientConfig.withMultipleWriteRegionsEnabled(this.connectionPolicy.isMultipleWriteRegionsEnabled());
            this.diagnosticsClientConfig.withEndpointDiscoveryEnabled(this.connectionPolicy.isEndpointDiscoveryEnabled());
            this.diagnosticsClientConfig.withPreferredRegions(this.connectionPolicy.getPreferredRegions());
            this.diagnosticsClientConfig.withMachineId(tempMachineId);
            this.diagnosticsClientConfig.withProactiveContainerInitConfig(containerProactiveInitConfig);
            this.diagnosticsClientConfig.withSessionRetryOptions(sessionRetryOptions);
            this.sessionCapturingOverrideEnabled = sessionCapturingOverrideEnabled;
            this.sessionCapturingDisabled = disableSessionCapturing = ConsistencyLevel.SESSION != consistencyLevel && !sessionCapturingOverrideEnabled;
            this.consistencyLevel = consistencyLevel;
            this.userAgentContainer = new UserAgentContainer();
            String userAgentSuffix = this.connectionPolicy.getUserAgentSuffix();
            if (userAgentSuffix != null && userAgentSuffix.length() > 0) {
                this.userAgentContainer.setSuffix(userAgentSuffix);
            }
            this.httpClientInterceptor = null;
            this.reactorHttpClient = this.httpClient();
            this.globalEndpointManager = new GlobalEndpointManager(this.asDatabaseAccountManagerInternal(), this.connectionPolicy, configs);
            this.isRegionScopedSessionCapturingEnabledOnClientOrSystemConfig = isRegionScopedSessionCapturingEnabled;
            this.sessionContainer = new SessionContainer(this.serviceEndpoint.getHost(), disableSessionCapturing);
            this.globalPartitionEndpointManagerForCircuitBreaker = new GlobalPartitionEndpointManagerForCircuitBreaker(this.globalEndpointManager);
            this.globalPartitionEndpointManagerForCircuitBreaker.init();
            this.cachedCosmosAsyncClientSnapshot = new AtomicReference();
            this.diagnosticsClientConfig.withPartitionLevelCircuitBreakerConfig(this.globalPartitionEndpointManagerForCircuitBreaker.getCircuitBreakerConfig());
            this.retryPolicy = new RetryPolicy(this, this.globalEndpointManager, this.connectionPolicy, this.globalPartitionEndpointManagerForCircuitBreaker);
            this.resetSessionTokenRetryPolicy = this.retryPolicy;
            CpuMemoryMonitor.register(this);
            this.queryPlanCache = new ConcurrentHashMap<String, PartitionedQueryExecutionInfo>();
            this.apiType = apiType;
            this.clientTelemetryConfig = clientTelemetryConfig;
        }
        catch (RuntimeException e) {
            logger.error("unexpected failure in initializing client.", (Throwable)e);
            this.close();
            throw e;
        }
    }

    @Override
    public DiagnosticsClientContext.DiagnosticsClientConfig getConfig() {
        return this.diagnosticsClientConfig;
    }

    @Override
    public CosmosDiagnostics createDiagnostics() {
        CosmosDiagnostics diagnostics = diagnosticsAccessor.create(this, telemetryCfgAccessor.getSamplingRate(this.clientTelemetryConfig));
        this.mostRecentlyCreatedDiagnostics.set(diagnostics);
        return diagnostics;
    }

    private DatabaseAccount initializeGatewayConfigurationReader() {
        this.gatewayConfigurationReader = new GatewayServiceConfigurationReader(this.globalEndpointManager);
        DatabaseAccount databaseAccount = this.globalEndpointManager.getLatestDatabaseAccount();
        if (databaseAccount == null) {
            Throwable databaseRefreshErrorSnapshot = this.globalEndpointManager.getLatestDatabaseRefreshError();
            if (databaseRefreshErrorSnapshot != null) {
                logger.error("Client initialization failed. Check if the endpoint is reachable and if your auth token is valid. More info: https://aka.ms/cosmosdb-tsg-service-unavailable-java. More details: " + databaseRefreshErrorSnapshot.getMessage(), databaseRefreshErrorSnapshot);
                throw new RuntimeException("Client initialization failed. Check if the endpoint is reachable and if your auth token is valid. More info: https://aka.ms/cosmosdb-tsg-service-unavailable-java. More details: " + databaseRefreshErrorSnapshot.getMessage(), databaseRefreshErrorSnapshot);
            }
            logger.error("Client initialization failed. Check if the endpoint is reachable and if your auth token is valid. More info: https://aka.ms/cosmosdb-tsg-service-unavailable-java");
            throw new RuntimeException("Client initialization failed. Check if the endpoint is reachable and if your auth token is valid. More info: https://aka.ms/cosmosdb-tsg-service-unavailable-java.");
        }
        this.useMultipleWriteLocations = this.connectionPolicy.isMultipleWriteRegionsEnabled() && BridgeInternal.isEnableMultipleWriteLocations(databaseAccount);
        return databaseAccount;
    }

    private void resetSessionContainerIfNeeded(DatabaseAccount databaseAccount) {
        boolean isRegionScopingOfSessionTokensPossible = this.isRegionScopingOfSessionTokensPossible(databaseAccount, this.useMultipleWriteLocations, this.isRegionScopedSessionCapturingEnabledOnClientOrSystemConfig);
        if (isRegionScopingOfSessionTokensPossible) {
            this.sessionContainer = new RegionScopedSessionContainer(this.serviceEndpoint.getHost(), this.sessionCapturingDisabled, this.globalEndpointManager);
            this.diagnosticsClientConfig.withRegionScopedSessionContainerOptions((RegionScopedSessionContainer)this.sessionContainer);
        }
    }

    private boolean isRegionScopingOfSessionTokensPossible(DatabaseAccount databaseAccount, boolean useMultipleWriteLocations, boolean isRegionScopedSessionCapturingEnabled) {
        if (!isRegionScopedSessionCapturingEnabled) {
            return false;
        }
        if (!useMultipleWriteLocations) {
            return false;
        }
        Iterable<DatabaseAccountLocation> readableLocationsIterable = databaseAccount.getReadableLocations();
        for (DatabaseAccountLocation readableLocation : readableLocationsIterable) {
            String normalizedReadableRegion = readableLocation.getName().toLowerCase(Locale.ROOT).trim().replace(" ", "");
            if (RegionNameToRegionIdMap.getRegionId(normalizedReadableRegion) != -1) continue;
            return false;
        }
        return true;
    }

    private void updateGatewayProxy() {
        this.gatewayProxy.setGatewayServiceConfigurationReader(this.gatewayConfigurationReader);
        this.gatewayProxy.setCollectionCache(this.collectionCache);
        this.gatewayProxy.setPartitionKeyRangeCache(this.partitionKeyRangeCache);
        this.gatewayProxy.setUseMultipleWriteLocations(this.useMultipleWriteLocations);
        this.gatewayProxy.setSessionContainer(this.sessionContainer);
    }

    public void init(CosmosClientMetadataCachesSnapshot metadataCachesSnapshot, Function<HttpClient, HttpClient> httpClientInterceptor) {
        try {
            this.httpClientInterceptor = httpClientInterceptor;
            if (httpClientInterceptor != null) {
                this.reactorHttpClient = httpClientInterceptor.apply(this.httpClient());
            }
            this.gatewayProxy = this.createRxGatewayProxy(this.sessionContainer, this.consistencyLevel, this.queryCompatibilityMode, this.userAgentContainer, this.globalEndpointManager, this.reactorHttpClient, this.apiType);
            this.globalEndpointManager.init();
            DatabaseAccount databaseAccountSnapshot = this.initializeGatewayConfigurationReader();
            this.resetSessionContainerIfNeeded(databaseAccountSnapshot);
            this.collectionCache = metadataCachesSnapshot != null ? new RxClientCollectionCache(this, this.sessionContainer, this.gatewayProxy, this, this.retryPolicy, metadataCachesSnapshot.getCollectionInfoByNameCache(), metadataCachesSnapshot.getCollectionInfoByIdCache()) : new RxClientCollectionCache(this, this.sessionContainer, this.gatewayProxy, this, this.retryPolicy);
            this.resetSessionTokenRetryPolicy = new ResetSessionTokenRetryPolicyFactory(this.sessionContainer, this.collectionCache, this.retryPolicy);
            this.partitionKeyRangeCache = new RxPartitionKeyRangeCache(this, this.collectionCache);
            this.updateGatewayProxy();
            this.clientTelemetry = new ClientTelemetry(this, null, RxDocumentClientImpl.randomUuid().toString(), ManagementFactory.getRuntimeMXBean().getName(), this.connectionPolicy.getConnectionMode(), this.globalEndpointManager.getLatestDatabaseAccount().getId(), null, null, this.configs, this.clientTelemetryConfig, this, this.connectionPolicy.getPreferredRegions());
            this.clientTelemetry.init().thenEmpty(publisher -> logger.warn("Initialized DocumentClient [{}] with machineId[{}] serviceEndpoint [{}], connectionPolicy [{}], consistencyLevel [{}]", new Object[]{this.clientId, ClientTelemetry.getMachineId(this.diagnosticsClientConfig), this.serviceEndpoint, this.connectionPolicy, this.consistencyLevel})).subscribe();
            if (this.connectionPolicy.getConnectionMode() == ConnectionMode.GATEWAY) {
                this.storeModel = this.gatewayProxy;
            } else {
                this.initializeDirectConnectivity();
            }
            this.retryPolicy.setRxCollectionCache(this.collectionCache);
            ConsistencyLevel effectiveConsistencyLevel = this.consistencyLevel != null ? this.consistencyLevel : this.getDefaultConsistencyLevelOfAccount();
            boolean updatedDisableSessionCapturing = ConsistencyLevel.SESSION != effectiveConsistencyLevel && !this.sessionCapturingOverrideEnabled;
            this.sessionContainer.setDisableSessionCapturing(updatedDisableSessionCapturing);
        }
        catch (Exception e) {
            logger.error("unexpected failure in initializing client.", (Throwable)e);
            this.close();
            throw e;
        }
    }

    public void serialize(CosmosClientMetadataCachesSnapshot state) {
        RxCollectionCache.serialize(state, this.collectionCache);
    }

    private void initializeDirectConnectivity() {
        this.addressResolver = new GlobalAddressResolver(this, this.reactorHttpClient, this.globalEndpointManager, this.configs.getProtocol(), this, this.collectionCache, this.partitionKeyRangeCache, this.userAgentContainer, null, this.connectionPolicy, this.apiType);
        this.storeClientFactory = new StoreClientFactory(this.addressResolver, this.diagnosticsClientConfig, this.configs, this.connectionPolicy, this.userAgentContainer, this.connectionSharingAcrossClientsEnabled, this.clientTelemetry, this.globalEndpointManager);
        this.globalPartitionEndpointManagerForCircuitBreaker.setGlobalAddressResolver(this.addressResolver);
        this.createStoreModel(true);
    }

    DatabaseAccountManagerInternal asDatabaseAccountManagerInternal() {
        return new DatabaseAccountManagerInternal(){

            @Override
            public URI getServiceEndpoint() {
                return RxDocumentClientImpl.this.getServiceEndpoint();
            }

            @Override
            public Flux<DatabaseAccount> getDatabaseAccountFromEndpoint(URI endpoint) {
                logger.info("Getting database account endpoint from {}", (Object)endpoint);
                return RxDocumentClientImpl.this.getDatabaseAccountFromEndpoint(endpoint);
            }

            @Override
            public ConnectionPolicy getConnectionPolicy() {
                return RxDocumentClientImpl.this.getConnectionPolicy();
            }
        };
    }

    RxGatewayStoreModel createRxGatewayProxy(ISessionContainer sessionContainer, ConsistencyLevel consistencyLevel, QueryCompatibilityMode queryCompatibilityMode, UserAgentContainer userAgentContainer, GlobalEndpointManager globalEndpointManager, HttpClient httpClient, ApiType apiType) {
        return new RxGatewayStoreModel(this, sessionContainer, consistencyLevel, queryCompatibilityMode, userAgentContainer, globalEndpointManager, httpClient, apiType);
    }

    private HttpClient httpClient() {
        HttpClientConfig httpClientConfig = new HttpClientConfig(this.configs).withMaxIdleConnectionTimeout(this.connectionPolicy.getIdleHttpConnectionTimeout()).withPoolSize(this.connectionPolicy.getMaxConnectionPoolSize()).withProxy(this.connectionPolicy.getProxy()).withNetworkRequestTimeout(this.connectionPolicy.getHttpNetworkRequestTimeout()).withServerCertValidationDisabled(this.connectionPolicy.isServerCertValidationDisabled());
        if (this.connectionSharingAcrossClientsEnabled) {
            return SharedGatewayHttpClient.getOrCreateInstance(httpClientConfig, this.diagnosticsClientConfig);
        }
        this.diagnosticsClientConfig.withGatewayHttpClientConfig(httpClientConfig.toDiagnosticsString());
        return HttpClient.createFixed(httpClientConfig);
    }

    private void createStoreModel(boolean subscribeRntbdStatus) {
        StoreClient storeClient = this.storeClientFactory.createStoreClient(this, this.addressResolver, this.sessionContainer, this.gatewayConfigurationReader, this, this.useMultipleWriteLocations, this.sessionRetryOptions);
        this.storeModel = new ServerStoreModel(storeClient);
    }

    @Override
    public URI getServiceEndpoint() {
        return this.serviceEndpoint;
    }

    @Override
    public ConnectionPolicy getConnectionPolicy() {
        return this.connectionPolicy;
    }

    @Override
    public boolean isContentResponseOnWriteEnabled() {
        return this.contentResponseOnWriteEnabled;
    }

    @Override
    public ConsistencyLevel getConsistencyLevel() {
        return this.consistencyLevel;
    }

    @Override
    public ClientTelemetry getClientTelemetry() {
        return this.clientTelemetry;
    }

    @Override
    public String getClientCorrelationId() {
        return this.clientCorrelationId;
    }

    @Override
    public String getMachineId() {
        if (this.diagnosticsClientConfig == null) {
            return null;
        }
        return ClientTelemetry.getMachineId(this.diagnosticsClientConfig);
    }

    @Override
    public String getUserAgent() {
        return this.userAgentContainer.getUserAgent();
    }

    @Override
    public CosmosDiagnostics getMostRecentlyCreatedDiagnostics() {
        return this.mostRecentlyCreatedDiagnostics.get();
    }

    @Override
    public Mono<ResourceResponse<Database>> createDatabase(Database database, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy(null);
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.createDatabaseInternal(database, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<Database>> createDatabaseInternal(Database database, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            SerializationDiagnosticsContext serializationDiagnosticsContext;
            if (database == null) {
                throw new IllegalArgumentException("Database");
            }
            logger.debug("Creating a Database. id: [{}]", (Object)database.getId());
            RxDocumentClientImpl.validateResource(database);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.Database, OperationType.Create);
            Instant serializationStartTimeUTC = Instant.now();
            ByteBuffer byteBuffer = database.serializeJsonToByteBuffer(CosmosItemSerializer.DEFAULT_SERIALIZER, null, false);
            Instant serializationEndTimeUTC = Instant.now();
            SerializationDiagnosticsContext.SerializationDiagnostics serializationDiagnostics = new SerializationDiagnosticsContext.SerializationDiagnostics(serializationStartTimeUTC, serializationEndTimeUTC, SerializationDiagnosticsContext.SerializationType.DATABASE_SERIALIZATION);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.Create, ResourceType.Database, "/dbs", byteBuffer, requestHeaders, (Object)options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            if ((serializationDiagnosticsContext = BridgeInternal.getSerializationDiagnosticsContext(request.requestContext.cosmosDiagnostics)) != null) {
                serializationDiagnosticsContext.addSerializationDiagnostics(serializationDiagnostics);
            }
            return this.create(request, retryPolicyInstance, this.getOperationContextAndListenerTuple(options)).map(response -> BridgeInternal.toResourceResponse(response, Database.class));
        }
        catch (Exception e) {
            logger.debug("Failure in creating a database. due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<Database>> deleteDatabase(String databaseLink, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy(null);
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.deleteDatabaseInternal(databaseLink, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<Database>> deleteDatabaseInternal(String databaseLink, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty(databaseLink)) {
                throw new IllegalArgumentException("databaseLink");
            }
            logger.debug("Deleting a Database. databaseLink: [{}]", (Object)databaseLink);
            String path = Utils.joinPath(databaseLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.Database, OperationType.Delete);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.Delete, ResourceType.Database, path, requestHeaders, options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.delete(request, retryPolicyInstance, this.getOperationContextAndListenerTuple(options)).map(response -> BridgeInternal.toResourceResponse(response, Database.class));
        }
        catch (Exception e) {
            logger.debug("Failure in deleting a database. due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<Database>> readDatabase(String databaseLink, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy(null);
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.readDatabaseInternal(databaseLink, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<Database>> readDatabaseInternal(String databaseLink, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty(databaseLink)) {
                throw new IllegalArgumentException("databaseLink");
            }
            logger.debug("Reading a Database. databaseLink: [{}]", (Object)databaseLink);
            String path = Utils.joinPath(databaseLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.Database, OperationType.Read);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.Read, ResourceType.Database, path, requestHeaders, options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.read(request, retryPolicyInstance).map(response -> BridgeInternal.toResourceResponse(response, Database.class));
        }
        catch (Exception e) {
            logger.debug("Failure in reading a database. due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Flux<FeedResponse<Database>> readDatabases(QueryFeedOperationState state) {
        return this.nonDocumentReadFeed(state, ResourceType.Database, Database.class, "/dbs");
    }

    private String parentResourceLinkToQueryLink(String parentResourceLink, ResourceType resourceTypeEnum) {
        switch (resourceTypeEnum) {
            case Database: {
                return "/dbs";
            }
            case DocumentCollection: {
                return Utils.joinPath(parentResourceLink, "colls");
            }
            case Document: {
                return Utils.joinPath(parentResourceLink, "docs");
            }
            case Offer: {
                return "/offers/";
            }
            case User: {
                return Utils.joinPath(parentResourceLink, "users");
            }
            case ClientEncryptionKey: {
                return Utils.joinPath(parentResourceLink, "clientencryptionkeys");
            }
            case Permission: {
                return Utils.joinPath(parentResourceLink, "permissions");
            }
            case Attachment: {
                return Utils.joinPath(parentResourceLink, "attachments");
            }
            case StoredProcedure: {
                return Utils.joinPath(parentResourceLink, "sprocs");
            }
            case Trigger: {
                return Utils.joinPath(parentResourceLink, "triggers");
            }
            case UserDefinedFunction: {
                return Utils.joinPath(parentResourceLink, "udfs");
            }
            case Conflict: {
                return Utils.joinPath(parentResourceLink, "conflicts");
            }
        }
        throw new IllegalArgumentException("resource type not supported");
    }

    private OperationContextAndListenerTuple getOperationContextAndListenerTuple(CosmosQueryRequestOptions options) {
        if (options == null) {
            return null;
        }
        return qryOptAccessor.getImpl(options).getOperationContextAndListenerTuple();
    }

    private OperationContextAndListenerTuple getOperationContextAndListenerTuple(RequestOptions options) {
        if (options == null) {
            return null;
        }
        return options.getOperationContextAndListenerTuple();
    }

    private <T> Flux<FeedResponse<T>> createQuery(String parentResourceLink, SqlQuerySpec sqlQuery, QueryFeedOperationState state, Class<T> klass, ResourceType resourceTypeEnum) {
        return this.createQuery(parentResourceLink, sqlQuery, state, klass, resourceTypeEnum, this);
    }

    private <T> Flux<FeedResponse<T>> createQuery(String parentResourceLink, SqlQuerySpec sqlQuery, QueryFeedOperationState state, Class<T> klass, ResourceType resourceTypeEnum, DiagnosticsClientContext innerDiagnosticsFactory) {
        String resourceLink = this.parentResourceLinkToQueryLink(parentResourceLink, resourceTypeEnum);
        CosmosQueryRequestOptions nonNullQueryOptions = state.getQueryOptions();
        UUID correlationActivityIdOfRequestOptions = qryOptAccessor.getImpl(nonNullQueryOptions).getCorrelationActivityId();
        UUID correlationActivityId = correlationActivityIdOfRequestOptions != null ? correlationActivityIdOfRequestOptions : RxDocumentClientImpl.randomUuid();
        AtomicBoolean isQueryCancelledOnTimeout = new AtomicBoolean(false);
        IDocumentQueryClient queryClient = this.documentQueryClientImpl(this, this.getOperationContextAndListenerTuple(nonNullQueryOptions));
        InvalidPartitionExceptionRetryPolicy invalidPartitionExceptionRetryPolicy = new InvalidPartitionExceptionRetryPolicy(this.collectionCache, null, resourceLink, ModelBridgeInternal.getPropertiesFromQueryRequestOptions(nonNullQueryOptions));
        ScopedDiagnosticsFactory diagnosticsFactory = new ScopedDiagnosticsFactory(innerDiagnosticsFactory, false);
        state.registerDiagnosticsFactory(diagnosticsFactory::reset, diagnosticsFactory::merge);
        return ObservableHelper.fluxInlineIfPossibleAsObs(() -> this.createQueryInternal(diagnosticsFactory, resourceLink, sqlQuery, state.getQueryOptions(), klass, resourceTypeEnum, queryClient, correlationActivityId, isQueryCancelledOnTimeout), invalidPartitionExceptionRetryPolicy).flatMap(result -> {
            diagnosticsFactory.merge(state.getDiagnosticsContextSnapshot());
            return Mono.just((Object)result);
        }).onErrorMap(throwable -> {
            diagnosticsFactory.merge(state.getDiagnosticsContextSnapshot());
            return throwable;
        }).doOnCancel(() -> diagnosticsFactory.merge(state.getDiagnosticsContextSnapshot()));
    }

    private <T> Flux<FeedResponse<T>> createQueryInternal(DiagnosticsClientContext diagnosticsClientContext, String resourceLink, SqlQuerySpec sqlQuery, CosmosQueryRequestOptions options, Class<T> klass, ResourceType resourceTypeEnum, IDocumentQueryClient queryClient, UUID activityId, AtomicBoolean isQueryCancelledOnTimeout) {
        Flux<IDocumentQueryExecutionContext<T>> executionContext = DocumentQueryExecutionContextFactory.createDocumentQueryExecutionContextAsync(diagnosticsClientContext, queryClient, resourceTypeEnum, klass, sqlQuery, options, resourceLink, false, activityId, Configs.isQueryPlanCachingEnabled(), this.queryPlanCache, isQueryCancelledOnTimeout);
        AtomicBoolean isFirstResponse = new AtomicBoolean(true);
        return executionContext.flatMap(iDocumentQueryExecutionContext -> {
            QueryInfo queryInfo = null;
            if (iDocumentQueryExecutionContext instanceof PipelinedQueryExecutionContextBase) {
                queryInfo = ((PipelinedQueryExecutionContextBase)iDocumentQueryExecutionContext).getQueryInfo();
            }
            QueryInfo finalQueryInfo = queryInfo;
            Flux feedResponseFlux = iDocumentQueryExecutionContext.executeAsync().map(tFeedResponse -> {
                if (finalQueryInfo != null) {
                    if (finalQueryInfo.hasSelectValue()) {
                        ModelBridgeInternal.addQueryInfoToFeedResponse(tFeedResponse, finalQueryInfo);
                    }
                    if (isFirstResponse.compareAndSet(true, false)) {
                        ModelBridgeInternal.addQueryPlanDiagnosticsContextToFeedResponse(tFeedResponse, finalQueryInfo.getQueryPlanDiagnosticsContext());
                    }
                }
                return tFeedResponse;
            });
            RequestOptions requestOptions = options == null ? null : ImplementationBridgeHelpers.CosmosQueryRequestOptionsHelper.getCosmosQueryRequestOptionsAccessor().toRequestOptions(options);
            CosmosEndToEndOperationLatencyPolicyConfig endToEndPolicyConfig = this.getEndToEndOperationLatencyPolicyConfig(requestOptions, resourceTypeEnum, OperationType.Query);
            if (endToEndPolicyConfig != null && endToEndPolicyConfig.isEnabled()) {
                return RxDocumentClientImpl.getFeedResponseFluxWithTimeout(feedResponseFlux, endToEndPolicyConfig, options, isQueryCancelledOnTimeout, diagnosticsClientContext);
            }
            return feedResponseFlux;
        }, Queues.SMALL_BUFFER_SIZE, 1);
    }

    private static void applyExceptionToMergedDiagnosticsForQuery(CosmosQueryRequestOptions requestOptions, CosmosException exception, DiagnosticsClientContext diagnosticsClientContext) {
        CosmosDiagnostics mostRecentlyCreatedDiagnostics = diagnosticsClientContext.getMostRecentlyCreatedDiagnostics();
        if (mostRecentlyCreatedDiagnostics != null) {
            BridgeInternal.setCosmosDiagnostics(exception, mostRecentlyCreatedDiagnostics);
        } else {
            List<CosmosDiagnostics> cancelledRequestDiagnostics = qryOptAccessor.getCancelledRequestDiagnosticsTracker(requestOptions);
            if (cancelledRequestDiagnostics != null && !cancelledRequestDiagnostics.isEmpty()) {
                CosmosDiagnostics aggregratedCosmosDiagnostics = (CosmosDiagnostics)cancelledRequestDiagnostics.stream().reduce((first, toBeMerged) -> {
                    ClientSideRequestStatistics clientSideRequestStatistics = ImplementationBridgeHelpers.CosmosDiagnosticsHelper.getCosmosDiagnosticsAccessor().getClientSideRequestStatisticsRaw((CosmosDiagnostics)first);
                    ClientSideRequestStatistics toBeMergedClientSideRequestStatistics = ImplementationBridgeHelpers.CosmosDiagnosticsHelper.getCosmosDiagnosticsAccessor().getClientSideRequestStatisticsRaw((CosmosDiagnostics)first);
                    if (clientSideRequestStatistics == null) {
                        return toBeMerged;
                    }
                    clientSideRequestStatistics.mergeClientSideRequestStatistics(toBeMergedClientSideRequestStatistics);
                    return first;
                }).get();
                BridgeInternal.setCosmosDiagnostics(exception, aggregratedCosmosDiagnostics);
            }
        }
    }

    private static <T> Flux<FeedResponse<T>> getFeedResponseFluxWithTimeout(Flux<FeedResponse<T>> feedResponseFlux, CosmosEndToEndOperationLatencyPolicyConfig endToEndPolicyConfig, CosmosQueryRequestOptions requestOptions, AtomicBoolean isQueryCancelledOnTimeout, DiagnosticsClientContext diagnosticsClientContext) {
        Duration endToEndTimeout = endToEndPolicyConfig.getEndToEndOperationTimeout();
        if (endToEndTimeout.isNegative()) {
            return feedResponseFlux.timeout(endToEndTimeout).onErrorMap(throwable -> {
                if (throwable instanceof TimeoutException) {
                    CosmosException cancellationException = RxDocumentClientImpl.getNegativeTimeoutException(null, endToEndTimeout);
                    cancellationException.setStackTrace(throwable.getStackTrace());
                    isQueryCancelledOnTimeout.set(true);
                    RxDocumentClientImpl.applyExceptionToMergedDiagnosticsForQuery(requestOptions, cancellationException, diagnosticsClientContext);
                    return cancellationException;
                }
                return throwable;
            });
        }
        return feedResponseFlux.timeout(endToEndTimeout).onErrorMap(throwable -> {
            if (throwable instanceof TimeoutException) {
                OperationCancelledException exception = new OperationCancelledException();
                exception.setStackTrace(throwable.getStackTrace());
                isQueryCancelledOnTimeout.set(true);
                RxDocumentClientImpl.applyExceptionToMergedDiagnosticsForQuery(requestOptions, exception, diagnosticsClientContext);
                return exception;
            }
            return throwable;
        });
    }

    @Override
    public Flux<FeedResponse<Database>> queryDatabases(String query, QueryFeedOperationState state) {
        return this.queryDatabases(new SqlQuerySpec(query), state);
    }

    @Override
    public Flux<FeedResponse<Database>> queryDatabases(SqlQuerySpec querySpec, QueryFeedOperationState state) {
        return this.createQuery("/dbs", querySpec, state, Database.class, ResourceType.Database);
    }

    @Override
    public Mono<ResourceResponse<DocumentCollection>> createCollection(String databaseLink, DocumentCollection collection, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy(null);
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.createCollectionInternal(databaseLink, collection, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<DocumentCollection>> createCollectionInternal(String databaseLink, DocumentCollection collection, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            SerializationDiagnosticsContext serializationDiagnosticsContext;
            if (StringUtils.isEmpty(databaseLink)) {
                throw new IllegalArgumentException("databaseLink");
            }
            if (collection == null) {
                throw new IllegalArgumentException("collection");
            }
            logger.debug("Creating a Collection. databaseLink: [{}], Collection id: [{}]", (Object)databaseLink, (Object)collection.getId());
            RxDocumentClientImpl.validateResource(collection);
            String path = Utils.joinPath(databaseLink, "colls");
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.DocumentCollection, OperationType.Create);
            Instant serializationStartTimeUTC = Instant.now();
            ByteBuffer byteBuffer = collection.serializeJsonToByteBuffer(CosmosItemSerializer.DEFAULT_SERIALIZER, null, false);
            Instant serializationEndTimeUTC = Instant.now();
            SerializationDiagnosticsContext.SerializationDiagnostics serializationDiagnostics = new SerializationDiagnosticsContext.SerializationDiagnostics(serializationStartTimeUTC, serializationEndTimeUTC, SerializationDiagnosticsContext.SerializationType.CONTAINER_SERIALIZATION);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.Create, ResourceType.DocumentCollection, path, byteBuffer, requestHeaders, (Object)options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            if ((serializationDiagnosticsContext = BridgeInternal.getSerializationDiagnosticsContext(request.requestContext.cosmosDiagnostics)) != null) {
                serializationDiagnosticsContext.addSerializationDiagnostics(serializationDiagnostics);
            }
            return this.create(request, retryPolicyInstance, this.getOperationContextAndListenerTuple(options)).map(response -> BridgeInternal.toResourceResponse(response, DocumentCollection.class)).doOnNext(resourceResponse -> this.sessionContainer.setSessionToken(request, ((DocumentCollection)resourceResponse.getResource()).getResourceId(), BridgeInternal.getAltLink(resourceResponse.getResource()), resourceResponse.getResponseHeaders()));
        }
        catch (Exception e) {
            logger.debug("Failure in creating a collection. due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<DocumentCollection>> replaceCollection(DocumentCollection collection, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy(null);
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.replaceCollectionInternal(collection, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<DocumentCollection>> replaceCollectionInternal(DocumentCollection collection, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            SerializationDiagnosticsContext serializationDiagnosticsContext;
            if (collection == null) {
                throw new IllegalArgumentException("collection");
            }
            logger.debug("Replacing a Collection. id: [{}]", (Object)collection.getId());
            RxDocumentClientImpl.validateResource(collection);
            String path = Utils.joinPath(collection.getSelfLink(), null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.DocumentCollection, OperationType.Replace);
            Instant serializationStartTimeUTC = Instant.now();
            ByteBuffer byteBuffer = collection.serializeJsonToByteBuffer(CosmosItemSerializer.DEFAULT_SERIALIZER, null, false);
            Instant serializationEndTimeUTC = Instant.now();
            SerializationDiagnosticsContext.SerializationDiagnostics serializationDiagnostics = new SerializationDiagnosticsContext.SerializationDiagnostics(serializationStartTimeUTC, serializationEndTimeUTC, SerializationDiagnosticsContext.SerializationType.CONTAINER_SERIALIZATION);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.Replace, ResourceType.DocumentCollection, path, byteBuffer, requestHeaders, (Object)options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            if ((serializationDiagnosticsContext = BridgeInternal.getSerializationDiagnosticsContext(request.requestContext.cosmosDiagnostics)) != null) {
                serializationDiagnosticsContext.addSerializationDiagnostics(serializationDiagnostics);
            }
            return this.replace(request, retryPolicyInstance).map(response -> BridgeInternal.toResourceResponse(response, DocumentCollection.class)).doOnNext(resourceResponse -> {
                if (resourceResponse.getResource() != null) {
                    this.sessionContainer.setSessionToken(request, ((DocumentCollection)resourceResponse.getResource()).getResourceId(), BridgeInternal.getAltLink(resourceResponse.getResource()), resourceResponse.getResponseHeaders());
                }
            });
        }
        catch (Exception e) {
            logger.debug("Failure in replacing a collection. due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<DocumentCollection>> deleteCollection(String collectionLink, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy(null);
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.deleteCollectionInternal(collectionLink, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<DocumentCollection>> deleteCollectionInternal(String collectionLink, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty(collectionLink)) {
                throw new IllegalArgumentException("collectionLink");
            }
            logger.debug("Deleting a Collection. collectionLink: [{}]", (Object)collectionLink);
            String path = Utils.joinPath(collectionLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.DocumentCollection, OperationType.Delete);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.Delete, ResourceType.DocumentCollection, path, requestHeaders, options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.delete(request, retryPolicyInstance, this.getOperationContextAndListenerTuple(options)).map(response -> BridgeInternal.toResourceResponse(response, DocumentCollection.class));
        }
        catch (Exception e) {
            logger.debug("Failure in deleting a collection, due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    private Mono<RxDocumentServiceResponse> delete(RxDocumentServiceRequest request, DocumentClientRetryPolicy documentClientRetryPolicy, OperationContextAndListenerTuple operationContextAndListenerTuple) {
        return this.populateHeadersAsync(request, RequestVerb.DELETE).flatMap(requestPopulated -> {
            if (documentClientRetryPolicy.getRetryContext() != null && documentClientRetryPolicy.getRetryContext().getRetryCount() > 0) {
                documentClientRetryPolicy.getRetryContext().updateEndTime();
            }
            return this.getStoreProxy((RxDocumentServiceRequest)requestPopulated).processMessage((RxDocumentServiceRequest)requestPopulated, operationContextAndListenerTuple);
        });
    }

    private Mono<RxDocumentServiceResponse> deleteAllItemsByPartitionKey(RxDocumentServiceRequest request, DocumentClientRetryPolicy documentClientRetryPolicy, OperationContextAndListenerTuple operationContextAndListenerTuple) {
        return this.populateHeadersAsync(request, RequestVerb.POST).flatMap(requestPopulated -> {
            RxStoreModel storeProxy = this.getStoreProxy((RxDocumentServiceRequest)requestPopulated);
            if (documentClientRetryPolicy.getRetryContext() != null && documentClientRetryPolicy.getRetryContext().getRetryCount() > 0) {
                documentClientRetryPolicy.getRetryContext().updateEndTime();
            }
            return storeProxy.processMessage((RxDocumentServiceRequest)requestPopulated, operationContextAndListenerTuple);
        });
    }

    private Mono<RxDocumentServiceResponse> read(RxDocumentServiceRequest request, DocumentClientRetryPolicy documentClientRetryPolicy) {
        return this.populateHeadersAsync(request, RequestVerb.GET).flatMap(requestPopulated -> {
            if (documentClientRetryPolicy.getRetryContext() != null && documentClientRetryPolicy.getRetryContext().getRetryCount() > 0) {
                documentClientRetryPolicy.getRetryContext().updateEndTime();
            }
            return this.getStoreProxy((RxDocumentServiceRequest)requestPopulated).processMessage((RxDocumentServiceRequest)requestPopulated);
        });
    }

    Mono<RxDocumentServiceResponse> readFeed(RxDocumentServiceRequest request) {
        return this.populateHeadersAsync(request, RequestVerb.GET).flatMap(requestPopulated -> this.getStoreProxy((RxDocumentServiceRequest)requestPopulated).processMessage((RxDocumentServiceRequest)requestPopulated));
    }

    private Mono<RxDocumentServiceResponse> query(RxDocumentServiceRequest request) {
        return this.populateHeadersAsync(request, RequestVerb.POST).flatMap(requestPopulated -> this.getStoreProxy((RxDocumentServiceRequest)requestPopulated).processMessage((RxDocumentServiceRequest)requestPopulated).map(response -> {
            this.captureSessionToken((RxDocumentServiceRequest)requestPopulated, (RxDocumentServiceResponse)response);
            return response;
        }));
    }

    @Override
    public Mono<ResourceResponse<DocumentCollection>> readCollection(String collectionLink, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy(null);
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.readCollectionInternal(collectionLink, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<DocumentCollection>> readCollectionInternal(String collectionLink, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty(collectionLink)) {
                throw new IllegalArgumentException("collectionLink");
            }
            logger.debug("Reading a Collection. collectionLink: [{}]", (Object)collectionLink);
            String path = Utils.joinPath(collectionLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.DocumentCollection, OperationType.Read);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.Read, ResourceType.DocumentCollection, path, requestHeaders, options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.read(request, retryPolicyInstance).map(response -> BridgeInternal.toResourceResponse(response, DocumentCollection.class));
        }
        catch (Exception e) {
            logger.debug("Failure in reading a collection, due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Flux<FeedResponse<DocumentCollection>> readCollections(String databaseLink, QueryFeedOperationState state) {
        if (StringUtils.isEmpty(databaseLink)) {
            throw new IllegalArgumentException("databaseLink");
        }
        return this.nonDocumentReadFeed(state, ResourceType.DocumentCollection, DocumentCollection.class, Utils.joinPath(databaseLink, "colls"));
    }

    @Override
    public Flux<FeedResponse<DocumentCollection>> queryCollections(String databaseLink, String query, QueryFeedOperationState state) {
        return this.createQuery(databaseLink, new SqlQuerySpec(query), state, DocumentCollection.class, ResourceType.DocumentCollection);
    }

    @Override
    public Flux<FeedResponse<DocumentCollection>> queryCollections(String databaseLink, SqlQuerySpec querySpec, QueryFeedOperationState state) {
        return this.createQuery(databaseLink, querySpec, state, DocumentCollection.class, ResourceType.DocumentCollection);
    }

    private static String serializeProcedureParams(List<Object> objectArray) {
        Object[] stringArray = new String[objectArray.size()];
        for (int i = 0; i < objectArray.size(); ++i) {
            Object object = objectArray.get(i);
            if (object instanceof JsonSerializable) {
                stringArray[i] = ((JsonSerializable)object).toJson();
                continue;
            }
            try {
                stringArray[i] = mapper.writeValueAsString(object);
                continue;
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Can't serialize the object into the json string", e);
            }
        }
        return String.format("[%s]", StringUtils.join(stringArray, ","));
    }

    private static void validateResource(Resource resource) {
        if (!StringUtils.isEmpty(resource.getId())) {
            if (resource.getId().indexOf(47) != -1 || resource.getId().indexOf(92) != -1 || resource.getId().indexOf(63) != -1 || resource.getId().indexOf(35) != -1) {
                throw new IllegalArgumentException("Id contains illegal chars.");
            }
            if (resource.getId().endsWith(" ")) {
                throw new IllegalArgumentException("Id ends with a space.");
            }
        }
    }

    private Map<String, String> getRequestHeaders(RequestOptions options, ResourceType resourceType, OperationType operationType) {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (this.useMultipleWriteLocations) {
            headers.put("x-ms-cosmos-allow-tentative-writes", Boolean.TRUE.toString());
        }
        if (this.consistencyLevel != null) {
            headers.put("x-ms-consistency-level", this.consistencyLevel.toString());
        }
        if (options == null) {
            if (!this.contentResponseOnWriteEnabled && resourceType.equals((Object)ResourceType.Document) && operationType.isWriteOperation()) {
                headers.put("Prefer", "return=minimal");
            }
            return headers;
        }
        Map<String, String> customOptions = options.getHeaders();
        if (customOptions != null) {
            headers.putAll(customOptions);
        }
        boolean contentResponseOnWriteEnabled = this.contentResponseOnWriteEnabled;
        if (options.isContentResponseOnWriteEnabled() != null) {
            contentResponseOnWriteEnabled = options.isContentResponseOnWriteEnabled();
        }
        if (!contentResponseOnWriteEnabled && resourceType.equals((Object)ResourceType.Document) && operationType.isWriteOperation()) {
            headers.put("Prefer", "return=minimal");
        }
        if (options.getIfMatchETag() != null) {
            headers.put("If-Match", options.getIfMatchETag());
        }
        if (options.getIfNoneMatchETag() != null) {
            headers.put("If-None-Match", options.getIfNoneMatchETag());
        }
        if (options.getConsistencyLevel() != null) {
            headers.put("x-ms-consistency-level", options.getConsistencyLevel().toString());
        }
        if (options.getIndexingDirective() != null) {
            headers.put("x-ms-indexing-directive", options.getIndexingDirective().toString());
        }
        if (options.getPostTriggerInclude() != null && options.getPostTriggerInclude().size() > 0) {
            String postTriggerInclude = StringUtils.join(options.getPostTriggerInclude(), ",");
            headers.put("x-ms-documentdb-post-trigger-include", postTriggerInclude);
        }
        if (options.getPreTriggerInclude() != null && options.getPreTriggerInclude().size() > 0) {
            String preTriggerInclude = StringUtils.join(options.getPreTriggerInclude(), ",");
            headers.put("x-ms-documentdb-pre-trigger-include", preTriggerInclude);
        }
        if (!Strings.isNullOrEmpty(options.getSessionToken())) {
            headers.put("x-ms-session-token", options.getSessionToken());
        }
        if (options.getResourceTokenExpirySeconds() != null) {
            headers.put("x-ms-documentdb-expiry-seconds", String.valueOf(options.getResourceTokenExpirySeconds()));
        }
        if (options.getOfferThroughput() != null && options.getOfferThroughput() >= 0) {
            headers.put("x-ms-offer-throughput", options.getOfferThroughput().toString());
        } else if (options.getOfferType() != null) {
            headers.put("x-ms-offer-type", options.getOfferType());
        }
        if (options.getOfferThroughput() == null && options.getThroughputProperties() != null) {
            Offer offer = ModelBridgeInternal.getOfferFromThroughputProperties(options.getThroughputProperties());
            OfferAutoscaleSettings offerAutoscaleSettings = offer.getOfferAutoScaleSettings();
            OfferAutoscaleAutoUpgradeProperties autoscaleAutoUpgradeProperties = null;
            if (offerAutoscaleSettings != null) {
                autoscaleAutoUpgradeProperties = offer.getOfferAutoScaleSettings().getAutoscaleAutoUpgradeProperties();
            }
            if (offer.hasOfferThroughput() && (offerAutoscaleSettings != null && offerAutoscaleSettings.getMaxThroughput() >= 0 || autoscaleAutoUpgradeProperties != null && autoscaleAutoUpgradeProperties.getAutoscaleThroughputProperties().getIncrementPercent() >= 0)) {
                throw new IllegalArgumentException("Autoscale provisioned throughput can not be configured with fixed offer");
            }
            if (offer.hasOfferThroughput()) {
                headers.put("x-ms-offer-throughput", String.valueOf(offer.getThroughput()));
            } else if (offer.getOfferAutoScaleSettings() != null) {
                headers.put("x-ms-cosmos-offer-autopilot-settings", offer.getOfferAutoScaleSettings().toJson());
            }
        }
        if (options.isQuotaInfoEnabled()) {
            headers.put("x-ms-documentdb-populatequotainfo", String.valueOf(true));
        }
        if (options.isScriptLoggingEnabled()) {
            headers.put("x-ms-documentdb-script-enable-logging", String.valueOf(true));
        }
        if (options.getDedicatedGatewayRequestOptions() != null) {
            if (options.getDedicatedGatewayRequestOptions().getMaxIntegratedCacheStaleness() != null) {
                headers.put("x-ms-dedicatedgateway-max-age", String.valueOf(Utils.getMaxIntegratedCacheStalenessInMillis(options.getDedicatedGatewayRequestOptions())));
            }
            if (options.getDedicatedGatewayRequestOptions().isIntegratedCacheBypassed()) {
                headers.put("x-ms-dedicatedgateway-bypass-cache", String.valueOf(options.getDedicatedGatewayRequestOptions().isIntegratedCacheBypassed()));
            }
        }
        return headers;
    }

    public IRetryPolicyFactory getResetSessionTokenRetryPolicy() {
        return this.resetSessionTokenRetryPolicy;
    }

    private Mono<RxDocumentServiceRequest> addPartitionKeyInformation(RxDocumentServiceRequest request, ByteBuffer contentAsByteBuffer, Document document, RequestOptions options) {
        Mono<Utils.ValueHolder<DocumentCollection>> collectionObs = this.collectionCache.resolveCollectionAsync(BridgeInternal.getMetaDataDiagnosticContext(request.requestContext.cosmosDiagnostics), request);
        return collectionObs.map(collectionValueHolder -> {
            this.addPartitionKeyInformation(request, contentAsByteBuffer, (Object)document, options, (DocumentCollection)collectionValueHolder.v, null);
            return request;
        });
    }

    private Mono<RxDocumentServiceRequest> addPartitionKeyInformation(RxDocumentServiceRequest request, ByteBuffer contentAsByteBuffer, Object document, RequestOptions options, Mono<Utils.ValueHolder<DocumentCollection>> collectionObs, PointOperationContextForCircuitBreaker pointOperationContextForCircuitBreaker) {
        return collectionObs.map(collectionValueHolder -> {
            this.addPartitionKeyInformation(request, contentAsByteBuffer, document, options, (DocumentCollection)collectionValueHolder.v, pointOperationContextForCircuitBreaker);
            return request;
        });
    }

    private void addPartitionKeyInformation(RxDocumentServiceRequest request, ByteBuffer contentAsByteBuffer, Object objectDoc, RequestOptions options, DocumentCollection collection, PointOperationContextForCircuitBreaker pointOperationContextForCircuitBreaker) {
        PartitionKeyDefinition partitionKeyDefinition = collection.getPartitionKey();
        PartitionKeyInternal partitionKeyInternal = null;
        if (options != null && options.getPartitionKey() != null && options.getPartitionKey().equals(PartitionKey.NONE)) {
            partitionKeyInternal = ModelBridgeInternal.getNonePartitionKey(partitionKeyDefinition);
        } else if (options != null && options.getPartitionKey() != null) {
            partitionKeyInternal = BridgeInternal.getPartitionKeyInternal(options.getPartitionKey());
        } else if (partitionKeyDefinition == null || partitionKeyDefinition.getPaths().size() == 0) {
            partitionKeyInternal = PartitionKeyInternal.getEmpty();
        } else if (contentAsByteBuffer != null || objectDoc != null) {
            InternalObjectNode internalObjectNode;
            if (objectDoc instanceof InternalObjectNode) {
                internalObjectNode = (InternalObjectNode)objectDoc;
            } else if (objectDoc instanceof ObjectNode) {
                internalObjectNode = new InternalObjectNode((ObjectNode)objectDoc);
            } else if (contentAsByteBuffer != null) {
                contentAsByteBuffer.rewind();
                internalObjectNode = new InternalObjectNode(contentAsByteBuffer);
            } else {
                throw new IllegalStateException("ContentAsByteBuffer and objectDoc are null");
            }
            Instant serializationStartTime = Instant.now();
            partitionKeyInternal = PartitionKeyHelper.extractPartitionKeyValueFromDocument(internalObjectNode, partitionKeyDefinition);
            Instant serializationEndTime = Instant.now();
            SerializationDiagnosticsContext.SerializationDiagnostics serializationDiagnostics = new SerializationDiagnosticsContext.SerializationDiagnostics(serializationStartTime, serializationEndTime, SerializationDiagnosticsContext.SerializationType.PARTITION_KEY_FETCH_SERIALIZATION);
            SerializationDiagnosticsContext serializationDiagnosticsContext = BridgeInternal.getSerializationDiagnosticsContext(request.requestContext.cosmosDiagnostics);
            if (serializationDiagnosticsContext != null) {
                serializationDiagnosticsContext.addSerializationDiagnostics(serializationDiagnostics);
            } else if (pointOperationContextForCircuitBreaker != null && (serializationDiagnosticsContext = pointOperationContextForCircuitBreaker.getSerializationDiagnosticsContext()) != null) {
                serializationDiagnosticsContext.addSerializationDiagnostics(serializationDiagnostics);
            }
        } else {
            throw new UnsupportedOperationException("PartitionKey value must be supplied for this operation.");
        }
        request.setPartitionKeyInternal(partitionKeyInternal);
        request.setPartitionKeyDefinition(partitionKeyDefinition);
        request.getHeaders().put("x-ms-documentdb-partitionkey", Utils.escapeNonAscii(partitionKeyInternal.toJson()));
    }

    private Mono<Tuple2<RxDocumentServiceRequest, Utils.ValueHolder<DocumentCollection>>> getCreateDocumentRequest(DocumentClientRetryPolicy requestRetryPolicy, String documentCollectionLink, Object document, RequestOptions options, boolean disableAutomaticIdGeneration, OperationType operationType, DiagnosticsClientContext clientContextOverride, PointOperationContextForCircuitBreaker pointOperationContextForCircuitBreaker) {
        SerializationDiagnosticsContext serializationDiagnosticsContext;
        if (StringUtils.isEmpty(documentCollectionLink)) {
            throw new IllegalArgumentException("documentCollectionLink");
        }
        if (document == null) {
            throw new IllegalArgumentException("document");
        }
        Instant serializationStartTimeUTC = Instant.now();
        String trackingId = null;
        if (options != null) {
            trackingId = options.getTrackingId();
        }
        ByteBuffer content = InternalObjectNode.serializeJsonToByteBuffer(document, options.getEffectiveItemSerializer(), trackingId, true);
        Instant serializationEndTimeUTC = Instant.now();
        SerializationDiagnosticsContext.SerializationDiagnostics serializationDiagnostics = new SerializationDiagnosticsContext.SerializationDiagnostics(serializationStartTimeUTC, serializationEndTimeUTC, SerializationDiagnosticsContext.SerializationType.ITEM_SERIALIZATION);
        String path = Utils.joinPath(documentCollectionLink, "docs");
        Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.Document, operationType);
        RxDocumentServiceRequest request = RxDocumentServiceRequest.create(this.getEffectiveClientContext(clientContextOverride), operationType, ResourceType.Document, path, requestHeaders, options, content);
        if (operationType.isWriteOperation() && options != null && options.getNonIdempotentWriteRetriesEnabled() != null && options.getNonIdempotentWriteRetriesEnabled().booleanValue()) {
            request.setNonIdempotentWriteRetriesEnabled(true);
        }
        if (options != null) {
            DocumentServiceRequestContext requestContext = request.requestContext;
            options.getMarkE2ETimeoutInRequestContextCallbackHook().set(() -> requestContext.setIsRequestCancelledOnTimeout(new AtomicBoolean(true)));
            requestContext.setExcludeRegions(options.getExcludedRegions());
            requestContext.setKeywordIdentifiers(options.getKeywordIdentifiers());
        }
        if ((serializationDiagnosticsContext = BridgeInternal.getSerializationDiagnosticsContext(request.requestContext.cosmosDiagnostics)) != null) {
            serializationDiagnosticsContext.addSerializationDiagnostics(serializationDiagnostics);
        }
        if (requestRetryPolicy != null) {
            requestRetryPolicy.onBeforeSendRequest(request);
        }
        Mono<Utils.ValueHolder<DocumentCollection>> collectionObs = this.collectionCache.resolveCollectionAsync(BridgeInternal.getMetaDataDiagnosticContext(request.requestContext.cosmosDiagnostics), request);
        return this.addPartitionKeyInformation(request, content, document, options, collectionObs, pointOperationContextForCircuitBreaker).zipWith(collectionObs);
    }

    private Mono<RxDocumentServiceRequest> getBatchDocumentRequest(DocumentClientRetryPolicy requestRetryPolicy, String documentCollectionLink, ServerBatchRequest serverBatchRequest, RequestOptions options, boolean disableAutomaticIdGeneration) {
        SerializationDiagnosticsContext serializationDiagnosticsContext;
        Preconditions.checkArgument(StringUtils.isNotEmpty(documentCollectionLink), "expected non empty documentCollectionLink");
        Preconditions.checkNotNull(serverBatchRequest, "expected non null serverBatchRequest");
        Instant serializationStartTimeUTC = Instant.now();
        ByteBuffer content = ByteBuffer.wrap(Utils.getUTF8Bytes(serverBatchRequest.getRequestBody()));
        Instant serializationEndTimeUTC = Instant.now();
        SerializationDiagnosticsContext.SerializationDiagnostics serializationDiagnostics = new SerializationDiagnosticsContext.SerializationDiagnostics(serializationStartTimeUTC, serializationEndTimeUTC, SerializationDiagnosticsContext.SerializationType.ITEM_SERIALIZATION);
        String path = Utils.joinPath(documentCollectionLink, "docs");
        Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.Document, OperationType.Batch);
        RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.Batch, ResourceType.Document, path, requestHeaders, options, content);
        if (options != null) {
            DocumentServiceRequestContext requestContext = request.requestContext;
            options.getMarkE2ETimeoutInRequestContextCallbackHook().set(() -> requestContext.setIsRequestCancelledOnTimeout(new AtomicBoolean(true)));
            requestContext.setExcludeRegions(options.getExcludedRegions());
            requestContext.setKeywordIdentifiers(options.getKeywordIdentifiers());
        }
        if ((serializationDiagnosticsContext = BridgeInternal.getSerializationDiagnosticsContext(request.requestContext.cosmosDiagnostics)) != null) {
            serializationDiagnosticsContext.addSerializationDiagnostics(serializationDiagnostics);
        }
        if (options != null) {
            request.requestContext.setExcludeRegions(options.getExcludedRegions());
            request.requestContext.setKeywordIdentifiers(options.getKeywordIdentifiers());
        }
        if (requestRetryPolicy != null) {
            requestRetryPolicy.onBeforeSendRequest(request);
        }
        MetadataDiagnosticsContext metadataDiagnosticsContext = BridgeInternal.getMetaDataDiagnosticContext(request.requestContext.cosmosDiagnostics);
        request.requestContext.setPointOperationContext(new PointOperationContextForCircuitBreaker(new AtomicBoolean(false), false, documentCollectionLink, serializationDiagnosticsContext));
        return this.collectionCache.resolveCollectionAsync(metadataDiagnosticsContext, request).flatMap(documentCollectionValueHolder -> {
            if (documentCollectionValueHolder == null || documentCollectionValueHolder.v == null) {
                return Mono.error((Throwable)new IllegalStateException("documentCollectionValueHolder or documentCollectionValueHolder.v cannot be null"));
            }
            return this.partitionKeyRangeCache.tryLookupAsync(metadataDiagnosticsContext, ((DocumentCollection)documentCollectionValueHolder.v).getResourceId(), null, null).flatMap(collectionRoutingMapValueHolder -> {
                if (collectionRoutingMapValueHolder == null || collectionRoutingMapValueHolder.v == null) {
                    return Mono.error((Throwable)new IllegalStateException("collectionRoutingMapValueHolder or collectionRoutingMapValueHolder.v cannot be null"));
                }
                this.addBatchHeaders(request, serverBatchRequest, (DocumentCollection)documentCollectionValueHolder.v);
                if (this.globalPartitionEndpointManagerForCircuitBreaker.isPartitionLevelCircuitBreakingApplicable(request) && options != null) {
                    options.setPartitionKeyDefinition(((DocumentCollection)documentCollectionValueHolder.v).getPartitionKey());
                    this.addPartitionLevelUnavailableRegionsForRequest(request, options, (CollectionRoutingMap)collectionRoutingMapValueHolder.v, requestRetryPolicy);
                }
                return Mono.just((Object)request);
            });
        });
    }

    private RxDocumentServiceRequest addBatchHeaders(RxDocumentServiceRequest request, ServerBatchRequest serverBatchRequest, DocumentCollection collection) {
        if (serverBatchRequest instanceof SinglePartitionKeyServerBatchRequest) {
            PartitionKeyInternal partitionKeyInternal;
            PartitionKey partitionKey = ((SinglePartitionKeyServerBatchRequest)serverBatchRequest).getPartitionKeyValue();
            if (partitionKey.equals(PartitionKey.NONE)) {
                PartitionKeyDefinition partitionKeyDefinition = collection.getPartitionKey();
                partitionKeyInternal = ModelBridgeInternal.getNonePartitionKey(partitionKeyDefinition);
            } else {
                partitionKeyInternal = BridgeInternal.getPartitionKeyInternal(partitionKey);
            }
            request.setPartitionKeyInternal(partitionKeyInternal);
            request.getHeaders().put("x-ms-documentdb-partitionkey", Utils.escapeNonAscii(partitionKeyInternal.toJson()));
        } else if (serverBatchRequest instanceof PartitionKeyRangeServerBatchRequest) {
            request.setPartitionKeyRangeIdentity(new PartitionKeyRangeIdentity(((PartitionKeyRangeServerBatchRequest)serverBatchRequest).getPartitionKeyRangeId()));
        } else {
            throw new UnsupportedOperationException("Unknown Server request.");
        }
        request.getHeaders().put("x-ms-cosmos-is-batch-request", Boolean.TRUE.toString());
        request.getHeaders().put("x-ms-cosmos-batch-atomic", String.valueOf(serverBatchRequest.isAtomicBatch()));
        request.getHeaders().put("x-ms-cosmos-batch-continue-on-error", String.valueOf(serverBatchRequest.isShouldContinueOnError()));
        request.setPartitionKeyDefinition(collection.getPartitionKey());
        request.setNumberOfItemsInBatchRequest(serverBatchRequest.getOperations().size());
        return request;
    }

    public Mono<RxDocumentServiceRequest> populateHeadersAsync(RxDocumentServiceRequest request, RequestVerb httpMethod) {
        request.getHeaders().put("x-ms-date", Utils.nowAsRFC1123());
        if (this.masterKeyOrResourceToken != null || this.resourceTokensMap != null || this.cosmosAuthorizationTokenResolver != null || this.credential != null) {
            String resourceName = request.getResourceAddress();
            String authorization = this.getUserAuthorizationToken(resourceName, request.getResourceType(), httpMethod, request.getHeaders(), AuthorizationTokenType.PrimaryMasterKey, request.properties);
            try {
                authorization = URLEncoder.encode(authorization, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException("Failed to encode authtoken.", e);
            }
            request.getHeaders().put("authorization", authorization);
        }
        if (this.apiType != null) {
            request.getHeaders().put("x-ms-cosmos-apitype", this.apiType.toString());
        }
        this.populateCapabilitiesHeader(request);
        if ((RequestVerb.POST.equals((Object)httpMethod) || RequestVerb.PUT.equals((Object)httpMethod)) && !request.getHeaders().containsKey("Content-Type")) {
            request.getHeaders().put("Content-Type", "application/json");
        }
        if (RequestVerb.PATCH.equals((Object)httpMethod) && !request.getHeaders().containsKey("Content-Type")) {
            request.getHeaders().put("Content-Type", "application/json-patch+json");
        }
        if (!request.getHeaders().containsKey("Accept")) {
            request.getHeaders().put("Accept", "application/json");
        }
        MetadataDiagnosticsContext metadataDiagnosticsCtx = BridgeInternal.getMetaDataDiagnosticContext(request.requestContext.cosmosDiagnostics);
        if (this.requiresFeedRangeFiltering(request)) {
            return request.getFeedRange().populateFeedRangeFilteringHeaders(this.getPartitionKeyRangeCache(), request, (Mono<Utils.ValueHolder<DocumentCollection>>)this.collectionCache.resolveCollectionAsync(metadataDiagnosticsCtx, request).flatMap(documentCollectionValueHolder -> {
                if (documentCollectionValueHolder.v != null) {
                    request.setPartitionKeyDefinition(((DocumentCollection)documentCollectionValueHolder.v).getPartitionKey());
                }
                return Mono.just((Object)documentCollectionValueHolder);
            })).flatMap(this::populateAuthorizationHeader);
        }
        return this.populateAuthorizationHeader(request);
    }

    private void populateCapabilitiesHeader(RxDocumentServiceRequest request) {
        if (!request.getHeaders().containsKey("x-ms-cosmos-sdk-supportedcapabilities")) {
            request.getHeaders().put("x-ms-cosmos-sdk-supportedcapabilities", HttpConstants.SDKSupportedCapabilities.SUPPORTED_CAPABILITIES);
        }
    }

    private boolean requiresFeedRangeFiltering(RxDocumentServiceRequest request) {
        if (request.getResourceType() != ResourceType.Document && request.getResourceType() != ResourceType.Conflict) {
            return false;
        }
        if (request.hasFeedRangeFilteringBeenApplied()) {
            return false;
        }
        switch (request.getOperationType()) {
            case ReadFeed: 
            case Query: 
            case SqlQuery: {
                return request.getFeedRange() != null;
            }
        }
        return false;
    }

    @Override
    public Mono<RxDocumentServiceRequest> populateAuthorizationHeader(RxDocumentServiceRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("request");
        }
        if (this.authorizationTokenType == AuthorizationTokenType.AadToken) {
            return AadTokenAuthorizationHelper.getAuthorizationToken(this.tokenCredentialCache).map(authorization -> {
                request.getHeaders().put("authorization", (String)authorization);
                return request;
            });
        }
        return Mono.just((Object)request);
    }

    @Override
    public Mono<HttpHeaders> populateAuthorizationHeader(HttpHeaders httpHeaders) {
        if (httpHeaders == null) {
            throw new IllegalArgumentException("httpHeaders");
        }
        if (this.authorizationTokenType == AuthorizationTokenType.AadToken) {
            return AadTokenAuthorizationHelper.getAuthorizationToken(this.tokenCredentialCache).map(authorization -> {
                httpHeaders.set("authorization", (String)authorization);
                return httpHeaders;
            });
        }
        return Mono.just((Object)httpHeaders);
    }

    @Override
    public AuthorizationTokenType getAuthorizationTokenType() {
        return this.authorizationTokenType;
    }

    @Override
    public String getUserAuthorizationToken(String resourceName, ResourceType resourceType, RequestVerb requestVerb, Map<String, String> headers, AuthorizationTokenType tokenType, Map<String, Object> properties) {
        if (this.cosmosAuthorizationTokenResolver != null) {
            return this.cosmosAuthorizationTokenResolver.getAuthorizationToken(requestVerb.toUpperCase(), resourceName, this.resolveCosmosResourceType(resourceType).toString(), properties != null ? Collections.unmodifiableMap(properties) : null);
        }
        if (this.credential != null) {
            return this.authorizationTokenProvider.generateKeyAuthorizationSignature(requestVerb, resourceName, resourceType, headers);
        }
        if (this.masterKeyOrResourceToken != null && this.hasAuthKeyResourceToken && this.resourceTokensMap == null) {
            return this.masterKeyOrResourceToken;
        }
        assert (this.resourceTokensMap != null);
        if (resourceType.equals((Object)ResourceType.DatabaseAccount)) {
            return this.firstResourceTokenFromPermissionFeed;
        }
        return ResourceTokenAuthorizationHelper.getAuthorizationTokenUsingResourceTokens(this.resourceTokensMap, requestVerb, resourceName, headers);
    }

    private CosmosResourceType resolveCosmosResourceType(ResourceType resourceType) {
        CosmosResourceType cosmosResourceType = ModelBridgeInternal.fromServiceSerializedFormat(resourceType.toString());
        if (cosmosResourceType == null) {
            return CosmosResourceType.SYSTEM;
        }
        return cosmosResourceType;
    }

    void captureSessionToken(RxDocumentServiceRequest request, RxDocumentServiceResponse response) {
        this.sessionContainer.setSessionToken(request, response.getResponseHeaders());
    }

    private Mono<RxDocumentServiceResponse> create(RxDocumentServiceRequest request, DocumentClientRetryPolicy documentClientRetryPolicy, OperationContextAndListenerTuple operationContextAndListenerTuple) {
        return this.populateHeadersAsync(request, RequestVerb.POST).flatMap(requestPopulated -> {
            RxStoreModel storeProxy = this.getStoreProxy((RxDocumentServiceRequest)requestPopulated);
            if (documentClientRetryPolicy.getRetryContext() != null && documentClientRetryPolicy.getRetryContext().getRetryCount() > 0) {
                documentClientRetryPolicy.getRetryContext().updateEndTime();
            }
            return storeProxy.processMessage((RxDocumentServiceRequest)requestPopulated, operationContextAndListenerTuple);
        });
    }

    private Mono<RxDocumentServiceResponse> upsert(RxDocumentServiceRequest request, DocumentClientRetryPolicy documentClientRetryPolicy, OperationContextAndListenerTuple operationContextAndListenerTuple) {
        return this.populateHeadersAsync(request, RequestVerb.POST).flatMap(requestPopulated -> {
            Map<String, String> headers = requestPopulated.getHeaders();
            assert (headers != null);
            headers.put("x-ms-documentdb-is-upsert", "true");
            if (documentClientRetryPolicy.getRetryContext() != null && documentClientRetryPolicy.getRetryContext().getRetryCount() > 0) {
                documentClientRetryPolicy.getRetryContext().updateEndTime();
            }
            return this.getStoreProxy((RxDocumentServiceRequest)requestPopulated).processMessage((RxDocumentServiceRequest)requestPopulated, operationContextAndListenerTuple).map(response -> {
                this.captureSessionToken((RxDocumentServiceRequest)requestPopulated, (RxDocumentServiceResponse)response);
                return response;
            });
        });
    }

    private Mono<RxDocumentServiceResponse> replace(RxDocumentServiceRequest request, DocumentClientRetryPolicy documentClientRetryPolicy) {
        return this.populateHeadersAsync(request, RequestVerb.PUT).flatMap(requestPopulated -> {
            if (documentClientRetryPolicy.getRetryContext() != null && documentClientRetryPolicy.getRetryContext().getRetryCount() > 0) {
                documentClientRetryPolicy.getRetryContext().updateEndTime();
            }
            return this.getStoreProxy((RxDocumentServiceRequest)requestPopulated).processMessage((RxDocumentServiceRequest)requestPopulated);
        });
    }

    private Mono<RxDocumentServiceResponse> patch(RxDocumentServiceRequest request, DocumentClientRetryPolicy documentClientRetryPolicy) {
        return this.populateHeadersAsync(request, RequestVerb.PATCH).flatMap(requestPopulated -> {
            if (documentClientRetryPolicy.getRetryContext() != null && documentClientRetryPolicy.getRetryContext().getRetryCount() > 0) {
                documentClientRetryPolicy.getRetryContext().updateEndTime();
            }
            return this.getStoreProxy((RxDocumentServiceRequest)requestPopulated).processMessage((RxDocumentServiceRequest)requestPopulated);
        });
    }

    @Override
    public Mono<ResourceResponse<Document>> createDocument(String collectionLink, Object document, RequestOptions options, boolean disableAutomaticIdGeneration) {
        return this.wrapPointOperationWithAvailabilityStrategy(ResourceType.Document, OperationType.Create, (opt, e2ecfg, clientCtxOverride, pointOperationContextForCircuitBreaker) -> this.createDocumentCore(collectionLink, document, opt, disableAutomaticIdGeneration, e2ecfg, clientCtxOverride, pointOperationContextForCircuitBreaker), options, options != null && options.getNonIdempotentWriteRetriesEnabled() != null && options.getNonIdempotentWriteRetriesEnabled() != false, collectionLink);
    }

    private Mono<ResourceResponse<Document>> createDocumentCore(String collectionLink, Object document, RequestOptions options, boolean disableAutomaticIdGeneration, CosmosEndToEndOperationLatencyPolicyConfig endToEndPolicyConfig, DiagnosticsClientContext clientContextOverride, PointOperationContextForCircuitBreaker pointOperationContextForCircuitBreaker) {
        RequestOptions nonNullRequestOptions;
        ScopedDiagnosticsFactory scopedDiagnosticsFactory = new ScopedDiagnosticsFactory(clientContextOverride, false);
        DocumentClientRetryPolicy requestRetryPolicy = this.resetSessionTokenRetryPolicy.getRequestPolicy(scopedDiagnosticsFactory);
        RequestOptions requestOptions = nonNullRequestOptions = options != null ? options : new RequestOptions();
        if (nonNullRequestOptions.getPartitionKey() == null) {
            requestRetryPolicy = new PartitionKeyMismatchRetryPolicy(this.collectionCache, requestRetryPolicy, collectionLink, nonNullRequestOptions);
        }
        DocumentClientRetryPolicy finalRetryPolicyInstance = requestRetryPolicy;
        AtomicReference<RxDocumentServiceRequest> requestReference = new AtomicReference<RxDocumentServiceRequest>();
        return this.handleCircuitBreakingFeedbackForPointOperation(RxDocumentClientImpl.getPointOperationResponseMonoWithE2ETimeout(nonNullRequestOptions, endToEndPolicyConfig, ObservableHelper.inlineIfPossibleAsObs(() -> this.createDocumentInternal(collectionLink, document, nonNullRequestOptions, disableAutomaticIdGeneration, finalRetryPolicyInstance, scopedDiagnosticsFactory, requestReference, pointOperationContextForCircuitBreaker), requestRetryPolicy), scopedDiagnosticsFactory), requestReference);
    }

    private Mono<ResourceResponse<Document>> createDocumentInternal(String collectionLink, Object document, RequestOptions options, boolean disableAutomaticIdGeneration, DocumentClientRetryPolicy requestRetryPolicy, DiagnosticsClientContext clientContextOverride, AtomicReference<RxDocumentServiceRequest> documentServiceRequestReference, PointOperationContextForCircuitBreaker pointOperationContextForCircuitBreaker) {
        try {
            logger.debug("Creating a Document. collectionLink: [{}]", (Object)collectionLink);
            Mono<Tuple2<RxDocumentServiceRequest, Utils.ValueHolder<DocumentCollection>>> requestToDocumentCollectionObs = this.getCreateDocumentRequest(requestRetryPolicy, collectionLink, document, options, disableAutomaticIdGeneration, OperationType.Create, clientContextOverride, pointOperationContextForCircuitBreaker);
            return requestToDocumentCollectionObs.flatMap(requestToDocumentCollection -> {
                RxDocumentServiceRequest request = (RxDocumentServiceRequest)requestToDocumentCollection.getT1();
                Utils.ValueHolder documentCollectionValueHolder = (Utils.ValueHolder)requestToDocumentCollection.getT2();
                if (documentCollectionValueHolder == null || documentCollectionValueHolder.v == null) {
                    return Mono.error((Throwable)new IllegalStateException("documentCollectionValueHolder or documentCollectionValueHolder.v cannot be null"));
                }
                return this.partitionKeyRangeCache.tryLookupAsync(BridgeInternal.getMetaDataDiagnosticContext(request.requestContext.cosmosDiagnostics), ((DocumentCollection)documentCollectionValueHolder.v).getResourceId(), null, null).flatMap(collectionRoutingMapValueHolder -> {
                    if (collectionRoutingMapValueHolder == null || collectionRoutingMapValueHolder.v == null) {
                        return Mono.error((Throwable)new IllegalStateException("collectionRoutingMapValueHolder or collectionRoutingMapValueHolder.v cannot be null"));
                    }
                    options.setPartitionKeyDefinition(((DocumentCollection)documentCollectionValueHolder.v).getPartitionKey());
                    this.addPartitionLevelUnavailableRegionsForRequest(request, options, (CollectionRoutingMap)collectionRoutingMapValueHolder.v, requestRetryPolicy);
                    documentServiceRequestReference.set(request);
                    request.requestContext.setPointOperationContext(pointOperationContextForCircuitBreaker);
                    this.mergeContextInformationIntoDiagnosticsForPointRequest(request, pointOperationContextForCircuitBreaker);
                    return this.create(request, requestRetryPolicy, this.getOperationContextAndListenerTuple(options));
                }).map(serviceResponse -> BridgeInternal.toResourceResponse(serviceResponse, Document.class));
            });
        }
        catch (Exception e) {
            logger.debug("Failure in creating a document due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    private static <T> Mono<T> getPointOperationResponseMonoWithE2ETimeout(RequestOptions requestOptions, CosmosEndToEndOperationLatencyPolicyConfig endToEndPolicyConfig, Mono<T> rxDocumentServiceResponseMono, ScopedDiagnosticsFactory scopedDiagnosticsFactory) {
        requestOptions.setCosmosEndToEndLatencyPolicyConfig(endToEndPolicyConfig);
        if (endToEndPolicyConfig != null && endToEndPolicyConfig.isEnabled()) {
            Duration endToEndTimeout = endToEndPolicyConfig.getEndToEndOperationTimeout();
            if (endToEndTimeout.isNegative()) {
                CosmosDiagnostics latestCosmosDiagnosticsSnapshot = scopedDiagnosticsFactory.getMostRecentlyCreatedDiagnostics();
                if (latestCosmosDiagnosticsSnapshot == null) {
                    scopedDiagnosticsFactory.createDiagnostics();
                }
                return Mono.error((Throwable)((Object)RxDocumentClientImpl.getNegativeTimeoutException(scopedDiagnosticsFactory.getMostRecentlyCreatedDiagnostics(), endToEndTimeout)));
            }
            return rxDocumentServiceResponseMono.timeout(endToEndTimeout).onErrorMap(throwable -> RxDocumentClientImpl.getCancellationExceptionForPointOperations(scopedDiagnosticsFactory, throwable, requestOptions.getMarkE2ETimeoutInRequestContextCallbackHook()));
        }
        return rxDocumentServiceResponseMono;
    }

    private <T> Mono<T> handleCircuitBreakingFeedbackForPointOperation(Mono<T> response, AtomicReference<RxDocumentServiceRequest> requestReference) {
        return response.doOnSuccess(ignore -> {
            if (this.globalPartitionEndpointManagerForCircuitBreaker.isPartitionLevelCircuitBreakingApplicable((RxDocumentServiceRequest)requestReference.get())) {
                RxDocumentServiceRequest succeededRequest = (RxDocumentServiceRequest)requestReference.get();
                Preconditions.checkNotNull(succeededRequest.requestContext, "Argument 'succeededRequest.requestContext' must not be null!");
                PointOperationContextForCircuitBreaker pointOperationContextForCircuitBreaker = succeededRequest.requestContext.getPointOperationContextForCircuitBreaker();
                Preconditions.checkNotNull(pointOperationContextForCircuitBreaker, "Argument 'pointOperationContextForCircuitBreaker' must not be null!");
                pointOperationContextForCircuitBreaker.setHasOperationSeenSuccess();
                this.globalPartitionEndpointManagerForCircuitBreaker.handleLocationSuccessForPartitionKeyRange(succeededRequest);
            }
        }).doOnError(throwable -> {
            if (throwable instanceof OperationCancelledException && this.globalPartitionEndpointManagerForCircuitBreaker.isPartitionLevelCircuitBreakingApplicable((RxDocumentServiceRequest)requestReference.get())) {
                RxDocumentServiceRequest failedRequest = (RxDocumentServiceRequest)requestReference.get();
                Preconditions.checkNotNull(failedRequest.requestContext, "Argument 'failedRequest.requestContext' must not be null!");
                PointOperationContextForCircuitBreaker pointOperationContextForCircuitBreaker = failedRequest.requestContext.getPointOperationContextForCircuitBreaker();
                Preconditions.checkNotNull(pointOperationContextForCircuitBreaker, "Argument 'pointOperationContextForCircuitBreaker' must not be null!");
                if (pointOperationContextForCircuitBreaker.isThresholdBasedAvailabilityStrategyEnabled()) {
                    if (!pointOperationContextForCircuitBreaker.isRequestHedged() && pointOperationContextForCircuitBreaker.getHasOperationSeenSuccess()) {
                        this.handleLocationCancellationExceptionForPartitionKeyRange(failedRequest);
                    }
                } else {
                    this.handleLocationCancellationExceptionForPartitionKeyRange(failedRequest);
                }
            }
        }).doFinally(signalType -> {
            if (signalType != SignalType.CANCEL) {
                return;
            }
            if (this.globalPartitionEndpointManagerForCircuitBreaker.isPartitionLevelCircuitBreakingApplicable((RxDocumentServiceRequest)requestReference.get())) {
                RxDocumentServiceRequest failedRequest = (RxDocumentServiceRequest)requestReference.get();
                Preconditions.checkNotNull(failedRequest.requestContext, "Argument 'failedRequest.requestContext' must not be null!");
                PointOperationContextForCircuitBreaker pointOperationContextForCircuitBreaker = failedRequest.requestContext.getPointOperationContextForCircuitBreaker();
                Preconditions.checkNotNull(pointOperationContextForCircuitBreaker, "Argument 'pointOperationContextForCircuitBreaker' must not be null!");
                if (pointOperationContextForCircuitBreaker.isThresholdBasedAvailabilityStrategyEnabled() && !pointOperationContextForCircuitBreaker.isRequestHedged() && pointOperationContextForCircuitBreaker.getHasOperationSeenSuccess()) {
                    this.handleLocationCancellationExceptionForPartitionKeyRange(failedRequest);
                }
            }
        });
    }

    private <T> Mono<NonTransientFeedOperationResult<T>> handleCircuitBreakingFeedbackForFeedOperationWithAvailabilityStrategy(Mono<NonTransientFeedOperationResult<T>> response, RxDocumentServiceRequest request) {
        return response.doOnSuccess(nonTransientFeedOperationResult -> {
            if (this.globalPartitionEndpointManagerForCircuitBreaker.isPartitionLevelCircuitBreakingApplicable(request) && !nonTransientFeedOperationResult.isError()) {
                Preconditions.checkNotNull(request, "Argument 'request' cannot be null!");
                Preconditions.checkNotNull(request.requestContext, "Argument 'request.requestContext' cannot be null!");
                FeedOperationContextForCircuitBreaker feedOperationContextForCircuitBreaker = request.requestContext.getFeedOperationContextForCircuitBreaker();
                Preconditions.checkNotNull(feedOperationContextForCircuitBreaker, "Argument 'feedOperationContextForCircuitBreaker' cannot be null!");
                feedOperationContextForCircuitBreaker.addPartitionKeyRangeWithSuccess(request.requestContext.resolvedPartitionKeyRangeForCircuitBreaker, request.getResourceId());
                this.globalPartitionEndpointManagerForCircuitBreaker.handleLocationSuccessForPartitionKeyRange(request);
            }
        }).doFinally(signalType -> {
            if (signalType != SignalType.CANCEL) {
                return;
            }
            if (this.globalPartitionEndpointManagerForCircuitBreaker.isPartitionLevelCircuitBreakingApplicable(request)) {
                Preconditions.checkNotNull(request, "Argument 'request' cannot be null!");
                Preconditions.checkNotNull(request.requestContext, "Argument 'request.requestContext' cannot be null!");
                FeedOperationContextForCircuitBreaker feedOperationContextForCircuitBreaker = request.requestContext.getFeedOperationContextForCircuitBreaker();
                Preconditions.checkNotNull(feedOperationContextForCircuitBreaker, "Argument 'feedOperationContextForCircuitBreaker' cannot be null!");
                if (!feedOperationContextForCircuitBreaker.getIsRequestHedged() && feedOperationContextForCircuitBreaker.isThresholdBasedAvailabilityStrategyEnabled() && feedOperationContextForCircuitBreaker.hasPartitionKeyRangeSeenSuccess(request.requestContext.resolvedPartitionKeyRange, request.getResourceId())) {
                    this.handleLocationCancellationExceptionForPartitionKeyRange(request);
                }
            }
        });
    }

    private static Throwable getCancellationExceptionForPointOperations(ScopedDiagnosticsFactory scopedDiagnosticsFactory, Throwable throwable, AtomicReference<Runnable> markE2ETimeoutInRequestContextCallbackHook) {
        Throwable unwrappedException = Exceptions.unwrap((Throwable)throwable);
        if (unwrappedException instanceof TimeoutException) {
            CosmosDiagnostics lastDiagnosticsSnapshot;
            OperationCancelledException exception = new OperationCancelledException();
            exception.setStackTrace(throwable.getStackTrace());
            Runnable actualCallback = markE2ETimeoutInRequestContextCallbackHook.get();
            if (actualCallback != null) {
                logger.trace("Calling actual Mark E2E timeout callback");
                actualCallback.run();
            }
            if ((lastDiagnosticsSnapshot = scopedDiagnosticsFactory.getMostRecentlyCreatedDiagnostics()) == null) {
                scopedDiagnosticsFactory.createDiagnostics();
            }
            BridgeInternal.setCosmosDiagnostics(exception, scopedDiagnosticsFactory.getMostRecentlyCreatedDiagnostics());
            return exception;
        }
        return throwable;
    }

    private static CosmosException getNegativeTimeoutException(CosmosDiagnostics cosmosDiagnostics, Duration negativeTimeout) {
        Preconditions.checkNotNull(negativeTimeout, "Argument 'negativeTimeout' must not be null");
        Preconditions.checkArgument(negativeTimeout.isNegative(), "This exception should only be used for negative timeouts");
        String message = String.format("Negative timeout '%s' provided.", negativeTimeout);
        OperationCancelledException exception = new OperationCancelledException(message, null);
        BridgeInternal.setSubStatusCode(exception, 20901);
        if (cosmosDiagnostics != null) {
            BridgeInternal.setCosmosDiagnostics(exception, cosmosDiagnostics);
        }
        return exception;
    }

    @Override
    public Mono<ResourceResponse<Document>> upsertDocument(String collectionLink, Object document, RequestOptions options, boolean disableAutomaticIdGeneration) {
        return this.wrapPointOperationWithAvailabilityStrategy(ResourceType.Document, OperationType.Upsert, (opt, e2ecfg, clientCtxOverride, pointOperationContextForCircuitBreaker) -> this.upsertDocumentCore(collectionLink, document, opt, disableAutomaticIdGeneration, e2ecfg, clientCtxOverride, pointOperationContextForCircuitBreaker), options, options != null && options.getNonIdempotentWriteRetriesEnabled() != null && options.getNonIdempotentWriteRetriesEnabled() != false, collectionLink);
    }

    private Mono<ResourceResponse<Document>> upsertDocumentCore(String collectionLink, Object document, RequestOptions options, boolean disableAutomaticIdGeneration, CosmosEndToEndOperationLatencyPolicyConfig endToEndPolicyConfig, DiagnosticsClientContext clientContextOverride, PointOperationContextForCircuitBreaker pointOperationContextForCircuitBreaker) {
        RequestOptions nonNullRequestOptions = options != null ? options : new RequestOptions();
        ScopedDiagnosticsFactory scopedDiagnosticsFactory = new ScopedDiagnosticsFactory(clientContextOverride, false);
        DocumentClientRetryPolicy requestRetryPolicy = this.resetSessionTokenRetryPolicy.getRequestPolicy(scopedDiagnosticsFactory);
        if (nonNullRequestOptions.getPartitionKey() == null) {
            requestRetryPolicy = new PartitionKeyMismatchRetryPolicy(this.collectionCache, requestRetryPolicy, collectionLink, nonNullRequestOptions);
        }
        DocumentClientRetryPolicy finalRetryPolicyInstance = requestRetryPolicy;
        AtomicReference<RxDocumentServiceRequest> requestReference = new AtomicReference<RxDocumentServiceRequest>();
        return this.handleCircuitBreakingFeedbackForPointOperation(RxDocumentClientImpl.getPointOperationResponseMonoWithE2ETimeout(nonNullRequestOptions, endToEndPolicyConfig, ObservableHelper.inlineIfPossibleAsObs(() -> this.upsertDocumentInternal(collectionLink, document, nonNullRequestOptions, disableAutomaticIdGeneration, finalRetryPolicyInstance, scopedDiagnosticsFactory, requestReference, pointOperationContextForCircuitBreaker), finalRetryPolicyInstance), scopedDiagnosticsFactory), requestReference);
    }

    private Mono<ResourceResponse<Document>> upsertDocumentInternal(String collectionLink, Object document, RequestOptions options, boolean disableAutomaticIdGeneration, DocumentClientRetryPolicy retryPolicyInstance, DiagnosticsClientContext clientContextOverride, AtomicReference<RxDocumentServiceRequest> requestReference, PointOperationContextForCircuitBreaker pointOperationContextForCircuitBreaker) {
        try {
            logger.debug("Upserting a Document. collectionLink: [{}]", (Object)collectionLink);
            Mono<Tuple2<RxDocumentServiceRequest, Utils.ValueHolder<DocumentCollection>>> requestToDocumentCollectionObs = this.getCreateDocumentRequest(retryPolicyInstance, collectionLink, document, options, disableAutomaticIdGeneration, OperationType.Upsert, clientContextOverride, pointOperationContextForCircuitBreaker);
            return requestToDocumentCollectionObs.flatMap(requestToDocumentCollection -> {
                RxDocumentServiceRequest request = (RxDocumentServiceRequest)requestToDocumentCollection.getT1();
                Utils.ValueHolder documentCollectionValueHolder = (Utils.ValueHolder)requestToDocumentCollection.getT2();
                if (documentCollectionValueHolder == null || documentCollectionValueHolder.v == null) {
                    return Mono.error((Throwable)new IllegalStateException("documentCollectionValueHolder or documentCollectionValueHolder.v cannot be null"));
                }
                return this.partitionKeyRangeCache.tryLookupAsync(BridgeInternal.getMetaDataDiagnosticContext(request.requestContext.cosmosDiagnostics), ((DocumentCollection)documentCollectionValueHolder.v).getResourceId(), null, null).flatMap(collectionRoutingMapValueHolder -> {
                    if (collectionRoutingMapValueHolder == null || collectionRoutingMapValueHolder.v == null) {
                        return Mono.error((Throwable)new IllegalStateException("collectionRoutingMapValueHolder or collectionRoutingMapValueHolder.v cannot be null"));
                    }
                    options.setPartitionKeyDefinition(((DocumentCollection)documentCollectionValueHolder.v).getPartitionKey());
                    this.addPartitionLevelUnavailableRegionsForRequest(request, options, (CollectionRoutingMap)collectionRoutingMapValueHolder.v, retryPolicyInstance);
                    request.requestContext.setPointOperationContext(pointOperationContextForCircuitBreaker);
                    requestReference.set(request);
                    this.mergeContextInformationIntoDiagnosticsForPointRequest(request, pointOperationContextForCircuitBreaker);
                    return this.upsert(request, retryPolicyInstance, this.getOperationContextAndListenerTuple(options));
                }).map(serviceResponse -> BridgeInternal.toResourceResponse(serviceResponse, Document.class));
            });
        }
        catch (Exception e) {
            logger.debug("Failure in upserting a document due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<Document>> replaceDocument(String documentLink, Object document, RequestOptions options) {
        String collectionLink = Utils.getCollectionName(documentLink);
        return this.wrapPointOperationWithAvailabilityStrategy(ResourceType.Document, OperationType.Replace, (opt, e2ecfg, clientCtxOverride, pointOperationContextForCircuitBreaker) -> this.replaceDocumentCore(documentLink, document, opt, e2ecfg, clientCtxOverride, pointOperationContextForCircuitBreaker), options, options != null && options.getNonIdempotentWriteRetriesEnabled() != null && options.getNonIdempotentWriteRetriesEnabled() != false, collectionLink);
    }

    private Mono<ResourceResponse<Document>> replaceDocumentCore(String documentLink, Object document, RequestOptions options, CosmosEndToEndOperationLatencyPolicyConfig endToEndPolicyConfig, DiagnosticsClientContext clientContextOverride, PointOperationContextForCircuitBreaker pointOperationContextForCircuitBreaker) {
        RequestOptions nonNullRequestOptions = options != null ? options : new RequestOptions();
        ScopedDiagnosticsFactory scopedDiagnosticsFactory = new ScopedDiagnosticsFactory(clientContextOverride, false);
        DocumentClientRetryPolicy requestRetryPolicy = this.resetSessionTokenRetryPolicy.getRequestPolicy(scopedDiagnosticsFactory);
        if (nonNullRequestOptions.getPartitionKey() == null) {
            String collectionLink = Utils.getCollectionName(documentLink);
            requestRetryPolicy = new PartitionKeyMismatchRetryPolicy(this.collectionCache, requestRetryPolicy, collectionLink, nonNullRequestOptions);
        }
        DocumentClientRetryPolicy finalRequestRetryPolicy = requestRetryPolicy;
        AtomicReference<RxDocumentServiceRequest> requestReference = new AtomicReference<RxDocumentServiceRequest>();
        return this.handleCircuitBreakingFeedbackForPointOperation(RxDocumentClientImpl.getPointOperationResponseMonoWithE2ETimeout(nonNullRequestOptions, endToEndPolicyConfig, ObservableHelper.inlineIfPossibleAsObs(() -> this.replaceDocumentInternal(documentLink, document, nonNullRequestOptions, finalRequestRetryPolicy, endToEndPolicyConfig, scopedDiagnosticsFactory, requestReference, pointOperationContextForCircuitBreaker), requestRetryPolicy), scopedDiagnosticsFactory), requestReference);
    }

    private Mono<ResourceResponse<Document>> replaceDocumentInternal(String documentLink, Object document, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance, CosmosEndToEndOperationLatencyPolicyConfig endToEndPolicyConfig, DiagnosticsClientContext clientContextOverride, AtomicReference<RxDocumentServiceRequest> requestReference, PointOperationContextForCircuitBreaker pointOperationContextForCircuitBreaker) {
        try {
            if (StringUtils.isEmpty(documentLink)) {
                throw new IllegalArgumentException("documentLink");
            }
            if (document == null) {
                throw new IllegalArgumentException("document");
            }
            Document typedDocument = Document.fromObject(document, options.getEffectiveItemSerializer());
            return this.replaceDocumentInternal(documentLink, typedDocument, options, retryPolicyInstance, clientContextOverride, requestReference, pointOperationContextForCircuitBreaker);
        }
        catch (Exception e) {
            logger.debug("Failure in replacing a document due to [{}]", (Object)e.getMessage());
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<Document>> replaceDocument(Document document, RequestOptions options) {
        String collectionLink = Utils.getCollectionName(document.getSelfLink());
        return this.wrapPointOperationWithAvailabilityStrategy(ResourceType.Document, OperationType.Replace, (opt, e2ecfg, clientCtxOverride, pointOperationContextForCircuitBreaker) -> this.replaceDocumentCore(document, opt, e2ecfg, clientCtxOverride, pointOperationContextForCircuitBreaker), options, options != null && options.getNonIdempotentWriteRetriesEnabled() != null && options.getNonIdempotentWriteRetriesEnabled() != false, collectionLink);
    }

    private Mono<ResourceResponse<Document>> replaceDocumentCore(Document document, RequestOptions options, CosmosEndToEndOperationLatencyPolicyConfig endToEndPolicyConfig, DiagnosticsClientContext clientContextOverride, PointOperationContextForCircuitBreaker pointOperationContextForCircuitBreaker) {
        DocumentClientRetryPolicy requestRetryPolicy = this.resetSessionTokenRetryPolicy.getRequestPolicy(clientContextOverride);
        if (options == null || options.getPartitionKey() == null) {
            String collectionLink = document.getSelfLink();
            requestRetryPolicy = new PartitionKeyMismatchRetryPolicy(this.collectionCache, requestRetryPolicy, collectionLink, options);
        }
        DocumentClientRetryPolicy finalRequestRetryPolicy = requestRetryPolicy;
        AtomicReference<RxDocumentServiceRequest> requestReference = new AtomicReference<RxDocumentServiceRequest>();
        return this.handleCircuitBreakingFeedbackForPointOperation(ObservableHelper.inlineIfPossibleAsObs(() -> this.replaceDocumentInternal(document, options, finalRequestRetryPolicy, endToEndPolicyConfig, clientContextOverride, requestReference, pointOperationContextForCircuitBreaker), requestRetryPolicy), requestReference);
    }

    private Mono<ResourceResponse<Document>> replaceDocumentInternal(Document document, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance, CosmosEndToEndOperationLatencyPolicyConfig endToEndPolicyConfig, DiagnosticsClientContext clientContextOverride, AtomicReference<RxDocumentServiceRequest> requestReference, PointOperationContextForCircuitBreaker pointOperationContextForCircuitBreaker) {
        try {
            if (document == null) {
                throw new IllegalArgumentException("document");
            }
            return this.replaceDocumentInternal(document.getSelfLink(), document, options, retryPolicyInstance, clientContextOverride, requestReference, pointOperationContextForCircuitBreaker);
        }
        catch (Exception e) {
            logger.debug("Failure in replacing a database due to [{}]", (Object)e.getMessage());
            return Mono.error((Throwable)e);
        }
    }

    private Mono<ResourceResponse<Document>> replaceDocumentInternal(String documentLink, Document document, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance, DiagnosticsClientContext clientContextOverride, AtomicReference<RxDocumentServiceRequest> requestReference, PointOperationContextForCircuitBreaker pointOperationContextForCircuitBreaker) {
        SerializationDiagnosticsContext serializationDiagnosticsContext;
        String trackingId;
        if (document == null) {
            throw new IllegalArgumentException("document");
        }
        logger.debug("Replacing a Document. documentLink: [{}]", (Object)documentLink);
        String path = Utils.joinPath(documentLink, null);
        Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.Document, OperationType.Replace);
        Instant serializationStartTimeUTC = Instant.now();
        Consumer<Map> onAfterSerialization = null;
        if (options != null && (trackingId = options.getTrackingId()) != null && !trackingId.isEmpty()) {
            onAfterSerialization = node -> node.put("_trackingId", trackingId);
        }
        ByteBuffer content = document.serializeJsonToByteBuffer(options.getEffectiveItemSerializer(), onAfterSerialization, false);
        Instant serializationEndTime = Instant.now();
        SerializationDiagnosticsContext.SerializationDiagnostics serializationDiagnostics = new SerializationDiagnosticsContext.SerializationDiagnostics(serializationStartTimeUTC, serializationEndTime, SerializationDiagnosticsContext.SerializationType.ITEM_SERIALIZATION);
        RxDocumentServiceRequest request = RxDocumentServiceRequest.create(this.getEffectiveClientContext(clientContextOverride), OperationType.Replace, ResourceType.Document, path, requestHeaders, options, content);
        if (options != null && options.getNonIdempotentWriteRetriesEnabled() != null && options.getNonIdempotentWriteRetriesEnabled().booleanValue()) {
            request.setNonIdempotentWriteRetriesEnabled(true);
        }
        if (options != null) {
            DocumentServiceRequestContext requestContext = request.requestContext;
            options.getMarkE2ETimeoutInRequestContextCallbackHook().set(() -> requestContext.setIsRequestCancelledOnTimeout(new AtomicBoolean(true)));
            requestContext.setExcludeRegions(options.getExcludedRegions());
            requestContext.setKeywordIdentifiers(options.getKeywordIdentifiers());
        }
        if ((serializationDiagnosticsContext = BridgeInternal.getSerializationDiagnosticsContext(request.requestContext.cosmosDiagnostics)) != null) {
            serializationDiagnosticsContext.addSerializationDiagnostics(serializationDiagnostics);
        }
        if (retryPolicyInstance != null) {
            retryPolicyInstance.onBeforeSendRequest(request);
        }
        Mono<Utils.ValueHolder<DocumentCollection>> collectionObs = this.collectionCache.resolveCollectionAsync(BridgeInternal.getMetaDataDiagnosticContext(request.requestContext.cosmosDiagnostics), request);
        Mono<RxDocumentServiceRequest> requestObs = this.addPartitionKeyInformation(request, content, (Object)document, options, collectionObs, pointOperationContextForCircuitBreaker);
        return collectionObs.flatMap(documentCollectionValueHolder -> {
            if (documentCollectionValueHolder == null || documentCollectionValueHolder.v == null) {
                return Mono.error((Throwable)new IllegalStateException("documentCollectionValueHolder or documentCollectionValueHolder.v cannot be null"));
            }
            return this.partitionKeyRangeCache.tryLookupAsync(BridgeInternal.getMetaDataDiagnosticContext(request.requestContext.cosmosDiagnostics), ((DocumentCollection)documentCollectionValueHolder.v).getResourceId(), null, null).flatMap(collectionRoutingMapValueHolder -> {
                if (collectionRoutingMapValueHolder == null || collectionRoutingMapValueHolder.v == null) {
                    return Mono.error((Throwable)new IllegalStateException("collectionRoutingMapValueHolder or collectionRoutingMapValueHolder.v cannot be null"));
                }
                return requestObs.flatMap(req -> {
                    options.setPartitionKeyDefinition(((DocumentCollection)documentCollectionValueHolder.v).getPartitionKey());
                    this.addPartitionLevelUnavailableRegionsForRequest((RxDocumentServiceRequest)req, options, (CollectionRoutingMap)collectionRoutingMapValueHolder.v, retryPolicyInstance);
                    req.requestContext.setPointOperationContext(pointOperationContextForCircuitBreaker);
                    requestReference.set((RxDocumentServiceRequest)req);
                    this.mergeContextInformationIntoDiagnosticsForPointRequest(request, pointOperationContextForCircuitBreaker);
                    return this.replace(request, retryPolicyInstance);
                }).map(resp -> BridgeInternal.toResourceResponse(resp, Document.class));
            });
        });
    }

    private CosmosEndToEndOperationLatencyPolicyConfig getEndToEndOperationLatencyPolicyConfig(RequestOptions options, ResourceType resourceType, OperationType operationType) {
        return this.getEffectiveEndToEndOperationLatencyPolicyConfig(options != null ? options.getCosmosEndToEndLatencyPolicyConfig() : null, resourceType, operationType);
    }

    private CosmosEndToEndOperationLatencyPolicyConfig getEffectiveEndToEndOperationLatencyPolicyConfig(CosmosEndToEndOperationLatencyPolicyConfig policyConfig, ResourceType resourceType, OperationType operationType) {
        if (policyConfig != null) {
            return policyConfig;
        }
        if (resourceType != ResourceType.Document) {
            return null;
        }
        if (!operationType.isPointOperation() && Configs.isDefaultE2ETimeoutDisabledForNonPointOperations()) {
            return null;
        }
        return this.cosmosEndToEndOperationLatencyPolicyConfig;
    }

    @Override
    public Mono<ResourceResponse<Document>> patchDocument(String documentLink, CosmosPatchOperations cosmosPatchOperations, RequestOptions options) {
        String collectionLink = Utils.getCollectionName(documentLink);
        return this.wrapPointOperationWithAvailabilityStrategy(ResourceType.Document, OperationType.Patch, (opt, e2ecfg, clientCtxOverride, pointOperationContextForCircuitBreaker) -> this.patchDocumentCore(documentLink, cosmosPatchOperations, opt, e2ecfg, clientCtxOverride, pointOperationContextForCircuitBreaker), options, options != null && options.getNonIdempotentWriteRetriesEnabled() != null && options.getNonIdempotentWriteRetriesEnabled() != false, collectionLink);
    }

    private Mono<ResourceResponse<Document>> patchDocumentCore(String documentLink, CosmosPatchOperations cosmosPatchOperations, RequestOptions options, CosmosEndToEndOperationLatencyPolicyConfig endToEndPolicyConfig, DiagnosticsClientContext clientContextOverride, PointOperationContextForCircuitBreaker pointOperationContextForCircuitBreaker) {
        RequestOptions nonNullRequestOptions = options != null ? options : new RequestOptions();
        ScopedDiagnosticsFactory scopedDiagnosticsFactory = new ScopedDiagnosticsFactory(clientContextOverride, false);
        DocumentClientRetryPolicy documentClientRetryPolicy = this.resetSessionTokenRetryPolicy.getRequestPolicy(scopedDiagnosticsFactory);
        AtomicReference<RxDocumentServiceRequest> requestReference = new AtomicReference<RxDocumentServiceRequest>();
        return this.handleCircuitBreakingFeedbackForPointOperation(RxDocumentClientImpl.getPointOperationResponseMonoWithE2ETimeout(nonNullRequestOptions, endToEndPolicyConfig, ObservableHelper.inlineIfPossibleAsObs(() -> this.patchDocumentInternal(documentLink, cosmosPatchOperations, nonNullRequestOptions, documentClientRetryPolicy, scopedDiagnosticsFactory, requestReference, pointOperationContextForCircuitBreaker), documentClientRetryPolicy), scopedDiagnosticsFactory), requestReference);
    }

    private Mono<ResourceResponse<Document>> patchDocumentInternal(String documentLink, CosmosPatchOperations cosmosPatchOperations, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance, DiagnosticsClientContext clientContextOverride, AtomicReference<RxDocumentServiceRequest> requestReference, PointOperationContextForCircuitBreaker pointOperationContextForCircuitBreaker) {
        SerializationDiagnosticsContext serializationDiagnosticsContext;
        Preconditions.checkArgument(StringUtils.isNotEmpty(documentLink), "expected non empty documentLink");
        Preconditions.checkNotNull(cosmosPatchOperations, "expected non null cosmosPatchOperations");
        logger.debug("Running patch operations on Document. documentLink: [{}]", (Object)documentLink);
        String path = Utils.joinPath(documentLink, null);
        Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.Document, OperationType.Patch);
        Instant serializationStartTimeUTC = Instant.now();
        ByteBuffer content = ByteBuffer.wrap(PatchUtil.serializeCosmosPatchToByteArray(cosmosPatchOperations, options));
        Instant serializationEndTime = Instant.now();
        SerializationDiagnosticsContext.SerializationDiagnostics serializationDiagnostics = new SerializationDiagnosticsContext.SerializationDiagnostics(serializationStartTimeUTC, serializationEndTime, SerializationDiagnosticsContext.SerializationType.ITEM_SERIALIZATION);
        RxDocumentServiceRequest request = RxDocumentServiceRequest.create(clientContextOverride, OperationType.Patch, ResourceType.Document, path, requestHeaders, options, content);
        if (options != null && options.getNonIdempotentWriteRetriesEnabled() != null && options.getNonIdempotentWriteRetriesEnabled().booleanValue()) {
            request.setNonIdempotentWriteRetriesEnabled(true);
        }
        if (options != null) {
            DocumentServiceRequestContext requestContext = request.requestContext;
            options.getMarkE2ETimeoutInRequestContextCallbackHook().set(() -> requestContext.setIsRequestCancelledOnTimeout(new AtomicBoolean(true)));
            requestContext.setExcludeRegions(options.getExcludedRegions());
            requestContext.setKeywordIdentifiers(options.getKeywordIdentifiers());
        }
        if (retryPolicyInstance != null) {
            retryPolicyInstance.onBeforeSendRequest(request);
        }
        if ((serializationDiagnosticsContext = BridgeInternal.getSerializationDiagnosticsContext(request.requestContext.cosmosDiagnostics)) != null) {
            serializationDiagnosticsContext.addSerializationDiagnostics(serializationDiagnostics);
        }
        Mono<Utils.ValueHolder<DocumentCollection>> collectionObs = this.collectionCache.resolveCollectionAsync(BridgeInternal.getMetaDataDiagnosticContext(request.requestContext.cosmosDiagnostics), request);
        Mono<RxDocumentServiceRequest> requestObs = this.addPartitionKeyInformation(request, null, null, options, collectionObs, pointOperationContextForCircuitBreaker);
        return collectionObs.flatMap(documentCollectionValueHolder -> {
            if (documentCollectionValueHolder == null || documentCollectionValueHolder.v == null) {
                return Mono.error((Throwable)new IllegalStateException("documentCollectionValueHolder or documentCollectionValueHolder.v cannot be null"));
            }
            return this.partitionKeyRangeCache.tryLookupAsync(BridgeInternal.getMetaDataDiagnosticContext(request.requestContext.cosmosDiagnostics), ((DocumentCollection)documentCollectionValueHolder.v).getResourceId(), null, null).flatMap(collectionRoutingMapValueHolder -> {
                if (collectionRoutingMapValueHolder == null || collectionRoutingMapValueHolder.v == null) {
                    return Mono.error((Throwable)new IllegalStateException("collectionRoutingMapValueHolder or collectionRoutingMapValueHolder.v cannot be null"));
                }
                return requestObs.flatMap(req -> {
                    options.setPartitionKeyDefinition(((DocumentCollection)documentCollectionValueHolder.v).getPartitionKey());
                    this.addPartitionLevelUnavailableRegionsForRequest((RxDocumentServiceRequest)req, options, (CollectionRoutingMap)collectionRoutingMapValueHolder.v, retryPolicyInstance);
                    req.requestContext.setPointOperationContext(pointOperationContextForCircuitBreaker);
                    requestReference.set((RxDocumentServiceRequest)req);
                    this.mergeContextInformationIntoDiagnosticsForPointRequest(request, pointOperationContextForCircuitBreaker);
                    return this.patch(request, retryPolicyInstance);
                }).map(resp -> BridgeInternal.toResourceResponse(resp, Document.class));
            });
        });
    }

    @Override
    public Mono<ResourceResponse<Document>> deleteDocument(String documentLink, RequestOptions options) {
        String collectionLink = Utils.getCollectionName(documentLink);
        return this.wrapPointOperationWithAvailabilityStrategy(ResourceType.Document, OperationType.Delete, (opt, e2ecfg, clientCtxOverride, pointOperationContextForCircuitBreaker) -> this.deleteDocumentCore(documentLink, null, opt, e2ecfg, clientCtxOverride, pointOperationContextForCircuitBreaker), options, options != null && options.getNonIdempotentWriteRetriesEnabled() != null && options.getNonIdempotentWriteRetriesEnabled() != false, collectionLink);
    }

    @Override
    public Mono<ResourceResponse<Document>> deleteDocument(String documentLink, InternalObjectNode internalObjectNode, RequestOptions options) {
        String collectionLink = Utils.getCollectionName(documentLink);
        return this.wrapPointOperationWithAvailabilityStrategy(ResourceType.Document, OperationType.Delete, (opt, e2ecfg, clientCtxOverride, pointOperationContextForCircuitBreaker) -> this.deleteDocumentCore(documentLink, internalObjectNode, opt, e2ecfg, clientCtxOverride, pointOperationContextForCircuitBreaker), options, options != null && options.getNonIdempotentWriteRetriesEnabled() != null && options.getNonIdempotentWriteRetriesEnabled() != false, collectionLink);
    }

    private Mono<ResourceResponse<Document>> deleteDocumentCore(String documentLink, InternalObjectNode internalObjectNode, RequestOptions options, CosmosEndToEndOperationLatencyPolicyConfig endToEndPolicyConfig, DiagnosticsClientContext clientContextOverride, PointOperationContextForCircuitBreaker pointOperationContextForCircuitBreaker) {
        RequestOptions nonNullRequestOptions = options != null ? options : new RequestOptions();
        ScopedDiagnosticsFactory scopedDiagnosticsFactory = new ScopedDiagnosticsFactory(clientContextOverride, false);
        DocumentClientRetryPolicy requestRetryPolicy = this.resetSessionTokenRetryPolicy.getRequestPolicy(scopedDiagnosticsFactory);
        AtomicReference<RxDocumentServiceRequest> requestReference = new AtomicReference<RxDocumentServiceRequest>();
        return this.handleCircuitBreakingFeedbackForPointOperation(RxDocumentClientImpl.getPointOperationResponseMonoWithE2ETimeout(nonNullRequestOptions, endToEndPolicyConfig, ObservableHelper.inlineIfPossibleAsObs(() -> this.deleteDocumentInternal(documentLink, internalObjectNode, nonNullRequestOptions, requestRetryPolicy, scopedDiagnosticsFactory, requestReference, pointOperationContextForCircuitBreaker), requestRetryPolicy), scopedDiagnosticsFactory), requestReference);
    }

    private Mono<ResourceResponse<Document>> deleteDocumentInternal(String documentLink, InternalObjectNode internalObjectNode, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance, DiagnosticsClientContext clientContextOverride, AtomicReference<RxDocumentServiceRequest> requestReference, PointOperationContextForCircuitBreaker pointOperationContextForCircuitBreaker) {
        try {
            if (StringUtils.isEmpty(documentLink)) {
                throw new IllegalArgumentException("documentLink");
            }
            logger.debug("Deleting a Document. documentLink: [{}]", (Object)documentLink);
            String path = Utils.joinPath(documentLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.Document, OperationType.Delete);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create(this.getEffectiveClientContext(clientContextOverride), OperationType.Delete, ResourceType.Document, path, requestHeaders, options);
            if (options != null && options.getNonIdempotentWriteRetriesEnabled() != null && options.getNonIdempotentWriteRetriesEnabled().booleanValue()) {
                request.setNonIdempotentWriteRetriesEnabled(true);
            }
            if (options != null) {
                DocumentServiceRequestContext requestContext = request.requestContext;
                options.getMarkE2ETimeoutInRequestContextCallbackHook().set(() -> requestContext.setIsRequestCancelledOnTimeout(new AtomicBoolean(true)));
                requestContext.setExcludeRegions(options.getExcludedRegions());
                requestContext.setKeywordIdentifiers(options.getKeywordIdentifiers());
            }
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            Mono<Utils.ValueHolder<DocumentCollection>> collectionObs = this.collectionCache.resolveCollectionAsync(BridgeInternal.getMetaDataDiagnosticContext(request.requestContext.cosmosDiagnostics), request);
            Mono<RxDocumentServiceRequest> requestObs = this.addPartitionKeyInformation(request, null, (Object)internalObjectNode, options, collectionObs, pointOperationContextForCircuitBreaker);
            return collectionObs.flatMap(documentCollectionValueHolder -> this.partitionKeyRangeCache.tryLookupAsync(BridgeInternal.getMetaDataDiagnosticContext(request.requestContext.cosmosDiagnostics), ((DocumentCollection)documentCollectionValueHolder.v).getResourceId(), null, null).flatMap(collectionRoutingMapValueHolder -> requestObs.flatMap(req -> {
                options.setPartitionKeyDefinition(((DocumentCollection)documentCollectionValueHolder.v).getPartitionKey());
                this.addPartitionLevelUnavailableRegionsForRequest(request, options, (CollectionRoutingMap)collectionRoutingMapValueHolder.v, retryPolicyInstance);
                req.requestContext.setPointOperationContext(pointOperationContextForCircuitBreaker);
                requestReference.set((RxDocumentServiceRequest)req);
                this.mergeContextInformationIntoDiagnosticsForPointRequest(request, pointOperationContextForCircuitBreaker);
                return this.delete((RxDocumentServiceRequest)req, retryPolicyInstance, this.getOperationContextAndListenerTuple(options));
            }).map(serviceResponse -> BridgeInternal.toResourceResponse(serviceResponse, Document.class))));
        }
        catch (Exception e) {
            logger.debug("Failure in deleting a document due to [{}]", (Object)e.getMessage());
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<Document>> deleteAllDocumentsByPartitionKey(String collectionLink, PartitionKey partitionKey, RequestOptions options) {
        DocumentClientRetryPolicy requestRetryPolicy = this.resetSessionTokenRetryPolicy.getRequestPolicy(null);
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.deleteAllDocumentsByPartitionKeyInternal(collectionLink, options, requestRetryPolicy), requestRetryPolicy);
    }

    private Mono<ResourceResponse<Document>> deleteAllDocumentsByPartitionKeyInternal(String collectionLink, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty(collectionLink)) {
                throw new IllegalArgumentException("collectionLink");
            }
            logger.debug("Deleting all items by Partition Key. collectionLink: [{}]", (Object)collectionLink);
            String path = Utils.joinPath(collectionLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.PartitionKey, OperationType.Delete);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.Delete, ResourceType.PartitionKey, path, requestHeaders, options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            Mono<Utils.ValueHolder<DocumentCollection>> collectionObs = this.collectionCache.resolveCollectionAsync(BridgeInternal.getMetaDataDiagnosticContext(request.requestContext.cosmosDiagnostics), request);
            Mono<RxDocumentServiceRequest> requestObs = this.addPartitionKeyInformation(request, null, null, options, collectionObs, null);
            return requestObs.flatMap(req -> this.deleteAllItemsByPartitionKey((RxDocumentServiceRequest)req, retryPolicyInstance, this.getOperationContextAndListenerTuple(options)).map(serviceResponse -> BridgeInternal.toResourceResponse(serviceResponse, Document.class)));
        }
        catch (Exception e) {
            logger.debug("Failure in deleting documents due to [{}]", (Object)e.getMessage());
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<Document>> readDocument(String documentLink, RequestOptions options) {
        return this.readDocument(documentLink, options, this);
    }

    private Mono<ResourceResponse<Document>> readDocument(String documentLink, RequestOptions options, DiagnosticsClientContext innerDiagnosticsFactory) {
        String collectionLink = Utils.getCollectionName(documentLink);
        return this.wrapPointOperationWithAvailabilityStrategy(ResourceType.Document, OperationType.Read, (opt, e2ecfg, clientCtxOverride, pointOperationContextForCircuitBreaker) -> this.readDocumentCore(documentLink, opt, e2ecfg, clientCtxOverride, pointOperationContextForCircuitBreaker), options, false, innerDiagnosticsFactory, collectionLink);
    }

    private Mono<ResourceResponse<Document>> readDocumentCore(String documentLink, RequestOptions options, CosmosEndToEndOperationLatencyPolicyConfig endToEndPolicyConfig, DiagnosticsClientContext clientContextOverride, PointOperationContextForCircuitBreaker pointOperationContextForCircuitBreaker) {
        RequestOptions nonNullRequestOptions = options != null ? options : new RequestOptions();
        ScopedDiagnosticsFactory scopedDiagnosticsFactory = new ScopedDiagnosticsFactory(clientContextOverride, false);
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy(scopedDiagnosticsFactory);
        AtomicReference<RxDocumentServiceRequest> requestReference = new AtomicReference<RxDocumentServiceRequest>();
        return this.handleCircuitBreakingFeedbackForPointOperation(RxDocumentClientImpl.getPointOperationResponseMonoWithE2ETimeout(nonNullRequestOptions, endToEndPolicyConfig, ObservableHelper.inlineIfPossibleAsObs(() -> this.readDocumentInternal(documentLink, nonNullRequestOptions, retryPolicyInstance, scopedDiagnosticsFactory, requestReference, pointOperationContextForCircuitBreaker), retryPolicyInstance), scopedDiagnosticsFactory), requestReference);
    }

    private Mono<ResourceResponse<Document>> readDocumentInternal(String documentLink, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance, DiagnosticsClientContext clientContextOverride, AtomicReference<RxDocumentServiceRequest> requestReference, PointOperationContextForCircuitBreaker pointOperationContextForCircuitBreaker) {
        try {
            if (StringUtils.isEmpty(documentLink)) {
                throw new IllegalArgumentException("documentLink");
            }
            logger.debug("Reading a Document. documentLink: [{}]", (Object)documentLink);
            String path = Utils.joinPath(documentLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.Document, OperationType.Read);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create(this.getEffectiveClientContext(clientContextOverride), OperationType.Read, ResourceType.Document, path, requestHeaders, options);
            DocumentServiceRequestContext requestContext = request.requestContext;
            options.getMarkE2ETimeoutInRequestContextCallbackHook().set(() -> requestContext.setIsRequestCancelledOnTimeout(new AtomicBoolean(true)));
            requestContext.setExcludeRegions(options.getExcludedRegions());
            requestContext.setKeywordIdentifiers(options.getKeywordIdentifiers());
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            Mono<Utils.ValueHolder<DocumentCollection>> collectionObs = this.collectionCache.resolveCollectionAsync(BridgeInternal.getMetaDataDiagnosticContext(request.requestContext.cosmosDiagnostics), request);
            return collectionObs.flatMap(documentCollectionValueHolder -> {
                if (documentCollectionValueHolder == null || documentCollectionValueHolder.v == null) {
                    return Mono.error((Throwable)new IllegalStateException("documentCollectionValueHolder or documentCollectionValueHolder.v cannot be null"));
                }
                DocumentCollection documentCollection = (DocumentCollection)documentCollectionValueHolder.v;
                return this.partitionKeyRangeCache.tryLookupAsync(BridgeInternal.getMetaDataDiagnosticContext(request.requestContext.cosmosDiagnostics), documentCollection.getResourceId(), null, null).flatMap(collectionRoutingMapValueHolder -> {
                    if (collectionRoutingMapValueHolder == null || collectionRoutingMapValueHolder.v == null) {
                        return Mono.error((Throwable)new IllegalStateException("collectionRoutingMapValueHolder or collectionRoutingMapValueHolder.v cannot be null"));
                    }
                    Mono<RxDocumentServiceRequest> requestObs = this.addPartitionKeyInformation(request, null, null, options, collectionObs, pointOperationContextForCircuitBreaker);
                    return requestObs.flatMap(req -> {
                        options.setPartitionKeyDefinition(documentCollection.getPartitionKey());
                        this.addPartitionLevelUnavailableRegionsForRequest((RxDocumentServiceRequest)req, options, (CollectionRoutingMap)collectionRoutingMapValueHolder.v, retryPolicyInstance);
                        req.requestContext.setPointOperationContext(pointOperationContextForCircuitBreaker);
                        requestReference.set((RxDocumentServiceRequest)req);
                        this.mergeContextInformationIntoDiagnosticsForPointRequest(request, pointOperationContextForCircuitBreaker);
                        return this.read((RxDocumentServiceRequest)req, retryPolicyInstance).map(serviceResponse -> BridgeInternal.toResourceResponse(serviceResponse, Document.class));
                    });
                });
            });
        }
        catch (Exception e) {
            logger.debug("Failure in reading a document due to [{}]", (Object)e.getMessage());
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public <T> Flux<FeedResponse<T>> readDocuments(String collectionLink, QueryFeedOperationState state, Class<T> classOfT) {
        if (StringUtils.isEmpty(collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        return this.queryDocuments(collectionLink, "SELECT * FROM r", state, classOfT);
    }

    @Override
    public <T> Mono<FeedResponse<T>> readMany(List<CosmosItemIdentity> itemIdentityList, String collectionLink, QueryFeedOperationState state, Class<T> klass) {
        ScopedDiagnosticsFactory diagnosticsFactory = new ScopedDiagnosticsFactory(this, true);
        state.registerDiagnosticsFactory(() -> {}, ctx -> diagnosticsFactory.merge((CosmosDiagnosticsContext)ctx));
        String resourceLink = this.parentResourceLinkToQueryLink(collectionLink, ResourceType.Document);
        RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)diagnosticsFactory, OperationType.Query, ResourceType.Document, collectionLink, null);
        Mono<Utils.ValueHolder<DocumentCollection>> collectionObs = this.collectionCache.resolveCollectionAsync(null, request);
        return collectionObs.flatMap(documentCollectionResourceResponse -> {
            DocumentCollection collection = (DocumentCollection)documentCollectionResourceResponse.v;
            if (collection == null) {
                return Mono.error((Throwable)new IllegalStateException("Collection cannot be null"));
            }
            PartitionKeyDefinition pkDefinition = collection.getPartitionKey();
            Mono<Utils.ValueHolder<CollectionRoutingMap>> valueHolderMono = this.partitionKeyRangeCache.tryLookupAsync(BridgeInternal.getMetaDataDiagnosticContext(request.requestContext.cosmosDiagnostics), collection.getResourceId(), null, null);
            return valueHolderMono.flatMap(collectionRoutingMapValueHolder -> {
                HashMap<PartitionKeyRange, List<CosmosItemIdentity>> partitionRangeItemKeyMap = new HashMap<PartitionKeyRange, List<CosmosItemIdentity>>();
                CollectionRoutingMap routingMap = (CollectionRoutingMap)collectionRoutingMapValueHolder.v;
                if (routingMap == null) {
                    return Mono.error((Throwable)new IllegalStateException("Failed to get routing map."));
                }
                itemIdentityList.forEach(itemIdentity -> {
                    if (pkDefinition.getKind().equals((Object)PartitionKind.MULTI_HASH) && ModelBridgeInternal.getPartitionKeyInternal(itemIdentity.getPartitionKey()).getComponents().size() != pkDefinition.getPaths().size()) {
                        throw new IllegalArgumentException("Partition key provided either doesn't correspond to definition in the collection or doesn't match partition key field values specified in the document.");
                    }
                    String effectivePartitionKeyString = PartitionKeyInternalHelper.getEffectivePartitionKeyString(BridgeInternal.getPartitionKeyInternal(itemIdentity.getPartitionKey()), pkDefinition);
                    PartitionKeyRange range = routingMap.getRangeByEffectivePartitionKey(effectivePartitionKeyString);
                    if (partitionRangeItemKeyMap.get(range) == null) {
                        ArrayList<CosmosItemIdentity> list = new ArrayList<CosmosItemIdentity>();
                        list.add((CosmosItemIdentity)itemIdentity);
                        partitionRangeItemKeyMap.put(range, list);
                    } else {
                        List pairs = (List)partitionRangeItemKeyMap.get(range);
                        pairs.add(itemIdentity);
                        partitionRangeItemKeyMap.put(range, pairs);
                    }
                });
                Map<PartitionKeyRange, SqlQuerySpec> rangeQueryMap = this.getRangeQueryMap(partitionRangeItemKeyMap, collection.getPartitionKey());
                Flux pointReads = this.pointReadsForReadMany(diagnosticsFactory, partitionRangeItemKeyMap, resourceLink, state.getQueryOptions(), klass);
                Flux queries = this.queryForReadMany(diagnosticsFactory, resourceLink, new SqlQuerySpec(DUMMY_SQL_QUERY), state.getQueryOptions(), klass, ResourceType.Document, collection, Collections.unmodifiableMap(rangeQueryMap));
                return Flux.merge((Publisher[])new Publisher[]{pointReads, queries}).collectList().map(feedList -> {
                    ArrayList finalList = new ArrayList();
                    HashMap<String, String> headers = new HashMap<String, String>();
                    ConcurrentHashMap<String, QueryMetrics> aggregatedQueryMetrics = new ConcurrentHashMap<String, QueryMetrics>();
                    DistinctClientSideRequestStatisticsCollection aggregateRequestStatistics = new DistinctClientSideRequestStatisticsCollection();
                    double requestCharge = 0.0;
                    for (FeedResponse page : feedList) {
                        ConcurrentMap<String, QueryMetrics> pageQueryMetrics = ModelBridgeInternal.queryMetrics(page);
                        if (pageQueryMetrics != null) {
                            pageQueryMetrics.forEach(aggregatedQueryMetrics::putIfAbsent);
                        }
                        requestCharge += page.getRequestCharge();
                        finalList.addAll(page.getResults());
                        aggregateRequestStatistics.addAll(diagnosticsAccessor.getClientSideRequestStatistics(page.getCosmosDiagnostics()));
                    }
                    CosmosDiagnostics aggregatedDiagnostics = BridgeInternal.createCosmosDiagnostics(aggregatedQueryMetrics);
                    diagnosticsAccessor.addClientSideDiagnosticsToFeed(aggregatedDiagnostics, aggregateRequestStatistics);
                    state.mergeDiagnosticsContext();
                    CosmosDiagnosticsContext ctx = state.getDiagnosticsContextSnapshot();
                    if (ctx != null) {
                        ctxAccessor.recordOperation(ctx, 200, 0, finalList.size(), requestCharge, aggregatedDiagnostics, null);
                        diagnosticsAccessor.setDiagnosticsContext(aggregatedDiagnostics, ctx);
                    }
                    headers.put("x-ms-request-charge", Double.toString(requestCharge));
                    FeedResponse frp = BridgeInternal.createFeedResponseWithQueryMetrics(finalList, headers, aggregatedQueryMetrics, null, false, false, aggregatedDiagnostics);
                    return frp;
                });
            }).onErrorMap(throwable -> {
                if (throwable instanceof CosmosException) {
                    CosmosException cosmosException = (CosmosException)((Object)((Object)((Object)throwable)));
                    CosmosDiagnostics diagnostics = cosmosException.getDiagnostics();
                    if (diagnostics != null) {
                        state.mergeDiagnosticsContext();
                        CosmosDiagnosticsContext ctx = state.getDiagnosticsContextSnapshot();
                        if (ctx != null) {
                            ctxAccessor.recordOperation(ctx, cosmosException.getStatusCode(), cosmosException.getSubStatusCode(), 0, cosmosException.getRequestCharge(), diagnostics, (Throwable)throwable);
                            diagnosticsAccessor.setDiagnosticsContext(diagnostics, state.getDiagnosticsContextSnapshot());
                        }
                    }
                    return cosmosException;
                }
                return throwable;
            });
        });
    }

    private Map<PartitionKeyRange, SqlQuerySpec> getRangeQueryMap(Map<PartitionKeyRange, List<CosmosItemIdentity>> partitionRangeItemKeyMap, PartitionKeyDefinition partitionKeyDefinition) {
        HashMap<PartitionKeyRange, SqlQuerySpec> rangeQueryMap = new HashMap<PartitionKeyRange, SqlQuerySpec>();
        List<String> partitionKeySelectors = this.createPkSelectors(partitionKeyDefinition);
        for (Map.Entry<PartitionKeyRange, List<CosmosItemIdentity>> entry : partitionRangeItemKeyMap.entrySet()) {
            List<CosmosItemIdentity> cosmosItemIdentityList = entry.getValue();
            if (cosmosItemIdentityList.size() <= 1) continue;
            SqlQuerySpec sqlQuerySpec = partitionKeySelectors.size() == 1 && partitionKeySelectors.get(0).equals("[\"id\"]") ? this.createReadManyQuerySpecPartitionKeyIdSame(cosmosItemIdentityList) : this.createReadManyQuerySpec(entry.getValue(), partitionKeySelectors);
            rangeQueryMap.put(entry.getKey(), sqlQuerySpec);
        }
        return rangeQueryMap;
    }

    private SqlQuerySpec createReadManyQuerySpecPartitionKeyIdSame(List<CosmosItemIdentity> idPartitionKeyPairList) {
        StringBuilder queryStringBuilder = new StringBuilder();
        ArrayList<SqlParameter> parameters = new ArrayList<SqlParameter>();
        queryStringBuilder.append("SELECT * FROM c WHERE c.id IN ( ");
        for (int i = 0; i < idPartitionKeyPairList.size(); ++i) {
            CosmosItemIdentity itemIdentity = idPartitionKeyPairList.get(i);
            String idValue = itemIdentity.getId();
            String idParamName = "@param" + i;
            parameters.add(new SqlParameter(idParamName, idValue));
            queryStringBuilder.append(idParamName);
            if (i >= idPartitionKeyPairList.size() - 1) continue;
            queryStringBuilder.append(", ");
        }
        queryStringBuilder.append(" )");
        return new SqlQuerySpec(queryStringBuilder.toString(), parameters);
    }

    private SqlQuerySpec createReadManyQuerySpec(List<CosmosItemIdentity> itemIdentities, List<String> partitionKeySelectors) {
        StringBuilder queryStringBuilder = new StringBuilder();
        ArrayList<SqlParameter> parameters = new ArrayList<SqlParameter>();
        queryStringBuilder.append("SELECT * FROM c WHERE ( ");
        int paramCount = 0;
        for (int i = 0; i < itemIdentities.size(); ++i) {
            CosmosItemIdentity itemIdentity = itemIdentities.get(i);
            PartitionKey pkValueAsPartitionKey = itemIdentity.getPartitionKey();
            Object[] pkValues = ModelBridgeInternal.getPartitionKeyInternal(pkValueAsPartitionKey).toObjectArray();
            ArrayList<List<String>> partitionKeyParams = new ArrayList<List<String>>();
            int pathCount = 0;
            for (Object object : pkValues) {
                String pkParamName = "@param" + paramCount;
                partitionKeyParams.add(Arrays.asList(partitionKeySelectors.get(pathCount), pkParamName));
                parameters.add(new SqlParameter(pkParamName, object));
                ++paramCount;
                ++pathCount;
            }
            String idValue = itemIdentity.getId();
            String idParamName = "@param" + paramCount;
            ++paramCount;
            parameters.add(new SqlParameter(idParamName, idValue));
            queryStringBuilder.append("(");
            queryStringBuilder.append("c.id = ");
            queryStringBuilder.append(idParamName);
            for (List list : partitionKeyParams) {
                queryStringBuilder.append(" AND ");
                queryStringBuilder.append(" c");
                queryStringBuilder.append((String)list.get(0));
                queryStringBuilder.append(" = ");
                queryStringBuilder.append((String)list.get(1));
            }
            queryStringBuilder.append(" )");
            if (i >= itemIdentities.size() - 1) continue;
            queryStringBuilder.append(" OR ");
        }
        queryStringBuilder.append(" )");
        return new SqlQuerySpec(queryStringBuilder.toString(), parameters);
    }

    private List<String> createPkSelectors(PartitionKeyDefinition partitionKeyDefinition) {
        return partitionKeyDefinition.getPaths().stream().map(pathPart -> StringUtils.substring(pathPart, 1)).map(pathPart -> StringUtils.replace(pathPart, "\"", "\\")).map(part -> "[\"" + part + "\"]").collect(Collectors.toList());
    }

    private <T> Flux<FeedResponse<T>> queryForReadMany(ScopedDiagnosticsFactory diagnosticsFactory, String parentResourceLink, SqlQuerySpec sqlQuery, CosmosQueryRequestOptions options, Class<T> klass, ResourceType resourceTypeEnum, DocumentCollection collection, Map<PartitionKeyRange, SqlQuerySpec> rangeQueryMap) {
        if (rangeQueryMap.isEmpty()) {
            return Flux.empty();
        }
        UUID activityId = RxDocumentClientImpl.randomUuid();
        AtomicBoolean isQueryCancelledOnTimeout = new AtomicBoolean(false);
        IDocumentQueryClient queryClient = this.documentQueryClientImpl(this, this.getOperationContextAndListenerTuple(options));
        Flux<IDocumentQueryExecutionContext<T>> executionContext = DocumentQueryExecutionContextFactory.createReadManyQueryAsync(diagnosticsFactory, queryClient, collection.getResourceId(), sqlQuery, rangeQueryMap, options, collection, parentResourceLink, activityId, klass, resourceTypeEnum, isQueryCancelledOnTimeout);
        Flux feedResponseFlux = executionContext.flatMap(IDocumentQueryExecutionContext::executeAsync);
        RequestOptions requestOptions = options == null ? null : ImplementationBridgeHelpers.CosmosQueryRequestOptionsHelper.getCosmosQueryRequestOptionsAccessor().toRequestOptions(options);
        CosmosEndToEndOperationLatencyPolicyConfig endToEndPolicyConfig = this.getEndToEndOperationLatencyPolicyConfig(requestOptions, ResourceType.Document, OperationType.Query);
        if (endToEndPolicyConfig != null && endToEndPolicyConfig.isEnabled()) {
            return RxDocumentClientImpl.getFeedResponseFluxWithTimeout(feedResponseFlux, endToEndPolicyConfig, options, isQueryCancelledOnTimeout, diagnosticsFactory);
        }
        return feedResponseFlux;
    }

    private <T> Flux<FeedResponse<T>> pointReadsForReadMany(ScopedDiagnosticsFactory diagnosticsFactory, Map<PartitionKeyRange, List<CosmosItemIdentity>> singleItemPartitionRequestMap, String resourceLink, CosmosQueryRequestOptions queryRequestOptions, Class<T> klass) {
        CosmosItemSerializer effectiveItemSerializer = this.getEffectiveItemSerializer(queryRequestOptions);
        return Flux.fromIterable(singleItemPartitionRequestMap.values()).flatMap(cosmosItemIdentityList -> {
            if (cosmosItemIdentityList.size() == 1) {
                CosmosItemIdentity firstIdentity = (CosmosItemIdentity)cosmosItemIdentityList.get(0);
                RequestOptions requestOptions = ImplementationBridgeHelpers.CosmosQueryRequestOptionsHelper.getCosmosQueryRequestOptionsAccessor().toRequestOptions(queryRequestOptions);
                requestOptions.setPartitionKey(firstIdentity.getPartitionKey());
                return this.readDocument(resourceLink + firstIdentity.getId(), requestOptions, diagnosticsFactory).flatMap(resourceResponse -> Mono.just(new ImmutablePair<ResourceResponse, Object>((ResourceResponse)resourceResponse, null))).onErrorResume(throwable -> {
                    Throwable unwrappedThrowable = Exceptions.unwrap((Throwable)throwable);
                    if (unwrappedThrowable instanceof CosmosException) {
                        CosmosException cosmosException = (CosmosException)((Object)((Object)((Object)unwrappedThrowable)));
                        int statusCode = cosmosException.getStatusCode();
                        int subStatusCode = cosmosException.getSubStatusCode();
                        if (statusCode == 404 && subStatusCode == 0) {
                            return Mono.just(new ImmutablePair<Object, CosmosException>(null, cosmosException));
                        }
                    }
                    return Mono.error((Throwable)unwrappedThrowable);
                });
            }
            return Mono.empty();
        }).flatMap(resourceResponseToExceptionPair -> {
            FeedResponse<Object> feedResponse;
            ResourceResponse resourceResponse = (ResourceResponse)resourceResponseToExceptionPair.getLeft();
            CosmosException cosmosException = (CosmosException)((Object)((Object)resourceResponseToExceptionPair.getRight()));
            if (cosmosException != null) {
                feedResponse = ModelBridgeInternal.createFeedResponse(new ArrayList(), cosmosException.getResponseHeaders());
                diagnosticsAccessor.addClientSideDiagnosticsToFeed(feedResponse.getCosmosDiagnostics(), Collections.singleton(BridgeInternal.getClientSideRequestStatics(cosmosException.getDiagnostics())));
            } else {
                CosmosItemResponse cosmosItemResponse = itemResponseAccessor.createCosmosItemResponse(resourceResponse, klass, effectiveItemSerializer);
                feedResponse = ModelBridgeInternal.createFeedResponse(Arrays.asList(cosmosItemResponse.getItem()), cosmosItemResponse.getResponseHeaders());
                diagnosticsAccessor.addClientSideDiagnosticsToFeed(feedResponse.getCosmosDiagnostics(), Collections.singleton(BridgeInternal.getClientSideRequestStatics(cosmosItemResponse.getDiagnostics())));
            }
            return Mono.just(feedResponse);
        });
    }

    @Override
    public <T> Flux<FeedResponse<T>> queryDocuments(String collectionLink, String query, QueryFeedOperationState state, Class<T> classOfT) {
        return this.queryDocuments(collectionLink, new SqlQuerySpec(query), state, classOfT);
    }

    @Override
    public CosmosItemSerializer getEffectiveItemSerializer(CosmosItemSerializer requestOptionsItemSerializer) {
        if (requestOptionsItemSerializer != null) {
            return requestOptionsItemSerializer;
        }
        if (this.defaultCustomSerializer != null) {
            return this.defaultCustomSerializer;
        }
        return CosmosItemSerializer.DEFAULT_SERIALIZER;
    }

    private <T> CosmosItemSerializer getEffectiveItemSerializer(CosmosQueryRequestOptions queryRequestOptions) {
        CosmosItemSerializer requestOptionsItemSerializer = queryRequestOptions != null ? queryRequestOptions.getCustomItemSerializer() : null;
        return this.getEffectiveItemSerializer(requestOptionsItemSerializer);
    }

    private <T> CosmosItemSerializer getEffectiveItemSerializer(CosmosItemRequestOptions itemRequestOptions) {
        CosmosItemSerializer requestOptionsItemSerializer = itemRequestOptions != null ? itemRequestOptions.getCustomItemSerializer() : null;
        return this.getEffectiveItemSerializer(requestOptionsItemSerializer);
    }

    private IDocumentQueryClient documentQueryClientImpl(RxDocumentClientImpl rxDocumentClientImpl, final OperationContextAndListenerTuple operationContextAndListenerTuple) {
        return new IDocumentQueryClient(){

            @Override
            public RxCollectionCache getCollectionCache() {
                return RxDocumentClientImpl.this.collectionCache;
            }

            @Override
            public RxPartitionKeyRangeCache getPartitionKeyRangeCache() {
                return RxDocumentClientImpl.this.partitionKeyRangeCache;
            }

            @Override
            public IRetryPolicyFactory getResetSessionTokenRetryPolicy() {
                return RxDocumentClientImpl.this.resetSessionTokenRetryPolicy;
            }

            @Override
            public ConsistencyLevel getDefaultConsistencyLevelAsync() {
                return RxDocumentClientImpl.this.gatewayConfigurationReader.getDefaultConsistencyLevel();
            }

            @Override
            public ConsistencyLevel getDesiredConsistencyLevelAsync() {
                return RxDocumentClientImpl.this.consistencyLevel;
            }

            @Override
            public Mono<RxDocumentServiceResponse> executeQueryAsync(RxDocumentServiceRequest request) {
                if (operationContextAndListenerTuple == null) {
                    return RxDocumentClientImpl.this.query(request).single();
                }
                OperationListener listener = operationContextAndListenerTuple.getOperationListener();
                OperationContext operationContext = operationContextAndListenerTuple.getOperationContext();
                request.getHeaders().put("x-ms-cosmos-correlated-activityid", operationContext.getCorrelationActivityId());
                listener.requestListener(operationContext, request);
                return RxDocumentClientImpl.this.query(request).single().doOnNext(response -> listener.responseListener(operationContext, (RxDocumentServiceResponse)response)).doOnError(ex -> listener.exceptionListener(operationContext, (Throwable)ex));
            }

            @Override
            public IDocumentQueryClient.QueryCompatibilityMode getQueryCompatibilityMode() {
                return IDocumentQueryClient.QueryCompatibilityMode.Default;
            }

            @Override
            public <T> Mono<T> executeFeedOperationWithAvailabilityStrategy(ResourceType resourceType, OperationType operationType, Supplier<DocumentClientRetryPolicy> retryPolicyFactory, RxDocumentServiceRequest req, BiFunction<Supplier<DocumentClientRetryPolicy>, RxDocumentServiceRequest, Mono<T>> feedOperation, String collectionLink) {
                return RxDocumentClientImpl.this.executeFeedOperationWithAvailabilityStrategy(resourceType, operationType, retryPolicyFactory, req, feedOperation, collectionLink);
            }

            @Override
            public <T> CosmosItemSerializer getEffectiveItemSerializer(CosmosQueryRequestOptions queryRequestOptions) {
                return RxDocumentClientImpl.this.getEffectiveItemSerializer(queryRequestOptions);
            }

            @Override
            public Mono<RxDocumentServiceResponse> readFeedAsync(RxDocumentServiceRequest request) {
                return null;
            }

            @Override
            public Mono<RxDocumentServiceRequest> populateFeedRangeHeader(RxDocumentServiceRequest request) {
                if (RxDocumentClientImpl.this.requiresFeedRangeFiltering(request)) {
                    return request.getFeedRange().populateFeedRangeFilteringHeaders(RxDocumentClientImpl.this.partitionKeyRangeCache, request, RxDocumentClientImpl.this.collectionCache.resolveCollectionAsync(BridgeInternal.getMetaDataDiagnosticContext(request.requestContext.cosmosDiagnostics), request)).flatMap(ignore -> Mono.just((Object)request));
                }
                return Mono.just((Object)request);
            }

            @Override
            public Mono<RxDocumentServiceRequest> addPartitionLevelUnavailableRegionsOnRequest(RxDocumentServiceRequest request, CosmosQueryRequestOptions queryRequestOptions, DocumentClientRetryPolicy documentClientRetryPolicy) {
                if (RxDocumentClientImpl.this.globalPartitionEndpointManagerForCircuitBreaker.isPartitionLevelCircuitBreakingApplicable(request)) {
                    String collectionRid = qryOptAccessor.getCollectionRid(queryRequestOptions);
                    Preconditions.checkNotNull(collectionRid, "Argument 'collectionRid' cannot be null!");
                    return RxDocumentClientImpl.this.partitionKeyRangeCache.tryLookupAsync(BridgeInternal.getMetaDataDiagnosticContext(request.requestContext.cosmosDiagnostics), collectionRid, null, null).flatMap(collectionRoutingMapValueHolder -> {
                        if (collectionRoutingMapValueHolder.v == null) {
                            return Mono.error((Throwable)((Object)new CollectionRoutingMapNotFoundException("Argument 'collectionRoutingMapValueHolder.v' cannot be null!")));
                        }
                        RxDocumentClientImpl.this.addPartitionLevelUnavailableRegionsForFeedRequest(request, queryRequestOptions, (CollectionRoutingMap)collectionRoutingMapValueHolder.v);
                        if (documentClientRetryPolicy != null) {
                            documentClientRetryPolicy.onBeforeSendRequest(request);
                        }
                        return Mono.just((Object)request);
                    });
                }
                return Mono.just((Object)request);
            }

            @Override
            public GlobalEndpointManager getGlobalEndpointManager() {
                return RxDocumentClientImpl.this.getGlobalEndpointManager();
            }

            @Override
            public GlobalPartitionEndpointManagerForCircuitBreaker getGlobalPartitionEndpointManagerForCircuitBreaker() {
                return RxDocumentClientImpl.this.globalPartitionEndpointManagerForCircuitBreaker;
            }
        };
    }

    @Override
    public <T> Flux<FeedResponse<T>> queryDocuments(String collectionLink, SqlQuerySpec querySpec, QueryFeedOperationState state, Class<T> classOfT) {
        SqlQuerySpecLogger.getInstance().logQuery(querySpec);
        return this.createQuery(collectionLink, querySpec, state, classOfT, ResourceType.Document);
    }

    @Override
    public <T> Flux<FeedResponse<T>> queryDocumentChangeFeed(DocumentCollection collection, CosmosChangeFeedRequestOptions requestOptions, Class<T> classOfT) {
        Preconditions.checkNotNull(collection, "Argument 'collection' must not be null.");
        ChangeFeedQueryImpl<T> changeFeedQueryImpl = new ChangeFeedQueryImpl<T>(this, ResourceType.Document, classOfT, collection.getAltLink(), collection.getResourceId(), requestOptions);
        return changeFeedQueryImpl.executeAsync();
    }

    @Override
    public <T> Flux<FeedResponse<T>> queryDocumentChangeFeedFromPagedFlux(DocumentCollection collection, ChangeFeedOperationState state, Class<T> classOfT) {
        CosmosChangeFeedRequestOptions clonedOptions = changeFeedOptionsAccessor.clone(state.getChangeFeedOptions());
        CosmosChangeFeedRequestOptionsImpl optionsImpl = changeFeedOptionsAccessor.getImpl(clonedOptions);
        CosmosOperationDetails operationDetails = operationDetailsAccessor.create(optionsImpl, state.getDiagnosticsContextSnapshot());
        this.operationPolicies.forEach(policy -> {
            try {
                policy.process(operationDetails);
            }
            catch (RuntimeException exception) {
                logger.info("The following exception was thrown by a custom policy on changeFeed operation" + exception.getMessage());
                throw exception;
            }
        });
        ctxAccessor.setRequestOptions(state.getDiagnosticsContextSnapshot(), optionsImpl);
        return this.queryDocumentChangeFeed(collection, clonedOptions, classOfT);
    }

    @Override
    public <T> Flux<FeedResponse<T>> readAllDocuments(String collectionLink, PartitionKey partitionKey, QueryFeedOperationState state, Class<T> classOfT) {
        if (StringUtils.isEmpty(collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        if (partitionKey == null) {
            throw new IllegalArgumentException("partitionKey");
        }
        CosmosQueryRequestOptions effectiveOptions = qryOptAccessor.clone(state.getQueryOptions());
        RequestOptions nonNullRequestOptions = qryOptAccessor.toRequestOptions(effectiveOptions);
        CosmosEndToEndOperationLatencyPolicyConfig endToEndPolicyConfig = nonNullRequestOptions.getCosmosEndToEndLatencyPolicyConfig();
        List<String> orderedApplicableRegionsForSpeculation = this.getApplicableRegionsForSpeculation(endToEndPolicyConfig, ResourceType.Document, OperationType.Query, false, nonNullRequestOptions);
        ScopedDiagnosticsFactory diagnosticsFactory = new ScopedDiagnosticsFactory(this, false);
        if (orderedApplicableRegionsForSpeculation.size() < 2) {
            state.registerDiagnosticsFactory(() -> {}, ctx -> diagnosticsFactory.merge((CosmosDiagnosticsContext)ctx));
        } else {
            state.registerDiagnosticsFactory(() -> diagnosticsFactory.reset(), ctx -> diagnosticsFactory.merge((CosmosDiagnosticsContext)ctx));
        }
        RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)diagnosticsFactory, OperationType.Query, ResourceType.Document, collectionLink, null);
        Flux collectionObs = this.collectionCache.resolveCollectionAsync(null, request).flux();
        return collectionObs.flatMap(documentCollectionResourceResponse -> {
            DocumentCollection collection = (DocumentCollection)documentCollectionResourceResponse.v;
            if (collection == null) {
                return Mono.error((Throwable)new IllegalStateException("Collection cannot be null"));
            }
            PartitionKeyDefinition pkDefinition = collection.getPartitionKey();
            List<String> partitionKeySelectors = this.createPkSelectors(pkDefinition);
            SqlQuerySpec querySpec = RxDocumentClientImpl.createLogicalPartitionScanQuerySpec(partitionKey, partitionKeySelectors);
            String resourceLink = this.parentResourceLinkToQueryLink(collectionLink, ResourceType.Document);
            UUID activityId = RxDocumentClientImpl.randomUuid();
            AtomicBoolean isQueryCancelledOnTimeout = new AtomicBoolean(false);
            IDocumentQueryClient queryClient = this.documentQueryClientImpl(this, this.getOperationContextAndListenerTuple(state.getQueryOptions()));
            InvalidPartitionExceptionRetryPolicy invalidPartitionExceptionRetryPolicy = new InvalidPartitionExceptionRetryPolicy(this.collectionCache, null, resourceLink, ModelBridgeInternal.getPropertiesFromQueryRequestOptions(effectiveOptions));
            Flux innerFlux = ObservableHelper.fluxInlineIfPossibleAsObs(() -> {
                Flux valueHolderMono = this.partitionKeyRangeCache.tryLookupAsync(BridgeInternal.getMetaDataDiagnosticContext(request.requestContext.cosmosDiagnostics), collection.getResourceId(), null, null).flux();
                return valueHolderMono.flatMap(collectionRoutingMapValueHolder -> {
                    CollectionRoutingMap routingMap = (CollectionRoutingMap)collectionRoutingMapValueHolder.v;
                    if (routingMap == null) {
                        return Mono.error((Throwable)new IllegalStateException("Failed to get routing map."));
                    }
                    String effectivePartitionKeyString = PartitionKeyInternalHelper.getEffectivePartitionKeyString(BridgeInternal.getPartitionKeyInternal(partitionKey), pkDefinition);
                    PartitionKeyRange range = routingMap.getRangeByEffectivePartitionKey(effectivePartitionKeyString);
                    return this.createQueryInternal(diagnosticsFactory, resourceLink, querySpec, ModelBridgeInternal.setPartitionKeyRangeIdInternal(effectiveOptions, range.getId()), classOfT, ResourceType.Document, queryClient, activityId, isQueryCancelledOnTimeout);
                });
            }, invalidPartitionExceptionRetryPolicy);
            if (orderedApplicableRegionsForSpeculation.size() < 2) {
                return innerFlux;
            }
            return innerFlux.flatMap(result -> {
                diagnosticsFactory.merge(nonNullRequestOptions);
                return Mono.just((Object)result);
            }).onErrorMap(throwable -> {
                diagnosticsFactory.merge(nonNullRequestOptions);
                return throwable;
            }).doOnCancel(() -> diagnosticsFactory.merge(nonNullRequestOptions));
        });
    }

    @Override
    public Map<String, PartitionedQueryExecutionInfo> getQueryPlanCache() {
        return this.queryPlanCache;
    }

    @Override
    public Flux<FeedResponse<PartitionKeyRange>> readPartitionKeyRanges(String collectionLink, QueryFeedOperationState state) {
        if (StringUtils.isEmpty(collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        return this.nonDocumentReadFeed(state, ResourceType.PartitionKeyRange, PartitionKeyRange.class, Utils.joinPath(collectionLink, "pkranges"));
    }

    @Override
    public Flux<FeedResponse<PartitionKeyRange>> readPartitionKeyRanges(String collectionLink, CosmosQueryRequestOptions options) {
        if (StringUtils.isEmpty(collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        return this.nonDocumentReadFeed(options, ResourceType.PartitionKeyRange, PartitionKeyRange.class, Utils.joinPath(collectionLink, "pkranges"));
    }

    private RxDocumentServiceRequest getStoredProcedureRequest(String collectionLink, StoredProcedure storedProcedure, RequestOptions options, OperationType operationType) {
        if (StringUtils.isEmpty(collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        if (storedProcedure == null) {
            throw new IllegalArgumentException("storedProcedure");
        }
        RxDocumentClientImpl.validateResource(storedProcedure);
        String path = Utils.joinPath(collectionLink, "sprocs");
        Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.StoredProcedure, operationType);
        return RxDocumentServiceRequest.create((DiagnosticsClientContext)this, operationType, ResourceType.StoredProcedure, path, (Resource)storedProcedure, requestHeaders, (Object)options);
    }

    private RxDocumentServiceRequest getUserDefinedFunctionRequest(String collectionLink, UserDefinedFunction udf, RequestOptions options, OperationType operationType) {
        if (StringUtils.isEmpty(collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        if (udf == null) {
            throw new IllegalArgumentException("udf");
        }
        RxDocumentClientImpl.validateResource(udf);
        String path = Utils.joinPath(collectionLink, "udfs");
        Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.UserDefinedFunction, operationType);
        return RxDocumentServiceRequest.create((DiagnosticsClientContext)this, operationType, ResourceType.UserDefinedFunction, path, (Resource)udf, requestHeaders, (Object)options);
    }

    @Override
    public Mono<ResourceResponse<StoredProcedure>> createStoredProcedure(String collectionLink, StoredProcedure storedProcedure, RequestOptions options) {
        DocumentClientRetryPolicy requestRetryPolicy = this.resetSessionTokenRetryPolicy.getRequestPolicy(null);
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.createStoredProcedureInternal(collectionLink, storedProcedure, options, requestRetryPolicy), requestRetryPolicy);
    }

    private Mono<ResourceResponse<StoredProcedure>> createStoredProcedureInternal(String collectionLink, StoredProcedure storedProcedure, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            logger.debug("Creating a StoredProcedure. collectionLink: [{}], storedProcedure id [{}]", (Object)collectionLink, (Object)storedProcedure.getId());
            RxDocumentServiceRequest request = this.getStoredProcedureRequest(collectionLink, storedProcedure, options, OperationType.Create);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.create(request, retryPolicyInstance, this.getOperationContextAndListenerTuple(options)).map(response -> BridgeInternal.toResourceResponse(response, StoredProcedure.class));
        }
        catch (Exception e) {
            logger.debug("Failure in creating a StoredProcedure due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<StoredProcedure>> replaceStoredProcedure(StoredProcedure storedProcedure, RequestOptions options) {
        DocumentClientRetryPolicy requestRetryPolicy = this.resetSessionTokenRetryPolicy.getRequestPolicy(null);
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.replaceStoredProcedureInternal(storedProcedure, options, requestRetryPolicy), requestRetryPolicy);
    }

    private Mono<ResourceResponse<StoredProcedure>> replaceStoredProcedureInternal(StoredProcedure storedProcedure, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (storedProcedure == null) {
                throw new IllegalArgumentException("storedProcedure");
            }
            logger.debug("Replacing a StoredProcedure. storedProcedure id [{}]", (Object)storedProcedure.getId());
            RxDocumentClientImpl.validateResource(storedProcedure);
            String path = Utils.joinPath(storedProcedure.getSelfLink(), null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.StoredProcedure, OperationType.Replace);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.Replace, ResourceType.StoredProcedure, path, (Resource)storedProcedure, requestHeaders, (Object)options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.replace(request, retryPolicyInstance).map(response -> BridgeInternal.toResourceResponse(response, StoredProcedure.class));
        }
        catch (Exception e) {
            logger.debug("Failure in replacing a StoredProcedure due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<StoredProcedure>> deleteStoredProcedure(String storedProcedureLink, RequestOptions options) {
        DocumentClientRetryPolicy requestRetryPolicy = this.resetSessionTokenRetryPolicy.getRequestPolicy(null);
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.deleteStoredProcedureInternal(storedProcedureLink, options, requestRetryPolicy), requestRetryPolicy);
    }

    private Mono<ResourceResponse<StoredProcedure>> deleteStoredProcedureInternal(String storedProcedureLink, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty(storedProcedureLink)) {
                throw new IllegalArgumentException("storedProcedureLink");
            }
            logger.debug("Deleting a StoredProcedure. storedProcedureLink [{}]", (Object)storedProcedureLink);
            String path = Utils.joinPath(storedProcedureLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.StoredProcedure, OperationType.Delete);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.Delete, ResourceType.StoredProcedure, path, requestHeaders, options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.delete(request, retryPolicyInstance, this.getOperationContextAndListenerTuple(options)).map(response -> BridgeInternal.toResourceResponse(response, StoredProcedure.class));
        }
        catch (Exception e) {
            logger.debug("Failure in deleting a StoredProcedure due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<StoredProcedure>> readStoredProcedure(String storedProcedureLink, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy(null);
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.readStoredProcedureInternal(storedProcedureLink, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<StoredProcedure>> readStoredProcedureInternal(String storedProcedureLink, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty(storedProcedureLink)) {
                throw new IllegalArgumentException("storedProcedureLink");
            }
            logger.debug("Reading a StoredProcedure. storedProcedureLink [{}]", (Object)storedProcedureLink);
            String path = Utils.joinPath(storedProcedureLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.StoredProcedure, OperationType.Read);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.Read, ResourceType.StoredProcedure, path, requestHeaders, options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.read(request, retryPolicyInstance).map(response -> BridgeInternal.toResourceResponse(response, StoredProcedure.class));
        }
        catch (Exception e) {
            logger.debug("Failure in reading a StoredProcedure due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Flux<FeedResponse<StoredProcedure>> readStoredProcedures(String collectionLink, QueryFeedOperationState state) {
        if (StringUtils.isEmpty(collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        return this.nonDocumentReadFeed(state, ResourceType.StoredProcedure, StoredProcedure.class, Utils.joinPath(collectionLink, "sprocs"));
    }

    @Override
    public Flux<FeedResponse<StoredProcedure>> queryStoredProcedures(String collectionLink, String query, QueryFeedOperationState state) {
        return this.queryStoredProcedures(collectionLink, new SqlQuerySpec(query), state);
    }

    @Override
    public Flux<FeedResponse<StoredProcedure>> queryStoredProcedures(String collectionLink, SqlQuerySpec querySpec, QueryFeedOperationState state) {
        return this.createQuery(collectionLink, querySpec, state, StoredProcedure.class, ResourceType.StoredProcedure);
    }

    @Override
    public Mono<StoredProcedureResponse> executeStoredProcedure(String storedProcedureLink, RequestOptions options, List<Object> procedureParams) {
        DocumentClientRetryPolicy documentClientRetryPolicy = this.resetSessionTokenRetryPolicy.getRequestPolicy(null);
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.executeStoredProcedureInternal(storedProcedureLink, options, procedureParams, documentClientRetryPolicy), documentClientRetryPolicy);
    }

    @Override
    public Mono<CosmosBatchResponse> executeBatchRequest(String collectionLink, ServerBatchRequest serverBatchRequest, RequestOptions options, boolean disableAutomaticIdGeneration) {
        AtomicReference<RxDocumentServiceRequest> requestReference = new AtomicReference<RxDocumentServiceRequest>();
        RequestOptions nonNullRequestOptions = options != null ? options : new RequestOptions();
        CosmosEndToEndOperationLatencyPolicyConfig endToEndPolicyConfig = this.getEndToEndOperationLatencyPolicyConfig(nonNullRequestOptions, ResourceType.Document, OperationType.Batch);
        ScopedDiagnosticsFactory scopedDiagnosticsFactory = new ScopedDiagnosticsFactory(this, false);
        DocumentClientRetryPolicy documentClientRetryPolicy = this.resetSessionTokenRetryPolicy.getRequestPolicy(scopedDiagnosticsFactory);
        return this.handleCircuitBreakingFeedbackForPointOperation(RxDocumentClientImpl.getPointOperationResponseMonoWithE2ETimeout(nonNullRequestOptions, endToEndPolicyConfig, ObservableHelper.inlineIfPossibleAsObs(() -> this.executeBatchRequestInternal(collectionLink, serverBatchRequest, options, documentClientRetryPolicy, disableAutomaticIdGeneration, requestReference), documentClientRetryPolicy), scopedDiagnosticsFactory), requestReference);
    }

    private Mono<StoredProcedureResponse> executeStoredProcedureInternal(String storedProcedureLink, RequestOptions options, List<Object> procedureParams, DocumentClientRetryPolicy retryPolicy) {
        try {
            logger.debug("Executing a StoredProcedure. storedProcedureLink [{}]", (Object)storedProcedureLink);
            String path = Utils.joinPath(storedProcedureLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.StoredProcedure, OperationType.ExecuteJavaScript);
            requestHeaders.put("Accept", "application/json");
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.ExecuteJavaScript, ResourceType.StoredProcedure, path, procedureParams != null && !procedureParams.isEmpty() ? RxDocumentClientImpl.serializeProcedureParams(procedureParams) : "", requestHeaders, (Object)options);
            if (options != null) {
                request.requestContext.setExcludeRegions(options.getExcludedRegions());
                request.requestContext.setKeywordIdentifiers(options.getKeywordIdentifiers());
            }
            if (retryPolicy != null) {
                retryPolicy.onBeforeSendRequest(request);
            }
            Mono<RxDocumentServiceRequest> reqObs = this.addPartitionKeyInformation(request, null, null, options);
            return reqObs.flatMap(req -> this.create(request, retryPolicy, this.getOperationContextAndListenerTuple(options)).map(response -> {
                this.captureSessionToken(request, (RxDocumentServiceResponse)response);
                return BridgeInternal.toStoredProcedureResponse(response);
            }));
        }
        catch (Exception e) {
            logger.debug("Failure in executing a StoredProcedure due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    private Mono<CosmosBatchResponse> executeBatchRequestInternal(String collectionLink, ServerBatchRequest serverBatchRequest, RequestOptions options, DocumentClientRetryPolicy requestRetryPolicy, boolean disableAutomaticIdGeneration, AtomicReference<RxDocumentServiceRequest> requestReference) {
        try {
            logger.debug("Executing a Batch request with number of operations {}", (Object)serverBatchRequest.getOperations().size());
            Mono<RxDocumentServiceRequest> requestObs = this.getBatchDocumentRequest(requestRetryPolicy, collectionLink, serverBatchRequest, options, disableAutomaticIdGeneration);
            Mono responseObservable = requestObs.flatMap(request -> {
                requestReference.set((RxDocumentServiceRequest)request);
                return this.create((RxDocumentServiceRequest)request, requestRetryPolicy, this.getOperationContextAndListenerTuple(options));
            });
            return responseObservable.map(serviceResponse -> BatchResponseParser.fromDocumentServiceResponse(serviceResponse, serverBatchRequest, true));
        }
        catch (Exception ex) {
            logger.debug("Failure in executing a batch due to [{}]", (Object)ex.getMessage(), (Object)ex);
            return Mono.error((Throwable)ex);
        }
    }

    @Override
    public Mono<ResourceResponse<Trigger>> createTrigger(String collectionLink, Trigger trigger, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy(null);
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.createTriggerInternal(collectionLink, trigger, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<Trigger>> createTriggerInternal(String collectionLink, Trigger trigger, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            logger.debug("Creating a Trigger. collectionLink [{}], trigger id [{}]", (Object)collectionLink, (Object)trigger.getId());
            RxDocumentServiceRequest request = this.getTriggerRequest(collectionLink, trigger, options, OperationType.Create);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.create(request, retryPolicyInstance, this.getOperationContextAndListenerTuple(options)).map(response -> BridgeInternal.toResourceResponse(response, Trigger.class));
        }
        catch (Exception e) {
            logger.debug("Failure in creating a Trigger due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    private RxDocumentServiceRequest getTriggerRequest(String collectionLink, Trigger trigger, RequestOptions options, OperationType operationType) {
        if (StringUtils.isEmpty(collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        if (trigger == null) {
            throw new IllegalArgumentException("trigger");
        }
        RxDocumentClientImpl.validateResource(trigger);
        String path = Utils.joinPath(collectionLink, "triggers");
        Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.Trigger, operationType);
        return RxDocumentServiceRequest.create((DiagnosticsClientContext)this, operationType, ResourceType.Trigger, path, (Resource)trigger, requestHeaders, (Object)options);
    }

    @Override
    public Mono<ResourceResponse<Trigger>> replaceTrigger(Trigger trigger, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy(null);
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.replaceTriggerInternal(trigger, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<Trigger>> replaceTriggerInternal(Trigger trigger, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (trigger == null) {
                throw new IllegalArgumentException("trigger");
            }
            logger.debug("Replacing a Trigger. trigger id [{}]", (Object)trigger.getId());
            RxDocumentClientImpl.validateResource(trigger);
            String path = Utils.joinPath(trigger.getSelfLink(), null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.Trigger, OperationType.Replace);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.Replace, ResourceType.Trigger, path, (Resource)trigger, requestHeaders, (Object)options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.replace(request, retryPolicyInstance).map(response -> BridgeInternal.toResourceResponse(response, Trigger.class));
        }
        catch (Exception e) {
            logger.debug("Failure in replacing a Trigger due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<Trigger>> deleteTrigger(String triggerLink, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy(null);
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.deleteTriggerInternal(triggerLink, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<Trigger>> deleteTriggerInternal(String triggerLink, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty(triggerLink)) {
                throw new IllegalArgumentException("triggerLink");
            }
            logger.debug("Deleting a Trigger. triggerLink [{}]", (Object)triggerLink);
            String path = Utils.joinPath(triggerLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.Trigger, OperationType.Delete);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.Delete, ResourceType.Trigger, path, requestHeaders, options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.delete(request, retryPolicyInstance, this.getOperationContextAndListenerTuple(options)).map(response -> BridgeInternal.toResourceResponse(response, Trigger.class));
        }
        catch (Exception e) {
            logger.debug("Failure in deleting a Trigger due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<Trigger>> readTrigger(String triggerLink, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy(null);
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.readTriggerInternal(triggerLink, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<Trigger>> readTriggerInternal(String triggerLink, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty(triggerLink)) {
                throw new IllegalArgumentException("triggerLink");
            }
            logger.debug("Reading a Trigger. triggerLink [{}]", (Object)triggerLink);
            String path = Utils.joinPath(triggerLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.Trigger, OperationType.Read);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.Read, ResourceType.Trigger, path, requestHeaders, options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.read(request, retryPolicyInstance).map(response -> BridgeInternal.toResourceResponse(response, Trigger.class));
        }
        catch (Exception e) {
            logger.debug("Failure in reading a Trigger due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Flux<FeedResponse<Trigger>> readTriggers(String collectionLink, QueryFeedOperationState state) {
        if (StringUtils.isEmpty(collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        return this.nonDocumentReadFeed(state, ResourceType.Trigger, Trigger.class, Utils.joinPath(collectionLink, "triggers"));
    }

    @Override
    public Flux<FeedResponse<Trigger>> queryTriggers(String collectionLink, String query, QueryFeedOperationState state) {
        return this.queryTriggers(collectionLink, new SqlQuerySpec(query), state);
    }

    @Override
    public Flux<FeedResponse<Trigger>> queryTriggers(String collectionLink, SqlQuerySpec querySpec, QueryFeedOperationState state) {
        return this.createQuery(collectionLink, querySpec, state, Trigger.class, ResourceType.Trigger);
    }

    @Override
    public Mono<ResourceResponse<UserDefinedFunction>> createUserDefinedFunction(String collectionLink, UserDefinedFunction udf, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy(null);
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.createUserDefinedFunctionInternal(collectionLink, udf, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<UserDefinedFunction>> createUserDefinedFunctionInternal(String collectionLink, UserDefinedFunction udf, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            logger.debug("Creating a UserDefinedFunction. collectionLink [{}], udf id [{}]", (Object)collectionLink, (Object)udf.getId());
            RxDocumentServiceRequest request = this.getUserDefinedFunctionRequest(collectionLink, udf, options, OperationType.Create);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.create(request, retryPolicyInstance, this.getOperationContextAndListenerTuple(options)).map(response -> BridgeInternal.toResourceResponse(response, UserDefinedFunction.class));
        }
        catch (Exception e) {
            logger.debug("Failure in creating a UserDefinedFunction due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<UserDefinedFunction>> replaceUserDefinedFunction(UserDefinedFunction udf, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy(null);
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.replaceUserDefinedFunctionInternal(udf, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<UserDefinedFunction>> replaceUserDefinedFunctionInternal(UserDefinedFunction udf, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (udf == null) {
                throw new IllegalArgumentException("udf");
            }
            logger.debug("Replacing a UserDefinedFunction. udf id [{}]", (Object)udf.getId());
            RxDocumentClientImpl.validateResource(udf);
            String path = Utils.joinPath(udf.getSelfLink(), null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.UserDefinedFunction, OperationType.Replace);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.Replace, ResourceType.UserDefinedFunction, path, (Resource)udf, requestHeaders, (Object)options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.replace(request, retryPolicyInstance).map(response -> BridgeInternal.toResourceResponse(response, UserDefinedFunction.class));
        }
        catch (Exception e) {
            logger.debug("Failure in replacing a UserDefinedFunction due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<UserDefinedFunction>> deleteUserDefinedFunction(String udfLink, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy(null);
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.deleteUserDefinedFunctionInternal(udfLink, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<UserDefinedFunction>> deleteUserDefinedFunctionInternal(String udfLink, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty(udfLink)) {
                throw new IllegalArgumentException("udfLink");
            }
            logger.debug("Deleting a UserDefinedFunction. udfLink [{}]", (Object)udfLink);
            String path = Utils.joinPath(udfLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.UserDefinedFunction, OperationType.Delete);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.Delete, ResourceType.UserDefinedFunction, path, requestHeaders, options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.delete(request, retryPolicyInstance, this.getOperationContextAndListenerTuple(options)).map(response -> BridgeInternal.toResourceResponse(response, UserDefinedFunction.class));
        }
        catch (Exception e) {
            logger.debug("Failure in deleting a UserDefinedFunction due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<UserDefinedFunction>> readUserDefinedFunction(String udfLink, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy(null);
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.readUserDefinedFunctionInternal(udfLink, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<UserDefinedFunction>> readUserDefinedFunctionInternal(String udfLink, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty(udfLink)) {
                throw new IllegalArgumentException("udfLink");
            }
            logger.debug("Reading a UserDefinedFunction. udfLink [{}]", (Object)udfLink);
            String path = Utils.joinPath(udfLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.UserDefinedFunction, OperationType.Read);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.Read, ResourceType.UserDefinedFunction, path, requestHeaders, options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.read(request, retryPolicyInstance).map(response -> BridgeInternal.toResourceResponse(response, UserDefinedFunction.class));
        }
        catch (Exception e) {
            logger.debug("Failure in reading a UserDefinedFunction due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Flux<FeedResponse<UserDefinedFunction>> readUserDefinedFunctions(String collectionLink, QueryFeedOperationState state) {
        if (StringUtils.isEmpty(collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        return this.nonDocumentReadFeed(state, ResourceType.UserDefinedFunction, UserDefinedFunction.class, Utils.joinPath(collectionLink, "udfs"));
    }

    @Override
    public Flux<FeedResponse<UserDefinedFunction>> queryUserDefinedFunctions(String collectionLink, String query, QueryFeedOperationState state) {
        return this.queryUserDefinedFunctions(collectionLink, new SqlQuerySpec(query), state);
    }

    @Override
    public Flux<FeedResponse<UserDefinedFunction>> queryUserDefinedFunctions(String collectionLink, SqlQuerySpec querySpec, QueryFeedOperationState state) {
        return this.createQuery(collectionLink, querySpec, state, UserDefinedFunction.class, ResourceType.UserDefinedFunction);
    }

    @Override
    public Mono<ResourceResponse<Conflict>> readConflict(String conflictLink, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy(null);
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.readConflictInternal(conflictLink, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<Conflict>> readConflictInternal(String conflictLink, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty(conflictLink)) {
                throw new IllegalArgumentException("conflictLink");
            }
            logger.debug("Reading a Conflict. conflictLink [{}]", (Object)conflictLink);
            String path = Utils.joinPath(conflictLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.Conflict, OperationType.Read);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.Read, ResourceType.Conflict, path, requestHeaders, options);
            Mono<RxDocumentServiceRequest> reqObs = this.addPartitionKeyInformation(request, null, null, options);
            return reqObs.flatMap(req -> {
                if (retryPolicyInstance != null) {
                    retryPolicyInstance.onBeforeSendRequest(request);
                }
                return this.read(request, retryPolicyInstance).map(response -> BridgeInternal.toResourceResponse(response, Conflict.class));
            });
        }
        catch (Exception e) {
            logger.debug("Failure in reading a Conflict due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Flux<FeedResponse<Conflict>> readConflicts(String collectionLink, QueryFeedOperationState state) {
        if (StringUtils.isEmpty(collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        return this.nonDocumentReadFeed(state, ResourceType.Conflict, Conflict.class, Utils.joinPath(collectionLink, "conflicts"));
    }

    @Override
    public Flux<FeedResponse<Conflict>> queryConflicts(String collectionLink, String query, QueryFeedOperationState state) {
        return this.queryConflicts(collectionLink, new SqlQuerySpec(query), state);
    }

    @Override
    public Flux<FeedResponse<Conflict>> queryConflicts(String collectionLink, SqlQuerySpec querySpec, QueryFeedOperationState state) {
        return this.createQuery(collectionLink, querySpec, state, Conflict.class, ResourceType.Conflict);
    }

    @Override
    public Mono<ResourceResponse<Conflict>> deleteConflict(String conflictLink, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy(null);
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.deleteConflictInternal(conflictLink, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<Conflict>> deleteConflictInternal(String conflictLink, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty(conflictLink)) {
                throw new IllegalArgumentException("conflictLink");
            }
            logger.debug("Deleting a Conflict. conflictLink [{}]", (Object)conflictLink);
            String path = Utils.joinPath(conflictLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.Conflict, OperationType.Delete);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.Delete, ResourceType.Conflict, path, requestHeaders, options);
            Mono<RxDocumentServiceRequest> reqObs = this.addPartitionKeyInformation(request, null, null, options);
            return reqObs.flatMap(req -> {
                if (retryPolicyInstance != null) {
                    retryPolicyInstance.onBeforeSendRequest(request);
                }
                return this.delete(request, retryPolicyInstance, this.getOperationContextAndListenerTuple(options)).map(response -> BridgeInternal.toResourceResponse(response, Conflict.class));
            });
        }
        catch (Exception e) {
            logger.debug("Failure in deleting a Conflict due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<User>> createUser(String databaseLink, User user, RequestOptions options) {
        DocumentClientRetryPolicy documentClientRetryPolicy = this.resetSessionTokenRetryPolicy.getRequestPolicy(null);
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.createUserInternal(databaseLink, user, options, documentClientRetryPolicy), documentClientRetryPolicy);
    }

    private Mono<ResourceResponse<User>> createUserInternal(String databaseLink, User user, RequestOptions options, DocumentClientRetryPolicy documentClientRetryPolicy) {
        try {
            logger.debug("Creating a User. databaseLink [{}], user id [{}]", (Object)databaseLink, (Object)user.getId());
            RxDocumentServiceRequest request = this.getUserRequest(databaseLink, user, options, OperationType.Create);
            return this.create(request, documentClientRetryPolicy, this.getOperationContextAndListenerTuple(options)).map(response -> BridgeInternal.toResourceResponse(response, User.class));
        }
        catch (Exception e) {
            logger.debug("Failure in creating a User due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<User>> upsertUser(String databaseLink, User user, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy(null);
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.upsertUserInternal(databaseLink, user, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<User>> upsertUserInternal(String databaseLink, User user, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            logger.debug("Upserting a User. databaseLink [{}], user id [{}]", (Object)databaseLink, (Object)user.getId());
            RxDocumentServiceRequest request = this.getUserRequest(databaseLink, user, options, OperationType.Upsert);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.upsert(request, retryPolicyInstance, this.getOperationContextAndListenerTuple(options)).map(response -> BridgeInternal.toResourceResponse(response, User.class));
        }
        catch (Exception e) {
            logger.debug("Failure in upserting a User due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    private RxDocumentServiceRequest getUserRequest(String databaseLink, User user, RequestOptions options, OperationType operationType) {
        if (StringUtils.isEmpty(databaseLink)) {
            throw new IllegalArgumentException("databaseLink");
        }
        if (user == null) {
            throw new IllegalArgumentException("user");
        }
        RxDocumentClientImpl.validateResource(user);
        String path = Utils.joinPath(databaseLink, "users");
        Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.User, operationType);
        return RxDocumentServiceRequest.create((DiagnosticsClientContext)this, operationType, ResourceType.User, path, (Resource)user, requestHeaders, (Object)options);
    }

    @Override
    public Mono<ResourceResponse<User>> replaceUser(User user, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy(null);
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.replaceUserInternal(user, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<User>> replaceUserInternal(User user, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (user == null) {
                throw new IllegalArgumentException("user");
            }
            logger.debug("Replacing a User. user id [{}]", (Object)user.getId());
            RxDocumentClientImpl.validateResource(user);
            String path = Utils.joinPath(user.getSelfLink(), null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.User, OperationType.Replace);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.Replace, ResourceType.User, path, (Resource)user, requestHeaders, (Object)options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.replace(request, retryPolicyInstance).map(response -> BridgeInternal.toResourceResponse(response, User.class));
        }
        catch (Exception e) {
            logger.debug("Failure in replacing a User due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<User>> deleteUser(String userLink, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy(null);
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.deleteUserInternal(userLink, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<User>> deleteUserInternal(String userLink, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty(userLink)) {
                throw new IllegalArgumentException("userLink");
            }
            logger.debug("Deleting a User. userLink [{}]", (Object)userLink);
            String path = Utils.joinPath(userLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.User, OperationType.Delete);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.Delete, ResourceType.User, path, requestHeaders, options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.delete(request, retryPolicyInstance, this.getOperationContextAndListenerTuple(options)).map(response -> BridgeInternal.toResourceResponse(response, User.class));
        }
        catch (Exception e) {
            logger.debug("Failure in deleting a User due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<User>> readUser(String userLink, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy(null);
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.readUserInternal(userLink, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<User>> readUserInternal(String userLink, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty(userLink)) {
                throw new IllegalArgumentException("userLink");
            }
            logger.debug("Reading a User. userLink [{}]", (Object)userLink);
            String path = Utils.joinPath(userLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.User, OperationType.Read);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.Read, ResourceType.User, path, requestHeaders, options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.read(request, retryPolicyInstance).map(response -> BridgeInternal.toResourceResponse(response, User.class));
        }
        catch (Exception e) {
            logger.debug("Failure in reading a User due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Flux<FeedResponse<User>> readUsers(String databaseLink, QueryFeedOperationState state) {
        if (StringUtils.isEmpty(databaseLink)) {
            throw new IllegalArgumentException("databaseLink");
        }
        return this.nonDocumentReadFeed(state, ResourceType.User, User.class, Utils.joinPath(databaseLink, "users"));
    }

    @Override
    public Flux<FeedResponse<User>> queryUsers(String databaseLink, String query, QueryFeedOperationState state) {
        return this.queryUsers(databaseLink, new SqlQuerySpec(query), state);
    }

    @Override
    public Flux<FeedResponse<User>> queryUsers(String databaseLink, SqlQuerySpec querySpec, QueryFeedOperationState state) {
        return this.createQuery(databaseLink, querySpec, state, User.class, ResourceType.User);
    }

    @Override
    public Mono<ResourceResponse<ClientEncryptionKey>> readClientEncryptionKey(String clientEncryptionKeyLink, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy(null);
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.readClientEncryptionKeyInternal(clientEncryptionKeyLink, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<ClientEncryptionKey>> readClientEncryptionKeyInternal(String clientEncryptionKeyLink, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty(clientEncryptionKeyLink)) {
                throw new IllegalArgumentException("clientEncryptionKeyLink");
            }
            logger.debug("Reading a client encryption key. clientEncryptionKeyLink [{}]", (Object)clientEncryptionKeyLink);
            String path = Utils.joinPath(clientEncryptionKeyLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.ClientEncryptionKey, OperationType.Read);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.Read, ResourceType.ClientEncryptionKey, path, requestHeaders, options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.read(request, retryPolicyInstance).map(response -> BridgeInternal.toResourceResponse(response, ClientEncryptionKey.class));
        }
        catch (Exception e) {
            logger.debug("Failure in reading a client encryption key due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<ClientEncryptionKey>> createClientEncryptionKey(String databaseLink, ClientEncryptionKey clientEncryptionKey, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy(null);
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.createClientEncryptionKeyInternal(databaseLink, clientEncryptionKey, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<ClientEncryptionKey>> createClientEncryptionKeyInternal(String databaseLink, ClientEncryptionKey clientEncryptionKey, RequestOptions options, DocumentClientRetryPolicy documentClientRetryPolicy) {
        try {
            logger.debug("Creating a client encryption key. databaseLink [{}], clientEncryptionKey id [{}]", (Object)databaseLink, (Object)clientEncryptionKey.getId());
            RxDocumentServiceRequest request = this.getClientEncryptionKeyRequest(databaseLink, clientEncryptionKey, options, OperationType.Create);
            return this.create(request, documentClientRetryPolicy, this.getOperationContextAndListenerTuple(options)).map(response -> BridgeInternal.toResourceResponse(response, ClientEncryptionKey.class));
        }
        catch (Exception e) {
            logger.debug("Failure in creating a client encryption key due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    private RxDocumentServiceRequest getClientEncryptionKeyRequest(String databaseLink, ClientEncryptionKey clientEncryptionKey, RequestOptions options, OperationType operationType) {
        if (StringUtils.isEmpty(databaseLink)) {
            throw new IllegalArgumentException("databaseLink");
        }
        if (clientEncryptionKey == null) {
            throw new IllegalArgumentException("clientEncryptionKey");
        }
        RxDocumentClientImpl.validateResource(clientEncryptionKey);
        String path = Utils.joinPath(databaseLink, "clientencryptionkeys");
        Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.ClientEncryptionKey, operationType);
        return RxDocumentServiceRequest.create((DiagnosticsClientContext)this, operationType, ResourceType.ClientEncryptionKey, path, (Resource)clientEncryptionKey, requestHeaders, (Object)options);
    }

    @Override
    public Mono<ResourceResponse<ClientEncryptionKey>> replaceClientEncryptionKey(ClientEncryptionKey clientEncryptionKey, String nameBasedLink, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy(null);
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.replaceClientEncryptionKeyInternal(clientEncryptionKey, nameBasedLink, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<ClientEncryptionKey>> replaceClientEncryptionKeyInternal(ClientEncryptionKey clientEncryptionKey, String nameBasedLink, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (clientEncryptionKey == null) {
                throw new IllegalArgumentException("clientEncryptionKey");
            }
            logger.debug("Replacing a clientEncryptionKey. clientEncryptionKey id [{}]", (Object)clientEncryptionKey.getId());
            RxDocumentClientImpl.validateResource(clientEncryptionKey);
            String path = Utils.joinPath(nameBasedLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.ClientEncryptionKey, OperationType.Replace);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.Replace, ResourceType.ClientEncryptionKey, path, (Resource)clientEncryptionKey, requestHeaders, (Object)options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.replace(request, retryPolicyInstance).map(response -> BridgeInternal.toResourceResponse(response, ClientEncryptionKey.class));
        }
        catch (Exception e) {
            logger.debug("Failure in replacing a clientEncryptionKey due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Flux<FeedResponse<ClientEncryptionKey>> readClientEncryptionKeys(String databaseLink, QueryFeedOperationState state) {
        if (StringUtils.isEmpty(databaseLink)) {
            throw new IllegalArgumentException("databaseLink");
        }
        return this.nonDocumentReadFeed(state, ResourceType.ClientEncryptionKey, ClientEncryptionKey.class, Utils.joinPath(databaseLink, "clientencryptionkeys"));
    }

    @Override
    public Flux<FeedResponse<ClientEncryptionKey>> queryClientEncryptionKeys(String databaseLink, SqlQuerySpec querySpec, QueryFeedOperationState state) {
        return this.createQuery(databaseLink, querySpec, state, ClientEncryptionKey.class, ResourceType.ClientEncryptionKey);
    }

    @Override
    public Mono<ResourceResponse<Permission>> createPermission(String userLink, Permission permission, RequestOptions options) {
        DocumentClientRetryPolicy documentClientRetryPolicy = this.resetSessionTokenRetryPolicy.getRequestPolicy(null);
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.createPermissionInternal(userLink, permission, options, documentClientRetryPolicy), this.resetSessionTokenRetryPolicy.getRequestPolicy(null));
    }

    private Mono<ResourceResponse<Permission>> createPermissionInternal(String userLink, Permission permission, RequestOptions options, DocumentClientRetryPolicy documentClientRetryPolicy) {
        try {
            logger.debug("Creating a Permission. userLink [{}], permission id [{}]", (Object)userLink, (Object)permission.getId());
            RxDocumentServiceRequest request = this.getPermissionRequest(userLink, permission, options, OperationType.Create);
            return this.create(request, documentClientRetryPolicy, this.getOperationContextAndListenerTuple(options)).map(response -> BridgeInternal.toResourceResponse(response, Permission.class));
        }
        catch (Exception e) {
            logger.debug("Failure in creating a Permission due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<Permission>> upsertPermission(String userLink, Permission permission, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy(null);
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.upsertPermissionInternal(userLink, permission, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<Permission>> upsertPermissionInternal(String userLink, Permission permission, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            logger.debug("Upserting a Permission. userLink [{}], permission id [{}]", (Object)userLink, (Object)permission.getId());
            RxDocumentServiceRequest request = this.getPermissionRequest(userLink, permission, options, OperationType.Upsert);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.upsert(request, retryPolicyInstance, this.getOperationContextAndListenerTuple(options)).map(response -> BridgeInternal.toResourceResponse(response, Permission.class));
        }
        catch (Exception e) {
            logger.debug("Failure in upserting a Permission due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    private RxDocumentServiceRequest getPermissionRequest(String userLink, Permission permission, RequestOptions options, OperationType operationType) {
        if (StringUtils.isEmpty(userLink)) {
            throw new IllegalArgumentException("userLink");
        }
        if (permission == null) {
            throw new IllegalArgumentException("permission");
        }
        RxDocumentClientImpl.validateResource(permission);
        String path = Utils.joinPath(userLink, "permissions");
        Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.Permission, operationType);
        return RxDocumentServiceRequest.create((DiagnosticsClientContext)this, operationType, ResourceType.Permission, path, (Resource)permission, requestHeaders, (Object)options);
    }

    @Override
    public Mono<ResourceResponse<Permission>> replacePermission(Permission permission, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy(null);
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.replacePermissionInternal(permission, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<Permission>> replacePermissionInternal(Permission permission, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (permission == null) {
                throw new IllegalArgumentException("permission");
            }
            logger.debug("Replacing a Permission. permission id [{}]", (Object)permission.getId());
            RxDocumentClientImpl.validateResource(permission);
            String path = Utils.joinPath(permission.getSelfLink(), null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.Permission, OperationType.Replace);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.Replace, ResourceType.Permission, path, (Resource)permission, requestHeaders, (Object)options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.replace(request, retryPolicyInstance).map(response -> BridgeInternal.toResourceResponse(response, Permission.class));
        }
        catch (Exception e) {
            logger.debug("Failure in replacing a Permission due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<Permission>> deletePermission(String permissionLink, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy(null);
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.deletePermissionInternal(permissionLink, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<Permission>> deletePermissionInternal(String permissionLink, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty(permissionLink)) {
                throw new IllegalArgumentException("permissionLink");
            }
            logger.debug("Deleting a Permission. permissionLink [{}]", (Object)permissionLink);
            String path = Utils.joinPath(permissionLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.Permission, OperationType.Delete);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.Delete, ResourceType.Permission, path, requestHeaders, options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.delete(request, retryPolicyInstance, this.getOperationContextAndListenerTuple(options)).map(response -> BridgeInternal.toResourceResponse(response, Permission.class));
        }
        catch (Exception e) {
            logger.debug("Failure in deleting a Permission due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<Permission>> readPermission(String permissionLink, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy(null);
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.readPermissionInternal(permissionLink, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<Permission>> readPermissionInternal(String permissionLink, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty(permissionLink)) {
                throw new IllegalArgumentException("permissionLink");
            }
            logger.debug("Reading a Permission. permissionLink [{}]", (Object)permissionLink);
            String path = Utils.joinPath(permissionLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.Permission, OperationType.Read);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.Read, ResourceType.Permission, path, requestHeaders, options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.read(request, retryPolicyInstance).map(response -> BridgeInternal.toResourceResponse(response, Permission.class));
        }
        catch (Exception e) {
            logger.debug("Failure in reading a Permission due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Flux<FeedResponse<Permission>> readPermissions(String userLink, QueryFeedOperationState state) {
        if (StringUtils.isEmpty(userLink)) {
            throw new IllegalArgumentException("userLink");
        }
        return this.nonDocumentReadFeed(state, ResourceType.Permission, Permission.class, Utils.joinPath(userLink, "permissions"));
    }

    @Override
    public Flux<FeedResponse<Permission>> queryPermissions(String userLink, String query, QueryFeedOperationState state) {
        return this.queryPermissions(userLink, new SqlQuerySpec(query), state);
    }

    @Override
    public Flux<FeedResponse<Permission>> queryPermissions(String userLink, SqlQuerySpec querySpec, QueryFeedOperationState state) {
        return this.createQuery(userLink, querySpec, state, Permission.class, ResourceType.Permission);
    }

    @Override
    public Mono<ResourceResponse<Offer>> replaceOffer(Offer offer) {
        DocumentClientRetryPolicy documentClientRetryPolicy = this.resetSessionTokenRetryPolicy.getRequestPolicy(null);
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.replaceOfferInternal(offer, documentClientRetryPolicy), documentClientRetryPolicy);
    }

    private Mono<ResourceResponse<Offer>> replaceOfferInternal(Offer offer, DocumentClientRetryPolicy documentClientRetryPolicy) {
        try {
            if (offer == null) {
                throw new IllegalArgumentException("offer");
            }
            logger.debug("Replacing an Offer. offer id [{}]", (Object)offer.getId());
            RxDocumentClientImpl.validateResource(offer);
            String path = Utils.joinPath(offer.getSelfLink(), null);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.Replace, ResourceType.Offer, path, (Resource)offer, null, null);
            return this.replace(request, documentClientRetryPolicy).map(response -> BridgeInternal.toResourceResponse(response, Offer.class));
        }
        catch (Exception e) {
            logger.debug("Failure in replacing an Offer due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<Offer>> readOffer(String offerLink) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy(null);
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.readOfferInternal(offerLink, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<Offer>> readOfferInternal(String offerLink, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty(offerLink)) {
                throw new IllegalArgumentException("offerLink");
            }
            logger.debug("Reading an Offer. offerLink [{}]", (Object)offerLink);
            String path = Utils.joinPath(offerLink, null);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.Read, ResourceType.Offer, path, (Map<String, String>)null, null);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.read(request, retryPolicyInstance).map(response -> BridgeInternal.toResourceResponse(response, Offer.class));
        }
        catch (Exception e) {
            logger.debug("Failure in reading an Offer due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Flux<FeedResponse<Offer>> readOffers(QueryFeedOperationState state) {
        return this.nonDocumentReadFeed(state, ResourceType.Offer, Offer.class, Utils.joinPath("offers", null));
    }

    private <T> Flux<FeedResponse<T>> nonDocumentReadFeed(QueryFeedOperationState state, ResourceType resourceType, Class<T> klass, String resourceLink) {
        return this.nonDocumentReadFeed(state.getQueryOptions(), resourceType, klass, resourceLink);
    }

    private <T> Flux<FeedResponse<T>> nonDocumentReadFeed(CosmosQueryRequestOptions options, ResourceType resourceType, Class<T> klass, String resourceLink) {
        DocumentClientRetryPolicy retryPolicy = this.resetSessionTokenRetryPolicy.getRequestPolicy(null);
        return ObservableHelper.fluxInlineIfPossibleAsObs(() -> this.nonDocumentReadFeedInternal(options, resourceType, klass, resourceLink, retryPolicy), retryPolicy);
    }

    private <T> Flux<FeedResponse<T>> nonDocumentReadFeedInternal(CosmosQueryRequestOptions options, ResourceType resourceType, Class<T> klass, String resourceLink, DocumentClientRetryPolicy retryPolicy) {
        int maxPageSize;
        CosmosQueryRequestOptions nonNullOptions = options != null ? options : new CosmosQueryRequestOptions();
        Integer maxItemCount = ModelBridgeInternal.getMaxItemCountFromQueryRequestOptions(nonNullOptions);
        int n = maxPageSize = maxItemCount != null ? maxItemCount : -1;
        assert (resourceType != ResourceType.Document);
        BiFunction<String, Integer, RxDocumentServiceRequest> createRequestFunc = (continuationToken, pageSize) -> {
            HashMap<String, String> requestHeaders = new HashMap<String, String>();
            if (continuationToken != null) {
                requestHeaders.put("x-ms-continuation", (String)continuationToken);
            }
            requestHeaders.put("x-ms-max-item-count", Integer.toString(pageSize));
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.ReadFeed, resourceType, resourceLink, requestHeaders, nonNullOptions);
            retryPolicy.onBeforeSendRequest(request);
            return request;
        };
        Function executeFunc = request -> this.readFeed((RxDocumentServiceRequest)request).map(response -> feedResponseAccessor.createFeedResponse((RxDocumentServiceResponse)response, CosmosItemSerializer.DEFAULT_SERIALIZER, klass));
        return Paginator.getPaginatedQueryResultAsObservable(nonNullOptions, createRequestFunc, executeFunc, maxPageSize, this.globalEndpointManager, this.globalPartitionEndpointManagerForCircuitBreaker);
    }

    @Override
    public Flux<FeedResponse<Offer>> queryOffers(String query, QueryFeedOperationState state) {
        return this.queryOffers(new SqlQuerySpec(query), state);
    }

    @Override
    public Flux<FeedResponse<Offer>> queryOffers(SqlQuerySpec querySpec, QueryFeedOperationState state) {
        return this.createQuery(null, querySpec, state, Offer.class, ResourceType.Offer);
    }

    @Override
    public Mono<DatabaseAccount> getDatabaseAccount() {
        DocumentClientRetryPolicy documentClientRetryPolicy = this.resetSessionTokenRetryPolicy.getRequestPolicy(null);
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.getDatabaseAccountInternal(documentClientRetryPolicy), documentClientRetryPolicy);
    }

    private Mono<DatabaseAccount> getDatabaseAccountInternal(DocumentClientRetryPolicy documentClientRetryPolicy) {
        try {
            logger.debug("Getting Database Account");
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.Read, ResourceType.DatabaseAccount, "", (Map<String, String>)null, null);
            return this.read(request, documentClientRetryPolicy).map(ModelBridgeInternal::toDatabaseAccount);
        }
        catch (Exception e) {
            logger.debug("Failure in getting Database Account due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    public ISessionContainer getSession() {
        return this.sessionContainer;
    }

    public void setSession(ISessionContainer sessionContainer) {
        this.sessionContainer = sessionContainer;
    }

    public CosmosAsyncClient getCachedCosmosAsyncClientSnapshot() {
        return this.cachedCosmosAsyncClientSnapshot.get();
    }

    @Override
    public RxClientCollectionCache getCollectionCache() {
        return this.collectionCache;
    }

    @Override
    public RxPartitionKeyRangeCache getPartitionKeyRangeCache() {
        return this.partitionKeyRangeCache;
    }

    @Override
    public GlobalEndpointManager getGlobalEndpointManager() {
        return this.globalEndpointManager;
    }

    @Override
    public GlobalPartitionEndpointManagerForCircuitBreaker getGlobalPartitionEndpointManagerForCircuitBreaker() {
        return this.globalPartitionEndpointManagerForCircuitBreaker;
    }

    @Override
    public AddressSelector getAddressSelector() {
        return new AddressSelector(this.addressResolver, this.configs.getProtocol());
    }

    public Flux<DatabaseAccount> getDatabaseAccountFromEndpoint(URI endpoint) {
        return Flux.defer(() -> {
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.Read, ResourceType.DatabaseAccount, "", null, null);
            return this.populateHeadersAsync(request, RequestVerb.GET).flatMap(requestPopulated -> {
                requestPopulated.setEndpointOverride(endpoint);
                return this.gatewayProxy.processMessage((RxDocumentServiceRequest)requestPopulated).doOnError(e -> {
                    String message = String.format("Failed to retrieve database account information. %s", e.getCause() != null ? e.getCause().toString() : e.toString());
                    logger.warn(message);
                }).map(rsp -> rsp.getResource(DatabaseAccount.class)).doOnNext(databaseAccount -> {
                    this.useMultipleWriteLocations = this.connectionPolicy.isMultipleWriteRegionsEnabled() && BridgeInternal.isEnableMultipleWriteLocations(databaseAccount);
                });
            });
        });
    }

    private RxStoreModel getStoreProxy(RxDocumentServiceRequest request) {
        if (request.useGatewayMode) {
            return this.gatewayProxy;
        }
        ResourceType resourceType = request.getResourceType();
        OperationType operationType = request.getOperationType();
        if (resourceType == ResourceType.Offer || resourceType == ResourceType.ClientEncryptionKey || resourceType.isScript() && operationType != OperationType.ExecuteJavaScript || resourceType == ResourceType.PartitionKeyRange || resourceType == ResourceType.PartitionKey && operationType == OperationType.Delete) {
            return this.gatewayProxy;
        }
        if (operationType == OperationType.Create || operationType == OperationType.Upsert) {
            if (resourceType == ResourceType.Database || resourceType == ResourceType.User || resourceType == ResourceType.DocumentCollection || resourceType == ResourceType.Permission) {
                return this.gatewayProxy;
            }
            return this.storeModel;
        }
        if (operationType == OperationType.Delete) {
            if (resourceType == ResourceType.Database || resourceType == ResourceType.User || resourceType == ResourceType.DocumentCollection) {
                return this.gatewayProxy;
            }
            return this.storeModel;
        }
        if (operationType == OperationType.Replace) {
            if (resourceType == ResourceType.DocumentCollection) {
                return this.gatewayProxy;
            }
            return this.storeModel;
        }
        if (operationType == OperationType.Read) {
            if (resourceType == ResourceType.DocumentCollection) {
                return this.gatewayProxy;
            }
            return this.storeModel;
        }
        if ((operationType == OperationType.Query || operationType == OperationType.SqlQuery || operationType == OperationType.ReadFeed) && Utils.isCollectionChild(request.getResourceType()) && request.getPartitionKeyRangeIdentity() == null && request.getHeaders().get("x-ms-documentdb-partitionkey") == null) {
            return this.gatewayProxy;
        }
        return this.storeModel;
    }

    @Override
    public void close() {
        logger.info("Attempting to close client {}", (Object)this.clientId);
        if (!this.closed.getAndSet(true)) {
            activeClientsCnt.decrementAndGet();
            logger.info("Shutting down ...");
            if (this.globalPartitionEndpointManagerForCircuitBreaker != null) {
                logger.info("Closing globalPartitionEndpointManagerForCircuitBreaker...");
                LifeCycleUtils.closeQuietly(this.globalPartitionEndpointManagerForCircuitBreaker);
            }
            logger.info("Closing Global Endpoint Manager ...");
            LifeCycleUtils.closeQuietly(this.globalEndpointManager);
            logger.info("Closing StoreClientFactory ...");
            LifeCycleUtils.closeQuietly(this.storeClientFactory);
            logger.info("Shutting down reactorHttpClient ...");
            LifeCycleUtils.closeQuietly(this.reactorHttpClient);
            logger.info("Shutting down CpuMonitor ...");
            CpuMemoryMonitor.unregister(this);
            if (this.throughputControlEnabled.get()) {
                logger.info("Closing ThroughputControlStore ...");
                this.throughputControlStore.close();
            }
            logger.info("Shutting down completed.");
        } else {
            logger.warn("Already shutdown!");
        }
    }

    @Override
    public synchronized void enableThroughputControlGroup(ThroughputControlGroupInternal group, Mono<Integer> throughputQueryMono) {
        Preconditions.checkNotNull(group, "Throughput control group can not be null");
        if (this.throughputControlEnabled.compareAndSet(false, true)) {
            this.throughputControlStore = new ThroughputControlStore(this.collectionCache, this.connectionPolicy.getConnectionMode(), this.partitionKeyRangeCache);
            if (ConnectionMode.DIRECT == this.connectionPolicy.getConnectionMode()) {
                this.storeModel.enableThroughputControl(this.throughputControlStore);
            } else {
                this.gatewayProxy.enableThroughputControl(this.throughputControlStore);
            }
        }
        this.throughputControlStore.enableThroughputControlGroup(group, throughputQueryMono);
    }

    @Override
    public Flux<Void> submitOpenConnectionTasksAndInitCaches(CosmosContainerProactiveInitConfig proactiveContainerInitConfig) {
        return this.storeModel.submitOpenConnectionTasksAndInitCaches(proactiveContainerInitConfig);
    }

    @Override
    public ConsistencyLevel getDefaultConsistencyLevelOfAccount() {
        return this.gatewayConfigurationReader.getDefaultConsistencyLevel();
    }

    @Override
    public void configureFaultInjectorProvider(IFaultInjectorProvider injectorProvider) {
        Preconditions.checkNotNull(injectorProvider, "Argument 'injectorProvider' can not be null");
        if (this.connectionPolicy.getConnectionMode() == ConnectionMode.DIRECT) {
            this.storeModel.configureFaultInjectorProvider(injectorProvider, this.configs);
            this.addressResolver.configureFaultInjectorProvider(injectorProvider, this.configs);
        }
        this.gatewayProxy.configureFaultInjectorProvider(injectorProvider, this.configs);
    }

    @Override
    public void recordOpenConnectionsAndInitCachesCompleted(List<CosmosContainerIdentity> cosmosContainerIdentities) {
        this.storeModel.recordOpenConnectionsAndInitCachesCompleted(cosmosContainerIdentities);
    }

    @Override
    public void recordOpenConnectionsAndInitCachesStarted(List<CosmosContainerIdentity> cosmosContainerIdentities) {
        this.storeModel.recordOpenConnectionsAndInitCachesStarted(cosmosContainerIdentities);
    }

    @Override
    public String getMasterKeyOrResourceToken() {
        return this.masterKeyOrResourceToken;
    }

    private static SqlQuerySpec createLogicalPartitionScanQuerySpec(PartitionKey partitionKey, List<String> partitionKeySelectors) {
        StringBuilder queryStringBuilder = new StringBuilder();
        ArrayList<SqlParameter> parameters = new ArrayList<SqlParameter>();
        queryStringBuilder.append("SELECT * FROM c WHERE");
        Object[] pkValues = ModelBridgeInternal.getPartitionKeyInternal(partitionKey).toObjectArray();
        String pkParamNamePrefix = "@pkValue";
        for (int i = 0; i < pkValues.length; ++i) {
            StringBuilder subQueryStringBuilder = new StringBuilder();
            String sqlParameterName = pkParamNamePrefix + i;
            if (i > 0) {
                subQueryStringBuilder.append(" AND ");
            }
            subQueryStringBuilder.append(" c");
            subQueryStringBuilder.append(partitionKeySelectors.get(i));
            subQueryStringBuilder.append(" = ");
            subQueryStringBuilder.append(sqlParameterName);
            parameters.add(new SqlParameter(sqlParameterName, pkValues[i]));
            queryStringBuilder.append((CharSequence)subQueryStringBuilder);
        }
        return new SqlQuerySpec(queryStringBuilder.toString(), parameters);
    }

    @Override
    public Mono<List<FeedRange>> getFeedRanges(String collectionLink, boolean forceRefresh) {
        InvalidPartitionExceptionRetryPolicy invalidPartitionExceptionRetryPolicy = new InvalidPartitionExceptionRetryPolicy(this.collectionCache, null, collectionLink, new HashMap<String, Object>());
        RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.Query, ResourceType.Document, collectionLink, null);
        invalidPartitionExceptionRetryPolicy.onBeforeSendRequest(request);
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.getFeedRangesInternal(request, collectionLink, forceRefresh), invalidPartitionExceptionRetryPolicy);
    }

    private Mono<List<FeedRange>> getFeedRangesInternal(RxDocumentServiceRequest request, String collectionLink, boolean forceRefresh) {
        logger.debug("getFeedRange collectionLink=[{}] - forceRefresh={}", (Object)collectionLink, (Object)forceRefresh);
        if (StringUtils.isEmpty(collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        Mono<Utils.ValueHolder<DocumentCollection>> collectionObs = this.collectionCache.resolveCollectionAsync(null, request);
        return collectionObs.flatMap(documentCollectionResourceResponse -> {
            DocumentCollection collection = (DocumentCollection)documentCollectionResourceResponse.v;
            if (collection == null) {
                return Mono.error((Throwable)new IllegalStateException("Collection cannot be null"));
            }
            Mono<Utils.ValueHolder<List<PartitionKeyRange>>> valueHolderMono = this.partitionKeyRangeCache.tryGetOverlappingRangesAsync(BridgeInternal.getMetaDataDiagnosticContext(request.requestContext.cosmosDiagnostics), collection.getResourceId(), RANGE_INCLUDING_ALL_PARTITION_KEY_RANGES, forceRefresh, null);
            return valueHolderMono.map(partitionKeyRangeList -> RxDocumentClientImpl.toFeedRanges(partitionKeyRangeList, request));
        });
    }

    private static List<FeedRange> toFeedRanges(Utils.ValueHolder<List<PartitionKeyRange>> partitionKeyRangeListValueHolder, RxDocumentServiceRequest request) {
        List partitionKeyRangeList = (List)partitionKeyRangeListValueHolder.v;
        if (partitionKeyRangeList == null) {
            request.forceNameCacheRefresh = true;
            throw new InvalidPartitionException();
        }
        ArrayList<FeedRange> feedRanges = new ArrayList<FeedRange>();
        partitionKeyRangeList.forEach(pkRange -> feedRanges.add(RxDocumentClientImpl.toFeedRange(pkRange)));
        return feedRanges;
    }

    private static FeedRange toFeedRange(PartitionKeyRange pkRange) {
        return new FeedRangeEpkImpl(pkRange.toRange());
    }

    public static UUID randomUuid() {
        return RxDocumentClientImpl.randomUuid(ThreadLocalRandom.current().nextLong(), ThreadLocalRandom.current().nextLong());
    }

    static UUID randomUuid(long msb, long lsb) {
        msb &= 0xFFFFFFFFFFFF0FFFL;
        lsb &= 0x3FFFFFFFFFFFFFFFL;
        return new UUID(msb |= 0x4000L, lsb |= Long.MIN_VALUE);
    }

    public void addPartitionLevelUnavailableRegionsForRequest(RxDocumentServiceRequest request, RequestOptions options, CollectionRoutingMap collectionRoutingMap, DocumentClientRetryPolicy documentClientRetryPolicy) {
        Preconditions.checkNotNull(request, "Argument 'request' cannot be null!");
        if (this.globalPartitionEndpointManagerForCircuitBreaker.isPartitionLevelCircuitBreakingApplicable(request)) {
            Preconditions.checkNotNull(options, "Argument 'options' cannot be null!");
            Preconditions.checkNotNull(options.getPartitionKeyDefinition(), "Argument 'partitionKeyDefinition' within options cannot be null!");
            Preconditions.checkNotNull(collectionRoutingMap, "Argument 'collectionRoutingMap' cannot be null!");
            PartitionKeyRange resolvedPartitionKeyRange = null;
            PartitionKeyDefinition partitionKeyDefinition = options.getPartitionKeyDefinition();
            PartitionKeyInternal partitionKeyInternal = request.getPartitionKeyInternal();
            if (partitionKeyInternal != null) {
                String effectivePartitionKeyString = PartitionKeyInternalHelper.getEffectivePartitionKeyString(partitionKeyInternal, partitionKeyDefinition);
                resolvedPartitionKeyRange = collectionRoutingMap.getRangeByEffectivePartitionKey(effectivePartitionKeyString);
                request.setEffectivePartitionKey(effectivePartitionKeyString);
            } else if (request.getPartitionKeyRangeIdentity() != null) {
                resolvedPartitionKeyRange = collectionRoutingMap.getRangeByPartitionKeyRangeId(request.getPartitionKeyRangeIdentity().getPartitionKeyRangeId());
            }
            Preconditions.checkNotNull(resolvedPartitionKeyRange, "resolvedPartitionKeyRange cannot be null!");
            Preconditions.checkNotNull(this.globalPartitionEndpointManagerForCircuitBreaker, "globalPartitionEndpointManagerForCircuitBreaker cannot be null!");
            request.requestContext.resolvedPartitionKeyRange = resolvedPartitionKeyRange;
            request.requestContext.resolvedPartitionKeyRangeForCircuitBreaker = resolvedPartitionKeyRange;
            List<String> unavailableRegionsForPartition = this.globalPartitionEndpointManagerForCircuitBreaker.getUnavailableRegionsForPartitionKeyRange(request.getResourceId(), resolvedPartitionKeyRange, request.getOperationType());
            request.requestContext.setUnavailableRegionsForPartition(unavailableRegionsForPartition);
            if (documentClientRetryPolicy != null) {
                documentClientRetryPolicy.onBeforeSendRequest(request);
            }
        }
    }

    public void mergeContextInformationIntoDiagnosticsForPointRequest(RxDocumentServiceRequest request, PointOperationContextForCircuitBreaker pointOperationContextForCircuitBreaker) {
        if (pointOperationContextForCircuitBreaker != null) {
            SerializationDiagnosticsContext serializationDiagnosticsContext = pointOperationContextForCircuitBreaker.getSerializationDiagnosticsContext();
            diagnosticsAccessor.mergeSerializationDiagnosticContext(request.requestContext.cosmosDiagnostics, serializationDiagnosticsContext);
        }
    }

    public void addPartitionLevelUnavailableRegionsForFeedRequest(RxDocumentServiceRequest request, CosmosQueryRequestOptions options, CollectionRoutingMap collectionRoutingMap) {
        Preconditions.checkNotNull(collectionRoutingMap, "collectionRoutingMap cannot be null!");
        PartitionKeyRange resolvedPartitionKeyRange = null;
        if (request.getPartitionKeyRangeIdentity() != null) {
            resolvedPartitionKeyRange = collectionRoutingMap.getRangeByPartitionKeyRangeId(request.getPartitionKeyRangeIdentity().getPartitionKeyRangeId());
        } else if (request.getPartitionKeyInternal() != null) {
            String effectivePartitionKeyString = PartitionKeyInternalHelper.getEffectivePartitionKeyString(request.getPartitionKeyInternal(), ImplementationBridgeHelpers.CosmosQueryRequestOptionsHelper.getCosmosQueryRequestOptionsAccessor().getPartitionKeyDefinition(options));
            resolvedPartitionKeyRange = collectionRoutingMap.getRangeByEffectivePartitionKey(effectivePartitionKeyString);
        }
        Preconditions.checkNotNull(resolvedPartitionKeyRange, "resolvedPartitionKeyRange cannot be null!");
        request.requestContext.resolvedPartitionKeyRange = resolvedPartitionKeyRange;
        request.requestContext.resolvedPartitionKeyRangeForCircuitBreaker = resolvedPartitionKeyRange;
        if (this.globalPartitionEndpointManagerForCircuitBreaker.isPartitionLevelCircuitBreakingApplicable(request)) {
            Preconditions.checkNotNull(this.globalPartitionEndpointManagerForCircuitBreaker, "globalPartitionEndpointManagerForCircuitBreaker cannot be null!");
            List<String> unavailableRegionsForPartition = this.globalPartitionEndpointManagerForCircuitBreaker.getUnavailableRegionsForPartitionKeyRange(request.getResourceId(), resolvedPartitionKeyRange, request.getOperationType());
            request.requestContext.setUnavailableRegionsForPartition(unavailableRegionsForPartition);
        }
    }

    public void addPartitionLevelUnavailableRegionsForChangeFeedRequest(RxDocumentServiceRequest request, CosmosChangeFeedRequestOptions options, CollectionRoutingMap collectionRoutingMap) {
        Preconditions.checkNotNull(collectionRoutingMap, "collectionRoutingMap cannot be null!");
        PartitionKeyRange resolvedPartitionKeyRange = null;
        if (request.getPartitionKeyRangeIdentity() != null) {
            resolvedPartitionKeyRange = collectionRoutingMap.getRangeByPartitionKeyRangeId(request.getPartitionKeyRangeIdentity().getPartitionKeyRangeId());
        } else if (request.getPartitionKeyInternal() != null) {
            String effectivePartitionKeyString = PartitionKeyInternalHelper.getEffectivePartitionKeyString(request.getPartitionKeyInternal(), ImplementationBridgeHelpers.CosmosChangeFeedRequestOptionsHelper.getCosmosChangeFeedRequestOptionsAccessor().getPartitionKeyDefinition(options));
            resolvedPartitionKeyRange = collectionRoutingMap.getRangeByEffectivePartitionKey(effectivePartitionKeyString);
        }
        Preconditions.checkNotNull(resolvedPartitionKeyRange, "resolvedPartitionKeyRange cannot be null!");
        request.requestContext.resolvedPartitionKeyRange = resolvedPartitionKeyRange;
        request.requestContext.resolvedPartitionKeyRangeForCircuitBreaker = resolvedPartitionKeyRange;
        if (this.globalPartitionEndpointManagerForCircuitBreaker.isPartitionLevelCircuitBreakingApplicable(request)) {
            Preconditions.checkNotNull(this.globalPartitionEndpointManagerForCircuitBreaker, "globalPartitionEndpointManagerForCircuitBreaker cannot be null!");
            List<String> unavailableRegionsForPartition = this.globalPartitionEndpointManagerForCircuitBreaker.getUnavailableRegionsForPartitionKeyRange(request.getResourceId(), resolvedPartitionKeyRange, request.getOperationType());
            request.requestContext.setUnavailableRegionsForPartition(unavailableRegionsForPartition);
        }
    }

    private Mono<ResourceResponse<Document>> wrapPointOperationWithAvailabilityStrategy(ResourceType resourceType, OperationType operationType, DocumentPointOperation callback, RequestOptions initialRequestOptions, boolean idempotentWriteRetriesEnabled, String collectionLink) {
        return this.wrapPointOperationWithAvailabilityStrategy(resourceType, operationType, callback, initialRequestOptions, idempotentWriteRetriesEnabled, this, collectionLink);
    }

    private Mono<ResourceResponse<Document>> wrapPointOperationWithAvailabilityStrategy(ResourceType resourceType, OperationType operationType, DocumentPointOperation callback, RequestOptions initialRequestOptions, boolean idempotentWriteRetriesEnabled, DiagnosticsClientContext innerDiagnosticsFactory, String collectionLink) {
        Preconditions.checkNotNull(resourceType, "Argument 'resourceType' must not be null.");
        Preconditions.checkNotNull(operationType, "Argument 'operationType' must not be null.");
        Preconditions.checkNotNull(callback, "Argument 'callback' must not be null.");
        RequestOptions nonNullRequestOptions = initialRequestOptions != null ? initialRequestOptions : new RequestOptions();
        Preconditions.checkArgument(resourceType == ResourceType.Document, "This method can only be used for document point operations.");
        CosmosEndToEndOperationLatencyPolicyConfig endToEndPolicyConfig = this.getEndToEndOperationLatencyPolicyConfig(nonNullRequestOptions, resourceType, operationType);
        List<String> orderedApplicableRegionsForSpeculation = this.getApplicableRegionsForSpeculation(endToEndPolicyConfig, resourceType, operationType, idempotentWriteRetriesEnabled, nonNullRequestOptions);
        AtomicBoolean isOperationSuccessful = new AtomicBoolean(false);
        if (orderedApplicableRegionsForSpeculation.size() < 2) {
            PointOperationContextForCircuitBreaker pointOperationContextForCircuitBreakerForMainRequest = new PointOperationContextForCircuitBreaker(isOperationSuccessful, false, collectionLink, new SerializationDiagnosticsContext());
            pointOperationContextForCircuitBreakerForMainRequest.setIsRequestHedged(false);
            return callback.apply(nonNullRequestOptions, endToEndPolicyConfig, innerDiagnosticsFactory, pointOperationContextForCircuitBreakerForMainRequest);
        }
        ThresholdBasedAvailabilityStrategy availabilityStrategy = (ThresholdBasedAvailabilityStrategy)endToEndPolicyConfig.getAvailabilityStrategy();
        ArrayList monoList = new ArrayList();
        ScopedDiagnosticsFactory diagnosticsFactory = new ScopedDiagnosticsFactory(innerDiagnosticsFactory, false);
        orderedApplicableRegionsForSpeculation.forEach(region -> {
            RequestOptions clonedOptions = new RequestOptions(nonNullRequestOptions);
            if (monoList.isEmpty()) {
                PointOperationContextForCircuitBreaker pointOperationContextForCircuitBreakerForMainRequest = new PointOperationContextForCircuitBreaker(isOperationSuccessful, true, collectionLink, new SerializationDiagnosticsContext());
                pointOperationContextForCircuitBreakerForMainRequest.setIsRequestHedged(false);
                Mono initialMonoAcrossAllRegions = callback.apply(clonedOptions, endToEndPolicyConfig, diagnosticsFactory, pointOperationContextForCircuitBreakerForMainRequest).map(NonTransientPointOperationResult::new).onErrorResume(RxDocumentClientImpl::isCosmosException, t -> Mono.just((Object)new NonTransientPointOperationResult(Utils.as(Exceptions.unwrap((Throwable)t), CosmosException.class))));
                if (logger.isDebugEnabled()) {
                    monoList.add(initialMonoAcrossAllRegions.doOnSubscribe(c -> logger.debug("STARTING to process {} operation in region '{}'", (Object)operationType, region)));
                } else {
                    monoList.add(initialMonoAcrossAllRegions);
                }
            } else {
                clonedOptions.setExcludedRegions(this.getEffectiveExcludedRegionsForHedging(nonNullRequestOptions.getExcludedRegions(), orderedApplicableRegionsForSpeculation, (String)region));
                PointOperationContextForCircuitBreaker pointOperationContextForCircuitBreakerForHedgedRequest = new PointOperationContextForCircuitBreaker(isOperationSuccessful, true, collectionLink, new SerializationDiagnosticsContext());
                pointOperationContextForCircuitBreakerForHedgedRequest.setIsRequestHedged(true);
                Mono regionalCrossRegionRetryMono = callback.apply(clonedOptions, endToEndPolicyConfig, diagnosticsFactory, pointOperationContextForCircuitBreakerForHedgedRequest).map(NonTransientPointOperationResult::new).onErrorResume(RxDocumentClientImpl::isNonTransientCosmosException, t -> Mono.just((Object)new NonTransientPointOperationResult(Utils.as(Exceptions.unwrap((Throwable)t), CosmosException.class))));
                Duration delayForCrossRegionalRetry = availabilityStrategy.getThreshold().plus(availabilityStrategy.getThresholdStep().multipliedBy(monoList.size() - 1));
                if (logger.isDebugEnabled()) {
                    monoList.add(regionalCrossRegionRetryMono.doOnSubscribe(c -> logger.debug("STARTING to process {} operation in region '{}'", (Object)operationType, region)).delaySubscription(delayForCrossRegionalRetry));
                } else {
                    monoList.add(regionalCrossRegionRetryMono.delaySubscription(delayForCrossRegionalRetry));
                }
            }
        });
        return Mono.firstWithValue(monoList).flatMap(nonTransientResult -> {
            diagnosticsFactory.merge(nonNullRequestOptions);
            if (nonTransientResult.isError()) {
                return Mono.error((Throwable)((Object)((NonTransientPointOperationResult)nonTransientResult).exception));
            }
            return Mono.just((Object)((NonTransientPointOperationResult)nonTransientResult).response);
        }).onErrorMap(throwable -> {
            Throwable exception = Exceptions.unwrap((Throwable)throwable);
            if (exception instanceof NoSuchElementException) {
                List innerThrowables = Exceptions.unwrapMultiple((Throwable)exception.getCause());
                int index = 0;
                for (Throwable innerThrowable : innerThrowables) {
                    Throwable innerException = Exceptions.unwrap((Throwable)innerThrowable);
                    if (innerException instanceof CosmosException) {
                        CosmosException cosmosException = Utils.as(innerException, CosmosException.class);
                        diagnosticsFactory.merge(nonNullRequestOptions);
                        return cosmosException;
                    }
                    if (innerException instanceof NoSuchElementException) {
                        logger.trace("Operation in {} completed with empty result because it was cancelled.", orderedApplicableRegionsForSpeculation.get(index));
                    } else if (logger.isWarnEnabled()) {
                        String message = "Unexpected Non-CosmosException when processing operation in '" + (String)orderedApplicableRegionsForSpeculation.get(index) + "'.";
                        logger.warn(message, innerException);
                    }
                    ++index;
                }
            }
            diagnosticsFactory.merge(nonNullRequestOptions);
            return exception;
        }).doOnCancel(() -> diagnosticsFactory.merge(nonNullRequestOptions));
    }

    private static boolean isCosmosException(Throwable t) {
        Throwable unwrappedException = Exceptions.unwrap((Throwable)t);
        return unwrappedException instanceof CosmosException;
    }

    private static boolean isNonTransientCosmosException(Throwable t) {
        Throwable unwrappedException = Exceptions.unwrap((Throwable)t);
        if (!(unwrappedException instanceof CosmosException)) {
            return false;
        }
        CosmosException cosmosException = Utils.as(unwrappedException, CosmosException.class);
        return RxDocumentClientImpl.isNonTransientResultForHedging(cosmosException.getStatusCode(), cosmosException.getSubStatusCode());
    }

    private List<String> getEffectiveExcludedRegionsForHedging(List<String> initialExcludedRegions, List<String> applicableRegions, String currentRegion) {
        ArrayList<String> effectiveExcludedRegions = new ArrayList<String>();
        if (initialExcludedRegions != null) {
            effectiveExcludedRegions.addAll(initialExcludedRegions);
        }
        for (String applicableRegion : applicableRegions) {
            if (applicableRegion.equals(currentRegion)) continue;
            effectiveExcludedRegions.add(applicableRegion);
        }
        return effectiveExcludedRegions;
    }

    private static boolean isNonTransientResultForHedging(int statusCode, int subStatusCode) {
        if (statusCode < 400) {
            return true;
        }
        if (statusCode == 408 && subStatusCode == 20008) {
            return true;
        }
        if (statusCode == 400 || statusCode == 409 || statusCode == 405 || statusCode == 412 || statusCode == 413 || statusCode == 401) {
            return true;
        }
        return statusCode == 404 && subStatusCode == 0;
    }

    private DiagnosticsClientContext getEffectiveClientContext(DiagnosticsClientContext clientContextOverride) {
        if (clientContextOverride != null) {
            return clientContextOverride;
        }
        return this;
    }

    private List<URI> getApplicableEndPoints(OperationType operationType, List<String> excludedRegions) {
        if (operationType.isReadOnlyOperation()) {
            return RxDocumentClientImpl.withoutNulls(this.globalEndpointManager.getApplicableReadEndpoints(excludedRegions));
        }
        if (operationType.isWriteOperation()) {
            return RxDocumentClientImpl.withoutNulls(this.globalEndpointManager.getApplicableWriteEndpoints(excludedRegions));
        }
        return EMPTY_ENDPOINT_LIST;
    }

    private static List<URI> withoutNulls(List<URI> orderedEffectiveEndpointsList) {
        if (orderedEffectiveEndpointsList == null) {
            return EMPTY_ENDPOINT_LIST;
        }
        int i = 0;
        while (i < orderedEffectiveEndpointsList.size()) {
            if (orderedEffectiveEndpointsList.get(i) == null) {
                orderedEffectiveEndpointsList.remove(i);
                continue;
            }
            ++i;
        }
        return orderedEffectiveEndpointsList;
    }

    private List<String> getApplicableRegionsForSpeculation(CosmosEndToEndOperationLatencyPolicyConfig endToEndPolicyConfig, ResourceType resourceType, OperationType operationType, boolean isIdempotentWriteRetriesEnabled, RequestOptions options) {
        return this.getApplicableRegionsForSpeculation(endToEndPolicyConfig, resourceType, operationType, isIdempotentWriteRetriesEnabled, options.getExcludedRegions());
    }

    private List<String> getApplicableRegionsForSpeculation(CosmosEndToEndOperationLatencyPolicyConfig endToEndPolicyConfig, ResourceType resourceType, OperationType operationType, boolean isIdempotentWriteRetriesEnabled, List<String> excludedRegions) {
        if (endToEndPolicyConfig == null || !endToEndPolicyConfig.isEnabled()) {
            return EMPTY_REGION_LIST;
        }
        if (resourceType != ResourceType.Document) {
            return EMPTY_REGION_LIST;
        }
        if (operationType.isWriteOperation() && !isIdempotentWriteRetriesEnabled) {
            return EMPTY_REGION_LIST;
        }
        if (operationType.isWriteOperation() && !this.globalEndpointManager.canUseMultipleWriteLocations()) {
            return EMPTY_REGION_LIST;
        }
        if (!(endToEndPolicyConfig.getAvailabilityStrategy() instanceof ThresholdBasedAvailabilityStrategy)) {
            return EMPTY_REGION_LIST;
        }
        List<URI> endpoints = this.getApplicableEndPoints(operationType, excludedRegions);
        HashSet normalizedExcludedRegions = new HashSet();
        if (excludedRegions != null) {
            excludedRegions.forEach(r -> normalizedExcludedRegions.add(r.toLowerCase(Locale.ROOT)));
        }
        ArrayList<String> orderedRegionsForSpeculation = new ArrayList<String>();
        endpoints.forEach(uri -> {
            String regionName = this.globalEndpointManager.getRegionName((URI)uri, operationType);
            if (!normalizedExcludedRegions.contains(regionName.toLowerCase(Locale.ROOT))) {
                orderedRegionsForSpeculation.add(regionName);
            }
        });
        return orderedRegionsForSpeculation;
    }

    private <T> Mono<T> executeFeedOperationWithAvailabilityStrategy(ResourceType resourceType, OperationType operationType, Supplier<DocumentClientRetryPolicy> retryPolicyFactory, RxDocumentServiceRequest req, BiFunction<Supplier<DocumentClientRetryPolicy>, RxDocumentServiceRequest, Mono<T>> feedOperation, String collectionLink) {
        Preconditions.checkNotNull(retryPolicyFactory, "Argument 'retryPolicyFactory' must not be null.");
        Preconditions.checkNotNull(req, "Argument 'req' must not be null.");
        assert (resourceType == ResourceType.Document);
        CosmosEndToEndOperationLatencyPolicyConfig endToEndPolicyConfig = this.getEffectiveEndToEndOperationLatencyPolicyConfig(req.requestContext.getEndToEndOperationLatencyPolicyConfig(), resourceType, operationType);
        List<String> initialExcludedRegions = req.requestContext.getExcludeRegions();
        List<String> orderedApplicableRegionsForSpeculation = this.getApplicableRegionsForSpeculation(endToEndPolicyConfig, resourceType, operationType, false, initialExcludedRegions);
        ConcurrentHashMap<PartitionKeyRangeWrapper, PartitionKeyRangeWrapper> partitionKeyRangesWithSuccess = new ConcurrentHashMap<PartitionKeyRangeWrapper, PartitionKeyRangeWrapper>();
        if (orderedApplicableRegionsForSpeculation.size() < 2) {
            FeedOperationContextForCircuitBreaker feedOperationContextForCircuitBreakerForRequestOutsideOfAvailabilityStrategyFlow = new FeedOperationContextForCircuitBreaker(partitionKeyRangesWithSuccess, false, collectionLink);
            feedOperationContextForCircuitBreakerForRequestOutsideOfAvailabilityStrategyFlow.setIsRequestHedged(false);
            req.requestContext.setFeedOperationContext(feedOperationContextForCircuitBreakerForRequestOutsideOfAvailabilityStrategyFlow);
            return feedOperation.apply(retryPolicyFactory, req);
        }
        FeedOperationContextForCircuitBreaker feedOperationContextForCircuitBreakerForParentRequestInAvailabilityStrategyFlow = new FeedOperationContextForCircuitBreaker(partitionKeyRangesWithSuccess, true, collectionLink);
        feedOperationContextForCircuitBreakerForParentRequestInAvailabilityStrategyFlow.setIsRequestHedged(false);
        req.requestContext.setFeedOperationContext(feedOperationContextForCircuitBreakerForParentRequestInAvailabilityStrategyFlow);
        ThresholdBasedAvailabilityStrategy availabilityStrategy = (ThresholdBasedAvailabilityStrategy)endToEndPolicyConfig.getAvailabilityStrategy();
        ArrayList monoList = new ArrayList();
        orderedApplicableRegionsForSpeculation.forEach(region -> {
            RxDocumentServiceRequest clonedRequest = req.clone();
            if (monoList.isEmpty()) {
                FeedOperationContextForCircuitBreaker feedOperationContextForCircuitBreakerForNonHedgedRequest = new FeedOperationContextForCircuitBreaker(partitionKeyRangesWithSuccess, true, collectionLink);
                feedOperationContextForCircuitBreakerForNonHedgedRequest.setIsRequestHedged(false);
                clonedRequest.requestContext.setFeedOperationContext(feedOperationContextForCircuitBreakerForNonHedgedRequest);
                Mono initialMonoAcrossAllRegions = this.handleCircuitBreakingFeedbackForFeedOperationWithAvailabilityStrategy(((Mono)feedOperation.apply(retryPolicyFactory, clonedRequest)).map(NonTransientFeedOperationResult::new).onErrorResume(RxDocumentClientImpl::isCosmosException, t -> Mono.just(new NonTransientFeedOperationResult(Utils.as(Exceptions.unwrap((Throwable)t), CosmosException.class)))), clonedRequest);
                if (logger.isDebugEnabled()) {
                    monoList.add(initialMonoAcrossAllRegions.doOnSubscribe(c -> logger.debug("STARTING to process {} operation in region '{}'", (Object)operationType, region)));
                } else {
                    monoList.add(initialMonoAcrossAllRegions);
                }
            } else {
                clonedRequest.requestContext.setExcludeRegions(this.getEffectiveExcludedRegionsForHedging(initialExcludedRegions, orderedApplicableRegionsForSpeculation, (String)region));
                FeedOperationContextForCircuitBreaker feedOperationContextForCircuitBreakerForHedgedRequest = new FeedOperationContextForCircuitBreaker(partitionKeyRangesWithSuccess, true, collectionLink);
                feedOperationContextForCircuitBreakerForHedgedRequest.setIsRequestHedged(true);
                clonedRequest.requestContext.setFeedOperationContext(feedOperationContextForCircuitBreakerForHedgedRequest);
                clonedRequest.requestContext.setKeywordIdentifiers(req.requestContext.getKeywordIdentifiers());
                Mono regionalCrossRegionRetryMono = this.handleCircuitBreakingFeedbackForFeedOperationWithAvailabilityStrategy(((Mono)feedOperation.apply(retryPolicyFactory, clonedRequest)).map(NonTransientFeedOperationResult::new).onErrorResume(RxDocumentClientImpl::isNonTransientCosmosException, t -> Mono.just(new NonTransientFeedOperationResult(Utils.as(Exceptions.unwrap((Throwable)t), CosmosException.class)))), clonedRequest);
                Duration delayForCrossRegionalRetry = availabilityStrategy.getThreshold().plus(availabilityStrategy.getThresholdStep().multipliedBy(monoList.size() - 1));
                if (logger.isDebugEnabled()) {
                    monoList.add(regionalCrossRegionRetryMono.doOnSubscribe(c -> logger.debug("STARTING to process {} operation in region '{}'", (Object)operationType, region)).delaySubscription(delayForCrossRegionalRetry));
                } else {
                    monoList.add(regionalCrossRegionRetryMono.delaySubscription(delayForCrossRegionalRetry));
                }
            }
        });
        return Mono.firstWithValue(monoList).flatMap(nonTransientResult -> {
            if (nonTransientResult.isError()) {
                return Mono.error((Throwable)((Object)((NonTransientFeedOperationResult)nonTransientResult).exception));
            }
            return Mono.just((Object)((NonTransientFeedOperationResult)nonTransientResult).response);
        }).onErrorMap(throwable -> {
            Throwable exception = Exceptions.unwrap((Throwable)throwable);
            if (exception instanceof NoSuchElementException) {
                List innerThrowables = Exceptions.unwrapMultiple((Throwable)exception.getCause());
                int index = 0;
                for (Throwable innerThrowable : innerThrowables) {
                    Throwable innerException = Exceptions.unwrap((Throwable)innerThrowable);
                    if (innerException instanceof CosmosException) {
                        return (Throwable)((Object)Utils.as(innerException, CosmosException.class));
                    }
                    if (innerException instanceof NoSuchElementException) {
                        logger.trace("Operation in {} completed with empty result because it was cancelled.", orderedApplicableRegionsForSpeculation.get(index));
                    } else if (logger.isWarnEnabled()) {
                        String message = "Unexpected Non-CosmosException when processing operation in '" + (String)orderedApplicableRegionsForSpeculation.get(index) + "'.";
                        logger.warn(message, innerException);
                    }
                    ++index;
                }
            }
            return exception;
        });
    }

    private void handleLocationCancellationExceptionForPartitionKeyRange(RxDocumentServiceRequest failedRequest) {
        URI firstContactedLocationEndpoint = diagnosticsAccessor.getFirstContactedLocationEndpoint(failedRequest.requestContext.cosmosDiagnostics);
        if (firstContactedLocationEndpoint != null) {
            this.globalPartitionEndpointManagerForCircuitBreaker.handleLocationExceptionForPartitionKeyRange(failedRequest, firstContactedLocationEndpoint);
        }
    }

    private static class ScopedDiagnosticsFactory
    implements DiagnosticsClientContext {
        private final AtomicBoolean isMerged = new AtomicBoolean(false);
        private final DiagnosticsClientContext inner;
        private final ConcurrentLinkedQueue<CosmosDiagnostics> createdDiagnostics;
        private final boolean shouldCaptureAllFeedDiagnostics;
        private final AtomicReference<CosmosDiagnostics> mostRecentlyCreatedDiagnostics = new AtomicReference<Object>(null);

        public ScopedDiagnosticsFactory(DiagnosticsClientContext inner, boolean shouldCaptureAllFeedDiagnostics) {
            Preconditions.checkNotNull(inner, "Argument 'inner' must not be null.");
            this.inner = inner;
            this.createdDiagnostics = new ConcurrentLinkedQueue();
            this.shouldCaptureAllFeedDiagnostics = shouldCaptureAllFeedDiagnostics;
        }

        @Override
        public DiagnosticsClientContext.DiagnosticsClientConfig getConfig() {
            return this.inner.getConfig();
        }

        @Override
        public CosmosDiagnostics createDiagnostics() {
            CosmosDiagnostics diagnostics = this.inner.createDiagnostics();
            this.createdDiagnostics.add(diagnostics);
            this.mostRecentlyCreatedDiagnostics.set(diagnostics);
            return diagnostics;
        }

        @Override
        public String getUserAgent() {
            return this.inner.getUserAgent();
        }

        @Override
        public CosmosDiagnostics getMostRecentlyCreatedDiagnostics() {
            return this.mostRecentlyCreatedDiagnostics.get();
        }

        public void merge(RequestOptions requestOptions) {
            CosmosDiagnosticsContext ctxSnapshot;
            CosmosDiagnosticsContext knownCtx = null;
            if (requestOptions != null && (ctxSnapshot = requestOptions.getDiagnosticsContextSnapshot()) != null) {
                knownCtx = requestOptions.getDiagnosticsContextSnapshot();
            }
            this.merge(knownCtx);
        }

        public void merge(CosmosDiagnosticsContext knownCtx) {
            if (!this.isMerged.compareAndSet(false, true)) {
                return;
            }
            CosmosDiagnosticsContext ctx = null;
            if (knownCtx != null) {
                ctx = knownCtx;
            } else {
                for (CosmosDiagnostics diagnostics : this.createdDiagnostics) {
                    if (diagnostics.getDiagnosticsContext() == null) continue;
                    ctx = diagnostics.getDiagnosticsContext();
                    break;
                }
            }
            if (ctx == null) {
                return;
            }
            for (CosmosDiagnostics diagnostics : this.createdDiagnostics) {
                AtomicBoolean isCaptured;
                if (diagnostics.getDiagnosticsContext() != null || !diagnosticsAccessor.isNotEmpty(diagnostics)) continue;
                if (this.shouldCaptureAllFeedDiagnostics && diagnosticsAccessor.getFeedResponseDiagnostics(diagnostics) != null && (isCaptured = diagnosticsAccessor.isDiagnosticsCapturedInPagedFlux(diagnostics)) != null) {
                    isCaptured.set(true);
                }
                ctxAccessor.addDiagnostics(ctx, diagnostics);
            }
        }

        public void reset() {
            this.createdDiagnostics.clear();
            this.isMerged.set(false);
        }
    }

    @FunctionalInterface
    private static interface DocumentPointOperation {
        public Mono<ResourceResponse<Document>> apply(RequestOptions var1, CosmosEndToEndOperationLatencyPolicyConfig var2, DiagnosticsClientContext var3, PointOperationContextForCircuitBreaker var4);
    }

    private static class NonTransientFeedOperationResult<T> {
        private final T response;
        private final CosmosException exception;

        public NonTransientFeedOperationResult(CosmosException exception) {
            Preconditions.checkNotNull(exception, "Argument 'exception' must not be null.");
            this.exception = exception;
            this.response = null;
        }

        public NonTransientFeedOperationResult(T response) {
            Preconditions.checkNotNull(response, "Argument 'response' must not be null.");
            this.exception = null;
            this.response = response;
        }

        public boolean isError() {
            return this.exception != null;
        }

        public CosmosException getException() {
            return this.exception;
        }

        public T getResponse() {
            return this.response;
        }
    }

    private static class NonTransientPointOperationResult {
        private final ResourceResponse<Document> response;
        private final CosmosException exception;

        public NonTransientPointOperationResult(CosmosException exception) {
            Preconditions.checkNotNull(exception, "Argument 'exception' must not be null.");
            this.exception = exception;
            this.response = null;
        }

        public NonTransientPointOperationResult(ResourceResponse<Document> response) {
            Preconditions.checkNotNull(response, "Argument 'response' must not be null.");
            this.exception = null;
            this.response = response;
        }

        public boolean isError() {
            return this.exception != null;
        }

        public CosmosException getException() {
            return this.exception;
        }

        public ResourceResponse<Document> getResponse() {
            return this.response;
        }
    }
}

