/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.circuitBreaker;

import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.core.JsonProcessingException;

public class PartitionLevelCircuitBreakerConfig {
    public static final PartitionLevelCircuitBreakerConfig DEFAULT = new PartitionLevelCircuitBreakerConfig();
    @JsonSetter(nulls=Nulls.SKIP)
    @JsonProperty
    private Boolean isPartitionLevelCircuitBreakerEnabled = false;
    @JsonSetter(nulls=Nulls.SKIP)
    @JsonProperty
    private String circuitBreakerType = "CONSECUTIVE_EXCEPTION_COUNT_BASED";
    @JsonSetter(nulls=Nulls.SKIP)
    @JsonProperty
    private int consecutiveExceptionCountToleratedForReads = 10;
    @JsonSetter(nulls=Nulls.SKIP)
    @JsonProperty
    private int consecutiveExceptionCountToleratedForWrites = 5;
    private String cachedConfigAsString = "";

    public Boolean isPartitionLevelCircuitBreakerEnabled() {
        return this.isPartitionLevelCircuitBreakerEnabled;
    }

    public String getCircuitBreakerType() {
        return this.circuitBreakerType;
    }

    public int getConsecutiveExceptionCountToleratedForReads() {
        return this.consecutiveExceptionCountToleratedForReads;
    }

    public int getConsecutiveExceptionCountToleratedForWrites() {
        return this.consecutiveExceptionCountToleratedForWrites;
    }

    public String toJson() {
        try {
            return Utils.getSimpleObjectMapper().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Unable to convert to Json String", e);
        }
    }

    public String getConfigAsString() {
        if (StringUtils.isEmpty(this.cachedConfigAsString)) {
            this.cachedConfigAsString = "(cb: " + this.isPartitionLevelCircuitBreakerEnabled + ", type: " + this.circuitBreakerType + ", rexcntt: " + this.consecutiveExceptionCountToleratedForReads + ", wexcntt: " + this.consecutiveExceptionCountToleratedForWrites + ")";
        }
        return this.cachedConfigAsString;
    }

    public static PartitionLevelCircuitBreakerConfig fromJsonString(String jsonString) {
        try {
            return (PartitionLevelCircuitBreakerConfig)Utils.getSimpleObjectMapper().readValue(jsonString, PartitionLevelCircuitBreakerConfig.class);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Unable to convert from Json String", e);
        }
    }
}

