/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.apachecommons.lang;

import java.util.Random;

public class RandomStringUtils {
    private static final Random RANDOM = new Random();

    private RandomStringUtils() {
    }

    public static String randomAlphabetic(int count) {
        return RandomStringUtils.random(count, true, false);
    }

    private static String random(int count, boolean letters, boolean numbers) {
        return RandomStringUtils.random(count, 0, 0, letters, numbers);
    }

    private static String random(int count, int start, int end, boolean letters, boolean numbers) {
        return RandomStringUtils.random(count, start, end, letters, numbers, null, RANDOM);
    }

    private static String random(int count, int start, int end, boolean letters, boolean numbers, char[] chars, Random random) {
        if (count == 0) {
            return "";
        }
        if (count < 0) {
            throw new IllegalArgumentException("Requested random string length " + count + " is less than 0.");
        }
        if (chars != null && chars.length == 0) {
            throw new IllegalArgumentException("The chars array must not be empty");
        }
        if (start == 0 && end == 0) {
            if (chars != null) {
                end = chars.length;
            } else if (!letters && !numbers) {
                end = 0x10FFFF;
            } else {
                end = 123;
                start = 32;
            }
        } else if (end <= start) {
            throw new IllegalArgumentException("Parameter end (" + end + ") must be greater than start (" + start + ")");
        }
        int zero_digit_ascii = 48;
        int first_letter_ascii = 65;
        if (chars == null && (numbers && end <= 48 || letters && end <= 65)) {
            throw new IllegalArgumentException("Parameter end (" + end + ") must be greater then (" + 48 + ") for generating digits or greater then (" + 65 + ") for generating letters.");
        }
        StringBuilder builder = new StringBuilder(count);
        int gap = end - start;
        block3: while (count-- != 0) {
            int codePoint;
            if (chars == null) {
                codePoint = random.nextInt(gap) + start;
                switch (Character.getType(codePoint)) {
                    case 0: 
                    case 18: 
                    case 19: {
                        ++count;
                        continue block3;
                    }
                }
            } else {
                codePoint = chars[random.nextInt(gap) + start];
            }
            int numberOfChars = Character.charCount(codePoint);
            if (count == 0 && numberOfChars > 1) {
                ++count;
                continue;
            }
            if (letters && Character.isLetter(codePoint) || numbers && Character.isDigit(codePoint) || !letters && !numbers) {
                builder.appendCodePoint(codePoint);
                if (numberOfChars != 2) continue;
                --count;
                continue;
            }
            ++count;
        }
        return builder.toString();
    }
}

