/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.patch;

import com.azure.cosmos.CosmosItemSerializer;
import com.azure.cosmos.implementation.JsonSerializable;
import com.azure.cosmos.implementation.RequestOptions;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.patch.PatchOperation;
import com.azure.cosmos.implementation.patch.PatchOperationCore;
import com.azure.cosmos.implementation.patch.PatchOperationType;
import com.azure.cosmos.models.CosmosPatchOperations;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.List;

public final class PatchUtil {
    public static JsonSerializable serializableBatchPatchOperation(CosmosPatchOperations patchOperations, RequestOptions requestOptions) {
        return PatchUtil.cosmosPatchToJsonSerializable(patchOperations, requestOptions);
    }

    public static byte[] serializeCosmosPatchToByteArray(CosmosPatchOperations patchOperations, RequestOptions requestOptions) {
        byte[] serializedBody;
        JsonSerializable jsonSerializable = PatchUtil.cosmosPatchToJsonSerializable(patchOperations, requestOptions);
        try {
            serializedBody = Utils.getSimpleObjectMapper().writeValueAsBytes((Object)jsonSerializable.getPropertyBag());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Can't serialize the object into the byte array", e);
        }
        return serializedBody;
    }

    private static JsonSerializable cosmosPatchToJsonSerializable(CosmosPatchOperations patchOperations, RequestOptions requestOptions) {
        String filterPredicate;
        JsonSerializable jsonSerializable = new JsonSerializable();
        ArrayNode operations = Utils.getSimpleObjectMapper().createArrayNode();
        List<PatchOperation> patchOperationList = ModelBridgeInternal.getPatchOperationsFromCosmosPatch(patchOperations);
        for (PatchOperation patchOperation : patchOperationList) {
            JsonSerializable operationJsonSerializable = new JsonSerializable();
            operationJsonSerializable.set("op", patchOperation.getOperationType().getOperationValue(), CosmosItemSerializer.DEFAULT_SERIALIZER);
            if (patchOperation instanceof PatchOperationCore) {
                if (patchOperation.getOperationType() == PatchOperationType.MOVE) {
                    operationJsonSerializable.set("path", ((PatchOperationCore)patchOperation).getPath(), CosmosItemSerializer.DEFAULT_SERIALIZER);
                    operationJsonSerializable.set("from", ((PatchOperationCore)patchOperation).getFrom(), CosmosItemSerializer.DEFAULT_SERIALIZER);
                } else {
                    operationJsonSerializable.set("path", ((PatchOperationCore)patchOperation).getPath(), CosmosItemSerializer.DEFAULT_SERIALIZER);
                    operationJsonSerializable.set("value", ((PatchOperationCore)patchOperation).getResource(), CosmosItemSerializer.DEFAULT_SERIALIZER);
                }
            } else {
                throw new IllegalArgumentException("Invalid patch operation type");
            }
            operations.add((JsonNode)operationJsonSerializable.getPropertyBag());
        }
        jsonSerializable.set("operations", operations, CosmosItemSerializer.DEFAULT_SERIALIZER);
        if (requestOptions != null && (filterPredicate = requestOptions.getFilterPredicate()) != null && !filterPredicate.isEmpty()) {
            jsonSerializable.set("condition", filterPredicate, CosmosItemSerializer.DEFAULT_SERIALIZER);
        }
        return jsonSerializable;
    }
}

