/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.circuitBreaker;

import com.azure.cosmos.implementation.Configs;
import com.azure.cosmos.implementation.FeedOperationContextForCircuitBreaker;
import com.azure.cosmos.implementation.GlobalEndpointManager;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.OperationType;
import com.azure.cosmos.implementation.PartitionKeyRange;
import com.azure.cosmos.implementation.PointOperationContextForCircuitBreaker;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.apachecommons.collections.list.UnmodifiableList;
import com.azure.cosmos.implementation.apachecommons.lang.tuple.Pair;
import com.azure.cosmos.implementation.circuitBreaker.ConsecutiveExceptionBasedCircuitBreaker;
import com.azure.cosmos.implementation.circuitBreaker.LocationHealthStatus;
import com.azure.cosmos.implementation.circuitBreaker.LocationSpecificHealthContext;
import com.azure.cosmos.implementation.circuitBreaker.LocationSpecificHealthContextTransitionHandler;
import com.azure.cosmos.implementation.circuitBreaker.PartitionKeyRangeWrapper;
import com.azure.cosmos.implementation.circuitBreaker.PartitionLevelCircuitBreakerConfig;
import com.azure.cosmos.implementation.directconnectivity.GatewayAddressCache;
import com.azure.cosmos.implementation.directconnectivity.GlobalAddressResolver;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public class GlobalPartitionEndpointManagerForCircuitBreaker
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(GlobalPartitionEndpointManagerForCircuitBreaker.class);
    private static final ImplementationBridgeHelpers.CosmosQueryRequestOptionsHelper.CosmosQueryRequestOptionsAccessor queryRequestOptionsAccessor = ImplementationBridgeHelpers.CosmosQueryRequestOptionsHelper.getCosmosQueryRequestOptionsAccessor();
    private final GlobalEndpointManager globalEndpointManager;
    private final ConcurrentHashMap<PartitionKeyRangeWrapper, PartitionLevelLocationUnavailabilityInfo> partitionKeyRangeToLocationSpecificUnavailabilityInfo;
    private final ConcurrentHashMap<PartitionKeyRangeWrapper, PartitionKeyRangeWrapper> partitionKeyRangesWithPossibleUnavailableRegions;
    private final LocationSpecificHealthContextTransitionHandler locationSpecificHealthContextTransitionHandler;
    private final ConsecutiveExceptionBasedCircuitBreaker consecutiveExceptionBasedCircuitBreaker;
    private final AtomicReference<GlobalAddressResolver> globalAddressResolverSnapshot;
    private final ConcurrentHashMap<URI, String> locationToRegion;
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final Scheduler partitionRecoveryScheduler = Schedulers.newSingle((String)"partition-availability-staleness-check");

    public GlobalPartitionEndpointManagerForCircuitBreaker(GlobalEndpointManager globalEndpointManager) {
        this.partitionKeyRangeToLocationSpecificUnavailabilityInfo = new ConcurrentHashMap();
        this.partitionKeyRangesWithPossibleUnavailableRegions = new ConcurrentHashMap();
        this.globalEndpointManager = globalEndpointManager;
        PartitionLevelCircuitBreakerConfig partitionLevelCircuitBreakerConfig = Configs.getPartitionLevelCircuitBreakerConfig();
        this.consecutiveExceptionBasedCircuitBreaker = new ConsecutiveExceptionBasedCircuitBreaker(partitionLevelCircuitBreakerConfig);
        this.locationSpecificHealthContextTransitionHandler = new LocationSpecificHealthContextTransitionHandler(this.globalEndpointManager, this.consecutiveExceptionBasedCircuitBreaker);
        this.globalAddressResolverSnapshot = new AtomicReference();
        this.locationToRegion = new ConcurrentHashMap();
    }

    public void init() {
        if (this.consecutiveExceptionBasedCircuitBreaker.isPartitionLevelCircuitBreakerEnabled()) {
            this.updateStaleLocationInfo().subscribeOn(this.partitionRecoveryScheduler).subscribe();
        }
    }

    public void handleLocationExceptionForPartitionKeyRange(RxDocumentServiceRequest request, URI failedLocation) {
        Preconditions.checkNotNull(request, "Argument 'request' cannot be null!");
        Preconditions.checkNotNull(request.requestContext, "Argument 'request.requestContext' cannot be null!");
        PartitionKeyRange partitionKeyRange = request.requestContext.resolvedPartitionKeyRange;
        Preconditions.checkNotNull(request.requestContext.resolvedPartitionKeyRange, "Argument 'request.requestContext.resolvedPartitionKeyRange' cannot be null!");
        String collectionResourceId = request.getResourceId();
        Preconditions.checkNotNull(collectionResourceId, "Argument 'collectionResourceId' cannot be null!");
        PartitionKeyRangeWrapper partitionKeyRangeWrapper = new PartitionKeyRangeWrapper(partitionKeyRange, collectionResourceId);
        AtomicBoolean isFailoverPossible = new AtomicBoolean(true);
        AtomicBoolean isFailureThresholdBreached = new AtomicBoolean(false);
        this.partitionKeyRangeToLocationSpecificUnavailabilityInfo.compute(partitionKeyRangeWrapper, (partitionKeyRangeWrapperAsKey, partitionLevelLocationUnavailabilityInfoAsVal) -> {
            if (partitionLevelLocationUnavailabilityInfoAsVal == null) {
                partitionLevelLocationUnavailabilityInfoAsVal = new PartitionLevelLocationUnavailabilityInfo();
            }
            isFailureThresholdBreached.set(((PartitionLevelLocationUnavailabilityInfo)partitionLevelLocationUnavailabilityInfoAsVal).handleException(partitionKeyRangeWrapperAsKey, failedLocation, request.isReadOnlyRequest()));
            if (isFailureThresholdBreached.get()) {
                UnmodifiableList<URI> applicableEndpoints = request.isReadOnlyRequest() ? this.globalEndpointManager.getApplicableReadEndpoints(request.requestContext.getExcludeRegions()) : this.globalEndpointManager.getApplicableWriteEndpoints(request.requestContext.getExcludeRegions());
                isFailoverPossible.set(partitionLevelLocationUnavailabilityInfoAsVal.areLocationsAvailableForPartitionKeyRange(applicableEndpoints));
            }
            request.requestContext.setLocationToLocationSpecificHealthContext(((PartitionLevelLocationUnavailabilityInfo)partitionLevelLocationUnavailabilityInfoAsVal).regionToLocationSpecificHealthContext);
            return partitionLevelLocationUnavailabilityInfoAsVal;
        });
        if (isFailoverPossible.get()) {
            return;
        }
        if (logger.isWarnEnabled()) {
            logger.warn("It is not possible to mark region {} as Unavailable for partition key range {}-{} and collection rid {} as all regions will be Unavailable in that case, will remove health status tracking for this partition!", new Object[]{this.globalEndpointManager.getRegionName(failedLocation, request.isReadOnlyRequest() ? OperationType.Read : OperationType.Create), partitionKeyRange.getMinInclusive(), partitionKeyRange.getMaxExclusive(), collectionResourceId});
        }
        this.partitionKeyRangeToLocationSpecificUnavailabilityInfo.remove(partitionKeyRangeWrapper);
    }

    public void handleLocationSuccessForPartitionKeyRange(RxDocumentServiceRequest request) {
        Preconditions.checkNotNull(request, "Argument 'request' cannot be null!");
        Preconditions.checkNotNull(request.requestContext, "Argument 'request.requestContext' cannot be null!");
        PartitionKeyRange partitionKeyRange = request.requestContext.resolvedPartitionKeyRange;
        Preconditions.checkNotNull(request.requestContext.resolvedPartitionKeyRange, "Argument 'request.requestContext.resolvedPartitionKeyRange' cannot be null!");
        String resourceId = request.getResourceId();
        PartitionKeyRangeWrapper partitionKeyRangeWrapper = new PartitionKeyRangeWrapper(partitionKeyRange, resourceId);
        URI succeededLocation = request.requestContext.locationEndpointToRoute;
        String collectionLink = GlobalPartitionEndpointManagerForCircuitBreaker.getCollectionLink(request);
        this.partitionKeyRangeToLocationSpecificUnavailabilityInfo.compute(partitionKeyRangeWrapper, (partitionKeyRangeWrapperAsKey, partitionKeyRangeToFailoverInfoAsVal) -> {
            if (partitionKeyRangeToFailoverInfoAsVal == null) {
                partitionKeyRangeToFailoverInfoAsVal = new PartitionLevelLocationUnavailabilityInfo();
            }
            ((PartitionLevelLocationUnavailabilityInfo)partitionKeyRangeToFailoverInfoAsVal).handleSuccess(partitionKeyRangeWrapper, collectionLink, succeededLocation, request.isReadOnlyRequest());
            request.requestContext.setLocationToLocationSpecificHealthContext(((PartitionLevelLocationUnavailabilityInfo)partitionKeyRangeToFailoverInfoAsVal).regionToLocationSpecificHealthContext);
            return partitionKeyRangeToFailoverInfoAsVal;
        });
    }

    public List<String> getUnavailableRegionsForPartitionKeyRange(String collectionResourceId, PartitionKeyRange partitionKeyRange, OperationType operationType) {
        Preconditions.checkNotNull(partitionKeyRange, "Argument 'partitionKeyRange' cannot be null!");
        Preconditions.checkNotNull(collectionResourceId, "Argument 'collectionResourceId' cannot be null!");
        PartitionKeyRangeWrapper partitionKeyRangeWrapper = new PartitionKeyRangeWrapper(partitionKeyRange, collectionResourceId);
        PartitionLevelLocationUnavailabilityInfo partitionLevelLocationUnavailabilityInfoSnapshot = this.partitionKeyRangeToLocationSpecificUnavailabilityInfo.get(partitionKeyRangeWrapper);
        ArrayList<String> unavailableRegions = new ArrayList<String>();
        if (partitionLevelLocationUnavailabilityInfoSnapshot != null) {
            ConcurrentHashMap locationEndpointToFailureMetricsForPartition = partitionLevelLocationUnavailabilityInfoSnapshot.locationEndpointToLocationSpecificContextForPartition;
            for (Map.Entry pair : locationEndpointToFailureMetricsForPartition.entrySet()) {
                URI location = (URI)pair.getKey();
                LocationSpecificHealthContext locationSpecificHealthContext = (LocationSpecificHealthContext)pair.getValue();
                if (locationSpecificHealthContext.getLocationHealthStatus() != LocationHealthStatus.Unavailable) continue;
                unavailableRegions.add(this.globalEndpointManager.getRegionName(location, operationType));
            }
        }
        return UnmodifiableList.unmodifiableList(unavailableRegions);
    }

    private Flux<?> updateStaleLocationInfo() {
        return Mono.just((Object)1).delayElement(Duration.ofSeconds(Configs.getStalePartitionUnavailabilityRefreshIntervalInSeconds())).repeat(() -> !this.isClosed.get()).flatMap(ignore -> Flux.fromIterable(this.partitionKeyRangesWithPossibleUnavailableRegions.entrySet())).publishOn(this.partitionRecoveryScheduler).flatMap(partitionKeyRangeWrapperToPartitionKeyRangeWrapperPair -> {
            logger.debug("Background updateStaleLocationInfo kicking in...");
            PartitionKeyRangeWrapper partitionKeyRangeWrapper = (PartitionKeyRangeWrapper)partitionKeyRangeWrapperToPartitionKeyRangeWrapperPair.getKey();
            PartitionLevelLocationUnavailabilityInfo partitionLevelLocationUnavailabilityInfo = this.partitionKeyRangeToLocationSpecificUnavailabilityInfo.get(partitionKeyRangeWrapper);
            if (partitionLevelLocationUnavailabilityInfo != null) {
                ArrayList<Pair<PartitionKeyRangeWrapper, Pair<URI, LocationSpecificHealthContext>>> locationToLocationSpecificHealthContextList = new ArrayList<Pair<PartitionKeyRangeWrapper, Pair<URI, LocationSpecificHealthContext>>>();
                for (Map.Entry locationToLocationLevelMetrics : partitionLevelLocationUnavailabilityInfo.locationEndpointToLocationSpecificContextForPartition.entrySet()) {
                    URI locationWithStaleUnavailabilityInfo = (URI)locationToLocationLevelMetrics.getKey();
                    LocationSpecificHealthContext locationSpecificHealthContext = (LocationSpecificHealthContext)locationToLocationLevelMetrics.getValue();
                    if (locationSpecificHealthContext.isRegionAvailableToProcessRequests()) continue;
                    locationToLocationSpecificHealthContextList.add(Pair.of(partitionKeyRangeWrapper, Pair.of(locationWithStaleUnavailabilityInfo, locationSpecificHealthContext)));
                }
                if (locationToLocationSpecificHealthContextList.isEmpty()) {
                    this.partitionKeyRangesWithPossibleUnavailableRegions.remove(partitionKeyRangeWrapper);
                    return Flux.empty();
                }
                return Flux.fromIterable(locationToLocationSpecificHealthContextList);
            }
            this.partitionKeyRangesWithPossibleUnavailableRegions.remove(partitionKeyRangeWrapper);
            return Mono.empty();
        }).flatMap(locationToLocationSpecificHealthContextPair -> {
            PartitionKeyRangeWrapper partitionKeyRangeWrapper = (PartitionKeyRangeWrapper)locationToLocationSpecificHealthContextPair.getLeft();
            URI locationWithStaleUnavailabilityInfo = (URI)((Pair)locationToLocationSpecificHealthContextPair.getRight()).getLeft();
            PartitionLevelLocationUnavailabilityInfo partitionLevelLocationUnavailabilityInfo = this.partitionKeyRangeToLocationSpecificUnavailabilityInfo.get(partitionKeyRangeWrapper);
            if (partitionLevelLocationUnavailabilityInfo != null) {
                GlobalAddressResolver globalAddressResolver = this.globalAddressResolverSnapshot.get();
                if (globalAddressResolver != null) {
                    GatewayAddressCache gatewayAddressCache = globalAddressResolver.getGatewayAddressCache(locationWithStaleUnavailabilityInfo);
                    if (gatewayAddressCache != null) {
                        return gatewayAddressCache.submitOpenConnectionTasks(partitionKeyRangeWrapper.getPartitionKeyRange(), partitionKeyRangeWrapper.getCollectionResourceId()).publishOn(this.partitionRecoveryScheduler).timeout(Duration.ofSeconds(Configs.getConnectionEstablishmentTimeoutForPartitionRecoveryInSeconds())).doOnComplete(() -> {
                            if (logger.isDebugEnabled()) {
                                logger.debug("Partition health recovery query for partition key range : {}-{} and collection rid : {} has succeeded...", new Object[]{partitionKeyRangeWrapper.getPartitionKeyRange().getMinInclusive(), partitionKeyRangeWrapper.getPartitionKeyRange().getMaxExclusive(), partitionKeyRangeWrapper.getCollectionResourceId()});
                            }
                            partitionLevelLocationUnavailabilityInfo.locationEndpointToLocationSpecificContextForPartition.compute(locationWithStaleUnavailabilityInfo, (locationWithStaleUnavailabilityInfoAsKey, locationSpecificContextAsVal) -> {
                                if (locationSpecificContextAsVal != null) {
                                    locationSpecificContextAsVal = this.locationSpecificHealthContextTransitionHandler.handleSuccess((LocationSpecificHealthContext)locationSpecificContextAsVal, partitionKeyRangeWrapper, this.locationToRegion.getOrDefault(locationWithStaleUnavailabilityInfoAsKey, ""), false, true);
                                }
                                return locationSpecificContextAsVal;
                            });
                        });
                    }
                } else {
                    partitionLevelLocationUnavailabilityInfo.locationEndpointToLocationSpecificContextForPartition.compute(locationWithStaleUnavailabilityInfo, (locationWithStaleUnavailabilityInfoAsKey, locationSpecificContextAsVal) -> {
                        if (locationSpecificContextAsVal != null) {
                            locationSpecificContextAsVal = this.locationSpecificHealthContextTransitionHandler.handleSuccess((LocationSpecificHealthContext)locationSpecificContextAsVal, partitionKeyRangeWrapper, this.locationToRegion.getOrDefault(locationWithStaleUnavailabilityInfoAsKey, ""), false, true);
                        }
                        return locationSpecificContextAsVal;
                    });
                }
            }
            return Flux.empty();
        }).onErrorResume(throwable -> {
            if (logger.isDebugEnabled()) {
                logger.debug("An exception was thrown trying to recover an Unavailable partition key range!");
            }
            return Flux.empty();
        });
    }

    public boolean isPartitionLevelCircuitBreakingApplicable(RxDocumentServiceRequest request) {
        if (!this.consecutiveExceptionBasedCircuitBreaker.isPartitionLevelCircuitBreakerEnabled()) {
            return false;
        }
        if (request == null) {
            return false;
        }
        if (request.getResourceType() != ResourceType.Document) {
            return false;
        }
        if (request.getOperationType() == OperationType.QueryPlan) {
            return false;
        }
        GlobalEndpointManager globalEndpointManager = this.globalEndpointManager;
        if (!globalEndpointManager.canUseMultipleWriteLocations(request)) {
            return false;
        }
        UnmodifiableList<URI> applicableWriteEndpoints = globalEndpointManager.getApplicableWriteEndpoints(Collections.emptyList());
        return applicableWriteEndpoints != null && applicableWriteEndpoints.size() > 1;
    }

    public void setGlobalAddressResolver(GlobalAddressResolver globalAddressResolver) {
        this.globalAddressResolverSnapshot.set(globalAddressResolver);
    }

    @Override
    public void close() {
        this.isClosed.set(true);
        this.partitionRecoveryScheduler.dispose();
    }

    public ConsecutiveExceptionBasedCircuitBreaker getConsecutiveExceptionBasedCircuitBreaker() {
        return this.consecutiveExceptionBasedCircuitBreaker;
    }

    public PartitionLevelCircuitBreakerConfig getCircuitBreakerConfig() {
        return this.consecutiveExceptionBasedCircuitBreaker.getPartitionLevelCircuitBreakerConfig();
    }

    private static String getCollectionLink(RxDocumentServiceRequest request) {
        Preconditions.checkNotNull(request, "Argument 'request' cannot be null!");
        Preconditions.checkNotNull(request.requestContext, "Argument 'request.requestContext' cannot be null!");
        PointOperationContextForCircuitBreaker pointOperationContextForCircuitBreaker = request.requestContext.getPointOperationContextForCircuitBreaker();
        FeedOperationContextForCircuitBreaker feedOperationContextForCircuitBreaker = request.requestContext.getFeedOperationContextForCircuitBreaker();
        if (pointOperationContextForCircuitBreaker != null) {
            Preconditions.checkNotNull(pointOperationContextForCircuitBreaker.getCollectionLink(), "Argument 'pointOperationContextForCircuitBreaker.getCollectionLink()' cannot be null!");
            return pointOperationContextForCircuitBreaker.getCollectionLink();
        }
        if (feedOperationContextForCircuitBreaker != null) {
            Preconditions.checkNotNull(feedOperationContextForCircuitBreaker.getCollectionLink(), "Argument 'feedOperationContextForCircuitBreaker.getCollectionLink()' cannot be null!");
            return feedOperationContextForCircuitBreaker.getCollectionLink();
        }
        throw new IllegalStateException("Both pointOperationContextForCircuitBreaker [or] feedOperationContextForCircuitBreaker cannot be null!");
    }

    private class PartitionLevelLocationUnavailabilityInfo {
        private final ConcurrentHashMap<URI, LocationSpecificHealthContext> locationEndpointToLocationSpecificContextForPartition = new ConcurrentHashMap();
        private final ConcurrentHashMap<String, LocationSpecificHealthContext> regionToLocationSpecificHealthContext = new ConcurrentHashMap();
        private final LocationSpecificHealthContextTransitionHandler locationSpecificHealthContextTransitionHandler;

        private PartitionLevelLocationUnavailabilityInfo() {
            this.locationSpecificHealthContextTransitionHandler = GlobalPartitionEndpointManagerForCircuitBreaker.this.locationSpecificHealthContextTransitionHandler;
        }

        private boolean handleException(PartitionKeyRangeWrapper partitionKeyRangeWrapper, URI locationWithException, boolean isReadOnlyRequest) {
            AtomicBoolean isExceptionThresholdBreached = new AtomicBoolean(false);
            this.locationEndpointToLocationSpecificContextForPartition.compute(locationWithException, (locationAsKey, locationSpecificContextAsVal) -> {
                if (locationSpecificContextAsVal == null) {
                    locationSpecificContextAsVal = new LocationSpecificHealthContext.Builder().withSuccessCountForWriteForRecovery(0).withExceptionCountForWriteForCircuitBreaking(0).withSuccessCountForReadForRecovery(0).withExceptionCountForReadForCircuitBreaking(0).withUnavailableSince(Instant.MAX).withLocationHealthStatus(LocationHealthStatus.HealthyWithFailures).withExceptionThresholdBreached(false).build();
                }
                LocationSpecificHealthContext locationSpecificHealthContextAfterTransition = this.locationSpecificHealthContextTransitionHandler.handleException((LocationSpecificHealthContext)locationSpecificContextAsVal, partitionKeyRangeWrapper, GlobalPartitionEndpointManagerForCircuitBreaker.this.partitionKeyRangesWithPossibleUnavailableRegions, GlobalPartitionEndpointManagerForCircuitBreaker.this.locationToRegion.getOrDefault(locationWithException, ""), isReadOnlyRequest);
                if (GlobalPartitionEndpointManagerForCircuitBreaker.this.locationToRegion.get(locationAsKey) == null) {
                    GlobalPartitionEndpointManagerForCircuitBreaker.this.locationToRegion.put(locationAsKey, GlobalPartitionEndpointManagerForCircuitBreaker.this.globalEndpointManager.getRegionName((URI)locationAsKey, isReadOnlyRequest ? OperationType.Read : OperationType.Create));
                }
                String region = (String)GlobalPartitionEndpointManagerForCircuitBreaker.this.locationToRegion.get(locationAsKey);
                this.regionToLocationSpecificHealthContext.put(region, locationSpecificHealthContextAfterTransition);
                isExceptionThresholdBreached.set(locationSpecificHealthContextAfterTransition.isExceptionThresholdBreached());
                return locationSpecificHealthContextAfterTransition;
            });
            return isExceptionThresholdBreached.get();
        }

        private void handleSuccess(PartitionKeyRangeWrapper partitionKeyRangeWrapper, String collectionLink, URI succeededLocation, boolean isReadOnlyRequest) {
            this.locationEndpointToLocationSpecificContextForPartition.compute(succeededLocation, (locationAsKey, locationSpecificContextAsVal) -> {
                if (locationSpecificContextAsVal == null) {
                    locationSpecificContextAsVal = new LocationSpecificHealthContext.Builder().withSuccessCountForWriteForRecovery(0).withExceptionCountForWriteForCircuitBreaking(0).withSuccessCountForReadForRecovery(0).withExceptionCountForReadForCircuitBreaking(0).withUnavailableSince(Instant.MAX).withLocationHealthStatus(LocationHealthStatus.Healthy).withExceptionThresholdBreached(false).build();
                }
                LocationSpecificHealthContext locationSpecificHealthContextAfterTransition = this.locationSpecificHealthContextTransitionHandler.handleSuccess((LocationSpecificHealthContext)locationSpecificContextAsVal, partitionKeyRangeWrapper, GlobalPartitionEndpointManagerForCircuitBreaker.this.locationToRegion.getOrDefault(succeededLocation, ""), false, isReadOnlyRequest);
                if (GlobalPartitionEndpointManagerForCircuitBreaker.this.locationToRegion.get(locationAsKey) == null) {
                    GlobalPartitionEndpointManagerForCircuitBreaker.this.locationToRegion.put(locationAsKey, GlobalPartitionEndpointManagerForCircuitBreaker.this.globalEndpointManager.getRegionName((URI)locationAsKey, isReadOnlyRequest ? OperationType.Read : OperationType.Create));
                }
                String region = (String)GlobalPartitionEndpointManagerForCircuitBreaker.this.locationToRegion.get(locationAsKey);
                this.regionToLocationSpecificHealthContext.put(region, locationSpecificHealthContextAfterTransition);
                return locationSpecificHealthContextAfterTransition;
            });
        }

        public boolean areLocationsAvailableForPartitionKeyRange(List<URI> availableLocationsAtAccountLevel) {
            for (URI availableLocation : availableLocationsAtAccountLevel) {
                if (!this.locationEndpointToLocationSpecificContextForPartition.containsKey(availableLocation)) {
                    return true;
                }
                LocationSpecificHealthContext locationSpecificHealthContextSnapshot = this.locationEndpointToLocationSpecificContextForPartition.get(availableLocation);
                if (!locationSpecificHealthContextSnapshot.isRegionAvailableToProcessRequests()) continue;
                return true;
            }
            return false;
        }
    }
}

