/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.CosmosItemSerializer;
import com.azure.cosmos.implementation.CosmosBulkExecutionOptionsImpl;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.batch.BulkExecutorDiagnosticsTracker;
import com.azure.cosmos.implementation.spark.OperationContextAndListenerTuple;
import com.azure.cosmos.models.CosmosBulkExecutionThresholdsState;
import java.time.Duration;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import reactor.core.scheduler.Scheduler;

public final class CosmosBulkExecutionOptions {
    private final CosmosBulkExecutionOptionsImpl actualRequestOptions;
    private static final Set<String> EMPTY_KEYWORD_IDENTIFIERS = Collections.unmodifiableSet(new HashSet());

    CosmosBulkExecutionOptions(CosmosBulkExecutionOptions toBeCloned) {
        this.actualRequestOptions = new CosmosBulkExecutionOptionsImpl(toBeCloned.actualRequestOptions);
    }

    CosmosBulkExecutionOptions(Object legacyBatchScopedContext, CosmosBulkExecutionThresholdsState thresholdsState, Map<String, String> customOptions) {
        this.actualRequestOptions = new CosmosBulkExecutionOptionsImpl(legacyBatchScopedContext, thresholdsState, customOptions);
    }

    public CosmosBulkExecutionOptions(CosmosBulkExecutionThresholdsState thresholdsState) {
        this(null, thresholdsState, null);
    }

    public CosmosBulkExecutionOptions() {
        this(null, null, null);
    }

    public int getInitialMicroBatchSize() {
        return this.actualRequestOptions.getInitialMicroBatchSize();
    }

    public CosmosBulkExecutionOptions setInitialMicroBatchSize(int initialMicroBatchSize) {
        this.actualRequestOptions.setInitialMicroBatchSize(initialMicroBatchSize);
        return this;
    }

    int getMaxMicroBatchPayloadSizeInBytes() {
        return this.actualRequestOptions.getMaxMicroBatchPayloadSizeInBytes();
    }

    CosmosBulkExecutionOptions setMaxMicroBatchPayloadSizeInBytes(int maxMicroBatchPayloadSizeInBytes) {
        this.actualRequestOptions.setMaxMicroBatchPayloadSizeInBytes(maxMicroBatchPayloadSizeInBytes);
        return this;
    }

    public int getMaxMicroBatchSize() {
        return this.actualRequestOptions.getMaxMicroBatchSize();
    }

    public CosmosBulkExecutionOptions setMaxMicroBatchSize(int maxMicroBatchSize) {
        this.actualRequestOptions.setMaxMicroBatchSize(maxMicroBatchSize);
        return this;
    }

    public CosmosItemSerializer getCustomItemSerializer() {
        return this.actualRequestOptions.getCustomItemSerializer();
    }

    public CosmosBulkExecutionOptions setCustomItemSerializer(CosmosItemSerializer customItemSerializer) {
        this.actualRequestOptions.setCustomItemSerializer(customItemSerializer);
        return this;
    }

    Integer getMaxConcurrentCosmosPartitions() {
        return this.actualRequestOptions.getMaxConcurrentCosmosPartitions();
    }

    CosmosBulkExecutionOptions setMaxConcurrentCosmosPartitions(int maxConcurrentCosmosPartitions) {
        this.actualRequestOptions.setMaxConcurrentCosmosPartitions(maxConcurrentCosmosPartitions);
        return this;
    }

    public int getMaxMicroBatchConcurrency() {
        return this.actualRequestOptions.getMaxMicroBatchConcurrency();
    }

    public CosmosBulkExecutionOptions setMaxMicroBatchConcurrency(int maxMicroBatchConcurrency) {
        this.actualRequestOptions.setMaxMicroBatchConcurrency(maxMicroBatchConcurrency);
        return this;
    }

    Duration getMaxMicroBatchInterval() {
        return this.actualRequestOptions.getMaxMicroBatchInterval();
    }

    double getMaxTargetedMicroBatchRetryRate() {
        return this.actualRequestOptions.getMaxTargetedMicroBatchRetryRate();
    }

    CosmosBulkExecutionOptions setTargetedMicroBatchRetryRate(double minRetryRate, double maxRetryRate) {
        this.actualRequestOptions.setTargetedMicroBatchRetryRate(minRetryRate, maxRetryRate);
        return this;
    }

    double getMinTargetedMicroBatchRetryRate() {
        return this.actualRequestOptions.getMinTargetedMicroBatchRetryRate();
    }

    Object getLegacyBatchScopedContext() {
        return this.actualRequestOptions.getLegacyBatchScopedContext();
    }

    public CosmosBulkExecutionThresholdsState getThresholdsState() {
        return this.actualRequestOptions.getThresholdsState();
    }

    OperationContextAndListenerTuple getOperationContextAndListenerTuple() {
        return this.actualRequestOptions.getOperationContextAndListenerTuple();
    }

    void setOperationContextAndListenerTuple(OperationContextAndListenerTuple operationContextAndListenerTuple) {
        this.actualRequestOptions.setOperationContextAndListenerTuple(operationContextAndListenerTuple);
    }

    CosmosBulkExecutionOptions setHeader(String name, String value) {
        this.actualRequestOptions.setHeader(name, value);
        return this;
    }

    Map<String, String> getHeaders() {
        return this.actualRequestOptions.getHeaders();
    }

    public String getThroughputControlGroupName() {
        return this.actualRequestOptions.getThroughputControlGroupName();
    }

    public CosmosBulkExecutionOptions setThroughputControlGroupName(String throughputControlGroupName) {
        this.actualRequestOptions.setThroughputControlGroupName(throughputControlGroupName);
        return this;
    }

    public CosmosBulkExecutionOptions setExcludedRegions(List<String> excludeRegions) {
        this.actualRequestOptions.setExcludedRegions(excludeRegions);
        return this;
    }

    public List<String> getExcludedRegions() {
        return this.actualRequestOptions.getExcludedRegions();
    }

    void setDiagnosticsTracker(BulkExecutorDiagnosticsTracker tracker) {
        this.actualRequestOptions.setDiagnosticsTracker(tracker);
    }

    BulkExecutorDiagnosticsTracker getDiagnosticsTracker() {
        return this.actualRequestOptions.getDiagnosticsTracker();
    }

    public CosmosBulkExecutionOptions setKeywordIdentifiers(Set<String> keywordIdentifiers) {
        if (keywordIdentifiers != null) {
            this.actualRequestOptions.setKeywordIdentifiers(Collections.unmodifiableSet(keywordIdentifiers));
        } else {
            this.actualRequestOptions.setKeywordIdentifiers(EMPTY_KEYWORD_IDENTIFIERS);
        }
        return this;
    }

    public Set<String> getKeywordIdentifiers() {
        return this.actualRequestOptions.getKeywordIdentifiers();
    }

    CosmosBulkExecutionOptionsImpl getImpl() {
        return this.actualRequestOptions;
    }

    CosmosBulkExecutionOptions setSchedulerOverride(Scheduler customScheduler) {
        this.actualRequestOptions.setSchedulerOverride(customScheduler);
        return this;
    }

    static void initialize() {
        ImplementationBridgeHelpers.CosmosBulkExecutionOptionsHelper.setCosmosBulkExecutionOptionsAccessor(new ImplementationBridgeHelpers.CosmosBulkExecutionOptionsHelper.CosmosBulkExecutionOptionsAccessor(){

            @Override
            public void setOperationContext(CosmosBulkExecutionOptions options, OperationContextAndListenerTuple operationContextAndListenerTuple) {
                options.setOperationContextAndListenerTuple(operationContextAndListenerTuple);
            }

            @Override
            public OperationContextAndListenerTuple getOperationContext(CosmosBulkExecutionOptions options) {
                return options.getOperationContextAndListenerTuple();
            }

            @Override
            public <T> T getLegacyBatchScopedContext(CosmosBulkExecutionOptions options) {
                return (T)options.getLegacyBatchScopedContext();
            }

            @Override
            public double getMinTargetedMicroBatchRetryRate(CosmosBulkExecutionOptions options) {
                return options.getMinTargetedMicroBatchRetryRate();
            }

            @Override
            public double getMaxTargetedMicroBatchRetryRate(CosmosBulkExecutionOptions options) {
                return options.getMaxTargetedMicroBatchRetryRate();
            }

            @Override
            public int getMaxMicroBatchPayloadSizeInBytes(CosmosBulkExecutionOptions options) {
                return options.getMaxMicroBatchPayloadSizeInBytes();
            }

            @Override
            public CosmosBulkExecutionOptions setMaxMicroBatchPayloadSizeInBytes(CosmosBulkExecutionOptions options, int maxMicroBatchPayloadSizeInBytes) {
                return options.setMaxMicroBatchPayloadSizeInBytes(maxMicroBatchPayloadSizeInBytes);
            }

            @Override
            public int getMaxMicroBatchConcurrency(CosmosBulkExecutionOptions options) {
                return options.getMaxMicroBatchConcurrency();
            }

            @Override
            public Integer getMaxConcurrentCosmosPartitions(CosmosBulkExecutionOptions options) {
                return options.getMaxConcurrentCosmosPartitions();
            }

            @Override
            public CosmosBulkExecutionOptions setMaxConcurrentCosmosPartitions(CosmosBulkExecutionOptions options, int maxConcurrentCosmosPartitions) {
                return options.setMaxConcurrentCosmosPartitions(maxConcurrentCosmosPartitions);
            }

            @Override
            public Duration getMaxMicroBatchInterval(CosmosBulkExecutionOptions options) {
                return options.getMaxMicroBatchInterval();
            }

            @Override
            public CosmosBulkExecutionOptions setTargetedMicroBatchRetryRate(CosmosBulkExecutionOptions options, double minRetryRate, double maxRetryRate) {
                return options.setTargetedMicroBatchRetryRate(minRetryRate, maxRetryRate);
            }

            @Override
            public CosmosBulkExecutionOptions setHeader(CosmosBulkExecutionOptions cosmosBulkExecutionOptions, String name, String value) {
                return cosmosBulkExecutionOptions.setHeader(name, value);
            }

            @Override
            public Map<String, String> getHeader(CosmosBulkExecutionOptions cosmosBulkExecutionOptions) {
                return cosmosBulkExecutionOptions.getHeaders();
            }

            @Override
            public Map<String, String> getCustomOptions(CosmosBulkExecutionOptions cosmosBulkExecutionOptions) {
                return cosmosBulkExecutionOptions.getHeaders();
            }

            @Override
            public int getMaxMicroBatchSize(CosmosBulkExecutionOptions cosmosBulkExecutionOptions) {
                if (cosmosBulkExecutionOptions == null) {
                    return 100;
                }
                return cosmosBulkExecutionOptions.getMaxMicroBatchSize();
            }

            @Override
            public void setDiagnosticsTracker(CosmosBulkExecutionOptions cosmosBulkExecutionOptions, BulkExecutorDiagnosticsTracker tracker) {
                cosmosBulkExecutionOptions.setDiagnosticsTracker(tracker);
            }

            @Override
            public BulkExecutorDiagnosticsTracker getDiagnosticsTracker(CosmosBulkExecutionOptions cosmosBulkExecutionOptions) {
                return cosmosBulkExecutionOptions.getDiagnosticsTracker();
            }

            @Override
            public CosmosBulkExecutionOptions setSchedulerOverride(CosmosBulkExecutionOptions cosmosBulkExecutionOptions, Scheduler customScheduler) {
                return cosmosBulkExecutionOptions.setSchedulerOverride(customScheduler);
            }

            @Override
            public CosmosBulkExecutionOptions clone(CosmosBulkExecutionOptions toBeCloned) {
                return new CosmosBulkExecutionOptions(toBeCloned);
            }

            @Override
            public CosmosBulkExecutionOptionsImpl getImpl(CosmosBulkExecutionOptions options) {
                return options.getImpl();
            }
        });
    }

    static {
        CosmosBulkExecutionOptions.initialize();
    }
}

