/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;

public enum CosmosVectorDistanceFunction {
    EUCLIDEAN("euclidean"),
    COSINE("cosine"),
    DOT_PRODUCT("dotproduct");

    private final String overWireValue;

    private CosmosVectorDistanceFunction(String overWireValue) {
        this.overWireValue = overWireValue;
    }

    @JsonValue
    public String toString() {
        return this.overWireValue;
    }

    public static CosmosVectorDistanceFunction fromString(String value) {
        return Arrays.stream(CosmosVectorDistanceFunction.values()).filter(vectorDistanceFunction -> vectorDistanceFunction.toString().equalsIgnoreCase(value)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Invalid distance function with value {%s} for the vector embedding policy.", value)));
    }
}

