/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.query;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosDiagnostics;
import com.azure.cosmos.CosmosException;
import com.azure.cosmos.implementation.ClientSideRequestStatistics;
import com.azure.cosmos.implementation.DiagnosticsClientContext;
import com.azure.cosmos.implementation.Document;
import com.azure.cosmos.implementation.DocumentClientRetryPolicy;
import com.azure.cosmos.implementation.DocumentCollection;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.QueryMetrics;
import com.azure.cosmos.implementation.RequestChargeTracker;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.feedranges.FeedRangeEpkImpl;
import com.azure.cosmos.implementation.query.IDocumentQueryClient;
import com.azure.cosmos.implementation.query.IDocumentQueryExecutionComponent;
import com.azure.cosmos.implementation.query.NonStreamingOrderByDocumentProducer;
import com.azure.cosmos.implementation.query.NonStreamingOrderByUtils;
import com.azure.cosmos.implementation.query.ParallelDocumentQueryExecutionContextBase;
import com.azure.cosmos.implementation.query.PipelinedDocumentQueryParams;
import com.azure.cosmos.implementation.query.QueryInfo;
import com.azure.cosmos.implementation.query.SortOrder;
import com.azure.cosmos.implementation.query.TriFunction;
import com.azure.cosmos.implementation.query.orderbyquery.OrderByRowResult;
import com.azure.cosmos.implementation.query.orderbyquery.OrderbyRowComparer;
import com.azure.cosmos.models.CosmosQueryRequestOptions;
import com.azure.cosmos.models.FeedResponse;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.azure.cosmos.models.SqlQuerySpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class NonStreamingOrderByDocumentQueryExecutionContext
extends ParallelDocumentQueryExecutionContextBase<Document> {
    private static final ImplementationBridgeHelpers.CosmosDiagnosticsHelper.CosmosDiagnosticsAccessor diagnosticsAccessor = ImplementationBridgeHelpers.CosmosDiagnosticsHelper.getCosmosDiagnosticsAccessor();
    private static final ImplementationBridgeHelpers.FeedResponseHelper.FeedResponseAccessor feedResponseAccessor = ImplementationBridgeHelpers.FeedResponseHelper.getFeedResponseAccessor();
    private static final String FormatPlaceHolder = "{documentdb-formattableorderbyquery-filter}";
    private static final String True = "true";
    private final OrderbyRowComparer<Document> consumeComparer;
    private final RequestChargeTracker tracker;
    private final ConcurrentMap<String, QueryMetrics> queryMetricMap;
    private final Collection<ClientSideRequestStatistics> clientSideRequestStatistics;
    private Flux<OrderByRowResult<Document>> orderByObservable;

    public NonStreamingOrderByDocumentQueryExecutionContext(DiagnosticsClientContext diagnosticsClientContext, IDocumentQueryClient client, ResourceType resourceTypeEnum, SqlQuerySpec query, CosmosQueryRequestOptions cosmosQueryRequestOptions, String resourceLink, String rewrittenQuery, OrderbyRowComparer<Document> consumeComparer, UUID correlatedActivityId, boolean hasSelectValue, AtomicBoolean isQueryCancelledOnTimeout) {
        super(diagnosticsClientContext, client, resourceTypeEnum, Document.class, query, cosmosQueryRequestOptions, resourceLink, rewrittenQuery, correlatedActivityId, hasSelectValue, isQueryCancelledOnTimeout);
        this.consumeComparer = consumeComparer;
        this.tracker = new RequestChargeTracker();
        this.queryMetricMap = new ConcurrentHashMap<String, QueryMetrics>();
        this.clientSideRequestStatistics = ConcurrentHashMap.newKeySet();
    }

    public static Flux<IDocumentQueryExecutionComponent<Document>> createAsync(DiagnosticsClientContext diagnosticsClientContext, IDocumentQueryClient client, PipelinedDocumentQueryParams<Document> initParams, DocumentCollection collection) {
        QueryInfo queryInfo = initParams.getQueryInfo();
        NonStreamingOrderByDocumentQueryExecutionContext context = new NonStreamingOrderByDocumentQueryExecutionContext(diagnosticsClientContext, client, initParams.getResourceTypeEnum(), initParams.getQuery(), initParams.getCosmosQueryRequestOptions(), initParams.getResourceLink(), initParams.getQueryInfo().getRewrittenQuery(), new OrderbyRowComparer<Document>(queryInfo.getOrderBy()), initParams.getCorrelatedActivityId(), queryInfo.hasSelectValue(), initParams.isQueryCancelledOnTimeout());
        context.setTop(initParams.getTop());
        try {
            context.initialize(initParams.getFeedRanges(), initParams.getQueryInfo().getOrderBy(), initParams.getQueryInfo().getOrderByExpressions(), initParams.getInitialPageSize(), collection);
            return Flux.just((Object)context);
        }
        catch (CosmosException dce) {
            return Flux.error((Throwable)((Object)dce));
        }
    }

    private void initialize(List<FeedRangeEpkImpl> feedRanges, List<SortOrder> sortOrders, Collection<String> orderByExpressions, int initialPageSize, DocumentCollection collection) throws CosmosException {
        HashMap<FeedRangeEpkImpl, String> partitionKeyRangeToContinuationToken = new HashMap<FeedRangeEpkImpl, String>();
        for (FeedRangeEpkImpl feedRangeEpk : feedRanges) {
            partitionKeyRangeToContinuationToken.put(feedRangeEpk, null);
        }
        super.initialize(collection, partitionKeyRangeToContinuationToken, initialPageSize, new SqlQuerySpec(this.querySpec.getQueryText().replace(FormatPlaceHolder, True), this.querySpec.getParameters()));
        this.orderByObservable = NonStreamingOrderByUtils.nonStreamingOrderedMerge(this.consumeComparer, this.tracker, this.documentProducers, initialPageSize, this.queryMetricMap, this.clientSideRequestStatistics);
    }

    protected NonStreamingOrderByDocumentProducer createDocumentProducer(String collectionRid, String continuationToken, int initialPageSize, CosmosQueryRequestOptions cosmosQueryRequestOptions, SqlQuerySpec querySpecForInit, Map<String, String> commonRequestHeaders, TriFunction<FeedRangeEpkImpl, String, Integer, RxDocumentServiceRequest> createRequestFunc, Function<RxDocumentServiceRequest, Mono<FeedResponse<Document>>> executeFunc, Supplier<DocumentClientRetryPolicy> createRetryPolicyFunc, FeedRangeEpkImpl feedRange) {
        return new NonStreamingOrderByDocumentProducer(this.consumeComparer, this.client, collectionRid, cosmosQueryRequestOptions, createRequestFunc, executeFunc, feedRange, collectionRid, createRetryPolicyFunc, Document.class, this.correlatedActivityId, initialPageSize, continuationToken, this.top, this.getOperationContextTextProvider());
    }

    @Override
    public Flux<FeedResponse<Document>> drainAsync(int maxPageSize) {
        return this.orderByObservable.transformDeferred((Function)new ItemToPageTransformer(this.tracker, maxPageSize, this.queryMetricMap, this.clientSideRequestStatistics));
    }

    @Override
    public Flux<FeedResponse<Document>> executeAsync() {
        return this.drainAsync(ModelBridgeInternal.getMaxItemCountFromQueryRequestOptions(this.cosmosQueryRequestOptions));
    }

    private static class ItemToPageTransformer
    implements Function<Flux<OrderByRowResult<Document>>, Flux<FeedResponse<Document>>> {
        private static final int DEFAULT_PAGE_SIZE = 100;
        private final RequestChargeTracker tracker;
        private final int maxPageSize;
        private final ConcurrentMap<String, QueryMetrics> queryMetricMap;
        private final Collection<ClientSideRequestStatistics> clientSideRequestStatistics;

        public ItemToPageTransformer(RequestChargeTracker tracker, int maxPageSize, ConcurrentMap<String, QueryMetrics> queryMetricsMap, Collection<ClientSideRequestStatistics> clientSideRequestStatistics) {
            this.tracker = tracker;
            this.maxPageSize = maxPageSize > 0 ? maxPageSize : 100;
            this.queryMetricMap = queryMetricsMap;
            this.clientSideRequestStatistics = clientSideRequestStatistics;
        }

        private static Map<String, String> headerResponse(double requestCharge) {
            return Utils.immutableMapOf("x-ms-request-charge", String.valueOf(requestCharge));
        }

        @Override
        public Flux<FeedResponse<Document>> apply(Flux<OrderByRowResult<Document>> source) {
            return source.window(this.maxPageSize).map(Flux::collectList).flatMap(resultListObs -> resultListObs, 1).map(orderByRowResults -> {
                FeedResponse feedResponse = feedResponseAccessor.createFeedResponse(orderByRowResults, ItemToPageTransformer.headerResponse(this.tracker.getAndResetCharge()), (CosmosDiagnostics)null);
                if (!this.queryMetricMap.isEmpty()) {
                    for (Map.Entry entry : this.queryMetricMap.entrySet()) {
                        BridgeInternal.putQueryMetricsIntoMap(feedResponse, (String)entry.getKey(), (QueryMetrics)entry.getValue());
                    }
                }
                return feedResponse;
            }).map(feedOfOrderByRowResults -> {
                ArrayList<Document> unwrappedResults = new ArrayList<Document>();
                for (OrderByRowResult orderByRowResult : feedOfOrderByRowResults.getResults()) {
                    unwrappedResults.add(orderByRowResult.getPayload());
                }
                FeedResponse feedResponse = BridgeInternal.createFeedResponseWithQueryMetrics(unwrappedResults, feedOfOrderByRowResults.getResponseHeaders(), BridgeInternal.queryMetricsFromFeedResponse(feedOfOrderByRowResults), ModelBridgeInternal.getQueryPlanDiagnosticsContext(feedOfOrderByRowResults), false, false, feedOfOrderByRowResults.getCosmosDiagnostics());
                diagnosticsAccessor.addClientSideDiagnosticsToFeed(feedResponse.getCosmosDiagnostics(), this.clientSideRequestStatistics);
                return feedResponse;
            }).switchIfEmpty((Publisher)Flux.defer(() -> {
                FeedResponse frp = BridgeInternal.createFeedResponseWithQueryMetrics(Utils.immutableListOf(), ItemToPageTransformer.headerResponse(this.tracker.getAndResetCharge()), this.queryMetricMap, null, false, false, null);
                diagnosticsAccessor.addClientSideDiagnosticsToFeed(frp.getCosmosDiagnostics(), this.clientSideRequestStatistics);
                return Flux.just(frp);
            }));
        }
    }
}

