/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.query;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosItemSerializer;
import com.azure.cosmos.implementation.BackoffRetryUtility;
import com.azure.cosmos.implementation.DiagnosticsClientContext;
import com.azure.cosmos.implementation.DocumentClientRetryPolicy;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.InvalidPartitionExceptionRetryPolicy;
import com.azure.cosmos.implementation.OperationType;
import com.azure.cosmos.implementation.PartitionKeyRange;
import com.azure.cosmos.implementation.PartitionKeyRangeGoneRetryPolicy;
import com.azure.cosmos.implementation.PathsHelper;
import com.azure.cosmos.implementation.QueryMetrics;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.apachecommons.lang.tuple.ImmutablePair;
import com.azure.cosmos.implementation.caches.IPartitionKeyRangeCache;
import com.azure.cosmos.implementation.caches.RxCollectionCache;
import com.azure.cosmos.implementation.feedranges.FeedRangeInternal;
import com.azure.cosmos.implementation.query.CompositeContinuationToken;
import com.azure.cosmos.implementation.query.DocumentQueryExecutionContextBase;
import com.azure.cosmos.implementation.query.IDocumentQueryClient;
import com.azure.cosmos.implementation.query.LimitContinuationToken;
import com.azure.cosmos.implementation.query.OrderByContinuationToken;
import com.azure.cosmos.implementation.query.Paginator;
import com.azure.cosmos.implementation.query.TopContinuationToken;
import com.azure.cosmos.implementation.query.ValueUnwrapCosmosItemSerializer;
import com.azure.cosmos.implementation.query.metrics.ClientSideMetrics;
import com.azure.cosmos.implementation.query.metrics.FetchExecutionRangeAccumulator;
import com.azure.cosmos.implementation.query.metrics.SchedulingStopwatch;
import com.azure.cosmos.implementation.query.metrics.SchedulingTimeSpan;
import com.azure.cosmos.implementation.routing.PartitionKeyInternal;
import com.azure.cosmos.implementation.routing.PartitionKeyRangeIdentity;
import com.azure.cosmos.implementation.routing.Range;
import com.azure.cosmos.implementation.routing.RoutingMapProviderHelper;
import com.azure.cosmos.models.CosmosQueryRequestOptions;
import com.azure.cosmos.models.FeedResponse;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.azure.cosmos.models.PartitionKeyDefinition;
import com.azure.cosmos.models.SqlQuerySpec;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DefaultDocumentQueryExecutionContext<T>
extends DocumentQueryExecutionContextBase<T> {
    private final AtomicInteger retries = new AtomicInteger(-1);
    private final SchedulingStopwatch fetchSchedulingMetrics = new SchedulingStopwatch();
    private final FetchExecutionRangeAccumulator fetchExecutionRangeAccumulator;
    private static final String DEFAULT_PARTITION_RANGE = "00-FF";
    private static final ImplementationBridgeHelpers.CosmosQueryRequestOptionsHelper.CosmosQueryRequestOptionsAccessor queryRequestOptionsAccessor = ImplementationBridgeHelpers.CosmosQueryRequestOptionsHelper.getCosmosQueryRequestOptionsAccessor();
    private final CosmosItemSerializer itemSerializer;

    public DefaultDocumentQueryExecutionContext(DiagnosticsClientContext diagnosticsClientContext, IDocumentQueryClient client, ResourceType resourceTypeEnum, Class<T> resourceType, SqlQuerySpec query, CosmosQueryRequestOptions cosmosQueryRequestOptions, String resourceLink, UUID correlatedActivityId, AtomicBoolean isQueryCancelledOnTimeout) {
        super(diagnosticsClientContext, client, resourceTypeEnum, resourceType, query, cosmosQueryRequestOptions, resourceLink, correlatedActivityId, isQueryCancelledOnTimeout);
        this.fetchSchedulingMetrics.ready();
        this.fetchExecutionRangeAccumulator = new FetchExecutionRangeAccumulator(DEFAULT_PARTITION_RANGE);
        CosmosItemSerializer candidateSerializer = client.getEffectiveItemSerializer(this.cosmosQueryRequestOptions);
        this.itemSerializer = candidateSerializer != CosmosItemSerializer.DEFAULT_SERIALIZER ? candidateSerializer : ValueUnwrapCosmosItemSerializer.create(false);
    }

    protected PartitionKeyInternal getPartitionKeyInternal() {
        return this.cosmosQueryRequestOptions.getPartitionKey() == null ? null : BridgeInternal.getPartitionKeyInternal(this.cosmosQueryRequestOptions.getPartitionKey());
    }

    protected PartitionKeyDefinition getPartitionKeyDefinition() {
        return queryRequestOptionsAccessor.getPartitionKeyDefinition(this.cosmosQueryRequestOptions);
    }

    @Override
    public Flux<FeedResponse<T>> executeAsync() {
        Integer maxItemCount;
        CosmosQueryRequestOptions newCosmosQueryRequestOptions;
        String originalContinuation;
        if (this.cosmosQueryRequestOptions == null) {
            this.cosmosQueryRequestOptions = new CosmosQueryRequestOptions();
        }
        if (DefaultDocumentQueryExecutionContext.isClientSideContinuationToken(originalContinuation = ModelBridgeInternal.getRequestContinuationFromQueryRequestOptions(newCosmosQueryRequestOptions = ImplementationBridgeHelpers.CosmosQueryRequestOptionsHelper.getCosmosQueryRequestOptionsAccessor().clone(this.cosmosQueryRequestOptions)))) {
            ModelBridgeInternal.setQueryRequestOptionsContinuationToken(newCosmosQueryRequestOptions, null);
            newCosmosQueryRequestOptions.setMaxDegreeOfParallelism(Integer.MAX_VALUE);
        }
        int maxPageSize = (maxItemCount = ModelBridgeInternal.getMaxItemCountFromQueryRequestOptions(newCosmosQueryRequestOptions)) != null ? maxItemCount : 100;
        BiFunction<String, Integer, RxDocumentServiceRequest> createRequestFunc = this::createRequestAsync;
        Function<RxDocumentServiceRequest, Mono<FeedResponse<T>>> executeFunc = this.executeInternalAsyncFunc();
        return Paginator.getPaginatedQueryResultAsObservable(newCosmosQueryRequestOptions, createRequestFunc, executeFunc, maxPageSize);
    }

    public Mono<List<PartitionKeyRange>> getTargetPartitionKeyRanges(String resourceId, List<Range<String>> queryRanges) {
        return RoutingMapProviderHelper.getOverlappingRanges(this.client.getPartitionKeyRangeCache(), resourceId, queryRanges);
    }

    public Mono<Range<String>> getTargetRange(String collectionRid, FeedRangeInternal feedRangeInternal) {
        return feedRangeInternal.getNormalizedEffectiveRange(this.client.getPartitionKeyRangeCache(), null, this.client.getCollectionCache().resolveByRidAsync(null, collectionRid, null));
    }

    public Mono<List<PartitionKeyRange>> getTargetPartitionKeyRangesById(String resourceId, String partitionKeyRangeIdInternal) {
        return this.client.getPartitionKeyRangeCache().tryGetPartitionKeyRangeByIdAsync(null, resourceId, partitionKeyRangeIdInternal, false, null).flatMap(partitionKeyRange -> Mono.just(Collections.singletonList((PartitionKeyRange)partitionKeyRange.v)));
    }

    private DocumentClientRetryPolicy createClientRetryPolicyInstance() {
        RxCollectionCache collectionCache = this.client.getCollectionCache();
        IPartitionKeyRangeCache partitionKeyRangeCache = this.client.getPartitionKeyRangeCache();
        DocumentClientRetryPolicy retryPolicyInstance = this.client.getResetSessionTokenRetryPolicy().getRequestPolicy(this.diagnosticsClientContext);
        retryPolicyInstance = new InvalidPartitionExceptionRetryPolicy(collectionCache, retryPolicyInstance, this.resourceLink, ModelBridgeInternal.getPropertiesFromQueryRequestOptions(this.cosmosQueryRequestOptions));
        if (this.resourceTypeEnum.isPartitioned()) {
            retryPolicyInstance = new PartitionKeyRangeGoneRetryPolicy(this.diagnosticsClientContext, collectionCache, partitionKeyRangeCache, PathsHelper.getCollectionPath(this.resourceLink), retryPolicyInstance, ModelBridgeInternal.getPropertiesFromQueryRequestOptions(this.cosmosQueryRequestOptions));
        }
        return retryPolicyInstance;
    }

    protected Function<RxDocumentServiceRequest, Mono<FeedResponse<T>>> executeInternalAsyncFunc() {
        return req -> this.client.executeFeedOperationWithAvailabilityStrategy(ResourceType.Document, OperationType.Query, this::createClientRetryPolicyInstance, (RxDocumentServiceRequest)req, this::executeInternalFuncCore);
    }

    private Mono<FeedResponse<T>> executeInternalFuncCore(Supplier<DocumentClientRetryPolicy> retryPolicyFactory, RxDocumentServiceRequest req) {
        DocumentClientRetryPolicy finalRetryPolicyInstance = retryPolicyFactory.get();
        finalRetryPolicyInstance.onBeforeSendRequest(req);
        this.fetchExecutionRangeAccumulator.beginFetchRange();
        this.fetchSchedulingMetrics.start();
        return BackoffRetryUtility.executeRetry(() -> {
            this.retries.incrementAndGet();
            return this.executeRequestAsync(this.itemSerializer, req);
        }, finalRetryPolicyInstance).map(tFeedResponse -> {
            this.fetchSchedulingMetrics.stop();
            this.fetchExecutionRangeAccumulator.endFetchRange(tFeedResponse.getActivityId(), tFeedResponse.getResults().size(), this.retries.get());
            ImmutablePair<String, SchedulingTimeSpan> schedulingTimeSpanMap = new ImmutablePair<String, SchedulingTimeSpan>(DEFAULT_PARTITION_RANGE, this.fetchSchedulingMetrics.getElapsedTime());
            if (!StringUtils.isEmpty(tFeedResponse.getResponseHeaders().get("x-ms-documentdb-query-metrics"))) {
                QueryMetrics qm = BridgeInternal.createQueryMetricsFromDelimitedStringAndClientSideMetrics(tFeedResponse.getResponseHeaders().get("x-ms-documentdb-query-metrics"), new ClientSideMetrics(this.retries.get(), tFeedResponse.getRequestCharge(), this.fetchExecutionRangeAccumulator.getExecutionRanges(), Collections.singletonList(schedulingTimeSpanMap)), tFeedResponse.getActivityId(), tFeedResponse.getResponseHeaders().getOrDefault("x-ms-cosmos-index-utilization", null));
                String pkrId = tFeedResponse.getResponseHeaders().get("x-ms-documentdb-partitionkeyrangeid");
                String queryMetricKey = "00-FF,pkrId:" + pkrId;
                BridgeInternal.putQueryMetricsIntoMap(tFeedResponse, queryMetricKey, qm);
            }
            return tFeedResponse;
        });
    }

    public RxDocumentServiceRequest createRequestAsync(String continuationToken, Integer maxPageSize) {
        Map<String, String> requestHeaders = this.createCommonHeadersAsync(this.getFeedOptions(continuationToken, maxPageSize));
        RxDocumentServiceRequest request = this.createDocumentServiceRequest(requestHeaders, this.query, this.getPartitionKeyInternal(), this.getPartitionKeyDefinition());
        if (!StringUtils.isEmpty(ModelBridgeInternal.getPartitionKeyRangeIdInternal(this.cosmosQueryRequestOptions))) {
            request.routeTo(new PartitionKeyRangeIdentity(ModelBridgeInternal.getPartitionKeyRangeIdInternal(this.cosmosQueryRequestOptions)));
        }
        return request;
    }

    private static boolean isClientSideContinuationToken(String continuationToken) {
        if (continuationToken != null) {
            Utils.ValueHolder<CompositeContinuationToken> outCompositeContinuationToken = new Utils.ValueHolder<CompositeContinuationToken>();
            if (CompositeContinuationToken.tryParse(continuationToken, outCompositeContinuationToken)) {
                return true;
            }
            Utils.ValueHolder<OrderByContinuationToken> outOrderByContinuationToken = new Utils.ValueHolder<OrderByContinuationToken>();
            if (OrderByContinuationToken.tryParse(continuationToken, outOrderByContinuationToken)) {
                return true;
            }
            Utils.ValueHolder<TopContinuationToken> outTopContinuationToken = new Utils.ValueHolder<TopContinuationToken>();
            if (TopContinuationToken.tryParse(continuationToken, outTopContinuationToken)) {
                return true;
            }
            Utils.ValueHolder<LimitContinuationToken> outLimitContinuationToken = new Utils.ValueHolder<LimitContinuationToken>();
            return LimitContinuationToken.tryParse(continuationToken, outLimitContinuationToken);
        }
        return false;
    }
}

