/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.changefeed.common;

public enum LeaseVersion {
    PARTITION_KEY_BASED_LEASE(0),
    EPK_RANGE_BASED_LEASE(1);

    private final int versionId;

    private LeaseVersion(int versionId) {
        this.versionId = versionId;
    }

    public int getVersionId() {
        return this.versionId;
    }

    public static LeaseVersion fromVersionId(int version) {
        switch (version) {
            case 0: {
                return PARTITION_KEY_BASED_LEASE;
            }
            case 1: {
                return EPK_RANGE_BASED_LEASE;
            }
        }
        throw new UnsupportedOperationException("Unsupported lease version {" + version + "}");
    }
}

