/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.ConsistencyLevel;
import com.azure.cosmos.CosmosDiagnosticsContext;
import com.azure.cosmos.CosmosDiagnosticsThresholds;
import com.azure.cosmos.CosmosEndToEndOperationLatencyPolicyConfig;
import com.azure.cosmos.CosmosItemSerializer;
import com.azure.cosmos.implementation.OverridableRequestOptions;
import com.azure.cosmos.implementation.WriteRetryPolicy;
import com.azure.cosmos.implementation.spark.OperationContextAndListenerTuple;
import com.azure.cosmos.models.CosmosRequestOptions;
import com.azure.cosmos.models.DedicatedGatewayRequestOptions;
import com.azure.cosmos.models.IndexingDirective;
import com.azure.cosmos.models.PartitionKey;
import com.azure.cosmos.models.ThroughputProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

public class RequestOptions
implements OverridableRequestOptions {
    private Map<String, String> customOptions;
    private List<String> preTriggerInclude;
    private List<String> postTriggerInclude;
    private IndexingDirective indexingDirective;
    private ConsistencyLevel consistencyLevel;
    private String sessionToken;
    private Integer resourceTokenExpirySeconds;
    private String offerType;
    private String ifMatchETag;
    private String ifNoneMatchETag;
    private Integer offerThroughput;
    private PartitionKey partitionkey;
    private boolean scriptLoggingEnabled;
    private boolean quotaInfoEnabled;
    private Map<String, Object> properties;
    private ThroughputProperties throughputProperties;
    private Boolean contentResponseOnWriteEnabled;
    private String filterPredicate;
    private String throughputControlGroupName;
    private OperationContextAndListenerTuple operationContextAndListenerTuple;
    private DedicatedGatewayRequestOptions dedicatedGatewayRequestOptions;
    private CosmosDiagnosticsThresholds thresholds;
    private boolean useTrackingIds;
    private String trackingId;
    private Boolean nonIdempotentWriteRetriesEnabled;
    private CosmosEndToEndOperationLatencyPolicyConfig endToEndOperationLatencyConfig;
    private List<String> excludeRegions;
    private Supplier<CosmosDiagnosticsContext> diagnosticsCtxSupplier;
    private CosmosItemSerializer effectiveItemSerializer;
    private final AtomicReference<Runnable> markE2ETimeoutInRequestContextCallbackHook;

    public RequestOptions() {
        this.markE2ETimeoutInRequestContextCallbackHook = new AtomicReference<Object>(null);
        this.effectiveItemSerializer = CosmosItemSerializer.DEFAULT_SERIALIZER;
    }

    public RequestOptions(RequestOptions toBeCloned) {
        this.indexingDirective = toBeCloned.indexingDirective;
        this.consistencyLevel = toBeCloned.consistencyLevel;
        this.sessionToken = toBeCloned.sessionToken;
        this.resourceTokenExpirySeconds = toBeCloned.resourceTokenExpirySeconds;
        this.offerType = toBeCloned.offerType;
        this.ifMatchETag = toBeCloned.ifMatchETag;
        this.ifNoneMatchETag = toBeCloned.ifNoneMatchETag;
        this.offerThroughput = toBeCloned.offerThroughput;
        this.partitionkey = toBeCloned.partitionkey;
        this.scriptLoggingEnabled = toBeCloned.scriptLoggingEnabled;
        this.quotaInfoEnabled = toBeCloned.quotaInfoEnabled;
        this.throughputProperties = toBeCloned.throughputProperties;
        this.contentResponseOnWriteEnabled = toBeCloned.contentResponseOnWriteEnabled;
        this.filterPredicate = toBeCloned.filterPredicate;
        this.throughputControlGroupName = toBeCloned.throughputControlGroupName;
        this.operationContextAndListenerTuple = toBeCloned.operationContextAndListenerTuple;
        this.dedicatedGatewayRequestOptions = toBeCloned.dedicatedGatewayRequestOptions;
        this.thresholds = toBeCloned.thresholds;
        this.trackingId = toBeCloned.trackingId;
        this.nonIdempotentWriteRetriesEnabled = toBeCloned.nonIdempotentWriteRetriesEnabled;
        this.endToEndOperationLatencyConfig = toBeCloned.endToEndOperationLatencyConfig;
        this.diagnosticsCtxSupplier = toBeCloned.diagnosticsCtxSupplier;
        this.markE2ETimeoutInRequestContextCallbackHook = new AtomicReference<Object>(null);
        this.effectiveItemSerializer = toBeCloned.effectiveItemSerializer;
        if (toBeCloned.customOptions != null) {
            this.customOptions = new HashMap<String, String>(toBeCloned.customOptions);
        }
        if (toBeCloned.properties != null) {
            this.properties = new HashMap<String, Object>(toBeCloned.properties);
        }
        if (toBeCloned.preTriggerInclude != null) {
            this.preTriggerInclude = new ArrayList<String>(toBeCloned.preTriggerInclude);
        }
        if (toBeCloned.postTriggerInclude != null) {
            this.postTriggerInclude = new ArrayList<String>(toBeCloned.postTriggerInclude);
        }
        if (toBeCloned.excludeRegions != null) {
            this.excludeRegions = new ArrayList<String>(toBeCloned.excludeRegions);
        }
    }

    public List<String> getPreTriggerInclude() {
        return this.preTriggerInclude;
    }

    OperationContextAndListenerTuple getOperationContextAndListenerTuple() {
        return this.operationContextAndListenerTuple;
    }

    public void setOperationContextAndListenerTuple(Object operationContextAndListenerTupleAsObject) {
        this.operationContextAndListenerTuple = (OperationContextAndListenerTuple)operationContextAndListenerTupleAsObject;
    }

    public void setPreTriggerInclude(List<String> preTriggerInclude) {
        this.preTriggerInclude = preTriggerInclude;
    }

    public RequestOptions setNonIdempotentWriteRetriesEnabled(boolean enabled) {
        this.nonIdempotentWriteRetriesEnabled = enabled;
        return this;
    }

    @Override
    public Boolean getNonIdempotentWriteRetriesEnabled() {
        return this.nonIdempotentWriteRetriesEnabled;
    }

    public List<String> getPostTriggerInclude() {
        return this.postTriggerInclude;
    }

    public void setPostTriggerInclude(List<String> postTriggerInclude) {
        this.postTriggerInclude = postTriggerInclude;
    }

    public String getIfMatchETag() {
        return this.ifMatchETag;
    }

    public void setIfMatchETag(String ifMatchETag) {
        this.ifMatchETag = ifMatchETag;
    }

    public String getIfNoneMatchETag() {
        return this.ifNoneMatchETag;
    }

    public void setIfNoneMatchETag(String ifNoneMatchETag) {
        this.ifNoneMatchETag = ifNoneMatchETag;
    }

    public String getFilterPredicate() {
        return this.filterPredicate;
    }

    public void setFilterPredicate(String filterPredicate) {
        this.filterPredicate = filterPredicate;
    }

    public IndexingDirective getIndexingDirective() {
        return this.indexingDirective;
    }

    public void setIndexingDirective(IndexingDirective indexingDirective) {
        this.indexingDirective = indexingDirective;
    }

    public void setTrackingId(String trackingId) {
        this.trackingId = trackingId;
    }

    public String getTrackingId() {
        return this.trackingId;
    }

    @Override
    public ConsistencyLevel getConsistencyLevel() {
        return this.consistencyLevel;
    }

    public void setConsistencyLevel(ConsistencyLevel consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
    }

    public String getSessionToken() {
        return this.sessionToken;
    }

    public void setSessionToken(String sessionToken) {
        this.sessionToken = sessionToken;
    }

    public Integer getResourceTokenExpirySeconds() {
        return this.resourceTokenExpirySeconds;
    }

    public void setResourceTokenExpirySeconds(Integer resourceTokenExpirySeconds) {
        this.resourceTokenExpirySeconds = resourceTokenExpirySeconds;
    }

    public String getOfferType() {
        return this.offerType;
    }

    public void setOfferType(String offerType) {
        this.offerType = offerType;
    }

    public Integer getOfferThroughput() {
        return this.offerThroughput;
    }

    public void setOfferThroughput(Integer offerThroughput) {
        this.offerThroughput = offerThroughput;
    }

    public void setThroughputProperties(ThroughputProperties throughputProperties) {
        this.throughputProperties = throughputProperties;
    }

    public ThroughputProperties getThroughputProperties() {
        return this.throughputProperties;
    }

    public PartitionKey getPartitionKey() {
        return this.partitionkey;
    }

    public void setPartitionKey(PartitionKey partitionkey) {
        this.partitionkey = partitionkey;
    }

    public boolean isScriptLoggingEnabled() {
        return this.scriptLoggingEnabled;
    }

    public void setScriptLoggingEnabled(boolean scriptLoggingEnabled) {
        this.scriptLoggingEnabled = scriptLoggingEnabled;
    }

    public boolean isQuotaInfoEnabled() {
        return this.quotaInfoEnabled;
    }

    public void setQuotaInfoEnabled(boolean quotaInfoEnabled) {
        this.quotaInfoEnabled = quotaInfoEnabled;
    }

    public void setHeader(String name, String value) {
        if (this.customOptions == null) {
            this.customOptions = new HashMap<String, String>();
        }
        this.customOptions.put(name, value);
    }

    public Map<String, String> getHeaders() {
        return this.customOptions;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    @Override
    public Boolean isContentResponseOnWriteEnabled() {
        return this.contentResponseOnWriteEnabled;
    }

    public void setContentResponseOnWriteEnabled(Boolean contentResponseOnWriteEnabled) {
        this.contentResponseOnWriteEnabled = contentResponseOnWriteEnabled;
    }

    @Override
    public String getThroughputControlGroupName() {
        return this.throughputControlGroupName;
    }

    public void setThroughputControlGroupName(String throughputControlGroupName) {
        this.throughputControlGroupName = throughputControlGroupName;
    }

    @Override
    public DedicatedGatewayRequestOptions getDedicatedGatewayRequestOptions() {
        return this.dedicatedGatewayRequestOptions;
    }

    public void setDedicatedGatewayRequestOptions(DedicatedGatewayRequestOptions dedicatedGatewayRequestOptions) {
        this.dedicatedGatewayRequestOptions = dedicatedGatewayRequestOptions;
    }

    @Override
    public CosmosDiagnosticsThresholds getDiagnosticsThresholds() {
        return this.thresholds;
    }

    @Override
    public Boolean isScanInQueryEnabled() {
        return null;
    }

    @Override
    public Integer getMaxDegreeOfParallelism() {
        return null;
    }

    @Override
    public Integer getMaxBufferedItemCount() {
        return null;
    }

    @Override
    public Integer getResponseContinuationTokenLimitInKb() {
        return null;
    }

    @Override
    public Integer getMaxItemCount() {
        return null;
    }

    @Override
    public Boolean isQueryMetricsEnabled() {
        return null;
    }

    @Override
    public Boolean isIndexMetricsEnabled() {
        return null;
    }

    @Override
    public Integer getMaxPrefetchPageCount() {
        return null;
    }

    @Override
    public String getQueryNameOrDefault(String defaultQueryName) {
        return null;
    }

    public void setDiagnosticsThresholds(CosmosDiagnosticsThresholds thresholds) {
        this.thresholds = thresholds;
    }

    public void setDiagnosticsContextSupplier(Supplier<CosmosDiagnosticsContext> ctxSupplier) {
        this.diagnosticsCtxSupplier = ctxSupplier;
    }

    public CosmosDiagnosticsContext getDiagnosticsContextSnapshot() {
        Supplier<CosmosDiagnosticsContext> ctxSupplierSnapshot = this.diagnosticsCtxSupplier;
        if (ctxSupplierSnapshot == null) {
            return null;
        }
        return ctxSupplierSnapshot.get();
    }

    public void setCosmosEndToEndLatencyPolicyConfig(CosmosEndToEndOperationLatencyPolicyConfig endToEndOperationLatencyPolicyConfig) {
        this.endToEndOperationLatencyConfig = endToEndOperationLatencyPolicyConfig;
    }

    @Override
    public CosmosEndToEndOperationLatencyPolicyConfig getCosmosEndToEndLatencyPolicyConfig() {
        return this.endToEndOperationLatencyConfig;
    }

    @Override
    public List<String> getExcludedRegions() {
        return this.excludeRegions;
    }

    public void setExcludedRegions(List<String> excludeRegions) {
        this.excludeRegions = excludeRegions;
    }

    public AtomicReference<Runnable> getMarkE2ETimeoutInRequestContextCallbackHook() {
        return this.markE2ETimeoutInRequestContextCallbackHook;
    }

    @Override
    public void override(CosmosRequestOptions cosmosCommonRequestOptions) {
        this.consistencyLevel = this.overrideOption(cosmosCommonRequestOptions.getConsistencyLevel(), this.consistencyLevel);
        this.contentResponseOnWriteEnabled = this.overrideOption(cosmosCommonRequestOptions.isContentResponseOnWriteEnabled(), this.contentResponseOnWriteEnabled);
        this.nonIdempotentWriteRetriesEnabled = this.overrideOption(cosmosCommonRequestOptions.getNonIdempotentWriteRetriesEnabled(), this.nonIdempotentWriteRetriesEnabled);
        this.dedicatedGatewayRequestOptions = this.overrideOption(cosmosCommonRequestOptions.getDedicatedGatewayRequestOptions(), this.dedicatedGatewayRequestOptions);
        this.excludeRegions = this.overrideOption(cosmosCommonRequestOptions.getExcludedRegions(), this.excludeRegions);
        this.throughputControlGroupName = this.overrideOption(cosmosCommonRequestOptions.getThroughputControlGroupName(), this.throughputControlGroupName);
        this.thresholds = this.overrideOption(cosmosCommonRequestOptions.getDiagnosticsThresholds(), this.thresholds);
        this.endToEndOperationLatencyConfig = this.overrideOption(cosmosCommonRequestOptions.getCosmosEndToEndLatencyPolicyConfig(), this.endToEndOperationLatencyConfig);
    }

    public CosmosItemSerializer getEffectiveItemSerializer() {
        return this.effectiveItemSerializer;
    }

    public void setEffectiveItemSerializer(CosmosItemSerializer serializer) {
        this.effectiveItemSerializer = serializer;
    }

    public void setUseTrackingIds(boolean useTrackingIds) {
        this.useTrackingIds = useTrackingIds;
    }

    public boolean getUseTrackingIds() {
        return this.useTrackingIds;
    }

    public WriteRetryPolicy calculateAndGetEffectiveNonIdempotentRetriesEnabled(WriteRetryPolicy clientDefault, boolean operationDefault) {
        if (this.nonIdempotentWriteRetriesEnabled != null) {
            return new WriteRetryPolicy(this.nonIdempotentWriteRetriesEnabled, this.useTrackingIds);
        }
        if (!operationDefault) {
            this.setNonIdempotentWriteRetriesEnabled(false);
            this.setUseTrackingIds(false);
            return WriteRetryPolicy.DISABLED;
        }
        if (clientDefault != null) {
            if (clientDefault.isEnabled()) {
                this.setNonIdempotentWriteRetriesEnabled(true);
                this.setUseTrackingIds(clientDefault.useTrackingIdProperty());
            } else {
                this.setNonIdempotentWriteRetriesEnabled(false);
                this.setUseTrackingIds(false);
            }
            return clientDefault;
        }
        this.setNonIdempotentWriteRetriesEnabled(false);
        this.setUseTrackingIds(false);
        return WriteRetryPolicy.DISABLED;
    }
}

