/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.ConnectionMode;
import com.azure.cosmos.ConsistencyLevel;
import com.azure.cosmos.CosmosContainerProactiveInitConfig;
import com.azure.cosmos.CosmosDiagnostics;
import com.azure.cosmos.CosmosEndToEndOperationLatencyPolicyConfig;
import com.azure.cosmos.SessionRetryOptions;
import com.azure.cosmos.implementation.Configs;
import com.azure.cosmos.implementation.ConnectionPolicy;
import com.azure.cosmos.implementation.RegionScopedSessionContainer;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.clienttelemetry.ClientTelemetry;
import com.azure.cosmos.implementation.guava27.Strings;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface DiagnosticsClientContext {
    public DiagnosticsClientConfig getConfig();

    public CosmosDiagnostics createDiagnostics();

    public String getUserAgent();

    public CosmosDiagnostics getMostRecentlyCreatedDiagnostics();

    @JsonSerialize(using=DiagnosticsClientConfigSerializer.class)
    public static class DiagnosticsClientConfig {
        private AtomicInteger activeClientsCnt;
        private int clientId;
        private Map<String, Integer> clientMap;
        private ConsistencyLevel consistencyLevel;
        private boolean connectionSharingAcrossClientsEnabled;
        private String consistencyRelatedConfigAsString;
        private String httpConfigAsString;
        private String otherCfgAsString;
        private String preferredRegionsAsString;
        private String proactivelyInitializedContainersAsString;
        private String endToEndOperationLatencyPolicyConfigAsString;
        private boolean endpointDiscoveryEnabled;
        private boolean multipleWriteRegionsEnabled;
        private String rntbdConfigAsString;
        private ConnectionMode connectionMode;
        private String machineId;
        private boolean replicaValidationEnabled = Configs.isReplicaAddressValidationEnabled();
        private ConnectionPolicy connectionPolicy;
        private String sessionRetryOptionsAsString;
        private String regionScopedSessionContainerOptionsAsString;

        public DiagnosticsClientConfig withMachineId(String machineId) {
            this.machineId = machineId;
            return this;
        }

        public DiagnosticsClientConfig withActiveClientCounter(AtomicInteger activeClientsCnt) {
            this.activeClientsCnt = activeClientsCnt;
            return this;
        }

        public DiagnosticsClientConfig withClientId(int clientId) {
            this.clientId = clientId;
            return this;
        }

        public DiagnosticsClientConfig withClientMap(Map<String, Integer> clientMap) {
            this.clientMap = clientMap;
            return this;
        }

        public DiagnosticsClientConfig withEndpointDiscoveryEnabled(boolean endpointDiscoveryEnabled) {
            this.endpointDiscoveryEnabled = endpointDiscoveryEnabled;
            return this;
        }

        public DiagnosticsClientConfig withMultipleWriteRegionsEnabled(boolean multipleWriteRegionsEnabled) {
            this.multipleWriteRegionsEnabled = multipleWriteRegionsEnabled;
            return this;
        }

        public DiagnosticsClientConfig withPreferredRegions(List<String> preferredRegions) {
            this.preferredRegionsAsString = preferredRegions == null || preferredRegions.isEmpty() ? "" : preferredRegions.stream().map(r -> DiagnosticsClientConfigSerializer.SPACE_PATTERN.matcher(r.toLowerCase(Locale.ROOT)).replaceAll("")).collect(Collectors.joining(","));
            return this;
        }

        public DiagnosticsClientConfig withConnectionPolicy(ConnectionPolicy connectionPolicy) {
            this.connectionPolicy = connectionPolicy;
            return this;
        }

        public DiagnosticsClientConfig withProactiveContainerInitConfig(CosmosContainerProactiveInitConfig config) {
            this.proactivelyInitializedContainersAsString = config == null ? "" : config.toString();
            return this;
        }

        public DiagnosticsClientConfig withEndToEndOperationLatencyPolicy(CosmosEndToEndOperationLatencyPolicyConfig config) {
            this.endToEndOperationLatencyPolicyConfigAsString = config == null ? "" : config.toString();
            return this;
        }

        public DiagnosticsClientConfig withConnectionSharingAcrossClientsEnabled(boolean connectionSharingAcrossClientsEnabled) {
            this.connectionSharingAcrossClientsEnabled = connectionSharingAcrossClientsEnabled;
            return this;
        }

        public DiagnosticsClientConfig withConsistency(ConsistencyLevel consistencyLevel) {
            this.consistencyLevel = consistencyLevel;
            return this;
        }

        public DiagnosticsClientConfig withRntbdOptions(String rntbdConfigAsString) {
            this.rntbdConfigAsString = rntbdConfigAsString;
            return this;
        }

        public DiagnosticsClientConfig withGatewayHttpClientConfig(String httpConfigAsString) {
            this.httpConfigAsString = httpConfigAsString;
            return this;
        }

        public DiagnosticsClientConfig withConnectionMode(ConnectionMode connectionMode) {
            this.connectionMode = connectionMode;
            return this;
        }

        public DiagnosticsClientConfig withSessionRetryOptions(SessionRetryOptions sessionRetryOptions) {
            this.sessionRetryOptionsAsString = sessionRetryOptions == null ? "" : sessionRetryOptions.toString();
            return this;
        }

        public DiagnosticsClientConfig withRegionScopedSessionContainerOptions(RegionScopedSessionContainer regionScopedSessionContainer) {
            this.regionScopedSessionContainerOptionsAsString = regionScopedSessionContainer == null ? "" : regionScopedSessionContainer.getRegionScopedSessionCapturingOptionsAsString();
            return this;
        }

        public ConnectionMode getConnectionMode() {
            return this.connectionMode;
        }

        public String consistencyRelatedConfig() {
            if (this.consistencyRelatedConfigAsString == null) {
                this.consistencyRelatedConfigAsString = this.consistencyRelatedConfigInternal();
            }
            return this.consistencyRelatedConfigAsString;
        }

        public String rntbdConfig() {
            return this.rntbdConfigAsString;
        }

        public String gwConfig() {
            return this.httpConfigAsString;
        }

        public String otherConnectionConfig() {
            if (this.otherCfgAsString == null) {
                this.otherCfgAsString = Strings.lenientFormat("(ed: %s, cs: %s, rv: %s)", this.endpointDiscoveryEnabled, this.connectionSharingAcrossClientsEnabled, this.replicaValidationEnabled);
            }
            return this.otherCfgAsString;
        }

        public int getClientId() {
            return this.clientId;
        }

        public String getMachineId() {
            return this.machineId;
        }

        public int getActiveClientsCount() {
            return this.activeClientsCnt != null ? this.activeClientsCnt.get() : -1;
        }

        private String consistencyRelatedConfigInternal() {
            return Strings.lenientFormat("(consistency: %s, mm: %s, prgns: [%s])", new Object[]{this.consistencyLevel, this.multipleWriteRegionsEnabled, this.preferredRegionsAsString});
        }

        private String excludedRegionsRelatedConfig() {
            if (this.connectionPolicy == null) {
                return "[]";
            }
            return this.connectionPolicy.getExcludedRegionsAsString();
        }
    }

    public static final class DiagnosticsClientConfigSerializer
    extends StdSerializer<DiagnosticsClientConfig> {
        private static final Logger logger = LoggerFactory.getLogger(DiagnosticsClientConfigSerializer.class);
        public static final DiagnosticsClientConfigSerializer INSTANCE = new DiagnosticsClientConfigSerializer();
        private static final Pattern SPACE_PATTERN = Pattern.compile(" ");
        private static final long serialVersionUID = 1L;

        protected DiagnosticsClientConfigSerializer() {
            this(null);
        }

        protected DiagnosticsClientConfigSerializer(Class<DiagnosticsClientConfig> t) {
            super(t);
        }

        public void serialize(DiagnosticsClientConfig clientConfig, JsonGenerator generator, SerializerProvider serializerProvider) throws IOException {
            generator.writeStartObject();
            try {
                generator.writeNumberField("id", clientConfig.getClientId());
                generator.writeStringField("machineId", ClientTelemetry.getMachineId(clientConfig));
                generator.writeStringField("connectionMode", clientConfig.getConnectionMode().toString());
                generator.writeNumberField("numberOfClients", clientConfig.getActiveClientsCount());
                generator.writeStringField("excrgns", clientConfig.excludedRegionsRelatedConfig());
                generator.writeObjectFieldStart("clientEndpoints");
                for (Map.Entry entry : clientConfig.clientMap.entrySet()) {
                    try {
                        generator.writeNumberField((String)entry.getKey(), ((Integer)entry.getValue()).intValue());
                    }
                    catch (Exception e) {
                        logger.debug("unexpected failure", (Throwable)e);
                    }
                }
                generator.writeEndObject();
                generator.writeObjectFieldStart("connCfg");
                try {
                    generator.writeStringField("rntbd", clientConfig.rntbdConfig());
                    generator.writeStringField("gw", clientConfig.gwConfig());
                    generator.writeStringField("other", clientConfig.otherConnectionConfig());
                }
                catch (Exception e) {
                    logger.debug("unexpected failure", (Throwable)e);
                }
                generator.writeEndObject();
                generator.writeStringField("consistencyCfg", clientConfig.consistencyRelatedConfig());
                generator.writeStringField("proactiveInitCfg", clientConfig.proactivelyInitializedContainersAsString);
                generator.writeStringField("e2ePolicyCfg", clientConfig.endToEndOperationLatencyPolicyConfigAsString);
                generator.writeStringField("sessionRetryCfg", clientConfig.sessionRetryOptionsAsString);
                if (!StringUtils.isEmpty(clientConfig.regionScopedSessionContainerOptionsAsString)) {
                    generator.writeStringField("regionScopedSessionCfg", clientConfig.regionScopedSessionContainerOptionsAsString);
                }
            }
            catch (Exception e) {
                logger.debug("unexpected failure", (Throwable)e);
            }
            generator.writeEndObject();
        }
    }
}

