/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.ConsistencyLevel;
import com.azure.cosmos.CosmosDiagnosticsThresholds;
import com.azure.cosmos.CosmosEndToEndOperationLatencyPolicyConfig;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.OverridableRequestOptions;
import com.azure.cosmos.models.DedicatedGatewayRequestOptions;
import java.util.List;

public final class CosmosRequestContext {
    private OverridableRequestOptions requestOptions;

    CosmosRequestContext(OverridableRequestOptions requestOptions) {
        this.requestOptions = requestOptions;
    }

    public CosmosEndToEndOperationLatencyPolicyConfig getCosmosEndToEndLatencyPolicyConfig() {
        return this.requestOptions.getCosmosEndToEndLatencyPolicyConfig();
    }

    public ConsistencyLevel getConsistencyLevel() {
        return this.requestOptions.getConsistencyLevel();
    }

    public Boolean isContentResponseOnWriteEnabled() {
        return this.requestOptions.isContentResponseOnWriteEnabled();
    }

    public Boolean getNonIdempotentWriteRetriesEnabled() {
        return this.requestOptions.getNonIdempotentWriteRetriesEnabled();
    }

    public DedicatedGatewayRequestOptions getDedicatedGatewayRequestOptions() {
        return this.requestOptions.getDedicatedGatewayRequestOptions();
    }

    public List<String> getExcludedRegions() {
        return this.requestOptions.getExcludedRegions();
    }

    public String getThroughputControlGroupName() {
        return this.requestOptions.getThroughputControlGroupName();
    }

    public CosmosDiagnosticsThresholds getDiagnosticsThresholds() {
        return this.requestOptions.getDiagnosticsThresholds();
    }

    public Boolean isScanInQueryEnabled() {
        return this.requestOptions.isScanInQueryEnabled();
    }

    public Integer getMaxDegreeOfParallelism() {
        return this.requestOptions.getMaxDegreeOfParallelism();
    }

    public Integer getMaxBufferedItemCount() {
        return this.requestOptions.getMaxBufferedItemCount();
    }

    public Integer getResponseContinuationTokenLimitInKb() {
        return this.requestOptions.getResponseContinuationTokenLimitInKb();
    }

    public Integer getMaxItemCount() {
        return this.requestOptions.getMaxItemCount();
    }

    public Boolean isQueryMetricsEnabled() {
        return this.requestOptions.isQueryMetricsEnabled();
    }

    public Boolean isIndexMetricsEnabled() {
        return this.requestOptions.isIndexMetricsEnabled();
    }

    public Integer getMaxPrefetchPageCount() {
        return this.requestOptions.getMaxPrefetchPageCount();
    }

    public String getQueryNameOrDefault(String defaultQueryName) {
        return this.requestOptions.getQueryNameOrDefault(defaultQueryName);
    }

    static void initialize() {
        ImplementationBridgeHelpers.CosmosRequestContextHelper.setCosmosRequestContextAccessor(new ImplementationBridgeHelpers.CosmosRequestContextHelper.CosmosRequestContextAccessor(){

            @Override
            public CosmosRequestContext create(OverridableRequestOptions requestOptions) {
                return new CosmosRequestContext(requestOptions);
            }
        });
    }
}

