/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.ConsistencyLevel;
import com.azure.cosmos.CosmosDiagnostics;
import com.azure.cosmos.CosmosDiagnosticsRequestEvent;
import com.azure.cosmos.CosmosDiagnosticsRequestInfo;
import com.azure.cosmos.CosmosDiagnosticsThresholds;
import com.azure.cosmos.CosmosException;
import com.azure.cosmos.implementation.ClientSideRequestStatistics;
import com.azure.cosmos.implementation.CosmosDiagnosticsSystemUsageSnapshot;
import com.azure.cosmos.implementation.DistinctClientSideRequestStatisticsCollection;
import com.azure.cosmos.implementation.FeedResponseDiagnostics;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.OperationType;
import com.azure.cosmos.implementation.OverridableRequestOptions;
import com.azure.cosmos.implementation.RequestTimeline;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.directconnectivity.StoreResponseDiagnostics;
import com.azure.cosmos.implementation.directconnectivity.StoreResultDiagnostics;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public final class CosmosDiagnosticsContext {
    private static final ImplementationBridgeHelpers.CosmosDiagnosticsHelper.CosmosDiagnosticsAccessor diagAccessor = ImplementationBridgeHelpers.CosmosDiagnosticsHelper.getCosmosDiagnosticsAccessor();
    private static final ObjectMapper mapper = Utils.getSimpleObjectMapper();
    private final String spanName;
    private final String accountName;
    private final String endpoint;
    private final String databaseName;
    private final String collectionName;
    private final ResourceType resourceType;
    private final String resourceTypeString;
    private final OperationType operationType;
    private final String operationTypeString;
    private final ConsistencyLevel consistencyLevel;
    private final ConcurrentLinkedDeque<CosmosDiagnostics> diagnostics;
    private final Integer maxItemCount;
    private final CosmosDiagnosticsThresholds thresholds;
    private final String operationId;
    private final String trackingId;
    private final String connectionMode;
    private final String userAgent;
    private Throwable finalError;
    private Instant startTime = null;
    private Duration duration = null;
    private int statusCode = 0;
    private int subStatusCode = 0;
    private final AtomicInteger actualItemCount = new AtomicInteger(-1);
    private float totalRequestCharge = 0.0f;
    private int maxRequestSize = 0;
    private int maxResponseSize = 0;
    private String cachedRequestDiagnostics = null;
    private final AtomicBoolean isCompleted = new AtomicBoolean(false);
    private Map<String, Object> systemUsage;
    private Double samplingRateSnapshot;
    private boolean isSampledOut;
    private ArrayList<CosmosDiagnosticsRequestInfo> requestInfo = null;
    private final Integer sequenceNumber;
    private String queryStatement;
    private OverridableRequestOptions requestOptions;

    CosmosDiagnosticsContext(String spanName, String accountName, String endpoint, String databaseName, String collectionName, ResourceType resourceType, OperationType operationType, String operationId, ConsistencyLevel consistencyLevel, Integer maxItemCount, CosmosDiagnosticsThresholds thresholds, String trackingId, String connectionMode, String userAgent, Integer sequenceNumber, String queryStatement, OverridableRequestOptions requestOptions) {
        Preconditions.checkNotNull(spanName, "Argument 'spanName' must not be null.");
        Preconditions.checkNotNull(accountName, "Argument 'accountName' must not be null.");
        Preconditions.checkNotNull(endpoint, "Argument 'endpoint' must not be null.");
        Preconditions.checkNotNull(resourceType, "Argument 'resourceType' must not be null.");
        Preconditions.checkNotNull(operationType, "Argument 'operationType' must not be null.");
        Preconditions.checkNotNull(consistencyLevel, "Argument 'consistencyLevel' must not be null.");
        Preconditions.checkNotNull(thresholds, "Argument 'thresholds' must not be null.");
        Preconditions.checkNotNull(connectionMode, "Argument 'connectionMode' must not be null.");
        Preconditions.checkNotNull(userAgent, "Argument 'userAgent' must not be null.");
        this.spanName = spanName;
        this.accountName = accountName;
        this.endpoint = endpoint;
        this.databaseName = databaseName != null ? databaseName : "";
        this.collectionName = collectionName != null ? collectionName : "";
        this.resourceType = resourceType;
        this.resourceTypeString = resourceType.toString();
        this.operationType = operationType;
        this.operationTypeString = operationType.toString();
        this.operationId = operationId != null ? operationId : "";
        this.diagnostics = new ConcurrentLinkedDeque();
        this.consistencyLevel = consistencyLevel;
        this.maxItemCount = maxItemCount;
        this.thresholds = thresholds;
        this.trackingId = trackingId;
        this.userAgent = userAgent;
        this.connectionMode = connectionMode;
        this.sequenceNumber = sequenceNumber;
        this.isSampledOut = false;
        this.queryStatement = queryStatement;
        this.requestOptions = requestOptions;
    }

    public String getAccountName() {
        return this.accountName;
    }

    String getEndpoint() {
        return this.endpoint;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getContainerName() {
        return this.collectionName;
    }

    public String getResourceType() {
        return this.resourceTypeString;
    }

    ResourceType getResourceTypeInternal() {
        return this.resourceType;
    }

    public String getOperationType() {
        return this.operationTypeString;
    }

    public String getTrackingId() {
        return this.trackingId;
    }

    public boolean isPointOperation() {
        return this.operationType.isPointOperation();
    }

    OperationType getOperationTypeInternal() {
        return this.operationType;
    }

    public String getOperationId() {
        return this.operationId;
    }

    Integer getSequenceNumber() {
        return this.sequenceNumber;
    }

    public ConsistencyLevel getEffectiveConsistencyLevel() {
        return this.consistencyLevel;
    }

    public Integer getMaxItemCount() {
        return this.maxItemCount;
    }

    public Integer getActualItemCount() {
        int snapshot = this.actualItemCount.get();
        if (snapshot < 0) {
            return null;
        }
        return snapshot;
    }

    String getSpanName() {
        return this.spanName;
    }

    public String getQueryStatement() {
        return this.queryStatement;
    }

    public boolean isThresholdViolated() {
        if (!this.isCompleted()) {
            return false;
        }
        if (this.thresholds.isFailureCondition(this.statusCode, this.subStatusCode)) {
            return true;
        }
        if (this.operationType.isPointOperation() ? Duration.ZERO.equals(this.thresholds.getPointOperationLatencyThreshold()) || this.thresholds.getPointOperationLatencyThreshold().compareTo(this.duration) < 0 : Duration.ZERO.equals(this.thresholds.getNonPointOperationLatencyThreshold()) || this.thresholds.getNonPointOperationLatencyThreshold().compareTo(this.duration) < 0) {
            return true;
        }
        if (this.thresholds.getRequestChargeThreshold() < this.totalRequestCharge) {
            return true;
        }
        return this.thresholds.getPayloadSizeThreshold() < Math.max(this.maxRequestSize, this.maxResponseSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addDiagnostics(CosmosDiagnostics cosmosDiagnostics) {
        Preconditions.checkNotNull(cosmosDiagnostics, "Argument 'cosmosDiagnostics' must not be null.");
        if (cosmosDiagnostics.getDiagnosticsContext() == this) {
            return;
        }
        if (cosmosDiagnostics.getFeedResponseDiagnostics() != null && !diagAccessor.isDiagnosticsCapturedInPagedFlux(cosmosDiagnostics).get()) {
            return;
        }
        String string = this.spanName;
        synchronized (string) {
            if (this.samplingRateSnapshot != null) {
                diagAccessor.setSamplingRateSnapshot(cosmosDiagnostics, this.samplingRateSnapshot);
            }
            this.addRequestSize(diagAccessor.getRequestPayloadSizeInBytes(cosmosDiagnostics));
            this.addResponseSize(diagAccessor.getTotalResponsePayloadSizeInBytes(cosmosDiagnostics));
            this.diagnostics.add(cosmosDiagnostics);
            this.cachedRequestDiagnostics = null;
            this.requestInfo = null;
            cosmosDiagnostics.setDiagnosticsContext(this);
        }
    }

    Collection<ClientSideRequestStatistics> getDistinctCombinedClientSideRequestStatistics() {
        DistinctClientSideRequestStatisticsCollection combinedClientSideRequestStatistics = new DistinctClientSideRequestStatisticsCollection();
        for (CosmosDiagnostics diagnostics : this.getDiagnostics()) {
            combinedClientSideRequestStatistics.addAll((Collection<? extends ClientSideRequestStatistics>)diagnostics.getClientSideRequestStatistics());
            FeedResponseDiagnostics feedResponseDiagnostics = diagnostics.getFeedResponseDiagnostics();
            if (feedResponseDiagnostics == null) continue;
            combinedClientSideRequestStatistics.addAll((Collection<? extends ClientSideRequestStatistics>)feedResponseDiagnostics.getClientSideRequestStatistics());
        }
        return combinedClientSideRequestStatistics;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public int getSubStatusCode() {
        return this.subStatusCode;
    }

    public Throwable getFinalError() {
        return this.finalError;
    }

    public int getMaxRequestPayloadSizeInBytes() {
        return this.maxRequestSize;
    }

    public int getMaxResponsePayloadSizeInBytes() {
        return this.maxResponseSize;
    }

    public float getTotalRequestCharge() {
        return this.totalRequestCharge;
    }

    public Set<String> getContactedRegionNames() {
        TreeSet<String> regionsContacted = new TreeSet<String>();
        if (this.diagnostics == null) {
            return regionsContacted;
        }
        for (CosmosDiagnostics d : this.diagnostics) {
            regionsContacted.addAll(d.getContactedRegionNames());
        }
        return regionsContacted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getSystemUsage() {
        String string = this.spanName;
        synchronized (string) {
            Map<String, Object> snapshot = this.systemUsage;
            if (snapshot != null) {
                return snapshot;
            }
            this.systemUsage = ClientSideRequestStatistics.fetchSystemInformation().toMap();
            return this.systemUsage;
        }
    }

    public int getRetryCount() {
        if (this.diagnostics == null) {
            return 0;
        }
        int totalRetryCount = 0;
        for (ClientSideRequestStatistics c : this.getDistinctCombinedClientSideRequestStatistics()) {
            totalRetryCount += this.getRetryCount(c);
        }
        return Math.max(0, totalRetryCount);
    }

    private int getRetryCount(ClientSideRequestStatistics c) {
        if (c == null || c.getRetryContext() == null) {
            return 0;
        }
        return c.getRetryContext().getRetryCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addRequestCharge(float requestCharge) {
        String string = this.spanName;
        synchronized (string) {
            this.totalRequestCharge += requestCharge;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addRequestSize(int bytes) {
        String string = this.spanName;
        synchronized (string) {
            this.maxRequestSize = Math.max(this.maxRequestSize, bytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addResponseSize(int bytes) {
        String string = this.spanName;
        synchronized (string) {
            this.maxResponseSize = Math.max(this.maxResponseSize, bytes);
        }
    }

    public Collection<CosmosDiagnostics> getDiagnostics() {
        return this.diagnostics;
    }

    public boolean isCompleted() {
        return this.isCompleted.get();
    }

    public Duration getDuration() {
        return this.duration;
    }

    public boolean isFailure() {
        if (!this.isCompleted()) {
            return false;
        }
        return this.thresholds.isFailureCondition(this.statusCode, this.subStatusCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startOperation() {
        String string = this.spanName;
        synchronized (string) {
            Preconditions.checkState(this.startTime == null, "Method 'startOperation' must not be called multiple times.");
            this.startTime = Instant.now();
            this.cachedRequestDiagnostics = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean endOperation(int statusCode, int subStatusCode, Integer actualItemCount, Double requestCharge, CosmosDiagnostics diagnostics, Throwable finalError) {
        String string = this.spanName;
        synchronized (string) {
            boolean hasCompletedOperation = this.isCompleted.compareAndSet(false, true);
            if (hasCompletedOperation) {
                this.recordOperation(statusCode, subStatusCode, actualItemCount, requestCharge, diagnostics, finalError);
            }
            return hasCompletedOperation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recordOperation(int statusCode, int subStatusCode, Integer actualItemCount, Double requestCharge, CosmosDiagnostics diagnostics, Throwable finalError) {
        String string = this.spanName;
        synchronized (string) {
            this.statusCode = statusCode;
            this.subStatusCode = subStatusCode;
            this.finalError = finalError;
            if (actualItemCount != null && !this.actualItemCount.compareAndSet(-1, actualItemCount)) {
                this.actualItemCount.addAndGet(actualItemCount);
            }
            this.duration = this.startTime != null ? Duration.between(this.startTime, Instant.now()) : null;
            if (diagnostics != null) {
                this.addDiagnostics(diagnostics);
            }
            if (requestCharge != null) {
                this.addRequestCharge(requestCharge.floatValue());
            }
            this.cachedRequestDiagnostics = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setSamplingRateSnapshot(double samplingRate, boolean isSampledOut) {
        String string = this.spanName;
        synchronized (string) {
            this.samplingRateSnapshot = samplingRate;
            this.isSampledOut = isSampledOut;
            for (CosmosDiagnostics d : this.diagnostics) {
                diagAccessor.setSamplingRateSnapshot(d, samplingRate);
            }
        }
    }

    boolean isSampledOut() {
        return this.isSampledOut;
    }

    String getRequestDiagnostics() {
        ObjectNode ctxNode = mapper.createObjectNode();
        ctxNode.put("spanName", this.spanName);
        ctxNode.put("account", this.accountName);
        ctxNode.put("db", this.databaseName);
        if (!this.collectionName.isEmpty()) {
            ctxNode.put("container", this.collectionName);
        }
        ctxNode.put("resource", this.resourceType.toString());
        ctxNode.put("operation", this.operationType.toString());
        if (!this.operationId.isEmpty()) {
            ctxNode.put("operationId", this.operationId);
        }
        if (this.trackingId != null && !this.trackingId.isEmpty()) {
            ctxNode.put("trackingId", this.trackingId);
        }
        if (this.sequenceNumber != null) {
            ctxNode.put("sequenceNumber", this.sequenceNumber);
        }
        ctxNode.put("consistency", this.consistencyLevel.toString());
        ctxNode.put("status", this.statusCode);
        if (this.subStatusCode != 0) {
            ctxNode.put("subStatus", this.subStatusCode);
        }
        ctxNode.put("RUs", this.totalRequestCharge);
        ctxNode.put("maxRequestSizeInBytes", this.maxRequestSize);
        ctxNode.put("maxResponseSizeInBytes", this.maxResponseSize);
        if (this.maxItemCount != null) {
            ctxNode.put("maxItems", this.maxItemCount);
        }
        if (this.actualItemCount.get() >= 0) {
            ctxNode.put("actualItems", this.actualItemCount.get());
        }
        if (this.queryStatement != null && this.queryStatement.length() > 0) {
            ctxNode.put("queryStatement", this.queryStatement);
        }
        if (this.finalError != null) {
            if (this.finalError instanceof CosmosException) {
                ctxNode.put("exception", ((CosmosException)((Object)this.finalError)).toString(false));
            } else {
                ctxNode.put("exception", this.finalError.getMessage());
            }
        }
        if (this.diagnostics != null && this.diagnostics.size() > 0) {
            ArrayNode diagnosticsNode = ctxNode.putArray("diagnostics");
            for (CosmosDiagnostics d : this.diagnostics) {
                ObjectNode childNode = mapper.createObjectNode();
                d.fillCosmosDiagnostics(childNode, null);
                diagnosticsNode.add((JsonNode)childNode);
            }
        }
        try {
            return mapper.writeValueAsString((Object)ctxNode);
        }
        catch (JsonProcessingException e) {
            ctxNode = mapper.createObjectNode();
            ctxNode.put("exception", e.toString());
            try {
                return mapper.writeValueAsString((Object)ctxNode);
            }
            catch (JsonProcessingException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toJson() {
        String snapshot = this.cachedRequestDiagnostics;
        if (snapshot != null) {
            return snapshot;
        }
        String string = this.spanName;
        synchronized (string) {
            snapshot = this.cachedRequestDiagnostics;
            if (snapshot != null) {
                return snapshot;
            }
            this.systemUsage = ClientSideRequestStatistics.fetchSystemInformation().toMap();
            this.cachedRequestDiagnostics = this.getRequestDiagnostics();
            return this.cachedRequestDiagnostics;
        }
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getConnectionMode() {
        return this.connectionMode;
    }

    private static void addRequestInfoForGatewayStatistics(ClientSideRequestStatistics requestStats, List<CosmosDiagnosticsRequestInfo> requestInfo) {
        List<ClientSideRequestStatistics.GatewayStatistics> gatewayStatsList = requestStats.getGatewayStatisticsList();
        if (gatewayStatsList == null || gatewayStatsList.size() == 0) {
            return;
        }
        for (ClientSideRequestStatistics.GatewayStatistics gatewayStats : gatewayStatsList) {
            CosmosDiagnosticsRequestInfo info = new CosmosDiagnosticsRequestInfo(requestStats.getActivityId(), null, gatewayStats.getPartitionKeyRangeId(), (Object)((Object)gatewayStats.getResourceType()) + ":" + (Object)((Object)gatewayStats.getOperationType()), requestStats.getRequestStartTimeUTC(), requestStats.getDuration(), null, gatewayStats.getRequestCharge(), gatewayStats.getResponsePayloadSizeInBytes(), gatewayStats.getStatusCode(), gatewayStats.getSubStatusCode(), new ArrayList<CosmosDiagnosticsRequestEvent>());
            requestInfo.add(info);
        }
    }

    private static void addRequestInfoForStoreResponses(ClientSideRequestStatistics requestStats, List<CosmosDiagnosticsRequestInfo> requestInfo, Collection<ClientSideRequestStatistics.StoreResponseStatistics> storeResponses) {
        for (ClientSideRequestStatistics.StoreResponseStatistics responseStats : storeResponses) {
            StoreResultDiagnostics resultDiagnostics = responseStats.getStoreResult();
            if (resultDiagnostics == null) continue;
            StoreResponseDiagnostics responseDiagnostics = resultDiagnostics.getStoreResponseDiagnostics();
            String partitionId = null;
            String[] partitionAndReplicaId = resultDiagnostics.getPartitionAndReplicaId();
            if (partitionAndReplicaId.length == 2) {
                partitionId = partitionAndReplicaId[0];
            }
            ArrayList<CosmosDiagnosticsRequestEvent> events = new ArrayList<CosmosDiagnosticsRequestEvent>();
            String pkRangeId = "";
            double requestCharge = 0.0;
            int responsePayloadLength = 0;
            int statusCode = 0;
            int subStatusCode = 0;
            String activityId = requestStats.getActivityId();
            if (responseDiagnostics != null) {
                activityId = responseDiagnostics.getActivityId();
                requestCharge = responseDiagnostics.getRequestCharge();
                responsePayloadLength = responseDiagnostics.getResponsePayloadLength();
                statusCode = responseDiagnostics.getStatusCode();
                subStatusCode = responseDiagnostics.getSubStatusCode();
                if (responseDiagnostics.getPartitionKeyRangeId() != null) {
                    pkRangeId = responseDiagnostics.getPartitionKeyRangeId();
                }
                RequestTimeline timeline = responseDiagnostics.getRequestTimeline();
                timeline.forEach(e -> {
                    if (e.getStartTime() != null && e.getDuration() != null && !e.getDuration().equals(Duration.ZERO)) {
                        events.add(new CosmosDiagnosticsRequestEvent(e.getStartTime(), e.getDuration(), e.getName()));
                    }
                });
            }
            Duration backendLatency = null;
            if (resultDiagnostics.getBackendLatencyInMs() != null) {
                backendLatency = Duration.ofNanos((long)(resultDiagnostics.getBackendLatencyInMs() * 1000000.0));
            }
            CosmosDiagnosticsRequestInfo info = new CosmosDiagnosticsRequestInfo(activityId, partitionId, pkRangeId, (Object)((Object)responseStats.getRequestResourceType()) + ":" + (Object)((Object)responseStats.getRequestOperationType()), requestStats.getRequestStartTimeUTC(), responseStats.getDuration(), backendLatency, requestCharge, responsePayloadLength, statusCode, subStatusCode, events);
            requestInfo.add(info);
        }
    }

    private void addRequestInfoForAddressResolution(ClientSideRequestStatistics requestStats, List<CosmosDiagnosticsRequestInfo> requestInfo, Map<String, ClientSideRequestStatistics.AddressResolutionStatistics> addressResolutionStatisticsMap) {
        if (addressResolutionStatisticsMap == null || addressResolutionStatisticsMap.isEmpty()) {
            return;
        }
        for (Map.Entry<String, ClientSideRequestStatistics.AddressResolutionStatistics> current : addressResolutionStatisticsMap.entrySet()) {
            ClientSideRequestStatistics.AddressResolutionStatistics addressResolutionStatistics = current.getValue();
            String addressResolutionActivityId = current.getKey();
            if (addressResolutionStatistics.isInflightRequest() || addressResolutionStatistics.getEndTimeUTC() == null) continue;
            Duration latency = Duration.between(addressResolutionStatistics.getStartTimeUTC(), addressResolutionStatistics.getEndTimeUTC());
            StringBuilder sb = new StringBuilder();
            sb.append("AddressResolution|");
            sb.append(addressResolutionStatistics.getTargetEndpoint());
            sb.append("|");
            if (addressResolutionStatistics.isForceRefresh()) {
                sb.append("1|");
            } else {
                sb.append("0|");
            }
            if (addressResolutionStatistics.isForceCollectionRoutingMapRefresh()) {
                sb.append("1");
            } else {
                sb.append("0");
            }
            CosmosDiagnosticsRequestInfo info = new CosmosDiagnosticsRequestInfo(addressResolutionActivityId, null, null, sb.toString(), addressResolutionStatistics.getStartTimeUTC(), latency, null, 0.0, 0, 0, 0, new ArrayList<CosmosDiagnosticsRequestEvent>());
            requestInfo.add(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CosmosDiagnosticsRequestInfo> getRequestInfo() {
        String string = this.spanName;
        synchronized (string) {
            ArrayList<CosmosDiagnosticsRequestInfo> snapshot = this.requestInfo;
            if (snapshot != null) {
                return snapshot;
            }
            snapshot = new ArrayList();
            for (ClientSideRequestStatistics requestStats : this.getDistinctCombinedClientSideRequestStatistics()) {
                CosmosDiagnosticsContext.addRequestInfoForStoreResponses(requestStats, snapshot, requestStats.getResponseStatisticsList());
                CosmosDiagnosticsContext.addRequestInfoForStoreResponses(requestStats, snapshot, requestStats.getSupplementalResponseStatisticsList());
                CosmosDiagnosticsContext.addRequestInfoForGatewayStatistics(requestStats, snapshot);
                this.addRequestInfoForAddressResolution(requestStats, snapshot, requestStats.getAddressResolutionStatistics());
            }
            this.requestInfo = snapshot;
            return snapshot;
        }
    }

    OverridableRequestOptions getRequestOptions() {
        return this.requestOptions;
    }

    void setRequestOptions(OverridableRequestOptions requestOptions) {
        this.requestOptions = requestOptions;
    }

    static void initialize() {
        ImplementationBridgeHelpers.CosmosDiagnosticsContextHelper.setCosmosDiagnosticsContextAccessor(new ImplementationBridgeHelpers.CosmosDiagnosticsContextHelper.CosmosDiagnosticsContextAccessor(){

            @Override
            public CosmosDiagnosticsContext create(String spanName, String account, String endpoint, String databaseId, String containerId, ResourceType resourceType, OperationType operationType, String operationId, ConsistencyLevel consistencyLevel, Integer maxItemCount, CosmosDiagnosticsThresholds thresholds, String trackingId, String connectionMode, String userAgent, Integer sequenceNumber, String queryStatement, OverridableRequestOptions requestOptions) {
                return new CosmosDiagnosticsContext(spanName, account, endpoint, databaseId, containerId, resourceType, operationType, operationId, consistencyLevel, maxItemCount, thresholds, trackingId, connectionMode, userAgent, sequenceNumber, queryStatement, requestOptions);
            }

            @Override
            public OverridableRequestOptions getRequestOptions(CosmosDiagnosticsContext ctx) {
                Preconditions.checkNotNull(ctx, "Argument 'ctx' must not be null.");
                return ctx.getRequestOptions();
            }

            @Override
            public void setRequestOptions(CosmosDiagnosticsContext ctx, OverridableRequestOptions requestOptions) {
                Preconditions.checkNotNull(ctx, "Argument 'ctx' must not be null.");
                ctx.setRequestOptions(requestOptions);
            }

            @Override
            public CosmosDiagnosticsSystemUsageSnapshot createSystemUsageSnapshot(String cpu, String used, String available, int cpuCount) {
                return new CosmosDiagnosticsSystemUsageSnapshot(cpu, used, available, cpuCount);
            }

            @Override
            public void startOperation(CosmosDiagnosticsContext ctx) {
                Preconditions.checkNotNull(ctx, "Argument 'ctx' must not be null.");
                ctx.startOperation();
            }

            @Override
            public void recordOperation(CosmosDiagnosticsContext ctx, int statusCode, int subStatusCode, Integer actualItemCount, Double requestCharge, CosmosDiagnostics diagnostics, Throwable finalError) {
                ctx.recordOperation(statusCode, subStatusCode, actualItemCount, requestCharge, diagnostics, finalError);
            }

            @Override
            public boolean endOperation(CosmosDiagnosticsContext ctx, int statusCode, int subStatusCode, Integer actualItemCount, Double requestCharge, CosmosDiagnostics diagnostics, Throwable finalError) {
                return ctx.endOperation(statusCode, subStatusCode, actualItemCount, requestCharge, diagnostics, finalError);
            }

            @Override
            public void addRequestCharge(CosmosDiagnosticsContext ctx, float requestCharge) {
                Preconditions.checkNotNull(ctx, "Argument 'ctx' must not be null.");
                ctx.addRequestCharge(requestCharge);
            }

            @Override
            public void addRequestSize(CosmosDiagnosticsContext ctx, int bytes) {
                Preconditions.checkNotNull(ctx, "Argument 'ctx' must not be null.");
                ctx.addRequestSize(bytes);
            }

            @Override
            public void addResponseSize(CosmosDiagnosticsContext ctx, int bytes) {
                Preconditions.checkNotNull(ctx, "Argument 'ctx' must not be null.");
                ctx.addResponseSize(bytes);
            }

            @Override
            public void addDiagnostics(CosmosDiagnosticsContext ctx, CosmosDiagnostics diagnostics) {
                Preconditions.checkNotNull(ctx, "Argument 'ctx' must not be null.");
                Preconditions.checkNotNull(ctx, "Argument 'diagnostics' must not be null.");
                ctx.addDiagnostics(diagnostics);
            }

            @Override
            public Collection<CosmosDiagnostics> getDiagnostics(CosmosDiagnosticsContext ctx) {
                Preconditions.checkNotNull(ctx, "Argument 'ctx' must not be null.");
                return ctx.getDiagnostics();
            }

            @Override
            public ResourceType getResourceType(CosmosDiagnosticsContext ctx) {
                Preconditions.checkNotNull(ctx, "Argument 'ctx' must not be null.");
                return ctx.getResourceTypeInternal();
            }

            @Override
            public OperationType getOperationType(CosmosDiagnosticsContext ctx) {
                Preconditions.checkNotNull(ctx, "Argument 'ctx' must not be null.");
                return ctx.getOperationTypeInternal();
            }

            @Override
            public String getEndpoint(CosmosDiagnosticsContext ctx) {
                Preconditions.checkNotNull(ctx, "Argument 'ctx' must not be null.");
                return ctx.getEndpoint();
            }

            @Override
            public Collection<ClientSideRequestStatistics> getDistinctCombinedClientSideRequestStatistics(CosmosDiagnosticsContext ctx) {
                Preconditions.checkNotNull(ctx, "Argument 'ctx' must not be null.");
                return ctx.getDistinctCombinedClientSideRequestStatistics();
            }

            @Override
            public String getSpanName(CosmosDiagnosticsContext ctx) {
                Preconditions.checkNotNull(ctx, "Argument 'ctx' must not be null.");
                return ctx.getSpanName();
            }

            @Override
            public void setSamplingRateSnapshot(CosmosDiagnosticsContext ctx, double samplingRate, boolean isSampledOut) {
                Preconditions.checkNotNull(ctx, "Argument 'ctx' must not be null.");
                ctx.setSamplingRateSnapshot(samplingRate, isSampledOut);
            }

            @Override
            public Integer getSequenceNumber(CosmosDiagnosticsContext ctx) {
                Preconditions.checkNotNull(ctx, "Argument 'ctx' must not be null.");
                return ctx.getSequenceNumber();
            }

            @Override
            public boolean isEmptyCompletion(CosmosDiagnosticsContext ctx) {
                Preconditions.checkNotNull(ctx, "Argument 'ctx' must not be null.");
                Integer sequenceNumber = ctx.getSequenceNumber();
                return sequenceNumber != null && sequenceNumber != 1;
            }

            @Override
            public String getQueryStatement(CosmosDiagnosticsContext ctx) {
                Preconditions.checkNotNull(ctx, "Argument 'ctx' must not be null.");
                return ctx.getQueryStatement();
            }
        });
    }
}

