/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.models.CosmosMetricCategory;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;

public final class CosmosMetricName {
    private final String name;
    private final CosmosMetricCategory metricCategory;
    public static final CosmosMetricName OPERATION_SUMMARY_CALLS = new CosmosMetricName(CosmosMetricName.nameOf("op.calls"), CosmosMetricCategory.OPERATION_SUMMARY);
    public static final CosmosMetricName OPERATION_SUMMARY_LATENCY = new CosmosMetricName(CosmosMetricName.nameOf("op.latency"), CosmosMetricCategory.OPERATION_SUMMARY);
    public static final CosmosMetricName OPERATION_SUMMARY_REQUEST_CHARGE = new CosmosMetricName(CosmosMetricName.nameOf("op.RUs"), CosmosMetricCategory.OPERATION_SUMMARY);
    public static final CosmosMetricName OPERATION_DETAILS_REGIONS_CONTACTED = new CosmosMetricName(CosmosMetricName.nameOf("op.regionsContacted"), CosmosMetricCategory.OPERATION_DETAILS);
    public static final CosmosMetricName OPERATION_DETAILS_ACTUAL_ITEM_COUNT = new CosmosMetricName(CosmosMetricName.nameOf("op.actualItemCount"), CosmosMetricCategory.OPERATION_DETAILS);
    public static final CosmosMetricName OPERATION_DETAILS_MAX_ITEM_COUNT = new CosmosMetricName(CosmosMetricName.nameOf("op.maxItemCount"), CosmosMetricCategory.OPERATION_DETAILS);
    public static final CosmosMetricName REQUEST_SUMMARY_DIRECT_REQUESTS = new CosmosMetricName(CosmosMetricName.nameOf("req.rntbd.requests"), CosmosMetricCategory.REQUEST_SUMMARY);
    public static final CosmosMetricName REQUEST_SUMMARY_DIRECT_LATENCY = new CosmosMetricName(CosmosMetricName.nameOf("req.rntbd.latency"), CosmosMetricCategory.REQUEST_SUMMARY);
    public static final CosmosMetricName REQUEST_SUMMARY_DIRECT_BACKEND_LATENCY = new CosmosMetricName(CosmosMetricName.nameOf("req.rntbd.backendLatency"), CosmosMetricCategory.REQUEST_SUMMARY);
    public static final CosmosMetricName REQUEST_SUMMARY_DIRECT_REQUEST_CHARGE = new CosmosMetricName(CosmosMetricName.nameOf("req.rntbd.RUs"), CosmosMetricCategory.REQUEST_SUMMARY);
    public static final CosmosMetricName REQUEST_SUMMARY_DIRECT_ACTUAL_ITEM_COUNT = new CosmosMetricName(CosmosMetricName.nameOf("req.rntbd.actualItemCount"), CosmosMetricCategory.REQUEST_SUMMARY);
    public static final CosmosMetricName REQUEST_SUMMARY_GATEWAY_REQUESTS = new CosmosMetricName(CosmosMetricName.nameOf("req.gw.requests"), CosmosMetricCategory.REQUEST_SUMMARY);
    public static final CosmosMetricName REQUEST_SUMMARY_GATEWAY_LATENCY = new CosmosMetricName(CosmosMetricName.nameOf("req.gw.latency"), CosmosMetricCategory.REQUEST_SUMMARY);
    public static final CosmosMetricName REQUEST_SUMMARY_GATEWAY_REQUEST_CHARGE = new CosmosMetricName(CosmosMetricName.nameOf("req.gw.RUs"), CosmosMetricCategory.REQUEST_SUMMARY);
    public static final CosmosMetricName REQUEST_SUMMARY_GATEWAY_ACTUAL_ITEM_COUNT = new CosmosMetricName(CosmosMetricName.nameOf("req.gw.actualItemCount"), CosmosMetricCategory.REQUEST_SUMMARY);
    public static final CosmosMetricName REQUEST_SUMMARY_SIZE_REQUEST = new CosmosMetricName(CosmosMetricName.nameOf("req.reqPayloadSize"), CosmosMetricCategory.REQUEST_SUMMARY);
    public static final CosmosMetricName REQUEST_SUMMARY_SIZE_RESPONSE = new CosmosMetricName(CosmosMetricName.nameOf("req.rspPayloadSize"), CosmosMetricCategory.REQUEST_SUMMARY);
    public static final CosmosMetricName REQUEST_DETAILS_DIRECT_TIMELINE = new CosmosMetricName(CosmosMetricName.nameOf("req.rntbd.timeline"), CosmosMetricCategory.REQUEST_DETAILS);
    public static final CosmosMetricName REQUEST_DETAILS_GATEWAY_TIMELINE = new CosmosMetricName(CosmosMetricName.nameOf("req.gw.timeline"), CosmosMetricCategory.REQUEST_DETAILS);
    public static final CosmosMetricName DIRECT_CHANNELS_ACQUIRED_COUNT = new CosmosMetricName(CosmosMetricName.nameOf("rntbd.channels.acquired.count"), CosmosMetricCategory.DIRECT_CHANNELS);
    public static final CosmosMetricName DIRECT_CHANNELS_CLOSED_COUNT = new CosmosMetricName(CosmosMetricName.nameOf("rntbd.channels.closed.count"), CosmosMetricCategory.DIRECT_CHANNELS);
    public static final CosmosMetricName DIRECT_CHANNELS_AVAILABLE_COUNT = new CosmosMetricName(CosmosMetricName.nameOf("rntbd.channels.available.count"), CosmosMetricCategory.DIRECT_CHANNELS);
    public static final CosmosMetricName DIRECT_ENDPOINTS_COUNT = new CosmosMetricName(CosmosMetricName.nameOf("rntbd.endpoints.count"), CosmosMetricCategory.DIRECT_ENDPOINTS);
    public static final CosmosMetricName DIRECT_ENDPOINTS_EVICTED = new CosmosMetricName(CosmosMetricName.nameOf("rntbd.endpoints.evicted"), CosmosMetricCategory.DIRECT_ENDPOINTS);
    public static final CosmosMetricName DIRECT_ADDRESS_RESOLUTION_REQUESTS = new CosmosMetricName(CosmosMetricName.nameOf("rntbd.addressResolution.requests"), CosmosMetricCategory.DIRECT_ADDRESS_RESOLUTIONS);
    public static final CosmosMetricName DIRECT_ADDRESS_RESOLUTION_LATENCY = new CosmosMetricName(CosmosMetricName.nameOf("rntbd.addressResolution.latency"), CosmosMetricCategory.DIRECT_ADDRESS_RESOLUTIONS);
    public static final CosmosMetricName DIRECT_REQUEST_LATENCY = new CosmosMetricName(CosmosMetricName.nameOf("rntbd.requests.latency"), CosmosMetricCategory.DIRECT_REQUESTS);
    public static final CosmosMetricName DIRECT_REQUEST_LATENCY_FAILED = new CosmosMetricName(CosmosMetricName.nameOf("rntbd.requests.failed.latency"), CosmosMetricCategory.DIRECT_REQUESTS);
    public static final CosmosMetricName DIRECT_REQUEST_LATENCY_SUCCESS = new CosmosMetricName(CosmosMetricName.nameOf("rntbd.requests.successful.latency"), CosmosMetricCategory.DIRECT_REQUESTS);
    public static final CosmosMetricName DIRECT_REQUEST_CONCURRENT_COUNT = new CosmosMetricName(CosmosMetricName.nameOf("rntbd.requests.concurrent.count"), CosmosMetricCategory.DIRECT_REQUESTS);
    public static final CosmosMetricName DIRECT_REQUEST_QUEUED_COUNT = new CosmosMetricName(CosmosMetricName.nameOf("rntbd.requests.queued.count"), CosmosMetricCategory.DIRECT_REQUESTS);
    public static final CosmosMetricName DIRECT_REQUEST_SIZE_REQUEST = new CosmosMetricName(CosmosMetricName.nameOf("rntbd.req.reqSize"), CosmosMetricCategory.DIRECT_REQUESTS);
    public static final CosmosMetricName DIRECT_REQUEST_SIZE_RESPONSE = new CosmosMetricName(CosmosMetricName.nameOf("rntbd.req.rspSize"), CosmosMetricCategory.DIRECT_REQUESTS);
    public static final CosmosMetricName SYSTEM_CPU = new CosmosMetricName(CosmosMetricName.nameOf("system.avgCpuLoad"), CosmosMetricCategory.SYSTEM);
    public static final CosmosMetricName SYSTEM_MEMORY_FREE = new CosmosMetricName(CosmosMetricName.nameOf("system.freeMemoryAvailable"), CosmosMetricCategory.SYSTEM);
    public static final CosmosMetricName LEGACY_DIRECT_ENDPOINT_STATISTICS_ACQUIRED = new CosmosMetricName(CosmosMetricName.nameOf("req.rntbd.stats.endpoint.acquiredChannels"), CosmosMetricCategory.LEGACY);
    public static final CosmosMetricName LEGACY_DIRECT_ENDPOINT_STATISTICS_AVAILABLE = new CosmosMetricName(CosmosMetricName.nameOf("req.rntbd.stats.endpoint.availableChannels"), CosmosMetricCategory.LEGACY);
    public static final CosmosMetricName LEGACY_DIRECT_ENDPOINT_STATISTICS_INFLIGHT = new CosmosMetricName(CosmosMetricName.nameOf("req.rntbd.stats.endpoint.inflightRequests"), CosmosMetricCategory.LEGACY);
    private static final Map<String, CosmosMetricName> meters = CosmosMetricName.createMeterNameMap();

    private CosmosMetricName(String name, CosmosMetricCategory metricCategory) {
        Preconditions.checkNotNull(name, "Argument 'name' must not be null.");
        Preconditions.checkNotNull(metricCategory, "Argument 'meterCategory' must not be null.");
        this.name = name;
        this.metricCategory = metricCategory;
    }

    public static CosmosMetricName fromString(String name) {
        Preconditions.checkNotNull(name, "Argument 'name' must not be null.");
        String normalizedName = name.trim().toLowerCase(Locale.ROOT);
        CosmosMetricName meterName = meters.getOrDefault(normalizedName, null);
        if (meterName == null) {
            String errorMessage = String.format("Argument 'name' has invalid value '%s' - valid values are: %s", name, CosmosMetricName.getValidValues());
            throw new IllegalArgumentException(errorMessage);
        }
        return meterName;
    }

    public CosmosMetricCategory getCategory() {
        return this.metricCategory;
    }

    @JsonValue
    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return Objects.hash(CosmosMetricName.class, this.name);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!CosmosMetricName.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.name == null) {
            return ((CosmosMetricName)obj).name == null;
        }
        return this.name.equals(((CosmosMetricName)obj).name);
    }

    private static Map<String, CosmosMetricName> createMeterNameMap() {
        HashMap<String, CosmosMetricName> map = new HashMap<String, CosmosMetricName>();
        map.put(CosmosMetricName.nameOf("op.latency"), OPERATION_SUMMARY_LATENCY);
        map.put(CosmosMetricName.nameOf("op.calls"), OPERATION_SUMMARY_CALLS);
        map.put(CosmosMetricName.nameOf("op.rus"), OPERATION_SUMMARY_REQUEST_CHARGE);
        map.put(CosmosMetricName.nameOf("op.maxitemcount"), OPERATION_DETAILS_MAX_ITEM_COUNT);
        map.put(CosmosMetricName.nameOf("op.actualitemcount"), OPERATION_DETAILS_ACTUAL_ITEM_COUNT);
        map.put(CosmosMetricName.nameOf("op.regionscontacted"), OPERATION_DETAILS_REGIONS_CONTACTED);
        map.put(CosmosMetricName.nameOf("req.rntbd.requests"), REQUEST_SUMMARY_DIRECT_REQUESTS);
        map.put(CosmosMetricName.nameOf("req.rntbd.latency"), REQUEST_SUMMARY_DIRECT_LATENCY);
        map.put(CosmosMetricName.nameOf("req.rntbd.backendlatency"), REQUEST_SUMMARY_DIRECT_BACKEND_LATENCY);
        map.put(CosmosMetricName.nameOf("req.rntbd.rus"), REQUEST_SUMMARY_DIRECT_REQUEST_CHARGE);
        map.put(CosmosMetricName.nameOf("req.rntbd.actualitemcount"), REQUEST_SUMMARY_DIRECT_ACTUAL_ITEM_COUNT);
        map.put(CosmosMetricName.nameOf("req.gw.requests"), REQUEST_SUMMARY_GATEWAY_REQUESTS);
        map.put(CosmosMetricName.nameOf("req.gw.latency"), REQUEST_SUMMARY_GATEWAY_LATENCY);
        map.put(CosmosMetricName.nameOf("req.gw.rus"), REQUEST_SUMMARY_GATEWAY_REQUEST_CHARGE);
        map.put(CosmosMetricName.nameOf("req.gw.actualitemcount"), REQUEST_SUMMARY_GATEWAY_ACTUAL_ITEM_COUNT);
        map.put(CosmosMetricName.nameOf("req.reqpayloadsize"), REQUEST_SUMMARY_SIZE_REQUEST);
        map.put(CosmosMetricName.nameOf("req.rsppayloadsize"), REQUEST_SUMMARY_SIZE_RESPONSE);
        map.put(CosmosMetricName.nameOf("req.rntbd.timeline"), REQUEST_DETAILS_DIRECT_TIMELINE);
        map.put(CosmosMetricName.nameOf("req.gw.timeline"), REQUEST_DETAILS_GATEWAY_TIMELINE);
        map.put(CosmosMetricName.nameOf("rntbd.channels.acquired.count"), DIRECT_CHANNELS_ACQUIRED_COUNT);
        map.put(CosmosMetricName.nameOf("rntbd.channels.available.count"), DIRECT_CHANNELS_AVAILABLE_COUNT);
        map.put(CosmosMetricName.nameOf("rntbd.channels.closed.count"), DIRECT_CHANNELS_CLOSED_COUNT);
        map.put(CosmosMetricName.nameOf("rntbd.endpoints.count"), DIRECT_ENDPOINTS_COUNT);
        map.put(CosmosMetricName.nameOf("rntbd.endpoints.evicted"), DIRECT_ENDPOINTS_EVICTED);
        map.put(CosmosMetricName.nameOf("rntbd.addressresolution.requests"), DIRECT_ADDRESS_RESOLUTION_REQUESTS);
        map.put(CosmosMetricName.nameOf("rntbd.addressresolution.latency"), DIRECT_ADDRESS_RESOLUTION_LATENCY);
        map.put(CosmosMetricName.nameOf("rntbd.requests.latency"), DIRECT_REQUEST_LATENCY);
        map.put(CosmosMetricName.nameOf("rntbd.requests.failed.latency"), DIRECT_REQUEST_LATENCY_FAILED);
        map.put(CosmosMetricName.nameOf("rntbd.requests.successful.latency"), DIRECT_REQUEST_LATENCY_SUCCESS);
        map.put(CosmosMetricName.nameOf("rntbd.requests.concurrent.count"), DIRECT_REQUEST_CONCURRENT_COUNT);
        map.put(CosmosMetricName.nameOf("rntbd.requests.queued.count"), DIRECT_REQUEST_QUEUED_COUNT);
        map.put(CosmosMetricName.nameOf("rntbd.req.reqsize"), DIRECT_REQUEST_SIZE_REQUEST);
        map.put(CosmosMetricName.nameOf("rntbd.req.rspsize"), DIRECT_REQUEST_SIZE_RESPONSE);
        map.put(CosmosMetricName.nameOf("system.freememoryavailable"), SYSTEM_MEMORY_FREE);
        map.put(CosmosMetricName.nameOf("system.avgcpuload"), SYSTEM_CPU);
        map.put(CosmosMetricName.nameOf("req.rntbd.stats.endpoint.acquiredchannels"), LEGACY_DIRECT_ENDPOINT_STATISTICS_ACQUIRED);
        map.put(CosmosMetricName.nameOf("req.rntbd.stats.endpoint.availablechannels"), LEGACY_DIRECT_ENDPOINT_STATISTICS_AVAILABLE);
        map.put(CosmosMetricName.nameOf("req.rntbd.stats.endpoint.inflightrequests"), LEGACY_DIRECT_ENDPOINT_STATISTICS_INFLIGHT);
        return Collections.unmodifiableMap(map);
    }

    private static String getValidValues() {
        StringJoiner sj = new StringJoiner(", ");
        for (CosmosMetricName metric : meters.values()) {
            sj.add(metric.name);
        }
        return sj.toString();
    }

    private static String nameOf(String member) {
        return "cosmos.client." + member;
    }
}

