/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.query.aggregation;

import com.azure.cosmos.implementation.Undefined;
import com.azure.cosmos.implementation.query.ItemComparator;
import com.azure.cosmos.implementation.query.aggregation.Aggregator;
import com.azure.cosmos.implementation.query.aggregation.MaxAggregator;
import com.fasterxml.jackson.databind.node.ObjectNode;

public class MinAggregator
implements Aggregator {
    public static final String COUNT_PROPERTY_NAME = "count";
    public static final String MIN_PROPERTY_NAME = "min";
    private Object value = Undefined.value();

    @Override
    public void aggregate(Object item) {
        ObjectNode objectNode;
        if (item instanceof ObjectNode && (objectNode = (ObjectNode)item).hasNonNull(COUNT_PROPERTY_NAME)) {
            long count = objectNode.get(COUNT_PROPERTY_NAME).asLong();
            if (count == 0L) {
                return;
            }
            item = objectNode.has(MIN_PROPERTY_NAME) ? MaxAggregator.getValue(objectNode.get(MIN_PROPERTY_NAME)) : Undefined.value();
        }
        if (item == Undefined.value()) {
            return;
        }
        if (Undefined.value().equals(this.value)) {
            this.value = item;
        } else if (ItemComparator.getInstance().compare(item, this.value) < 0) {
            this.value = item;
        }
    }

    @Override
    public Object getResult() {
        return this.value;
    }
}

