/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.ConsistencyLevel;
import com.azure.cosmos.CosmosDiagnostics;
import com.azure.cosmos.CosmosDiagnosticsThresholds;
import com.azure.cosmos.CosmosEndToEndOperationLatencyPolicyConfig;
import com.azure.cosmos.implementation.CosmosQueryRequestOptionsBase;
import com.azure.cosmos.implementation.CosmosQueryRequestOptionsImpl;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.RequestOptions;
import com.azure.cosmos.models.DedicatedGatewayRequestOptions;
import com.azure.cosmos.models.FeedRange;
import com.azure.cosmos.models.PartitionKey;
import java.time.Duration;
import java.util.List;

public class CosmosQueryRequestOptions {
    private final CosmosQueryRequestOptionsImpl actualRequestOptions;

    public CosmosQueryRequestOptions() {
        this.actualRequestOptions = new CosmosQueryRequestOptionsImpl();
    }

    CosmosQueryRequestOptions(CosmosQueryRequestOptions options) {
        this.actualRequestOptions = new CosmosQueryRequestOptionsImpl(options.actualRequestOptions);
    }

    CosmosQueryRequestOptions(CosmosQueryRequestOptionsBase<?> options) {
        this.actualRequestOptions = new CosmosQueryRequestOptionsImpl(options);
    }

    public ConsistencyLevel getConsistencyLevel() {
        return this.actualRequestOptions.getConsistencyLevel();
    }

    public CosmosQueryRequestOptions setConsistencyLevel(ConsistencyLevel consistencyLevel) {
        this.actualRequestOptions.setConsistencyLevel(consistencyLevel);
        return this;
    }

    public String getSessionToken() {
        return this.actualRequestOptions.getSessionToken();
    }

    public CosmosQueryRequestOptions setSessionToken(String sessionToken) {
        this.actualRequestOptions.setSessionToken(sessionToken);
        return this;
    }

    public Boolean isScanInQueryEnabled() {
        return this.actualRequestOptions.isScanInQueryEnabled();
    }

    public CosmosQueryRequestOptions setScanInQueryEnabled(Boolean scanInQueryEnabled) {
        this.actualRequestOptions.setScanInQueryEnabled(scanInQueryEnabled);
        return this;
    }

    public int getMaxDegreeOfParallelism() {
        return this.actualRequestOptions.getMaxDegreeOfParallelism();
    }

    public CosmosQueryRequestOptions setMaxDegreeOfParallelism(int maxDegreeOfParallelism) {
        this.actualRequestOptions.setMaxDegreeOfParallelism(maxDegreeOfParallelism);
        return this;
    }

    public int getMaxBufferedItemCount() {
        return this.actualRequestOptions.getMaxBufferedItemCount();
    }

    public CosmosQueryRequestOptions setMaxBufferedItemCount(int maxBufferedItemCount) {
        this.actualRequestOptions.setMaxBufferedItemCount(maxBufferedItemCount);
        return this;
    }

    public CosmosQueryRequestOptions setResponseContinuationTokenLimitInKb(int limitInKb) {
        this.actualRequestOptions.setResponseContinuationTokenLimitInKb(limitInKb);
        return this;
    }

    public int getResponseContinuationTokenLimitInKb() {
        return this.actualRequestOptions.getResponseContinuationTokenLimitInKb();
    }

    public CosmosQueryRequestOptions setCosmosEndToEndOperationLatencyPolicyConfig(CosmosEndToEndOperationLatencyPolicyConfig cosmosEndToEndOperationLatencyPolicyConfig) {
        this.actualRequestOptions.setCosmosEndToEndOperationLatencyPolicyConfig(cosmosEndToEndOperationLatencyPolicyConfig);
        return this;
    }

    public CosmosQueryRequestOptions setExcludedRegions(List<String> excludeRegions) {
        this.actualRequestOptions.setExcludedRegions(excludeRegions);
        return this;
    }

    public List<String> getExcludedRegions() {
        return this.actualRequestOptions.getExcludedRegions();
    }

    Integer getMaxItemCount() {
        return this.actualRequestOptions.getMaxItemCount();
    }

    CosmosQueryRequestOptions setMaxItemCount(Integer maxItemCount) {
        this.actualRequestOptions.setMaxItemCount(maxItemCount);
        return this;
    }

    String getRequestContinuation() {
        return this.actualRequestOptions.getRequestContinuation();
    }

    CosmosQueryRequestOptions setRequestContinuation(String requestContinuation) {
        this.actualRequestOptions.setRequestContinuation(requestContinuation);
        return this;
    }

    public PartitionKey getPartitionKey() {
        return this.actualRequestOptions.getPartitionKey();
    }

    public CosmosQueryRequestOptions setPartitionKey(PartitionKey partitionkey) {
        this.actualRequestOptions.setPartitionKey(partitionkey);
        return this;
    }

    public boolean isQueryMetricsEnabled() {
        return this.actualRequestOptions.isQueryMetricsEnabled();
    }

    public CosmosQueryRequestOptions setQueryMetricsEnabled(boolean queryMetricsEnabled) {
        this.actualRequestOptions.setQueryMetricsEnabled(queryMetricsEnabled);
        return this;
    }

    public FeedRange getFeedRange() {
        return this.actualRequestOptions.getFeedRange();
    }

    public CosmosQueryRequestOptions setFeedRange(FeedRange feedRange) {
        this.actualRequestOptions.setFeedRange(feedRange);
        return this;
    }

    public String getThroughputControlGroupName() {
        return this.actualRequestOptions.getThroughputControlGroupName();
    }

    public CosmosQueryRequestOptions setThroughputControlGroupName(String throughputControlGroupName) {
        this.actualRequestOptions.setThroughputControlGroupName(throughputControlGroupName);
        return this;
    }

    public DedicatedGatewayRequestOptions getDedicatedGatewayRequestOptions() {
        return this.actualRequestOptions.getDedicatedGatewayRequestOptions();
    }

    public CosmosQueryRequestOptions setDedicatedGatewayRequestOptions(DedicatedGatewayRequestOptions dedicatedGatewayRequestOptions) {
        this.actualRequestOptions.setDedicatedGatewayRequestOptions(dedicatedGatewayRequestOptions);
        return this;
    }

    public Duration getThresholdForDiagnosticsOnTracer() {
        return this.actualRequestOptions.getThresholdForDiagnosticsOnTracer();
    }

    public CosmosQueryRequestOptions setThresholdForDiagnosticsOnTracer(Duration thresholdForDiagnosticsOnTracer) {
        this.actualRequestOptions.setThresholdForDiagnosticsOnTracer(thresholdForDiagnosticsOnTracer);
        return this;
    }

    public CosmosQueryRequestOptions setDiagnosticsThresholds(CosmosDiagnosticsThresholds operationSpecificThresholds) {
        this.actualRequestOptions.setDiagnosticsThresholds(operationSpecificThresholds);
        return this;
    }

    public CosmosDiagnosticsThresholds getDiagnosticsThresholds() {
        return this.actualRequestOptions.getThresholds();
    }

    public boolean isIndexMetricsEnabled() {
        return this.actualRequestOptions.isIndexMetricsEnabled();
    }

    public CosmosQueryRequestOptions setIndexMetricsEnabled(boolean indexMetricsEnabled) {
        this.actualRequestOptions.setIndexMetricsEnabled(indexMetricsEnabled);
        return this;
    }

    public CosmosQueryRequestOptions setQueryName(String queryName) {
        this.actualRequestOptions.setQueryName(queryName);
        return this;
    }

    CosmosQueryRequestOptionsBase<?> getImpl() {
        return this.actualRequestOptions;
    }

    String getPartitionKeyRangeIdInternal() {
        return this.actualRequestOptions.getPartitionKeyRangeIdInternal();
    }

    CosmosQueryRequestOptions setPartitionKeyRangeIdInternal(String partitionKeyRangeId) {
        this.actualRequestOptions.setPartitionKeyRangeIdInternal(partitionKeyRangeId);
        return this;
    }

    static void initialize() {
        ImplementationBridgeHelpers.CosmosQueryRequestOptionsHelper.setCosmosQueryRequestOptionsAccessor(new ImplementationBridgeHelpers.CosmosQueryRequestOptionsHelper.CosmosQueryRequestOptionsAccessor(){

            @Override
            public CosmosQueryRequestOptionsBase<?> getImpl(CosmosQueryRequestOptions options) {
                return options.actualRequestOptions;
            }

            @Override
            public CosmosQueryRequestOptions clone(CosmosQueryRequestOptions toBeCloned) {
                return new CosmosQueryRequestOptions(toBeCloned);
            }

            @Override
            public CosmosQueryRequestOptions clone(CosmosQueryRequestOptionsBase<?> toBeCloned) {
                return new CosmosQueryRequestOptions(toBeCloned);
            }

            @Override
            public CosmosQueryRequestOptions disallowQueryPlanRetrieval(CosmosQueryRequestOptions queryRequestOptions) {
                queryRequestOptions.actualRequestOptions.disallowQueryPlanRetrieval();
                return queryRequestOptions;
            }

            @Override
            public boolean isQueryPlanRetrievalDisallowed(CosmosQueryRequestOptions queryRequestOptions) {
                return queryRequestOptions.actualRequestOptions.isQueryPlanRetrievalDisallowed();
            }

            @Override
            public boolean isEmptyPageDiagnosticsEnabled(CosmosQueryRequestOptions queryRequestOptions) {
                return queryRequestOptions.actualRequestOptions.isEmptyPageDiagnosticsEnabled();
            }

            @Override
            public String getQueryNameOrDefault(CosmosQueryRequestOptions queryRequestOptions, String defaultQueryName) {
                return queryRequestOptions.actualRequestOptions.getQueryNameOrDefault(defaultQueryName);
            }

            @Override
            public RequestOptions toRequestOptions(CosmosQueryRequestOptions queryRequestOptions) {
                RequestOptions requestOptions = queryRequestOptions.actualRequestOptions.applyToRequestOptions(new RequestOptions());
                requestOptions.setPartitionKey(queryRequestOptions.getPartitionKey());
                return requestOptions;
            }

            @Override
            public List<CosmosDiagnostics> getCancelledRequestDiagnosticsTracker(CosmosQueryRequestOptions options) {
                return options.actualRequestOptions.getCancelledRequestDiagnosticsTracker();
            }

            @Override
            public void setCancelledRequestDiagnosticsTracker(CosmosQueryRequestOptions options, List<CosmosDiagnostics> cancelledRequestDiagnosticsTracker) {
                options.actualRequestOptions.setCancelledRequestDiagnosticsTracker(cancelledRequestDiagnosticsTracker);
            }

            @Override
            public void setAllowEmptyPages(CosmosQueryRequestOptions options, boolean emptyPagesAllowed) {
                options.actualRequestOptions.setEmptyPagesAllowed(emptyPagesAllowed);
            }

            @Override
            public boolean getAllowEmptyPages(CosmosQueryRequestOptions options) {
                return options.actualRequestOptions.isEmptyPagesAllowed();
            }

            @Override
            public Integer getMaxItemCount(CosmosQueryRequestOptions options) {
                return options.getMaxItemCount();
            }

            @Override
            public String getRequestContinuation(CosmosQueryRequestOptions options) {
                return options.getRequestContinuation();
            }
        });
    }

    static {
        CosmosQueryRequestOptions.initialize();
    }
}

