/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.clienttelemetry;

import java.util.EnumSet;
import java.util.Locale;

public enum TagName {
    Container("Container", 1),
    Operation("Operation", 2),
    OperationStatusCode("OperationStatusCode", 4),
    ClientCorrelationId("ClientCorrelationId", 8),
    ConsistencyLevel("ConsistencyLevel", 16),
    PartitionKeyRangeId("PartitionKeyRangeId", 32),
    RequestStatusCode("RequestStatusCode", 64),
    RequestOperationType("RequestOperationType", 128),
    RegionName("RegionName", 256),
    ServiceEndpoint("ServiceEndpoint", 512),
    ServiceAddress("ServiceAddress", 1024),
    IsForceRefresh("IsForceRefresh", 2048),
    IsForceCollectionRoutingMapRefresh("IsForceCollectionRoutingMapRefresh", 4096),
    PartitionId("PartitionId", 8192),
    ReplicaId("ReplicaId", 16384),
    OperationSubStatusCode("OperationSubStatusCode", 32768);

    private final int value;
    private final String stringValue;
    private final String toLowerStringValue;
    public static final EnumSet<TagName> DEFAULT_TAGS;
    public static final EnumSet<TagName> ALL_TAGS;
    public static final EnumSet<TagName> MINIMUM_TAGS;

    private TagName(String stringValue, int value) {
        this.stringValue = stringValue;
        this.value = value;
        this.toLowerStringValue = stringValue.toLowerCase(Locale.ROOT);
    }

    public String toString() {
        return this.stringValue;
    }

    public String toLowerCase() {
        return this.toLowerStringValue;
    }

    public int value() {
        return this.value;
    }

    static {
        DEFAULT_TAGS = EnumSet.of(Container, new TagName[]{Operation, OperationStatusCode, ClientCorrelationId, RequestStatusCode, RequestOperationType, ServiceAddress, RegionName});
        ALL_TAGS = EnumSet.allOf(TagName.class);
        MINIMUM_TAGS = EnumSet.of(Container, new TagName[]{Operation, OperationStatusCode, ClientCorrelationId, RequestStatusCode, RequestOperationType});
    }
}

