/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.apachecommons.collections;

import com.azure.cosmos.implementation.apachecommons.collections.AbstractCollectionDecorator;
import com.azure.cosmos.implementation.apachecommons.collections.list.Unmodifiable;
import com.azure.cosmos.implementation.apachecommons.collections.list.iterators.UnmodifiableIterator;
import java.util.Collection;
import java.util.Iterator;

public final class UnmodifiableCollection<E>
extends AbstractCollectionDecorator<E>
implements Unmodifiable {
    private static final long serialVersionUID = -1742294389933370464L;

    public static <T> Collection<T> unmodifiableCollection(Collection<? extends T> coll) {
        if (coll instanceof Unmodifiable) {
            Collection<? extends T> tmpColl = coll;
            return tmpColl;
        }
        return new UnmodifiableCollection<T>(coll);
    }

    private UnmodifiableCollection(Collection<? extends E> coll) {
        super(coll);
    }

    @Override
    public Iterator<E> iterator() {
        return UnmodifiableIterator.unmodifiableIterator(this.decorated().iterator());
    }

    @Override
    public boolean add(E object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> coll) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> coll) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> coll) {
        throw new UnsupportedOperationException();
    }
}

