/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.implementation.Utils;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.function.Function;

public interface ItemDeserializer {
    public <T> T convert(Class<T> var1, JsonNode var2);

    public static class JsonDeserializer
    implements ItemDeserializer {
        private final Function<JsonNode, ?> factoryMethod;

        public JsonDeserializer(Function<JsonNode, ?> factoryMethod) {
            this.factoryMethod = factoryMethod;
        }

        public JsonDeserializer() {
            this.factoryMethod = null;
        }

        @Override
        public <T> T convert(Class<T> classType, JsonNode jsonNode) {
            if (jsonNode == null) {
                return null;
            }
            if (this.factoryMethod != null) {
                return (T)this.factoryMethod.apply(jsonNode);
            }
            try {
                return (T)Utils.getSimpleObjectMapper().treeToValue((TreeNode)jsonNode, classType);
            }
            catch (IOException e) {
                throw new IllegalStateException(String.format("Unable to parse JSON %s", jsonNode), e);
            }
        }
    }
}

