/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.JsonSerializable;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.models.CosmosItemOperation;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.time.Duration;

public final class CosmosBatchOperationResult {
    private final String eTag;
    private final double requestCharge;
    private final int statusCode;
    private final Duration retryAfter;
    private final int subStatusCode;
    private final CosmosItemOperation cosmosItemOperation;
    private ObjectNode resourceObject;

    CosmosBatchOperationResult(String eTag, double requestCharge, ObjectNode resourceObject, int statusCode, Duration retryAfter, int subStatusCode, CosmosItemOperation cosmosItemOperation) {
        Preconditions.checkNotNull(statusCode, "expected non-null statusCode");
        Preconditions.checkNotNull(cosmosItemOperation, "expected non-null cosmosItemOperation");
        this.eTag = eTag;
        this.requestCharge = requestCharge;
        this.resourceObject = resourceObject;
        this.statusCode = statusCode;
        this.retryAfter = retryAfter;
        this.subStatusCode = subStatusCode;
        this.cosmosItemOperation = cosmosItemOperation;
    }

    public String getETag() {
        return this.eTag;
    }

    public double getRequestCharge() {
        return this.requestCharge;
    }

    public <T> T getItem(Class<T> type) {
        T item = null;
        if (this.getResourceObject() != null) {
            item = new JsonSerializable(this.getResourceObject()).toObject(type);
        }
        return item;
    }

    public Duration getRetryAfterDuration() {
        return this.retryAfter;
    }

    public int getSubStatusCode() {
        return this.subStatusCode;
    }

    public boolean isSuccessStatusCode() {
        return 200 <= this.statusCode && this.statusCode <= 299;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    ObjectNode getResourceObject() {
        return this.resourceObject;
    }

    public CosmosItemOperation getOperation() {
        return this.cosmosItemOperation;
    }

    static void initialize() {
        ImplementationBridgeHelpers.CosmosBatchOperationResultHelper.setCosmosBatchOperationResultAccessor(new ImplementationBridgeHelpers.CosmosBatchOperationResultHelper.CosmosBatchOperationResultAccessor(){

            @Override
            public ObjectNode getResourceObject(CosmosBatchOperationResult cosmosBatchOperationResult) {
                return cosmosBatchOperationResult.getResourceObject();
            }

            @Override
            public void setResourceObject(CosmosBatchOperationResult cosmosBatchOperationResult, ObjectNode objectNode) {
                cosmosBatchOperationResult.resourceObject = objectNode;
            }
        });
    }

    static {
        CosmosBatchOperationResult.initialize();
    }
}

