/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.core.exception.AzureException;
import com.azure.cosmos.CosmosDiagnostics;
import com.azure.cosmos.implementation.CosmosError;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.RequestTimeline;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.directconnectivity.Uri;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdChannelAcquisitionTimeline;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdChannelStatistics;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdEndpointStatistics;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class CosmosException
extends AzureException {
    private static final long MAX_RETRY_AFTER_IN_MS = 5000L;
    private static final long serialVersionUID = 1L;
    private static final ObjectMapper mapper = new ObjectMapper();
    private final int statusCode;
    private final Map<String, String> responseHeaders;
    private CosmosDiagnostics cosmosDiagnostics;
    private RequestTimeline requestTimeline;
    private RntbdChannelAcquisitionTimeline channelAcquisitionTimeline;
    private CosmosError cosmosError;
    private RntbdEndpointStatistics rntbdEndpointStatistics;
    private RntbdChannelStatistics rntbdChannelStatistics;
    long lsn;
    String partitionKeyRangeId;
    Map<String, String> requestHeaders;
    private Uri requestUri;
    String resourceAddress;
    private int requestPayloadLength;
    private int rntbdRequestLength;
    private int rntbdResponseLength;
    private boolean sendingRequestHasStarted;
    private final List<String> replicaStatusList = new ArrayList<String>();
    private String faultInjectionRuleId;
    private List<String> faultInjectionEvaluationResults;

    protected CosmosException(int statusCode, String message, Map<String, String> responseHeaders, Throwable cause) {
        super(message, cause);
        this.statusCode = statusCode;
        this.responseHeaders = new ConcurrentHashMap<String, String>();
        if (responseHeaders != null) {
            for (Map.Entry<String, String> entry : responseHeaders.entrySet()) {
                if (entry.getKey() == null || entry.getValue() == null) continue;
                this.responseHeaders.put(entry.getKey(), entry.getValue());
            }
        }
    }

    protected CosmosException(int statusCode, String errorMessage) {
        this(statusCode, errorMessage, null, null);
        this.cosmosError = new CosmosError();
        ModelBridgeInternal.setProperty(this.cosmosError, "message", errorMessage);
    }

    protected CosmosException(int statusCode, Exception innerException) {
        this(statusCode, null, null, innerException);
    }

    protected CosmosException(int statusCode, CosmosError cosmosErrorResource, Map<String, String> responseHeaders) {
        this(null, statusCode, cosmosErrorResource, responseHeaders);
    }

    protected CosmosException(String resourceAddress, int statusCode, CosmosError cosmosErrorResource, Map<String, String> responseHeaders) {
        this(statusCode, cosmosErrorResource == null ? null : cosmosErrorResource.getMessage(), responseHeaders, null);
        this.resourceAddress = resourceAddress;
        this.cosmosError = cosmosErrorResource;
    }

    protected CosmosException(String resourceAddress, int statusCode, CosmosError cosmosErrorResource, Map<String, String> responseHeaders, Throwable cause) {
        this(statusCode, cosmosErrorResource == null ? null : cosmosErrorResource.getMessage(), responseHeaders, cause);
        this.resourceAddress = resourceAddress;
        this.cosmosError = cosmosErrorResource;
    }

    protected CosmosException(String message, Exception exception, Map<String, String> responseHeaders, int statusCode, String resourceAddress) {
        this(statusCode, message, responseHeaders, exception);
        this.resourceAddress = resourceAddress;
    }

    public String getMessage() {
        try {
            ObjectNode messageNode = mapper.createObjectNode();
            messageNode.put("innerErrorMessage", this.innerErrorMessage());
            if (this.cosmosDiagnostics != null) {
                this.cosmosDiagnostics.fillCosmosDiagnostics(messageNode, null);
            }
            return mapper.writeValueAsString((Object)messageNode);
        }
        catch (JsonProcessingException e) {
            if (this.cosmosDiagnostics == null) {
                return this.innerErrorMessage();
            }
            return this.innerErrorMessage() + ", " + this.cosmosDiagnostics.toString();
        }
    }

    public String getShortMessage() {
        return this.innerErrorMessage();
    }

    public String getActivityId() {
        if (this.responseHeaders != null) {
            return this.responseHeaders.get("x-ms-activity-id");
        }
        return null;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public int getSubStatusCode() {
        String subStatusString;
        int code = 0;
        if (this.responseHeaders != null && StringUtils.isNotEmpty(subStatusString = this.responseHeaders.get("x-ms-substatus"))) {
            try {
                code = Integer.parseInt(subStatusString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return code;
    }

    void setSubStatusCode(int subStatusCode) {
        this.responseHeaders.put("x-ms-substatus", Integer.toString(subStatusCode));
    }

    CosmosError getError() {
        return this.cosmosError;
    }

    void setError(CosmosError cosmosError) {
        this.cosmosError = cosmosError;
    }

    public Duration getRetryAfterDuration() {
        String header;
        long retryIntervalInMilliseconds = -1L;
        if (this.responseHeaders != null && StringUtils.isNotEmpty(header = this.responseHeaders.get("x-ms-retry-after-ms"))) {
            try {
                retryIntervalInMilliseconds = Math.min(Long.parseLong(header), 5000L);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Duration.ofMillis(retryIntervalInMilliseconds);
    }

    public Map<String, String> getResponseHeaders() {
        return this.responseHeaders;
    }

    String getResourceAddress() {
        return this.resourceAddress;
    }

    public CosmosDiagnostics getDiagnostics() {
        return this.cosmosDiagnostics;
    }

    CosmosException setDiagnostics(CosmosDiagnostics cosmosDiagnostics) {
        this.cosmosDiagnostics = cosmosDiagnostics;
        return this;
    }

    public double getRequestCharge() {
        String value = this.getResponseHeaders().get("x-ms-request-charge");
        if (StringUtils.isEmpty(value)) {
            return 0.0;
        }
        return Double.parseDouble(value);
    }

    void setRequestUri(Uri requestUri) {
        this.requestUri = requestUri;
    }

    Uri getRequestUri() {
        return this.requestUri;
    }

    public String toString() {
        return this.toString(true);
    }

    String toString(boolean includeDiagnostics) {
        try {
            List<Map.Entry<String, String>> filterRequestHeaders;
            ObjectNode exceptionMessageNode = mapper.createObjectNode();
            exceptionMessageNode.put("ClassName", ((Object)((Object)this)).getClass().getSimpleName());
            exceptionMessageNode.put("userAgent", this.getUserAgent());
            exceptionMessageNode.put("statusCode", this.statusCode);
            exceptionMessageNode.put("resourceAddress", this.resourceAddress);
            if (this.cosmosError != null) {
                exceptionMessageNode.put("error", this.cosmosError.toJson());
            }
            exceptionMessageNode.put("innerErrorMessage", this.innerErrorMessage());
            exceptionMessageNode.put("causeInfo", this.causeInfo());
            if (this.responseHeaders != null) {
                exceptionMessageNode.put("responseHeaders", this.responseHeaders.toString());
            }
            if ((filterRequestHeaders = this.filterSensitiveData(this.requestHeaders)) != null) {
                exceptionMessageNode.put("requestHeaders", filterRequestHeaders.toString());
            }
            if (StringUtils.isNotEmpty(this.faultInjectionRuleId)) {
                exceptionMessageNode.put("faultInjectionRuleId", this.faultInjectionRuleId);
            }
            if (includeDiagnostics && this.cosmosDiagnostics != null) {
                this.cosmosDiagnostics.fillCosmosDiagnostics(exceptionMessageNode, null);
            }
            return mapper.writeValueAsString((Object)exceptionMessageNode);
        }
        catch (JsonProcessingException ex) {
            return String.format("%s {%s=%s, error=%s, resourceAddress=%s, statusCode=%s, message=%s, causeInfo=%s, responseHeaders=%s, requestHeaders=%s, faultInjectionRuleId=[%s] }", ((Object)((Object)this)).getClass().getSimpleName(), "userAgent", this.getUserAgent(), this.cosmosError, this.resourceAddress, this.statusCode, this.getMessage(), this.causeInfo(), this.responseHeaders, this.filterSensitiveData(this.requestHeaders), this.faultInjectionRuleId);
        }
    }

    String innerErrorMessage() {
        String innerErrorMessage = super.getMessage();
        if (this.cosmosError != null && (innerErrorMessage = this.cosmosError.getMessage()) == null) {
            innerErrorMessage = String.valueOf(ModelBridgeInternal.getObjectFromJsonSerializable(this.cosmosError, "Errors"));
        }
        return innerErrorMessage;
    }

    private String causeInfo() {
        Throwable cause = this.getCause();
        if (cause != null) {
            return String.format("[class: %s, message: %s]", cause.getClass(), cause.getMessage());
        }
        return null;
    }

    private List<Map.Entry<String, String>> filterSensitiveData(Map<String, String> requestHeaders) {
        if (requestHeaders == null) {
            return null;
        }
        return requestHeaders.entrySet().stream().filter(entry -> !"authorization".equalsIgnoreCase((String)entry.getKey())).collect(Collectors.toList());
    }

    RequestTimeline getRequestTimeline() {
        return this.requestTimeline;
    }

    void setRequestTimeline(RequestTimeline requestTimeline) {
        this.requestTimeline = requestTimeline;
    }

    RntbdChannelAcquisitionTimeline getChannelAcquisitionTimeline() {
        return this.channelAcquisitionTimeline;
    }

    void setChannelAcquisitionTimeline(RntbdChannelAcquisitionTimeline channelAcquisitionTimeline) {
        this.channelAcquisitionTimeline = channelAcquisitionTimeline;
    }

    void setResourceAddress(String resourceAddress) {
        this.resourceAddress = resourceAddress;
    }

    void setRntbdServiceEndpointStatistics(RntbdEndpointStatistics rntbdEndpointStatistics) {
        this.rntbdEndpointStatistics = rntbdEndpointStatistics;
    }

    RntbdEndpointStatistics getRntbdServiceEndpointStatistics() {
        return this.rntbdEndpointStatistics;
    }

    RntbdChannelStatistics getRntbdChannelStatistics() {
        return this.rntbdChannelStatistics;
    }

    void setRntbdChannelStatistics(RntbdChannelStatistics rntbdChannelStatistics) {
        this.rntbdChannelStatistics = rntbdChannelStatistics;
    }

    void setRntbdRequestLength(int rntbdRequestLength) {
        this.rntbdRequestLength = rntbdRequestLength;
    }

    int getRntbdRequestLength() {
        return this.rntbdRequestLength;
    }

    void setRntbdResponseLength(int rntbdResponseLength) {
        this.rntbdResponseLength = rntbdResponseLength;
    }

    int getRntbdResponseLength() {
        return this.rntbdResponseLength;
    }

    void setRequestPayloadLength(int requestBodyLength) {
        this.requestPayloadLength = requestBodyLength;
    }

    int getRequestPayloadLength() {
        return this.requestPayloadLength;
    }

    boolean hasSendingRequestStarted() {
        return this.sendingRequestHasStarted;
    }

    void setSendingRequestHasStarted(boolean hasSendingRequestStarted) {
        this.sendingRequestHasStarted = hasSendingRequestStarted;
    }

    private String getUserAgent() {
        String userAgent = Utils.getUserAgent();
        if (this.requestHeaders != null) {
            userAgent = this.requestHeaders.getOrDefault("User-Agent", userAgent);
        }
        return userAgent;
    }

    void setFaultInjectionRuleId(String faultInjectionRUleId) {
        this.faultInjectionRuleId = faultInjectionRUleId;
    }

    String getFaultInjectionRuleId() {
        return this.faultInjectionRuleId;
    }

    void setFaultInjectionEvaluationResults(List<String> faultInjectionEvaluationResults) {
        this.faultInjectionEvaluationResults = faultInjectionEvaluationResults;
    }

    List<String> getFaultInjectionEvaluationResults() {
        return this.faultInjectionEvaluationResults;
    }

    List<String> getReplicaStatusList() {
        return this.replicaStatusList;
    }

    static void initialize() {
        ImplementationBridgeHelpers.CosmosExceptionHelper.setCosmosExceptionAccessor(new ImplementationBridgeHelpers.CosmosExceptionHelper.CosmosExceptionAccessor(){

            @Override
            public CosmosException createCosmosException(int statusCode, Exception innerException) {
                return new CosmosException(statusCode, innerException);
            }

            @Override
            public List<String> getReplicaStatusList(CosmosException cosmosException) {
                return cosmosException.getReplicaStatusList();
            }

            @Override
            public CosmosException setRntbdChannelStatistics(CosmosException cosmosException, RntbdChannelStatistics rntbdChannelStatistics) {
                cosmosException.setRntbdChannelStatistics(rntbdChannelStatistics);
                return cosmosException;
            }

            @Override
            public RntbdChannelStatistics getRntbdChannelStatistics(CosmosException cosmosException) {
                return cosmosException.getRntbdChannelStatistics();
            }

            @Override
            public void setFaultInjectionRuleId(CosmosException cosmosException, String faultInjectionRuleId) {
                cosmosException.setFaultInjectionRuleId(faultInjectionRuleId);
            }

            @Override
            public String getFaultInjectionRuleId(CosmosException cosmosException) {
                return cosmosException.getFaultInjectionRuleId();
            }

            @Override
            public void setFaultInjectionEvaluationResults(CosmosException cosmosException, List<String> faultInjectionRuleEvaluationResults) {
                cosmosException.setFaultInjectionEvaluationResults(faultInjectionRuleEvaluationResults);
            }

            @Override
            public List<String> getFaultInjectionEvaluationResults(CosmosException cosmosException) {
                return cosmosException.getFaultInjectionEvaluationResults();
            }

            @Override
            public void setRequestUri(CosmosException cosmosException, Uri requestUri) {
                cosmosException.setRequestUri(requestUri);
            }

            @Override
            public Uri getRequestUri(CosmosException cosmosException) {
                return cosmosException.getRequestUri();
            }
        });
    }

    static {
        CosmosException.initialize();
    }
}

