/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosException;
import com.azure.cosmos.implementation.Exceptions;
import com.azure.cosmos.implementation.GlobalEndpointManager;
import com.azure.cosmos.implementation.IRetryPolicy;
import com.azure.cosmos.implementation.RetryContext;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.ShouldRetryResult;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.WebExceptionRetryPolicy;
import com.azure.cosmos.implementation.directconnectivity.WebExceptionUtility;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class MetadataRequestRetryPolicy
implements IRetryPolicy {
    private static final Logger logger = LoggerFactory.getLogger(MetadataRequestRetryPolicy.class);
    private final GlobalEndpointManager globalEndpointManager;
    private RxDocumentServiceRequest request;
    private WebExceptionRetryPolicy webExceptionRetryPolicy;

    public MetadataRequestRetryPolicy(GlobalEndpointManager globalEndpointManager) {
        this.globalEndpointManager = globalEndpointManager;
    }

    public void onBeforeSendRequest(RxDocumentServiceRequest request) {
        this.request = request;
        this.webExceptionRetryPolicy = new WebExceptionRetryPolicy(BridgeInternal.getRetryContext(request.requestContext.cosmosDiagnostics));
    }

    private boolean shouldMarkRegionAsUnavailable(CosmosException exception) {
        if (!this.request.isAddressRefresh() && !this.request.isMetadataRequest()) {
            return false;
        }
        if (WebExceptionUtility.isNetworkFailure((Exception)((Object)exception))) {
            return Exceptions.isSubStatusCode(exception, 10001);
        }
        return false;
    }

    @Override
    public Mono<ShouldRetryResult> shouldRetry(Exception e) {
        return this.webExceptionRetryPolicy.shouldRetry(e).flatMap(shouldRetryResult -> {
            if (!shouldRetryResult.shouldRetry) {
                if (this.request == null || this.webExceptionRetryPolicy == null) {
                    logger.error("onBeforeSendRequest has not been invoked with the MetadataRequestRetryPolicy...");
                    return Mono.just((Object)ShouldRetryResult.error(e));
                }
                if (!(e instanceof CosmosException)) {
                    logger.debug("exception is not an instance of CosmosException...");
                    return Mono.just((Object)ShouldRetryResult.error(e));
                }
                CosmosException cosmosException = Utils.as(e, CosmosException.class);
                if (this.shouldMarkRegionAsUnavailable(cosmosException)) {
                    URI locationEndpointToRoute = this.request.requestContext.locationEndpointToRoute;
                    if (this.request.isReadOnlyRequest()) {
                        this.globalEndpointManager.markEndpointUnavailableForRead(locationEndpointToRoute);
                    } else {
                        this.globalEndpointManager.markEndpointUnavailableForWrite(locationEndpointToRoute);
                    }
                }
                return Mono.just((Object)ShouldRetryResult.error((Exception)((Object)cosmosException)));
            }
            return Mono.just((Object)shouldRetryResult);
        });
    }

    @Override
    public RetryContext getRetryContext() {
        return null;
    }
}

