/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.ConsistencyLevel;
import com.azure.cosmos.CosmosAsyncClient;
import com.azure.cosmos.CosmosDiagnosticsThresholds;
import com.azure.cosmos.implementation.DiagnosticsProvider;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.OperationType;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.implementation.guava25.base.Preconditions;

public class CosmosPagedFluxOptions {
    private static final ImplementationBridgeHelpers.CosmosAsyncClientHelper.CosmosAsyncClientAccessor clientAccessor = ImplementationBridgeHelpers.CosmosAsyncClientHelper.getCosmosAsyncClientAccessor();
    private String requestContinuation;
    private Integer maxItemCount;
    private DiagnosticsProvider tracerProvider;
    private String spanName;
    private String databaseId;
    private String containerId;
    private OperationType operationType;
    private ResourceType resourceType;
    private String serviceEndpoint;
    private CosmosAsyncClient cosmosAsyncClient;
    private CosmosDiagnosticsThresholds thresholds;
    private String operationId;
    private String userAgent;
    private String connectionMode;
    public ConsistencyLevel effectiveConsistencyLevel;
    public double samplingRateSnapshot = 1.0;

    public String getContainerId() {
        return this.containerId;
    }

    public OperationType getOperationType() {
        return this.operationType;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public CosmosAsyncClient getCosmosAsyncClient() {
        return this.cosmosAsyncClient;
    }

    public ConsistencyLevel getEffectiveConsistencyLevel() {
        return this.effectiveConsistencyLevel;
    }

    public String getRequestContinuation() {
        return this.requestContinuation;
    }

    public CosmosPagedFluxOptions setRequestContinuation(String requestContinuation) {
        this.requestContinuation = requestContinuation;
        return this;
    }

    public Integer getMaxItemCount() {
        return this.maxItemCount;
    }

    public CosmosPagedFluxOptions setMaxItemCount(Integer maxItemCount) {
        this.maxItemCount = maxItemCount;
        return this;
    }

    public DiagnosticsProvider getDiagnosticsProvider() {
        return this.tracerProvider;
    }

    public String getSpanName() {
        return this.spanName;
    }

    public String getDatabaseId() {
        return this.databaseId;
    }

    public String getAccountTag() {
        return this.serviceEndpoint;
    }

    public CosmosDiagnosticsThresholds getDiagnosticsThresholds() {
        return this.thresholds;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getConnectionMode() {
        return this.connectionMode;
    }

    public void setTracerInformation(String tracerSpanName, String databaseId, String containerId, String operationId, OperationType operationType, ResourceType resourceType, CosmosAsyncClient cosmosAsyncClient, ConsistencyLevel consistencyLevel, CosmosDiagnosticsThresholds thresholds) {
        Preconditions.checkNotNull(tracerSpanName, "Argument 'tracerSpanName' must not be NULL.");
        Preconditions.checkNotNull(operationType, "Argument 'operationType' must not be NULL.");
        Preconditions.checkNotNull(resourceType, "Argument 'resourceType' must not be NULL.");
        Preconditions.checkNotNull(cosmosAsyncClient, "Argument 'cosmosAsyncClient' must not be NULL.");
        Preconditions.checkNotNull(thresholds, "Argument 'thresholds' must not be NULL.");
        this.databaseId = databaseId;
        this.containerId = containerId;
        this.spanName = tracerSpanName;
        this.tracerProvider = clientAccessor.getDiagnosticsProvider(cosmosAsyncClient);
        this.serviceEndpoint = clientAccessor.getAccountTagValue(cosmosAsyncClient);
        this.connectionMode = clientAccessor.getConnectionMode(cosmosAsyncClient);
        this.userAgent = clientAccessor.getUserAgent(cosmosAsyncClient);
        this.operationId = operationId;
        this.operationType = operationType;
        this.resourceType = resourceType;
        this.cosmosAsyncClient = cosmosAsyncClient;
        this.effectiveConsistencyLevel = clientAccessor.getEffectiveConsistencyLevel(cosmosAsyncClient, operationType, consistencyLevel);
        this.thresholds = thresholds;
    }

    public void setTracerAndTelemetryInformation(String tracerSpanName, String databaseId, String containerId, OperationType operationType, ResourceType resourceType, CosmosAsyncClient cosmosAsyncClient, String operationId, ConsistencyLevel consistencyLevel, CosmosDiagnosticsThresholds thresholds) {
        Preconditions.checkNotNull(tracerSpanName, "Argument 'tracerSpanName' must not be NULL.");
        Preconditions.checkNotNull(databaseId, "Argument 'databaseId' must not be NULL.");
        Preconditions.checkNotNull(operationType, "Argument 'operationType' must not be NULL.");
        Preconditions.checkNotNull(resourceType, "Argument 'resourceType' must not be NULL.");
        Preconditions.checkNotNull(cosmosAsyncClient, "Argument 'cosmosAsyncClient' must not be NULL.");
        Preconditions.checkNotNull(thresholds, "Argument 'thresholds' must not be NULL.");
        this.tracerProvider = clientAccessor.getDiagnosticsProvider(cosmosAsyncClient);
        this.serviceEndpoint = clientAccessor.getAccountTagValue(cosmosAsyncClient);
        this.connectionMode = clientAccessor.getConnectionMode(cosmosAsyncClient);
        this.userAgent = clientAccessor.getUserAgent(cosmosAsyncClient);
        this.spanName = tracerSpanName;
        this.databaseId = databaseId;
        this.containerId = containerId;
        this.operationType = operationType;
        this.resourceType = resourceType;
        this.cosmosAsyncClient = cosmosAsyncClient;
        this.operationId = operationId;
        this.effectiveConsistencyLevel = clientAccessor.getEffectiveConsistencyLevel(cosmosAsyncClient, operationType, consistencyLevel);
        this.thresholds = thresholds;
    }

    public double getSamplingRateSnapshot() {
        return this.samplingRateSnapshot;
    }

    public void setSamplingRateSnapshot(double samplingRateSnapshot) {
        this.samplingRateSnapshot = samplingRateSnapshot;
    }
}

