/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.faultinjection;

import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class FaultInjectionRequestContext {
    private final Map<String, Integer> hitCountByRuleMap;
    private final Map<Long, String> transportRequestIdRuleIdMap;
    private volatile URI locationEndpointToRoute;

    public FaultInjectionRequestContext(FaultInjectionRequestContext cloneContext) {
        this.hitCountByRuleMap = cloneContext.hitCountByRuleMap;
        this.transportRequestIdRuleIdMap = new ConcurrentHashMap<Long, String>();
    }

    public FaultInjectionRequestContext() {
        this.hitCountByRuleMap = new ConcurrentHashMap<String, Integer>();
        this.transportRequestIdRuleIdMap = new ConcurrentHashMap<Long, String>();
    }

    public void applyFaultInjectionRule(long transportId, String ruleId) {
        this.hitCountByRuleMap.compute(ruleId, (id, count) -> {
            if (count == null) {
                return 1;
            }
            Integer n = count;
            count = count + 1;
            return count;
        });
        this.transportRequestIdRuleIdMap.put(transportId, ruleId);
    }

    public int getFaultInjectionRuleApplyCount(String ruleId) {
        return this.hitCountByRuleMap.getOrDefault(ruleId, 0);
    }

    public String getFaultInjectionRuleId(long transportRequesetId) {
        return this.transportRequestIdRuleIdMap.getOrDefault(transportRequesetId, null);
    }

    public void setLocationEndpointToRoute(URI locationEndpointToRoute) {
        this.locationEndpointToRoute = locationEndpointToRoute;
    }

    public URI getLocationEndpointToRoute() {
        return this.locationEndpointToRoute;
    }
}

