/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity;

import com.azure.cosmos.CosmosException;
import com.azure.cosmos.implementation.Exceptions;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.directconnectivity.StoreResponse;
import com.azure.cosmos.implementation.directconnectivity.StoreResponseDiagnostics;
import com.azure.cosmos.implementation.directconnectivity.StoreResult;
import com.azure.cosmos.implementation.directconnectivity.Uri;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreResultDiagnostics {
    private static final Logger logger = LoggerFactory.getLogger(StoreResultDiagnostics.class);
    private final long lsn;
    private final long quorumAckedLSN;
    private final long globalCommittedLSN;
    private final long numberOfReadRegions;
    private final long itemLSN;
    private final int currentReplicaSetSize;
    private final int currentWriteQuorum;
    private final boolean isValid;
    private boolean isGoneException;
    private boolean isNotFoundException;
    private boolean isInvalidPartitionException;
    private final Uri storePhysicalAddress;
    private boolean isThroughputControlRequestRateTooLargeException;
    private final Double backendLatencyInMs;
    private final Double retryAfterInMs;
    private StoreResponseDiagnostics storeResponseDiagnostics;

    public static StoreResultDiagnostics createStoreResultDiagnostics(StoreResult storeResult, RxDocumentServiceRequest request) {
        if (storeResult == null) {
            return null;
        }
        if (storeResult.getStoreResponse() != null) {
            return new StoreResultDiagnostics(storeResult, storeResult.getStoreResponse(), request);
        }
        return new StoreResultDiagnostics(storeResult, storeResult.getException(), request);
    }

    private StoreResultDiagnostics(StoreResult storeResult) {
        this.lsn = storeResult.lsn;
        this.quorumAckedLSN = storeResult.quorumAckedLSN;
        this.currentReplicaSetSize = storeResult.currentReplicaSetSize;
        this.currentWriteQuorum = storeResult.currentWriteQuorum;
        this.isValid = storeResult.isValid;
        this.storePhysicalAddress = storeResult.storePhysicalAddress != null ? storeResult.storePhysicalAddress : null;
        this.globalCommittedLSN = storeResult.globalCommittedLSN;
        this.numberOfReadRegions = storeResult.numberOfReadRegions;
        this.itemLSN = storeResult.itemLSN;
        this.backendLatencyInMs = storeResult.backendLatencyInMs;
        this.retryAfterInMs = storeResult.retryAfterInMs;
    }

    private StoreResultDiagnostics(StoreResult storeResult, CosmosException e, RxDocumentServiceRequest request) {
        this(storeResult);
        this.isGoneException = Exceptions.isGone(e);
        this.isNotFoundException = Exceptions.isNotFound(e);
        this.isInvalidPartitionException = Exceptions.isNameCacheStale(e);
        this.isThroughputControlRequestRateTooLargeException = Exceptions.isThroughputControlRequestRateTooLargeException(e);
        this.storeResponseDiagnostics = StoreResponseDiagnostics.createStoreResponseDiagnostics(e, request);
    }

    private StoreResultDiagnostics(StoreResult storeResult, StoreResponse storeResponse, RxDocumentServiceRequest request) {
        this(storeResult);
        this.storeResponseDiagnostics = StoreResponseDiagnostics.createStoreResponseDiagnostics(storeResponse, request);
    }

    public long getLsn() {
        return this.lsn;
    }

    public long getQuorumAckedLSN() {
        return this.quorumAckedLSN;
    }

    public long getGlobalCommittedLSN() {
        return this.globalCommittedLSN;
    }

    public long getNumberOfReadRegions() {
        return this.numberOfReadRegions;
    }

    public long getItemLSN() {
        return this.itemLSN;
    }

    public int getCurrentReplicaSetSize() {
        return this.currentReplicaSetSize;
    }

    public int getCurrentWriteQuorum() {
        return this.currentWriteQuorum;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public boolean isGoneException() {
        return this.isGoneException;
    }

    public boolean isNotFoundException() {
        return this.isNotFoundException;
    }

    public boolean isInvalidPartitionException() {
        return this.isInvalidPartitionException;
    }

    public String getStorePhysicalAddressAsString() {
        return this.storePhysicalAddress != null ? this.storePhysicalAddress.getURIAsString() : null;
    }

    public String getStorePhysicalAddressEscapedAuthority() {
        return this.storePhysicalAddress != null ? String.format("%s_%d", this.storePhysicalAddress.getURI().getHost(), this.storePhysicalAddress.getURI().getPort()) : null;
    }

    public String getStorePhysicalAddressEscapedPath() {
        return this.storePhysicalAddress != null ? this.storePhysicalAddress.getURI().getPath() : null;
    }

    public boolean isThroughputControlRequestRateTooLargeException() {
        return this.isThroughputControlRequestRateTooLargeException;
    }

    public Double getBackendLatencyInMs() {
        return this.backendLatencyInMs;
    }

    public Double getRetryAfterInMs() {
        return this.retryAfterInMs;
    }

    public StoreResponseDiagnostics getStoreResponseDiagnostics() {
        return this.storeResponseDiagnostics;
    }

    public static class StoreResultDiagnosticsSerializer
    extends StdSerializer<StoreResultDiagnostics> {
        private static final long serialVersionUID = 5315472126043077905L;

        public StoreResultDiagnosticsSerializer() {
            super(StoreResultDiagnostics.class);
        }

        public void serialize(StoreResultDiagnostics storeResultDiagnostics, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            StoreResponseDiagnostics storeResponseDiagnostics = storeResultDiagnostics.getStoreResponseDiagnostics();
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("storePhysicalAddress", storeResultDiagnostics.storePhysicalAddress == null ? null : storeResultDiagnostics.storePhysicalAddress.getURIAsString());
            jsonGenerator.writeNumberField("lsn", storeResultDiagnostics.lsn);
            jsonGenerator.writeNumberField("globalCommittedLsn", storeResultDiagnostics.globalCommittedLSN);
            jsonGenerator.writeStringField("partitionKeyRangeId", storeResponseDiagnostics.getPartitionKeyRangeId());
            jsonGenerator.writeBooleanField("isValid", storeResultDiagnostics.isValid);
            jsonGenerator.writeNumberField("statusCode", storeResponseDiagnostics.getStatusCode());
            jsonGenerator.writeNumberField("subStatusCode", storeResponseDiagnostics.getSubStatusCode());
            jsonGenerator.writeBooleanField("isGone", storeResultDiagnostics.isGoneException);
            jsonGenerator.writeBooleanField("isNotFound", storeResultDiagnostics.isNotFoundException);
            jsonGenerator.writeBooleanField("isInvalidPartition", storeResultDiagnostics.isInvalidPartitionException);
            jsonGenerator.writeBooleanField("isThroughputControlRequestRateTooLarge", storeResultDiagnostics.isThroughputControlRequestRateTooLargeException);
            jsonGenerator.writeNumberField("requestCharge", storeResponseDiagnostics.getRequestCharge());
            jsonGenerator.writeNumberField("itemLSN", storeResultDiagnostics.itemLSN);
            jsonGenerator.writeStringField("sessionToken", storeResponseDiagnostics.getSessionTokenAsString());
            jsonGenerator.writeObjectField("backendLatencyInMs", (Object)storeResultDiagnostics.backendLatencyInMs);
            jsonGenerator.writeObjectField("retryAfterInMs", (Object)storeResultDiagnostics.retryAfterInMs);
            this.writeNonNullStringField(jsonGenerator, "exceptionMessage", storeResponseDiagnostics.getExceptionMessage());
            this.writeNonNullStringField(jsonGenerator, "exceptionResponseHeaders", storeResponseDiagnostics.getExceptionResponseHeaders());
            this.writeNonNullStringField(jsonGenerator, "faultInjectionRuleId", storeResponseDiagnostics.getFaultInjectionRuleId());
            this.writeNonNullObjectField(jsonGenerator, "replicaStatusList", storeResponseDiagnostics.getReplicaStatusList());
            jsonGenerator.writeObjectField("transportRequestTimeline", (Object)storeResponseDiagnostics.getRequestTimeline());
            this.writeNonNullObjectField(jsonGenerator, "transportRequestChannelAcquisitionContext", storeResponseDiagnostics.getChannelAcquisitionTimeline());
            jsonGenerator.writeObjectField("rntbdRequestLengthInBytes", (Object)storeResponseDiagnostics.getRntbdRequestLength());
            jsonGenerator.writeObjectField("rntbdResponseLengthInBytes", (Object)storeResponseDiagnostics.getRntbdResponseLength());
            jsonGenerator.writeObjectField("requestPayloadLengthInBytes", (Object)storeResponseDiagnostics.getRequestPayloadLength());
            jsonGenerator.writeObjectField("responsePayloadLengthInBytes", (Object)storeResponseDiagnostics.getResponsePayloadLength());
            jsonGenerator.writeObjectField("channelStatistics", (Object)storeResponseDiagnostics.getRntbdChannelStatistics());
            jsonGenerator.writeObjectField("serviceEndpointStatistics", (Object)storeResponseDiagnostics.getRntbdEndpointStatistics());
            jsonGenerator.writeEndObject();
        }

        private void writeNonNullObjectField(JsonGenerator jsonGenerator, String fieldName, Object object) throws IOException {
            if (object == null) {
                return;
            }
            jsonGenerator.writeObjectField(fieldName, object);
        }

        private void writeNonNullStringField(JsonGenerator jsonGenerator, String fieldName, String value) throws IOException {
            if (value == null) {
                return;
            }
            jsonGenerator.writeStringField(fieldName, value);
        }
    }
}

