/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.batch;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosAsyncContainer;
import com.azure.cosmos.CosmosBridgeInternal;
import com.azure.cosmos.implementation.batch.SinglePartitionKeyServerBatchRequest;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.models.CosmosBatch;
import com.azure.cosmos.models.CosmosBatchRequestOptions;
import com.azure.cosmos.models.CosmosBatchResponse;
import com.azure.cosmos.models.CosmosItemOperation;
import com.azure.cosmos.models.ModelBridgeInternal;
import java.util.List;
import reactor.core.publisher.Mono;

public final class BatchExecutor {
    private final CosmosAsyncContainer container;
    private final CosmosBatchRequestOptions options;
    private final CosmosBatch cosmosBatch;

    public BatchExecutor(CosmosAsyncContainer container, CosmosBatch cosmosBatch, CosmosBatchRequestOptions options) {
        this.container = container;
        this.cosmosBatch = cosmosBatch;
        this.options = options;
    }

    public final Mono<CosmosBatchResponse> executeAsync() {
        List<CosmosItemOperation> operations = this.cosmosBatch.getOperations();
        Preconditions.checkArgument(operations.size() > 0, "Number of operations should be more than 0.");
        SinglePartitionKeyServerBatchRequest request = SinglePartitionKeyServerBatchRequest.createBatchRequest(this.cosmosBatch.getPartitionKeyValue(), operations);
        request.setAtomicBatch(true);
        request.setShouldContinueOnError(false);
        return CosmosBridgeInternal.getAsyncDocumentClient(this.container.getDatabase()).executeBatchRequest(BridgeInternal.getLink(this.container), request, ModelBridgeInternal.toRequestOptions(this.options), false);
    }
}

