/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import java.time.Duration;
import java.util.function.BiPredicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CosmosDiagnosticsThresholds {
    private static final Logger LOGGER = LoggerFactory.getLogger(CosmosDiagnosticsThresholds.class);
    public static final float DEFAULT_REQUEST_CHARGE_THRESHOLD = 1000.0f;
    public static final Duration DEFAULT_POINT_OPERATION_LATENCY_THRESHOLD = Duration.ofSeconds(1L);
    public static final Duration DEFAULT_NON_POINT_OPERATION_LATENCY_THRESHOLD = Duration.ofSeconds(3L);
    public static final int DEFAULT_PAYLOAD_SIZE_THRESHOLD_IN_BYTES = Integer.MAX_VALUE;
    private static final CosmosDiagnosticsThresholds DEFAULT = new CosmosDiagnosticsThresholds();
    private Duration pointOperationLatencyThreshold;
    private Duration nonPointOperationLatencyThreshold;
    private float requestChargeThreshold = 1000.0f;
    private int payloadSizeInBytesThreshold;
    private BiPredicate<Integer, Integer> isFailureHandler = (statusCode, subStatusCode) -> {
        Preconditions.checkNotNull(statusCode, "Argument 'statusCode' must not be null.");
        Preconditions.checkNotNull(subStatusCode, "Argument 'subStatusCode' must not be null.");
        if (statusCode >= 500) {
            return true;
        }
        if (subStatusCode == 0 && (statusCode == 404 || statusCode == 409 || statusCode == 412)) {
            return false;
        }
        if (statusCode == 429 && (subStatusCode == 10003 || subStatusCode == 3200)) {
            return false;
        }
        return statusCode >= 400;
    };

    public CosmosDiagnosticsThresholds() {
        this.pointOperationLatencyThreshold = DEFAULT_POINT_OPERATION_LATENCY_THRESHOLD;
        this.nonPointOperationLatencyThreshold = DEFAULT_NON_POINT_OPERATION_LATENCY_THRESHOLD;
        this.payloadSizeInBytesThreshold = Integer.MAX_VALUE;
    }

    public CosmosDiagnosticsThresholds setPointOperationLatencyThreshold(Duration pointOperationLatencyThreshold) {
        Preconditions.checkNotNull(pointOperationLatencyThreshold, "Argument 'pointOperationLatencyThreshold' must not be null.");
        this.pointOperationLatencyThreshold = pointOperationLatencyThreshold;
        return this;
    }

    public CosmosDiagnosticsThresholds setNonPointOperationLatencyThreshold(Duration nonPointOperationLatencyThreshold) {
        Preconditions.checkNotNull(nonPointOperationLatencyThreshold, "Argument 'nonPointOperationLatencyThreshold' must not be null.");
        this.nonPointOperationLatencyThreshold = nonPointOperationLatencyThreshold;
        return this;
    }

    public CosmosDiagnosticsThresholds setRequestChargeThreshold(float requestChargeThreshold) {
        this.requestChargeThreshold = requestChargeThreshold;
        return this;
    }

    public CosmosDiagnosticsThresholds setPayloadSizeThreshold(int bytes) {
        this.payloadSizeInBytesThreshold = bytes;
        return this;
    }

    public CosmosDiagnosticsThresholds setFailureHandler(BiPredicate<Integer, Integer> isFailureHandler) {
        Preconditions.checkNotNull(this.nonPointOperationLatencyThreshold, "Argument 'isFailureHandler' must not be null.");
        this.isFailureHandler = isFailureHandler;
        return this;
    }

    Duration getPointOperationLatencyThreshold() {
        return this.pointOperationLatencyThreshold;
    }

    Duration getNonPointOperationLatencyThreshold() {
        return this.nonPointOperationLatencyThreshold;
    }

    float getRequestChargeThreshold() {
        return this.requestChargeThreshold;
    }

    int getPayloadSizeThreshold() {
        return this.payloadSizeInBytesThreshold;
    }

    boolean isFailureCondition(int statusCode, int subStatusCode) {
        try {
            return this.isFailureHandler.test(statusCode, subStatusCode);
        }
        catch (Exception error) {
            LOGGER.error("Execution of custom isFailureHandler failed - treating operation as failure.", (Throwable)error);
            return false;
        }
    }

    static void initialize() {
        ImplementationBridgeHelpers.CosmosDiagnosticsThresholdsHelper.setCosmosDiagnosticsThresholdsAccessor(new ImplementationBridgeHelpers.CosmosDiagnosticsThresholdsHelper.CosmosDiagnosticsThresholdsAccessor(){

            @Override
            public Duration getPointReadLatencyThreshold(CosmosDiagnosticsThresholds thresholds) {
                if (thresholds == null) {
                    return DEFAULT.getPointOperationLatencyThreshold();
                }
                Preconditions.checkNotNull(thresholds, "Argument 'thresholds' must not be null.");
                return thresholds.getPointOperationLatencyThreshold();
            }

            @Override
            public Duration getNonPointReadLatencyThreshold(CosmosDiagnosticsThresholds thresholds) {
                if (thresholds == null) {
                    return DEFAULT.getNonPointOperationLatencyThreshold();
                }
                Preconditions.checkNotNull(thresholds, "Argument 'thresholds' must not be null.");
                return thresholds.getNonPointOperationLatencyThreshold();
            }

            @Override
            public float getRequestChargeThreshold(CosmosDiagnosticsThresholds thresholds) {
                if (thresholds == null) {
                    return DEFAULT.getRequestChargeThreshold();
                }
                Preconditions.checkNotNull(thresholds, "Argument 'thresholds' must not be null.");
                return thresholds.getRequestChargeThreshold();
            }

            @Override
            public int getPayloadSizeThreshold(CosmosDiagnosticsThresholds thresholds) {
                if (thresholds == null) {
                    return DEFAULT.getPayloadSizeThreshold();
                }
                Preconditions.checkNotNull(thresholds, "Argument 'thresholds' must not be null.");
                return thresholds.getPayloadSizeThreshold();
            }

            @Override
            public boolean isFailureCondition(CosmosDiagnosticsThresholds thresholds, int statusCode, int subStatusCode) {
                if (thresholds == null) {
                    return DEFAULT.isFailureCondition(statusCode, subStatusCode);
                }
                Preconditions.checkNotNull(thresholds, "Argument 'thresholds' must not be null.");
                return thresholds.isFailureCondition(statusCode, subStatusCode);
            }
        });
    }

    static {
        CosmosDiagnosticsThresholds.initialize();
    }
}

