/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.models.CosmosContainerIdentity;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public final class CosmosContainerProactiveInitConfig {
    private static final ImplementationBridgeHelpers.CosmosContainerIdentityHelper.CosmosContainerIdentityAccessor containerIdAccessor = ImplementationBridgeHelpers.CosmosContainerIdentityHelper.getCosmosContainerIdentityAccessor();
    private final List<CosmosContainerIdentity> cosmosContainerIdentities;
    private final int numProactiveConnectionRegions;

    CosmosContainerProactiveInitConfig(List<CosmosContainerIdentity> cosmosContainerIdentities, int numProactiveConnectionRegions) {
        this.cosmosContainerIdentities = Collections.unmodifiableList(cosmosContainerIdentities);
        this.numProactiveConnectionRegions = numProactiveConnectionRegions;
    }

    public List<CosmosContainerIdentity> getCosmosContainerIdentities() {
        return this.cosmosContainerIdentities;
    }

    public int getProactiveConnectionRegionsCount() {
        return this.numProactiveConnectionRegions;
    }

    public String toString() {
        if (this.cosmosContainerIdentities == null || this.cosmosContainerIdentities.isEmpty()) {
            return "";
        }
        return String.format("%s(%d)", this.cosmosContainerIdentities.stream().map(ci -> String.join((CharSequence)".", containerIdAccessor.getDatabaseName((CosmosContainerIdentity)ci), containerIdAccessor.getContainerName((CosmosContainerIdentity)ci))).collect(Collectors.joining(",")), this.numProactiveConnectionRegions);
    }
}

