/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity.rntbd;

import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdConnectionStateListener;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdContextNegotiator;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdEndpoint;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdRequestEncoder;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdRequestManager;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdResponseDecoder;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.pool.ChannelHealthChecker;
import io.netty.channel.pool.ChannelPoolHandler;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.AttributeKey;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RntbdClientChannelHandler
extends ChannelInitializer<Channel>
implements ChannelPoolHandler {
    private static final AttributeKey<RntbdRequestManager> REQUEST_MANAGER = AttributeKey.newInstance((String)"requestManager");
    private static final Logger logger = LoggerFactory.getLogger(RntbdClientChannelHandler.class);
    private final ChannelHealthChecker healthChecker;
    private final RntbdEndpoint.Config config;
    private final RntbdConnectionStateListener connectionStateListener;

    RntbdClientChannelHandler(RntbdEndpoint.Config config, ChannelHealthChecker healthChecker, RntbdConnectionStateListener connectionStateListener) {
        Preconditions.checkNotNull(healthChecker, "expected non-null healthChecker");
        Preconditions.checkNotNull(config, "expected non-null config");
        this.healthChecker = healthChecker;
        this.config = config;
        this.connectionStateListener = connectionStateListener;
    }

    public void channelAcquired(Channel channel) {
        logger.debug("{} CHANNEL ACQUIRED", (Object)channel);
    }

    public void channelCreated(Channel channel) {
        logger.debug("{} CHANNEL CREATED", (Object)channel);
        this.initChannel(channel);
    }

    public void channelReleased(Channel channel) {
        if (logger.isDebugEnabled()) {
            logger.debug("{} CHANNEL RELEASED", (Object)channel);
        }
    }

    protected void initChannel(Channel channel) {
        Preconditions.checkNotNull(channel, "expected non-null channel");
        RntbdRequestManager requestManager = new RntbdRequestManager(this.healthChecker, this.config.maxRequestsPerChannel(), this.connectionStateListener, this.config.idleConnectionTimerResolutionInNanos());
        ChannelPipeline pipeline = channel.pipeline();
        pipeline.addFirst(new ChannelHandler[]{new RntbdContextNegotiator(requestManager, this.config.userAgent()), new RntbdResponseDecoder(), new RntbdRequestEncoder(), requestManager});
        if (this.config.wireLogLevel() != null) {
            pipeline.addFirst(new ChannelHandler[]{new LoggingHandler(this.config.wireLogLevel())});
        }
        SslHandler sslHandler = new SslHandler(this.config.sslContext().newEngine(channel.alloc()));
        sslHandler.setHandshakeTimeout(this.config.sslHandshakeTimeoutInMillis(), TimeUnit.MILLISECONDS);
        pipeline.addFirst(SslHandler.class.toString(), (ChannelHandler)sslHandler);
        channel.attr(REQUEST_MANAGER).set((Object)requestManager);
    }
}

