/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.changefeed.pkversion;

import com.azure.cosmos.ChangeFeedProcessor;
import com.azure.cosmos.ConsistencyLevel;
import com.azure.cosmos.CosmosAsyncContainer;
import com.azure.cosmos.CosmosBridgeInternal;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.apachecommons.lang.tuple.Pair;
import com.azure.cosmos.implementation.changefeed.ChangeFeedContextClient;
import com.azure.cosmos.implementation.changefeed.ChangeFeedObserverFactory;
import com.azure.cosmos.implementation.changefeed.CheckpointFrequency;
import com.azure.cosmos.implementation.changefeed.HealthMonitor;
import com.azure.cosmos.implementation.changefeed.LeaseStoreManager;
import com.azure.cosmos.implementation.changefeed.PartitionLoadBalancingStrategy;
import com.azure.cosmos.implementation.changefeed.PartitionManager;
import com.azure.cosmos.implementation.changefeed.common.ChangeFeedContextClientImpl;
import com.azure.cosmos.implementation.changefeed.common.ChangeFeedMode;
import com.azure.cosmos.implementation.changefeed.common.CheckpointerObserverFactory;
import com.azure.cosmos.implementation.changefeed.common.DefaultObserverFactory;
import com.azure.cosmos.implementation.changefeed.common.EqualPartitionsBalancingStrategy;
import com.azure.cosmos.implementation.changefeed.common.PartitionedByIdCollectionRequestOptionsFactory;
import com.azure.cosmos.implementation.changefeed.common.TraceHealthMonitor;
import com.azure.cosmos.implementation.changefeed.pkversion.BootstrapperImpl;
import com.azure.cosmos.implementation.changefeed.pkversion.HealthMonitoringPartitionControllerDecorator;
import com.azure.cosmos.implementation.changefeed.pkversion.LeaseStoreManagerImpl;
import com.azure.cosmos.implementation.changefeed.pkversion.PartitionControllerImpl;
import com.azure.cosmos.implementation.changefeed.pkversion.PartitionLoadBalancerImpl;
import com.azure.cosmos.implementation.changefeed.pkversion.PartitionManagerImpl;
import com.azure.cosmos.implementation.changefeed.pkversion.PartitionProcessorFactoryImpl;
import com.azure.cosmos.implementation.changefeed.pkversion.PartitionSupervisorFactoryImpl;
import com.azure.cosmos.implementation.changefeed.pkversion.PartitionSynchronizerImpl;
import com.azure.cosmos.implementation.feedranges.FeedRangePartitionKeyRangeImpl;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.models.ChangeFeedProcessorOptions;
import com.azure.cosmos.models.ChangeFeedProcessorState;
import com.azure.cosmos.models.CosmosChangeFeedRequestOptions;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.fasterxml.jackson.databind.JsonNode;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public class IncrementalChangeFeedProcessorImpl
implements ChangeFeedProcessor,
AutoCloseable {
    private static final String PK_RANGE_ID_SEPARATOR = ":";
    private static final String SEGMENT_SEPARATOR = "#";
    private static final String PROPERTY_NAME_LSN = "_lsn";
    private final Logger logger = LoggerFactory.getLogger(IncrementalChangeFeedProcessorImpl.class);
    private final Duration sleepTime = Duration.ofSeconds(15L);
    private final Duration lockTime = Duration.ofSeconds(30L);
    private static final int DEFAULT_QUERY_PARTITIONS_MAX_BATCH_SIZE = 100;
    private static final int DEFAULT_DEGREE_OF_PARALLELISM = 25;
    private final String hostName;
    private final ChangeFeedContextClient feedContextClient;
    private final ChangeFeedProcessorOptions changeFeedProcessorOptions;
    private final ChangeFeedObserverFactory<JsonNode> observerFactory;
    private volatile String databaseResourceId;
    private volatile String collectionResourceId;
    private final ChangeFeedContextClient leaseContextClient;
    private PartitionLoadBalancingStrategy loadBalancingStrategy;
    private LeaseStoreManager leaseStoreManager;
    private HealthMonitor healthMonitor;
    private volatile PartitionManager partitionManager;
    private final Scheduler scheduler;

    public IncrementalChangeFeedProcessorImpl(String hostName, CosmosAsyncContainer feedContainer, CosmosAsyncContainer leaseContainer, Consumer<List<JsonNode>> consumer, ChangeFeedProcessorOptions changeFeedProcessorOptions) {
        Preconditions.checkNotNull(hostName, "Argument 'hostName' can not be null");
        Preconditions.checkNotNull(feedContainer, "Argument 'feedContainer' can not be null");
        Preconditions.checkNotNull(consumer, "Argument 'consumer' can not be null");
        if (changeFeedProcessorOptions == null) {
            changeFeedProcessorOptions = new ChangeFeedProcessorOptions();
        }
        this.validateChangeFeedProcessorOptions(changeFeedProcessorOptions);
        this.validateLeaseContainer(leaseContainer);
        this.hostName = hostName;
        this.changeFeedProcessorOptions = changeFeedProcessorOptions;
        this.feedContextClient = new ChangeFeedContextClientImpl(feedContainer);
        this.leaseContextClient = new ChangeFeedContextClientImpl(leaseContainer);
        this.scheduler = this.changeFeedProcessorOptions.getScheduler();
        this.feedContextClient.setScheduler(this.scheduler);
        this.leaseContextClient.setScheduler(this.scheduler);
        this.observerFactory = new DefaultObserverFactory<JsonNode>(consumer);
    }

    private void validateChangeFeedProcessorOptions(ChangeFeedProcessorOptions changeFeedProcessorOptions) {
        Preconditions.checkNotNull(changeFeedProcessorOptions, "Argument 'changeFeedProcessorOptions' can not be null");
        if (changeFeedProcessorOptions.getLeaseAcquireInterval().compareTo(ChangeFeedProcessorOptions.DEFAULT_ACQUIRE_INTERVAL) < 0) {
            this.logger.warn("Found lower than expected setting for leaseAcquireInterval");
        }
    }

    private void validateLeaseContainer(CosmosAsyncContainer leaseContainer) {
        Preconditions.checkNotNull(leaseContainer, "Argument 'leaseContainer' can not be null");
        if (!CosmosBridgeInternal.getContextClient(leaseContainer).isContentResponseOnWriteEnabled()) {
            throw new IllegalArgumentException("leaseClient: content response on write setting must be enabled");
        }
        ConsistencyLevel consistencyLevel = CosmosBridgeInternal.getContextClient(leaseContainer).getConsistencyLevel();
        if (consistencyLevel == ConsistencyLevel.CONSISTENT_PREFIX || consistencyLevel == ConsistencyLevel.EVENTUAL) {
            this.logger.warn("leaseClient consistency level setting are less then expected which is SESSION");
        }
    }

    @Override
    public Mono<Void> start() {
        if (this.partitionManager == null) {
            return this.initializeCollectionPropertiesForBuild().flatMap(value -> this.getLeaseStoreManager().flatMap(this::buildPartitionManager)).flatMap(partitionManager1 -> {
                this.partitionManager = partitionManager1;
                return this.partitionManager.start();
            });
        }
        return this.partitionManager.start();
    }

    @Override
    public Mono<Void> stop() {
        if (this.partitionManager == null || !this.partitionManager.isRunning()) {
            throw new IllegalStateException("The ChangeFeedProcessor instance has not fully started");
        }
        return this.partitionManager.stop();
    }

    @Override
    public boolean isStarted() {
        return this.partitionManager != null && this.partitionManager.isRunning();
    }

    @Override
    public Mono<Map<String, Integer>> getEstimatedLag() {
        ConcurrentHashMap earlyResult = new ConcurrentHashMap();
        if (this.leaseContextClient == null || this.feedContextClient == null) {
            return Mono.just(earlyResult);
        }
        return this.initializeCollectionPropertiesForBuild().flatMap(value -> this.getLeaseStoreManager()).flatMap(leaseStoreManager1 -> leaseStoreManager1.getAllLeases().flatMap(lease -> {
            FeedRangePartitionKeyRangeImpl feedRange = new FeedRangePartitionKeyRangeImpl(lease.getLeaseToken());
            CosmosChangeFeedRequestOptions options = ModelBridgeInternal.createChangeFeedRequestOptionsForChangeFeedState(lease.getContinuationState(this.collectionResourceId, ChangeFeedMode.INCREMENTAL));
            options.setMaxItemCount(1);
            return this.feedContextClient.createDocumentChangeFeedQuery(this.feedContextClient.getContainerClient(), options, JsonNode.class).take(1L).map(feedResponse -> {
                int estimatedLag;
                String ownerValue = lease.getOwner();
                String sessionTokenLsn = feedResponse.getSessionToken();
                String parsedSessionToken = sessionTokenLsn.substring(sessionTokenLsn.indexOf(PK_RANGE_ID_SEPARATOR));
                String[] segments = StringUtils.split(parsedSessionToken, SEGMENT_SEPARATOR);
                String latestLsn = segments[0];
                if (segments.length >= 2) {
                    latestLsn = segments[1];
                }
                if (ownerValue == null) {
                    ownerValue = "";
                }
                if (feedResponse.getResults() == null || feedResponse.getResults().size() == 0) {
                    return Pair.of(ownerValue + "_" + lease.getLeaseToken(), 0);
                }
                int currentLsn = 0;
                try {
                    currentLsn = Integer.parseInt(((JsonNode)feedResponse.getResults().get(0)).get(PROPERTY_NAME_LSN).asText("0"));
                    estimatedLag = Integer.parseInt(latestLsn);
                    estimatedLag = estimatedLag - currentLsn + 1;
                }
                catch (NumberFormatException ex) {
                    this.logger.warn("Unexpected Cosmos LSN found", (Throwable)ex);
                    estimatedLag = -1;
                }
                return Pair.of(ownerValue + "_" + lease.getLeaseToken() + "_" + currentLsn + "_" + latestLsn, estimatedLag);
            });
        }).collectList().map(valueList -> {
            ConcurrentHashMap<String, Integer> result = new ConcurrentHashMap<String, Integer>();
            for (Pair pair : valueList) {
                result.put((String)pair.getKey(), (Integer)pair.getValue());
            }
            return result;
        }));
    }

    @Override
    public Mono<List<ChangeFeedProcessorState>> getCurrentState() {
        if (this.leaseContextClient == null || this.feedContextClient == null) {
            return Mono.just(Collections.unmodifiableList(new ArrayList()));
        }
        return this.initializeCollectionPropertiesForBuild().flatMap(value -> this.getLeaseStoreManager()).flatMap(leaseStoreManager1 -> leaseStoreManager1.getAllLeases().flatMap(lease -> {
            FeedRangePartitionKeyRangeImpl feedRange = new FeedRangePartitionKeyRangeImpl(lease.getLeaseToken());
            CosmosChangeFeedRequestOptions options = ModelBridgeInternal.createChangeFeedRequestOptionsForChangeFeedState(lease.getContinuationState(this.collectionResourceId, ChangeFeedMode.INCREMENTAL));
            options.setMaxItemCount(1);
            return this.feedContextClient.createDocumentChangeFeedQuery(this.feedContextClient.getContainerClient(), options, JsonNode.class).take(1L).map(feedResponse -> {
                String sessionTokenLsn = feedResponse.getSessionToken();
                String parsedSessionToken = sessionTokenLsn.substring(sessionTokenLsn.indexOf(PK_RANGE_ID_SEPARATOR));
                String[] segments = StringUtils.split(parsedSessionToken, SEGMENT_SEPARATOR);
                String latestLsn = segments[0];
                if (segments.length >= 2) {
                    latestLsn = segments[1];
                }
                ChangeFeedProcessorState changeFeedProcessorState = new ChangeFeedProcessorState().setHostName(lease.getOwner()).setLeaseToken(lease.getLeaseToken());
                if (feedResponse.getResults() == null || feedResponse.getResults().size() == 0) {
                    changeFeedProcessorState.setEstimatedLag(0).setContinuationToken(latestLsn);
                    return changeFeedProcessorState;
                }
                changeFeedProcessorState.setContinuationToken(((JsonNode)feedResponse.getResults().get(0)).get(PROPERTY_NAME_LSN).asText(null));
                try {
                    int currentLsn = Integer.parseInt(((JsonNode)feedResponse.getResults().get(0)).get(PROPERTY_NAME_LSN).asText("0"));
                    int estimatedLag = Integer.parseInt(latestLsn);
                    estimatedLag = estimatedLag - currentLsn + 1;
                    changeFeedProcessorState.setEstimatedLag(estimatedLag);
                }
                catch (NumberFormatException ex) {
                    this.logger.warn("Unexpected Cosmos LSN found", (Throwable)ex);
                    changeFeedProcessorState.setEstimatedLag(-1);
                }
                return changeFeedProcessorState;
            });
        }).collectList().map(Collections::unmodifiableList));
    }

    private Mono<ChangeFeedProcessor> initializeCollectionPropertiesForBuild() {
        return this.feedContextClient.readDatabase(this.feedContextClient.getDatabaseClient(), null).map(databaseResourceResponse -> {
            this.databaseResourceId = databaseResourceResponse.getProperties().getId();
            return this.databaseResourceId;
        }).flatMap(id -> this.feedContextClient.readContainer(this.feedContextClient.getContainerClient(), null).map(documentCollectionResourceResponse -> {
            this.collectionResourceId = documentCollectionResourceResponse.getProperties().getId();
            return this;
        }));
    }

    private Mono<LeaseStoreManager> getLeaseStoreManager() {
        if (this.leaseStoreManager == null) {
            return this.leaseContextClient.readContainerSettings(this.leaseContextClient.getContainerClient(), null).flatMap(collectionSettings -> {
                boolean isPartitioned;
                boolean bl = isPartitioned = collectionSettings.getPartitionKeyDefinition() != null && collectionSettings.getPartitionKeyDefinition().getPaths() != null && collectionSettings.getPartitionKeyDefinition().getPaths().size() > 0;
                if (!isPartitioned || collectionSettings.getPartitionKeyDefinition().getPaths().size() != 1 || !collectionSettings.getPartitionKeyDefinition().getPaths().get(0).equals("/id")) {
                    return Mono.error((Throwable)new IllegalArgumentException("The lease collection must have partition key equal to id."));
                }
                PartitionedByIdCollectionRequestOptionsFactory requestOptionsFactory = new PartitionedByIdCollectionRequestOptionsFactory();
                String leasePrefix = this.getLeasePrefix();
                this.leaseStoreManager = LeaseStoreManagerImpl.builder().leasePrefix(leasePrefix).leaseCollectionLink(this.leaseContextClient.getContainerClient()).leaseContextClient(this.leaseContextClient).requestOptionsFactory(requestOptionsFactory).hostName(this.hostName).build();
                return Mono.just((Object)this.leaseStoreManager);
            });
        }
        return Mono.just((Object)this.leaseStoreManager);
    }

    private String getLeasePrefix() {
        String optionsPrefix = this.changeFeedProcessorOptions.getLeasePrefix();
        if (optionsPrefix == null) {
            optionsPrefix = "";
        }
        URI uri = this.feedContextClient.getServiceEndpoint();
        return String.format("%s%s_%s_%s", optionsPrefix, uri.getHost(), this.databaseResourceId, this.collectionResourceId);
    }

    private Mono<PartitionManager> buildPartitionManager(LeaseStoreManager leaseStoreManager) {
        CheckpointerObserverFactory<JsonNode> factory = new CheckpointerObserverFactory<JsonNode>(this.observerFactory, new CheckpointFrequency());
        PartitionSynchronizerImpl synchronizer = new PartitionSynchronizerImpl(this.feedContextClient, this.feedContextClient.getContainerClient(), leaseStoreManager, leaseStoreManager, 25, 100, this.collectionResourceId);
        BootstrapperImpl bootstrapper = new BootstrapperImpl(synchronizer, leaseStoreManager, this.lockTime, this.sleepTime);
        PartitionSupervisorFactoryImpl partitionSupervisorFactory = new PartitionSupervisorFactoryImpl(factory, leaseStoreManager, new PartitionProcessorFactoryImpl(this.feedContextClient, this.changeFeedProcessorOptions, leaseStoreManager, this.feedContextClient.getContainerClient(), this.collectionResourceId), this.changeFeedProcessorOptions, this.scheduler);
        if (this.loadBalancingStrategy == null) {
            this.loadBalancingStrategy = new EqualPartitionsBalancingStrategy(this.hostName, this.changeFeedProcessorOptions.getMinScaleCount(), this.changeFeedProcessorOptions.getMaxScaleCount(), this.changeFeedProcessorOptions.getLeaseExpirationInterval());
        }
        PartitionControllerImpl partitionController = new PartitionControllerImpl(leaseStoreManager, leaseStoreManager, partitionSupervisorFactory, synchronizer, this.scheduler);
        if (this.healthMonitor == null) {
            this.healthMonitor = new TraceHealthMonitor();
        }
        HealthMonitoringPartitionControllerDecorator partitionController2 = new HealthMonitoringPartitionControllerDecorator(partitionController, this.healthMonitor);
        PartitionLoadBalancerImpl partitionLoadBalancer = new PartitionLoadBalancerImpl(partitionController2, leaseStoreManager, this.loadBalancingStrategy, this.changeFeedProcessorOptions.getLeaseAcquireInterval(), this.scheduler);
        PartitionManagerImpl partitionManager = new PartitionManagerImpl(bootstrapper, partitionController, partitionLoadBalancer);
        return Mono.just((Object)partitionManager);
    }

    @Override
    public void close() {
        this.stop().subscribeOn(Schedulers.boundedElastic()).subscribe();
    }
}

