/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.implementation.OpenConnectionResponse;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.RxDocumentServiceResponse;
import com.azure.cosmos.implementation.spark.OperationContext;
import com.azure.cosmos.implementation.spark.OperationContextAndListenerTuple;
import com.azure.cosmos.implementation.spark.OperationListener;
import com.azure.cosmos.implementation.throughputControl.ThroughputControlStore;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface RxStoreModel {
    public Mono<RxDocumentServiceResponse> processMessage(RxDocumentServiceRequest var1);

    default public Mono<RxDocumentServiceResponse> processMessage(RxDocumentServiceRequest request, OperationContextAndListenerTuple operationContextAndListenerTuple) {
        if (operationContextAndListenerTuple == null) {
            return this.processMessage(request);
        }
        OperationListener listener = operationContextAndListenerTuple.getOperationListener();
        OperationContext operationContext = operationContextAndListenerTuple.getOperationContext();
        request.getHeaders().put("x-ms-cosmos-correlated-activityid", operationContext.getCorrelationActivityId());
        listener.requestListener(operationContext, request);
        return this.processMessage(request).doOnNext(response -> listener.responseListener(operationContext, (RxDocumentServiceResponse)response)).doOnError(ex -> listener.exceptionListener(operationContext, (Throwable)ex));
    }

    public void enableThroughputControl(ThroughputControlStore var1);

    public Flux<OpenConnectionResponse> openConnectionsAndInitCaches(String var1);
}

